/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils;

import com.google.common.base.CharMatcher;
import java.util.Locale;
import java.util.Objects;

public class BlobUtils {
    private static final CharMatcher WHITESPACE_MATCHER = CharMatcher.whitespace();
    private static final CharMatcher HEX_DIGIT_MATCHER = CharMatcher.inRange((char)'A', (char)'F').or(CharMatcher.inRange((char)'0', (char)'9')).precomputed();

    private BlobUtils() {
    }

    public static byte[] parseBlobString(String value) {
        Objects.requireNonNull(value, "value is null");
        if (value.length() < 3 || !value.startsWith("X'") || !value.endsWith("'")) {
            throw new IllegalArgumentException("Binary literal must be in the form X'hexstring'");
        }
        String hexString = WHITESPACE_MATCHER.removeFrom((CharSequence)(value = value.substring(2, value.length() - 1))).toUpperCase(Locale.ENGLISH);
        if (!HEX_DIGIT_MATCHER.matchesAllOf((CharSequence)hexString)) {
            throw new IllegalArgumentException("Binary literal can only contain hexadecimal digits");
        }
        if (hexString.length() % 2 != 0) {
            throw new IllegalArgumentException("Binary literal must contain an even number of digits");
        }
        int len = hexString.length();
        byte[] values = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            values[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return values;
    }
}

