/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrLabel;

public class AggregationLabelSet {
    private final Set<IrLabel> labels;
    private final boolean running;

    public AggregationLabelSet(Set<IrLabel> labels, boolean running) {
        this.labels = Objects.requireNonNull(labels, "labels is null");
        this.running = running;
    }

    public Set<IrLabel> getLabels() {
        return this.labels;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregationLabelSet that = (AggregationLabelSet)o;
        return this.labels.equals(that.labels) && this.running == that.running;
    }

    public int hashCode() {
        return Objects.hash(this.labels, this.running);
    }

    public static void serialize(AggregationLabelSet set, ByteBuffer byteBuffer) {
        byteBuffer.putInt(set.labels.size());
        for (IrLabel label : set.labels) {
            IrLabel.serialize(label, byteBuffer);
        }
        byteBuffer.put((byte)(set.running ? 1 : 0));
    }

    public static void serialize(AggregationLabelSet set, DataOutputStream stream) throws IOException {
        stream.writeInt(set.labels.size());
        for (IrLabel label : set.labels) {
            IrLabel.serialize(label, stream);
        }
        stream.writeBoolean(set.running);
    }

    public static AggregationLabelSet deserialize(ByteBuffer byteBuffer) {
        int size = byteBuffer.getInt();
        HashSet<IrLabel> labels = new HashSet<IrLabel>(size);
        for (int i = 0; i < size; ++i) {
            labels.add(IrLabel.deserialize(byteBuffer));
        }
        boolean running = byteBuffer.get() == 1;
        return new AggregationLabelSet(labels, running);
    }
}

