/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.codec;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.DecoderUtil;
import org.junit.Assert;
import org.junit.Test;

public class DecoderUtilTest {
    @Test
    public void testDecodeB() throws UnsupportedEncodingException {
        String s = DecoderUtil.decodeB((String)"VGhpcyBpcyB0aGUgcGxhaW4gdGV4dCBtZXNzYWdlIQ==", (String)"ISO8859-1", (DecodeMonitor)DecodeMonitor.STRICT);
        Assert.assertEquals((Object)"This is the plain text message!", (Object)s);
    }

    @Test
    public void testDecodeQ() throws UnsupportedEncodingException {
        String s = DecoderUtil.decodeQ((String)"=e1_=e2=09=E3_=E4_", (String)"ISO8859-1", (DecodeMonitor)DecodeMonitor.STRICT);
        Assert.assertEquals((Object)"\u00e1 \u00e2\t\u00e3 \u00e4 ", (Object)s);
    }

    @Test
    public void testNonEncodedWordsAreIgnored() {
        Assert.assertEquals((Object)"", (Object)DecoderUtil.decodeEncodedWords((String)""));
        Assert.assertEquals((Object)"Yada yada", (Object)DecoderUtil.decodeEncodedWords((String)"Yada yada"));
    }

    @Test
    public void testDecodeSomeEncodedWords() {
        Assert.assertEquals((Object)"  \u00e1\u00e2\u00e3\t\u00e4", (Object)DecoderUtil.decodeEncodedWords((String)"=?iso-8859-1?Q?_=20=e1=e2=E3=09=E4?="));
        Assert.assertEquals((Object)"Word 1 '  \u00e2\u00e3\t\u00e4'. Word 2 '  \u00e2\u00e3\t\u00e4'", (Object)DecoderUtil.decodeEncodedWords((String)"Word 1 '=?iso-8859-1?Q?_=20=e2=E3=09=E4?='. Word 2 '=?iso-8859-1?q?_=20=e2=E3=09=E4?='"));
        Assert.assertEquals((Object)"=?iso-8859-YADA?Q?_=20=t1=e2=E3=09=E4?=", (Object)DecoderUtil.decodeEncodedWords((String)"=?iso-8859-YADA?Q?_=20=t1=e2=E3=09=E4?="));
        Assert.assertEquals((Object)"A short text", (Object)DecoderUtil.decodeEncodedWords((String)"=?US-ASCII?B?QSBzaG9ydCB0ZXh0?="));
        Assert.assertEquals((Object)"A short text again!", (Object)DecoderUtil.decodeEncodedWords((String)"=?US-ASCII?b?QSBzaG9ydCB0ZXh0IGFnYWluIQ==?="));
    }

    @Test
    public void testDecodeJapaneseEncodedWords() {
        String enc = "=?ISO-2022-JP?B?GyRCTCQbKEobJEI+NRsoShskQkJ6GyhKGyRCOS0bKEo=?= =?ISO-2022-JP?B?GyRCOXAbKEobJEIiKBsoShskQiU1GyhKGyRCJSQbKEo=?= =?ISO-2022-JP?B?GyRCJUkbKEobJEIlUxsoShskQiU4GyhKGyRCJU0bKEo=?= =?ISO-2022-JP?B?GyRCJTkbKEobJEIkThsoShskQjdoGyhKGyRCRGobKEo=?= =?ISO-2022-JP?B?GyRCSEcbKEobJEIkRxsoShskQiQ5GyhKGyRCISobKEo=?=";
        String dec = DecoderUtil.decodeEncodedWords((String)enc);
        Assert.assertEquals((Object)"\u672a\u627f\u8afe\u5e83\u544a\u203b\u30b5\u30a4\u30c9\u30d3\u30b8\u30cd\u30b9\u306e\u6c7a\u5b9a\u7248\u3067\u3059\uff01", (Object)dec);
    }

    @Test
    public void testDecodeJapaneseEncodedWordsWithFallback() {
        String enc = "=?random?B?GyRCTCQbKEobJEI+NRsoShskQkJ6GyhKGyRCOS0bKEo=?= =?garbage?B?GyRCOXAbKEobJEIiKBsoShskQiU1GyhKGyRCJSQbKEo=?= =?charset?B?GyRCJUkbKEobJEIlUxsoShskQiU4GyhKGyRCJU0bKEo=?= =?name?B?GyRCJTkbKEobJEIkThsoShskQjdoGyhKGyRCRGobKEo=?= =?trash?B?GyRCSEcbKEobJEIkRxsoShskQiQ5GyhKGyRCISobKEo=?=";
        String dec = DecoderUtil.decodeEncodedWords((String)enc, (Charset)Charset.forName("ISO-2022-JP"));
        Assert.assertEquals((Object)"\u672a\u627f\u8afe\u5e83\u544a\u203b\u30b5\u30a4\u30c9\u30d3\u30b8\u30cd\u30b9\u306e\u6c7a\u5b9a\u7248\u3067\u3059\uff01", (Object)dec);
    }

    @Test
    public void testInvalidEncodedWordsAreIgnored() {
        Assert.assertEquals((Object)"=?iso8859-1?Q?=", (Object)DecoderUtil.decodeEncodedWords((String)"=?iso8859-1?Q?="));
        Assert.assertEquals((Object)"=?iso8859-1?b?=", (Object)DecoderUtil.decodeEncodedWords((String)"=?iso8859-1?b?="));
        Assert.assertEquals((Object)"=?ISO-8859-1?Q?", (Object)DecoderUtil.decodeEncodedWords((String)"=?ISO-8859-1?Q?"));
        Assert.assertEquals((Object)"=?ISO-8859-1?R?abc?=", (Object)DecoderUtil.decodeEncodedWords((String)"=?ISO-8859-1?R?abc?="));
        Assert.assertEquals((Object)"test =?ISO-8859-1?R?abc?=", (Object)DecoderUtil.decodeEncodedWords((String)"test =?ISO-8859-1?R?abc?="));
    }

    @Test
    public void testEmptyEncodedTextIsIgnored() {
        Assert.assertEquals((Object)"", (Object)DecoderUtil.decodeEncodedWords((String)"=?ISO-8859-1?Q??="));
        Assert.assertEquals((Object)"", (Object)DecoderUtil.decodeEncodedWords((String)"=?ISO-8859-1?B??="));
    }

    @Test
    public void testWhiteSpaceBetweenEncodedWordsGetsRemoved() {
        Assert.assertEquals((Object)"a", (Object)DecoderUtil.decodeEncodedWords((String)"=?ISO-8859-1?Q?a?="));
        Assert.assertEquals((Object)"a b", (Object)DecoderUtil.decodeEncodedWords((String)"=?ISO-8859-1?Q?a?= b"));
        Assert.assertEquals((Object)"ab", (Object)DecoderUtil.decodeEncodedWords((String)"=?ISO-8859-1?Q?a?= =?ISO-8859-1?Q?b?="));
        Assert.assertEquals((Object)"ab", (Object)DecoderUtil.decodeEncodedWords((String)"=?ISO-8859-1?Q?a?=  =?ISO-8859-1?Q?b?="));
        Assert.assertEquals((Object)"ab", (Object)DecoderUtil.decodeEncodedWords((String)"=?ISO-8859-1?Q?a?=\r\n  =?ISO-8859-1?Q?b?="));
        Assert.assertEquals((Object)"a b", (Object)DecoderUtil.decodeEncodedWords((String)"=?ISO-8859-1?Q?a_b?="));
        Assert.assertEquals((Object)"a b", (Object)DecoderUtil.decodeEncodedWords((String)"=?ISO-8859-1?Q?a?= =?ISO-8859-2?Q?_b?="));
    }

    @Test
    public void testEncodedTextMayStartWithAnEqualsSign() {
        Assert.assertEquals((Object)" foo", (Object)DecoderUtil.decodeEncodedWords((String)"=?utf-8?Q?=20foo?="));
        Assert.assertEquals((Object)"Re: How to place a view at the bottom with a 100% width", (Object)DecoderUtil.decodeEncodedWords((String)"=?utf-8?Q?Re:=20How=20to=20place=20a=20view=20at=20the=20bottom?= =?utf-8?Q?=20with=20a=20100%=20width?="));
        Assert.assertEquals((Object)"Test \u00fc and more", (Object)DecoderUtil.decodeEncodedWords((String)"Test =?ISO-8859-1?Q?=FC_?= =?ISO-8859-1?Q?and_more?="));
    }

    @Test
    public void testEncodedTextMayContainDollarSign() {
        Assert.assertEquals((Object)"variable ${target.nl}", (Object)DecoderUtil.decodeEncodedWords((String)"=?utf-8?Q?variable=20${target.nl}?="));
    }

    @Test
    public void testEncodedTextMayContainQuestionMark() {
        Assert.assertEquals((Object)"?", (Object)DecoderUtil.decodeEncodedWords((String)"=?ISO-8859-1?Q???="));
    }

    @Test
    public void testNonWhiteSpaceBetweenEncodedWordsIsRetained() {
        Assert.assertEquals((Object)"a b c", (Object)DecoderUtil.decodeEncodedWords((String)"=?ISO-8859-1?Q?a?= b =?ISO-8859-1?Q?c?="));
        Assert.assertEquals((Object)"a\rb\nc", (Object)DecoderUtil.decodeEncodedWords((String)"=?ISO-8859-1?Q?a?=\rb\n=?ISO-8859-1?Q?c?="));
    }

    @Test
    public void testTextBeforeAndAfterEncodedWordIsRetained() {
        Assert.assertEquals((Object)" a b c ", (Object)DecoderUtil.decodeEncodedWords((String)" =?ISO-8859-1?Q?a?= b =?ISO-8859-1?Q?c?= "));
        Assert.assertEquals((Object)"! a b c !", (Object)DecoderUtil.decodeEncodedWords((String)"! =?ISO-8859-1?Q?a?= b =?ISO-8859-1?Q?c?= !"));
    }

    @Test
    public void testFunnyInputDoesNotRaiseOutOfMemoryError() {
        Assert.assertEquals((Object)"=3?!!\\=?\"!g6P\"!Xp:\"!", (Object)DecoderUtil.decodeEncodedWords((String)"=3?!!\\=?\"!g6P\"!Xp:\"!"));
    }

    @Test
    public void testAllowsForOverriddingCharsets() {
        HashMap<Charset, Charset> overrides = new HashMap<Charset, Charset>();
        overrides.put(Charset.forName("ISO-8859-1"), Charset.forName("WINDOWS-1252"));
        String decoded = DecoderUtil.decodeEncodedWords((String)"=?ISO-8859-1?Q?You=92re_a_winner?=", (DecodeMonitor)DecodeMonitor.SILENT, null, overrides);
        Assert.assertEquals((Object)"You\u2019re a winner", (Object)decoded);
    }
}

