/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.migrate.ldapjdk;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.migrate.ldapjdk.IterableEnumeration;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Set;

@NotExtensible
@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public class LDAPAttribute
implements Serializable {
    private static final long serialVersionUID = 839217229050750570L;
    @NotNull
    private Attribute attribute;

    public LDAPAttribute(@NotNull Attribute attr) {
        this.attribute = attr;
    }

    public LDAPAttribute(@NotNull LDAPAttribute attr) {
        this.attribute = attr.attribute;
    }

    public LDAPAttribute(@NotNull String attrName) {
        this.attribute = new Attribute(attrName);
    }

    public LDAPAttribute(@NotNull String attrName, @NotNull byte[] attrBytes) {
        this.attribute = new Attribute(attrName, attrBytes);
    }

    public LDAPAttribute(@NotNull String attrName, @NotNull String attrString) {
        this.attribute = new Attribute(attrName, attrString);
    }

    public LDAPAttribute(@NotNull String attrName, @NotNull String[] attrStrings) {
        this.attribute = new Attribute(attrName, attrStrings);
    }

    @NotNull
    public String getName() {
        return this.attribute.getName();
    }

    @NotNull
    public String getBaseName() {
        return this.attribute.getBaseName();
    }

    @NotNull
    public static String getBaseName(@NotNull String attrName) {
        return Attribute.getBaseName(attrName);
    }

    @Nullable
    public String[] getSubtypes() {
        Set<String> optionSet = this.attribute.getOptions();
        if (optionSet.isEmpty()) {
            return null;
        }
        String[] options = new String[optionSet.size()];
        return optionSet.toArray(options);
    }

    @Nullable
    public static String[] getSubtypes(@NotNull String attrName) {
        return new LDAPAttribute(attrName).getSubtypes();
    }

    @Nullable
    public String getLangSubtype() {
        for (String s : this.attribute.getOptions()) {
            String lowerName = StaticUtils.toLowerCase(s);
            if (!lowerName.startsWith("lang-")) continue;
            return s;
        }
        return null;
    }

    public boolean hasSubtype(@NotNull String subtype) {
        return this.attribute.hasOption(subtype);
    }

    public boolean hasSubtypes(@NotNull String[] subtypes) {
        for (String s : subtypes) {
            if (this.attribute.hasOption(s)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Enumeration<String> getStringValues() {
        return new IterableEnumeration<String>(Arrays.asList(this.attribute.getValues()));
    }

    @NotNull
    public String[] getStringValueArray() {
        return this.attribute.getValues();
    }

    @NotNull
    public Enumeration<byte[]> getByteValues() {
        return new IterableEnumeration<byte[]>(Arrays.asList(this.attribute.getValueByteArrays()));
    }

    @NotNull
    public byte[][] getByteValueArray() {
        return this.attribute.getValueByteArrays();
    }

    public void addValue(@NotNull String attrString) {
        this.attribute = Attribute.mergeAttributes(this.attribute, new Attribute(this.attribute.getName(), attrString));
    }

    public void addValue(@NotNull byte[] attrBytes) {
        this.attribute = Attribute.mergeAttributes(this.attribute, new Attribute(this.attribute.getName(), attrBytes));
    }

    public void removeValue(@NotNull String attrValue) {
        this.attribute = Attribute.removeValues(this.attribute, new Attribute(this.attribute.getName(), attrValue));
    }

    public void removeValue(@NotNull byte[] attrValue) {
        this.attribute = Attribute.removeValues(this.attribute, new Attribute(this.attribute.getName(), attrValue));
    }

    public int size() {
        return this.attribute.size();
    }

    @NotNull
    public final Attribute toAttribute() {
        return this.attribute;
    }

    @NotNull
    public String toString() {
        return this.attribute.toString();
    }
}

