/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Null;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.GetPasswordQualityRequirementsExtendedResult;
import com.unboundid.ldap.sdk.unboundidds.extensions.GetPasswordQualityRequirementsTargetType;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetPasswordQualityRequirementsExtendedRequest
extends ExtendedRequest {
    @NotNull
    public static final String OID_GET_PASSWORD_QUALITY_REQUIREMENTS_REQUEST = "1.3.6.1.4.1.30221.2.6.43";
    private static final long serialVersionUID = -3652010872400265557L;
    @NotNull
    private final GetPasswordQualityRequirementsTargetType targetType;
    @Nullable
    private final String targetDN;

    private GetPasswordQualityRequirementsExtendedRequest(@NotNull GetPasswordQualityRequirementsTargetType targetType, @Nullable String targetDN, Control ... controls) {
        super(OID_GET_PASSWORD_QUALITY_REQUIREMENTS_REQUEST, GetPasswordQualityRequirementsExtendedRequest.encodeValue(targetType, targetDN), controls);
        this.targetType = targetType;
        this.targetDN = targetDN;
    }

    public GetPasswordQualityRequirementsExtendedRequest(@NotNull ExtendedRequest r) throws LDAPException {
        super(r);
        ASN1OctetString value = r.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_PW_QUALITY_REQS_REQUEST_NO_VALUE.get());
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            this.targetType = GetPasswordQualityRequirementsTargetType.forBERType(elements[0].getType());
            if (this.targetType == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_PW_QUALITY_REQS_REQUEST_UNKNOWN_TARGET_TYPE.get(StaticUtils.toHex(elements[0].getType())));
            }
            switch (this.targetType) {
                case ADD_WITH_SPECIFIED_PASSWORD_POLICY: 
                case SELF_CHANGE_FOR_SPECIFIED_USER: 
                case ADMINISTRATIVE_RESET_FOR_SPECIFIED_USER: {
                    this.targetDN = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
                    break;
                }
                default: {
                    this.targetDN = null;
                    break;
                }
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_PW_QUALITY_REQS_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull GetPasswordQualityRequirementsTargetType targetType, @Nullable String targetDN) {
        ASN1Element targetElement;
        switch (targetType) {
            case ADD_WITH_SPECIFIED_PASSWORD_POLICY: 
            case SELF_CHANGE_FOR_SPECIFIED_USER: 
            case ADMINISTRATIVE_RESET_FOR_SPECIFIED_USER: {
                targetElement = new ASN1OctetString(targetType.getBERType(), targetDN);
                break;
            }
            default: {
                targetElement = new ASN1Null(targetType.getBERType());
            }
        }
        ASN1Sequence valueSequence = new ASN1Sequence(targetElement);
        return new ASN1OctetString(valueSequence.encode());
    }

    @NotNull
    public static GetPasswordQualityRequirementsExtendedRequest createAddWithDefaultPasswordPolicyRequest(Control ... controls) {
        return new GetPasswordQualityRequirementsExtendedRequest(GetPasswordQualityRequirementsTargetType.ADD_WITH_DEFAULT_PASSWORD_POLICY, null, controls);
    }

    @NotNull
    public static GetPasswordQualityRequirementsExtendedRequest createAddWithSpecifiedPasswordPolicyRequest(@NotNull String policyDN, Control ... controls) {
        return new GetPasswordQualityRequirementsExtendedRequest(GetPasswordQualityRequirementsTargetType.ADD_WITH_SPECIFIED_PASSWORD_POLICY, policyDN, controls);
    }

    @NotNull
    public static GetPasswordQualityRequirementsExtendedRequest createSelfChangeWithSameAuthorizationIdentityRequest(Control ... controls) {
        return new GetPasswordQualityRequirementsExtendedRequest(GetPasswordQualityRequirementsTargetType.SELF_CHANGE_FOR_AUTHORIZATION_IDENTITY, null, controls);
    }

    @NotNull
    public static GetPasswordQualityRequirementsExtendedRequest createSelfChangeForSpecifiedUserRequest(@NotNull String userDN, Control ... controls) {
        return new GetPasswordQualityRequirementsExtendedRequest(GetPasswordQualityRequirementsTargetType.SELF_CHANGE_FOR_SPECIFIED_USER, userDN, controls);
    }

    @NotNull
    public static GetPasswordQualityRequirementsExtendedRequest createAdministrativeResetForSpecifiedUserRequest(@NotNull String userDN, Control ... controls) {
        return new GetPasswordQualityRequirementsExtendedRequest(GetPasswordQualityRequirementsTargetType.ADMINISTRATIVE_RESET_FOR_SPECIFIED_USER, userDN, controls);
    }

    @NotNull
    public GetPasswordQualityRequirementsTargetType getTargetType() {
        return this.targetType;
    }

    @Nullable
    public String getTargetDN() {
        return this.targetDN;
    }

    @Override
    @NotNull
    public GetPasswordQualityRequirementsExtendedResult process(@NotNull LDAPConnection connection, int depth) throws LDAPException {
        ExtendedResult result = super.process(connection, depth);
        return new GetPasswordQualityRequirementsExtendedResult(result);
    }

    @Override
    @NotNull
    public GetPasswordQualityRequirementsExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    @NotNull
    public GetPasswordQualityRequirementsExtendedRequest duplicate(@Nullable Control[] controls) {
        GetPasswordQualityRequirementsExtendedRequest r = new GetPasswordQualityRequirementsExtendedRequest(this.targetType, this.targetDN, controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    @Override
    @NotNull
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_GET_PW_QUALITY_REQS.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        Control[] controls;
        buffer.append("GetPasswordQualityRequirementsExtendedRequest(targetType=");
        buffer.append(this.targetType.name());
        if (this.targetDN != null) {
            buffer.append(", targetDN='");
            buffer.append(this.targetDN);
            buffer.append('\'');
        }
        if ((controls = this.getControls()).length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

