/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessages;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class LogMessage
implements Serializable {
    @NotNull
    private static final String TIMESTAMP_SEC_FORMAT = "'['dd/MMM/yyyy:HH:mm:ss Z']'";
    @NotNull
    private static final String TIMESTAMP_MS_FORMAT = "'['dd/MMM/yyyy:HH:mm:ss.SSS Z']'";
    @NotNull
    private static final ThreadLocal<SimpleDateFormat> dateSecFormat = new ThreadLocal();
    @NotNull
    private static final ThreadLocal<SimpleDateFormat> dateMsFormat = new ThreadLocal();
    private static final long serialVersionUID = -1210050773534504972L;
    @NotNull
    private final Date timestamp;
    @NotNull
    private final Map<String, String> namedValues;
    @NotNull
    private final Set<String> unnamedValues;
    @NotNull
    private final String messageString;

    protected LogMessage(@NotNull LogMessage m) {
        this.timestamp = m.timestamp;
        this.unnamedValues = m.unnamedValues;
        this.namedValues = m.namedValues;
        this.messageString = m.messageString;
    }

    protected LogMessage(@NotNull String s) throws LogException {
        SimpleDateFormat f;
        this.messageString = s;
        int bracketPos = s.indexOf(93);
        if (bracketPos < 0) {
            throw new LogException(s, LogMessages.ERR_LOG_MESSAGE_NO_TIMESTAMP.get());
        }
        String timestampString = s.substring(0, bracketPos + 1);
        if (LogMessage.timestampIncludesMilliseconds(timestampString)) {
            f = dateMsFormat.get();
            if (f == null) {
                f = new SimpleDateFormat(TIMESTAMP_MS_FORMAT);
                f.setLenient(false);
                dateMsFormat.set(f);
            }
        } else {
            f = dateSecFormat.get();
            if (f == null) {
                f = new SimpleDateFormat(TIMESTAMP_SEC_FORMAT);
                f.setLenient(false);
                dateSecFormat.set(f);
            }
        }
        try {
            this.timestamp = f.parse(timestampString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LogException(s, LogMessages.ERR_LOG_MESSAGE_INVALID_TIMESTAMP.get(StaticUtils.getExceptionMessage(e)), e);
        }
        LinkedHashMap<String, String> named = new LinkedHashMap<String, String>(StaticUtils.computeMapCapacity(10));
        LinkedHashSet<String> unnamed = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(10));
        LogMessage.parseTokens(s, bracketPos + 1, named, unnamed);
        this.namedValues = Collections.unmodifiableMap(named);
        this.unnamedValues = Collections.unmodifiableSet(unnamed);
    }

    private static void parseTokens(@NotNull String s, int startPos, @NotNull Map<String, String> named, @NotNull Set<String> unnamed) throws LogException {
        boolean inQuotes = false;
        StringBuilder buffer = new StringBuilder();
        for (int p = startPos; p < s.length(); ++p) {
            char c = s.charAt(p);
            if (c == ' ' && !inQuotes) {
                if (buffer.length() <= 0) continue;
                LogMessage.processToken(s, buffer.toString(), named, unnamed);
                buffer.delete(0, buffer.length());
                continue;
            }
            if (c == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            buffer.append(c);
        }
        if (buffer.length() > 0) {
            LogMessage.processToken(s, buffer.toString(), named, unnamed);
        }
    }

    private static void processToken(@NotNull String s, @NotNull String token, @NotNull Map<String, String> named, @NotNull Set<String> unnamed) throws LogException {
        int equalPos = token.indexOf(61);
        if (equalPos < 0) {
            unnamed.add(token);
        } else {
            String name = token.substring(0, equalPos);
            String value = LogMessage.processValue(s, token.substring(equalPos + 1));
            named.put(name, value);
        }
    }

    @NotNull
    private static String processValue(@NotNull String s, @NotNull String v) throws LogException {
        ByteStringBuffer b = new ByteStringBuffer();
        for (int i = 0; i < v.length(); ++i) {
            char c = v.charAt(i);
            if (c == '\"') continue;
            if (c == '#') {
                if (i > v.length() - 3) {
                    throw new LogException(s, LogMessages.ERR_LOG_MESSAGE_INVALID_ESCAPED_CHARACTER.get(v));
                }
                byte rawByte = 0;
                block19: for (int j = 0; j < 2; ++j) {
                    rawByte = (byte)(rawByte << 4);
                    switch (v.charAt(++i)) {
                        case '0': {
                            continue block19;
                        }
                        case '1': {
                            rawByte = (byte)(rawByte | 1);
                            continue block19;
                        }
                        case '2': {
                            rawByte = (byte)(rawByte | 2);
                            continue block19;
                        }
                        case '3': {
                            rawByte = (byte)(rawByte | 3);
                            continue block19;
                        }
                        case '4': {
                            rawByte = (byte)(rawByte | 4);
                            continue block19;
                        }
                        case '5': {
                            rawByte = (byte)(rawByte | 5);
                            continue block19;
                        }
                        case '6': {
                            rawByte = (byte)(rawByte | 6);
                            continue block19;
                        }
                        case '7': {
                            rawByte = (byte)(rawByte | 7);
                            continue block19;
                        }
                        case '8': {
                            rawByte = (byte)(rawByte | 8);
                            continue block19;
                        }
                        case '9': {
                            rawByte = (byte)(rawByte | 9);
                            continue block19;
                        }
                        case 'A': 
                        case 'a': {
                            rawByte = (byte)(rawByte | 0xA);
                            continue block19;
                        }
                        case 'B': 
                        case 'b': {
                            rawByte = (byte)(rawByte | 0xB);
                            continue block19;
                        }
                        case 'C': 
                        case 'c': {
                            rawByte = (byte)(rawByte | 0xC);
                            continue block19;
                        }
                        case 'D': 
                        case 'd': {
                            rawByte = (byte)(rawByte | 0xD);
                            continue block19;
                        }
                        case 'E': 
                        case 'e': {
                            rawByte = (byte)(rawByte | 0xE);
                            continue block19;
                        }
                        case 'F': 
                        case 'f': {
                            rawByte = (byte)(rawByte | 0xF);
                            continue block19;
                        }
                        default: {
                            throw new LogException(s, LogMessages.ERR_LOG_MESSAGE_INVALID_ESCAPED_CHARACTER.get(v));
                        }
                    }
                }
                b.append(rawByte);
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    private static boolean timestampIncludesMilliseconds(@NotNull String timestamp) {
        return timestamp.length() > 21 && timestamp.charAt(21) == '.';
    }

    @NotNull
    public final Date getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public final Map<String, String> getNamedValues() {
        return this.namedValues;
    }

    @Nullable
    public final String getNamedValue(@NotNull String name) {
        return this.namedValues.get(name);
    }

    @Nullable
    public final Boolean getNamedValueAsBoolean(@NotNull String name) {
        String s = this.namedValues.get(name);
        if (s == null) {
            return null;
        }
        String lowerValue = StaticUtils.toLowerCase(s);
        if (lowerValue.equals("true") || lowerValue.equals("t") || lowerValue.equals("yes") || lowerValue.equals("y") || lowerValue.equals("on") || lowerValue.equals("1")) {
            return Boolean.TRUE;
        }
        if (lowerValue.equals("false") || lowerValue.equals("f") || lowerValue.equals("no") || lowerValue.equals("n") || lowerValue.equals("off") || lowerValue.equals("0")) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Nullable
    public final Double getNamedValueAsDouble(@NotNull String name) {
        String s = this.namedValues.get(name);
        if (s == null) {
            return null;
        }
        try {
            return Double.valueOf(s);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Nullable
    public final Integer getNamedValueAsInteger(@NotNull String name) {
        String s = this.namedValues.get(name);
        if (s == null) {
            return null;
        }
        try {
            return Integer.valueOf(s);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Nullable
    public final Long getNamedValueAsLong(@NotNull String name) {
        String s = this.namedValues.get(name);
        if (s == null) {
            return null;
        }
        try {
            return Long.valueOf(s);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @NotNull
    public final Set<String> getUnnamedValues() {
        return this.unnamedValues;
    }

    public final boolean hasUnnamedValue(@NotNull String value) {
        return this.unnamedValues.contains(value);
    }

    @NotNull
    public final String toString() {
        return this.messageString;
    }
}

