/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.JSONExistsOnStep;
import org.jooq.Keyword;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.Cast;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;

final class JSONExists
extends AbstractCondition
implements JSONExistsOnStep,
QOM.UNotYetImplemented {
    private final Field<?> json;
    private final Field<String> path;

    JSONExists(Field<?> json, Field<String> path) {
        this(json, path, null);
    }

    private JSONExists(Field<?> json, Field<String> path, Behaviour onError) {
        this.json = json;
        this.path = path;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MYSQL: {
                ctx.visit(Names.N_JSON_CONTAINS_PATH).sql('(').visit(this.json).sql(", 'one', ").visit(this.path).sql(')');
                break;
            }
            case SQLITE: {
                ctx.visit(DSL.function(Names.N_JSON_TYPE, SQLDataType.JSON, this.json, this.path).isNotNull());
                break;
            }
            case POSTGRES: 
            case YUGABYTEDB: {
                ctx.visit(Names.N_JSONB_PATH_EXISTS).sql('(').visit(Tools.castIfNeeded(this.json, SQLDataType.JSONB)).sql(", ");
                Cast.renderCast(ctx, c -> c.visit(this.path), c -> c.visit(Names.N_JSONPATH));
                ctx.sql(')');
                break;
            }
            case CLICKHOUSE: {
                ctx.visit(DSL.function(DSL.systemName("JSON_EXISTS"), this.getDataType(), this.json, this.path));
                break;
            }
            case DUCKDB: {
                ctx.visit(DSL.jsonGetAttribute(this.json, this.path).isNotNull());
                break;
            }
            default: {
                ctx.visit(Keywords.K_JSON_EXISTS).sql('(').visit(this.json).sql(", ");
                ctx.visit(this.path);
                ctx.sql(')');
            }
        }
    }

    static enum Behaviour {
        ERROR,
        TRUE,
        FALSE,
        UNKNOWN;

        final Keyword keyword = DSL.keyword(this.name().toLowerCase());
    }
}

