/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.HttpAsyncContentProducer;
import org.apache.http.util.Args;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class ReactiveDataProducer
implements HttpAsyncContentProducer,
Subscriber<ByteBuffer> {
    private static final int BUFFER_WINDOW_SIZE = 5;
    private final AtomicReference<IOControl> controlChannel = new AtomicReference();
    private final AtomicReference<Throwable> exception = new AtomicReference();
    private final AtomicBoolean complete = new AtomicBoolean(false);
    private final Publisher<ByteBuffer> publisher;
    private final AtomicReference<Subscription> subscription = new AtomicReference();
    private final ArrayDeque<ByteBuffer> buffers = new ArrayDeque();
    private final ReentrantLock lock;

    public ReactiveDataProducer(Publisher<ByteBuffer> publisher) {
        this.publisher = (Publisher)Args.notNull(publisher, (String)"publisher");
        this.lock = new ReentrantLock();
    }

    public void onSubscribe(Subscription subscription) {
        if (this.subscription.getAndSet(subscription) != null) {
            throw new IllegalStateException("Already subscribed");
        }
        subscription.request(5L);
    }

    public void onNext(ByteBuffer byteBuffer) {
        byte[] copy = new byte[byteBuffer.remaining()];
        byteBuffer.get(copy);
        this.lock.lock();
        try {
            this.buffers.add(ByteBuffer.wrap(copy));
        }
        finally {
            this.lock.unlock();
        }
        if (this.controlChannel.get() != null) {
            this.controlChannel.get().requestOutput();
        }
    }

    public void onError(Throwable throwable) {
        this.subscription.set(null);
        this.exception.set(throwable);
        if (this.controlChannel.get() != null) {
            this.controlChannel.get().requestOutput();
        }
    }

    public void onComplete() {
        this.subscription.set(null);
        this.complete.set(true);
        if (this.controlChannel.get() != null) {
            this.controlChannel.get().requestOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceContent(ContentEncoder encoder, IOControl ioControl) throws IOException {
        block13: {
            if (this.controlChannel.get() == null) {
                this.controlChannel.set(ioControl);
                this.publisher.subscribe((Subscriber)this);
            }
            Throwable t = this.exception.get();
            Subscription s = this.subscription.get();
            int buffersToReplenish = 0;
            try {
                this.lock.lock();
                try {
                    if (t != null) {
                        throw new IOException(t.getMessage(), t);
                    }
                    if (this.complete.get() && this.buffers.isEmpty()) {
                        encoder.complete();
                        break block13;
                    }
                    while (!this.buffers.isEmpty()) {
                        ByteBuffer nextBuffer = this.buffers.remove();
                        encoder.write(nextBuffer);
                        if (nextBuffer.remaining() > 0) {
                            this.buffers.push(nextBuffer);
                            break;
                        }
                        if (s == null) continue;
                        ++buffersToReplenish;
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            finally {
                if (s != null && buffersToReplenish > 0) {
                    s.request((long)buffersToReplenish);
                }
                if (!this.complete.get()) {
                    ioControl.suspendOutput();
                }
            }
        }
    }

    public boolean isRepeatable() {
        return false;
    }

    public void close() throws IOException {
        this.controlChannel.set(null);
        Subscription s = this.subscription.getAndSet(null);
        if (s != null) {
            s.cancel();
        }
    }
}

