/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import org.apache.james.events.EventBusId;
import org.apache.james.events.EventBusName;
import org.apache.james.events.Group;
import org.apache.james.events.GroupConsumerRetry;
import org.apache.james.events.GroupRegistration;
import org.apache.james.events.RegistrationQueueName;
import reactor.rabbitmq.QueueSpecification;

public class NamingStrategy {
    public static final EventBusName JMAP_EVENT_BUS_NAME = new EventBusName("jmapEvent");
    public static final EventBusName MAILBOX_EVENT_BUS_NAME = new EventBusName("mailboxEvent");
    public static final NamingStrategy JMAP_NAMING_STRATEGY = new NamingStrategy(JMAP_EVENT_BUS_NAME);
    public static final NamingStrategy MAILBOX_EVENT_NAMING_STRATEGY = new NamingStrategy(MAILBOX_EVENT_BUS_NAME);
    private final EventBusName eventBusName;

    public NamingStrategy(EventBusName eventBusName) {
        this.eventBusName = eventBusName;
    }

    public RegistrationQueueName queueName(EventBusId eventBusId) {
        return new RegistrationQueueName(this.eventBusName.value() + "-eventbus-" + eventBusId.asString());
    }

    public QueueSpecification deadLetterQueue() {
        return QueueSpecification.queue((String)(this.eventBusName.value() + "-dead-letter-queue"));
    }

    public String exchange() {
        return this.eventBusName.value() + "-exchange";
    }

    public String deadLetterExchange() {
        return this.eventBusName.value() + "-dead-letter-exchange";
    }

    public GroupConsumerRetry.RetryExchangeName retryExchange(Group group) {
        return new GroupConsumerRetry.RetryExchangeName(this.eventBusName.value(), group);
    }

    public GroupRegistration.WorkQueueName workQueue(Group group) {
        return new GroupRegistration.WorkQueueName(this.eventBusName.value(), group);
    }

    public EventBusName getEventBusName() {
        return this.eventBusName;
    }
}

