/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.reflection;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.johnzon.mapper.reflection.JohnzonParameterizedType;

public final class Generics {
    private Generics() {
    }

    public static Type resolve(Type value, Class<?> rootClass) {
        if (TypeVariable.class.isInstance(value)) {
            return Generics.resolveTypeVariable(value, rootClass);
        }
        if (ParameterizedType.class.isInstance(value)) {
            return Generics.resolveParameterizedType(value, rootClass);
        }
        return value;
    }

    private static Type resolveParameterizedType(Type value, Class<?> rootClass) {
        ArrayList<Type> args = null;
        ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(value);
        int index = 0;
        for (Type arg : parameterizedType.getActualTypeArguments()) {
            Type type = Generics.resolve(arg, rootClass);
            if (type != arg && args == null) {
                args = new ArrayList<Type>();
                if (index > 0) {
                    args.addAll(Arrays.asList(parameterizedType.getActualTypeArguments()).subList(0, index));
                }
            }
            if (args != null) {
                args.add(type);
            }
            ++index;
        }
        if (args != null) {
            return new JohnzonParameterizedType(parameterizedType.getRawType(), args.toArray(new Type[args.size()]));
        }
        return value;
    }

    private static Type resolveTypeVariable(Type value, Class<?> rootClass) {
        ParameterizedType parentPt;
        int argIndex;
        Type parent;
        TypeVariable tv = (TypeVariable)TypeVariable.class.cast(value);
        Type type = parent = rootClass == null ? null : rootClass.getGenericSuperclass();
        while (Class.class.isInstance(parent)) {
            parent = ((Class)Class.class.cast(parent)).getGenericSuperclass();
        }
        while (ParameterizedType.class.isInstance(parent) && ((ParameterizedType)ParameterizedType.class.cast(parent)).getRawType() != tv.getGenericDeclaration()) {
            parent = ((Class)Class.class.cast(((ParameterizedType)ParameterizedType.class.cast(parent)).getRawType())).getGenericSuperclass();
        }
        if (ParameterizedType.class.isInstance(parent) && (argIndex = Arrays.asList(((Class)Class.class.cast((parentPt = (ParameterizedType)ParameterizedType.class.cast(parent)).getRawType())).getTypeParameters()).indexOf(tv)) >= 0) {
            Type type2 = parentPt.getActualTypeArguments()[argIndex];
            if (TypeVariable.class.isInstance(type2)) {
                return Generics.resolveTypeVariable(type2, rootClass);
            }
            return type2;
        }
        return value;
    }
}

