/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.whiteboard;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.registry.PerContextHandlerRegistry;
import org.apache.felix.http.base.internal.runtime.ServletContextHelperInfo;
import org.apache.felix.http.base.internal.service.HttpServiceFactory;
import org.apache.felix.http.base.internal.service.PerBundleHttpServiceImpl;
import org.apache.felix.http.base.internal.whiteboard.WhiteboardContextHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;

public class HttpServiceContextHandler
extends WhiteboardContextHandler {
    private final PerContextHandlerRegistry registry;
    private final HttpServiceFactory httpServiceFactory;
    private final Map<Long, ContextHolder> perBundleContextMap = new HashMap<Long, ContextHolder>();
    private final ServletContext sharedContext;

    public HttpServiceContextHandler(ServletContextHelperInfo info, PerContextHandlerRegistry registry, HttpServiceFactory httpServiceFactory, ServletContext webContext, Bundle httpBundle) {
        super(info, webContext, httpBundle);
        this.registry = registry;
        this.httpServiceFactory = httpServiceFactory;
        this.sharedContext = webContext;
    }

    @Override
    public PerContextHandlerRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public ServletContext getSharedContext() {
        return this.sharedContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForNull
    public ExtServletContext getServletContext(@CheckForNull Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        Long key = bundle.getBundleId();
        Map<Long, ContextHolder> map = this.perBundleContextMap;
        synchronized (map) {
            ContextHolder holder = this.perBundleContextMap.get(key);
            if (holder == null) {
                holder = new ContextHolder();
                PerBundleHttpServiceImpl service = (PerBundleHttpServiceImpl)this.httpServiceFactory.getService(bundle, (ServiceRegistration)null);
                holder.servletContext = service.getServletContext(service.createDefaultHttpContext());
                holder.httpService = service;
                this.perBundleContextMap.put(key, holder);
            }
            ++holder.counter;
            return holder.servletContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ungetServletContext(@Nonnull Bundle bundle) {
        Long key = bundle.getBundleId();
        Map<Long, ContextHolder> map = this.perBundleContextMap;
        synchronized (map) {
            ContextHolder holder = this.perBundleContextMap.get(key);
            if (holder != null) {
                --holder.counter;
                if (holder.counter == 0L) {
                    this.perBundleContextMap.remove(key);
                    holder.httpService.unregisterAll();
                }
            }
        }
    }

    private static final class ContextHolder {
        public long counter;
        public ExtServletContext servletContext;
        public PerBundleHttpServiceImpl httpService;

        private ContextHolder() {
        }
    }
}

