/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console.standalone;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.felix.gogo.runtime.threadio.ThreadIOImpl;
import org.apache.felix.service.threadio.ThreadIO;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.impl.action.command.ManagerImpl;
import org.apache.karaf.shell.impl.console.JLineTerminal;
import org.apache.karaf.shell.impl.console.SessionFactoryImpl;
import org.apache.karaf.shell.impl.console.TerminalFactory;
import org.apache.karaf.shell.support.ShellUtil;
import org.fusesource.jansi.AnsiConsole;

public class Main {
    private String application = System.getProperty("karaf.name", "root");
    private String user = "karaf";

    public static void main(String[] args) throws Exception {
        Main main = new Main();
        main.run(args);
    }

    public void run(String[] args) throws Exception {
        ThreadIOImpl threadio = new ThreadIOImpl();
        threadio.start();
        InputStream in = Main.unwrap(System.in);
        PrintStream out = Main.wrap(Main.unwrap(System.out));
        PrintStream err = Main.wrap(Main.unwrap(System.err));
        this.run(threadio, args, in, out, err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(ThreadIO threadio, String[] args, InputStream in, PrintStream out, PrintStream err) throws Exception {
        StringBuilder sb = new StringBuilder();
        String classpath = null;
        boolean batch = false;
        String file = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("--classpath=")) {
                classpath = arg.substring("--classpath=".length());
                continue;
            }
            if (arg.startsWith("-c=")) {
                classpath = arg.substring("-c=".length());
                continue;
            }
            if (arg.equals("--classpath") || arg.equals("-c")) {
                classpath = args[++i];
                continue;
            }
            if (arg.equals("-b") || arg.equals("--batch")) {
                batch = true;
                continue;
            }
            if (arg.startsWith("--file=")) {
                file = arg.substring("--file=".length());
                continue;
            }
            if (arg.startsWith("-f=")) {
                file = arg.substring("-f=".length());
                continue;
            }
            if (arg.equals("--file") || arg.equals("-f")) {
                file = args[++i];
                continue;
            }
            sb.append(arg);
            sb.append(' ');
        }
        if (file != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
                sb.setLength(0);
                int c = ((Reader)reader).read();
                while (c >= 0) {
                    sb.append((char)c);
                    c = ((Reader)reader).read();
                }
            }
        } else if (batch) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            sb.setLength(0);
            int c = ((Reader)reader).read();
            while (c >= 0) {
                sb.append((char)c);
                ((Reader)reader).read();
            }
        }
        ClassLoader cl = Main.class.getClassLoader();
        if (classpath != null) {
            List<URL> urls = Main.getFiles(new File(classpath));
            cl = new URLClassLoader(urls.toArray(new URL[urls.size()]), cl);
        }
        SessionFactory sessionFactory = this.createSessionFactory(threadio);
        this.run(sessionFactory, sb.toString(), in, out, err, cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(SessionFactory sessionFactory, String command, InputStream in, PrintStream out, PrintStream err, ClassLoader cl) throws Exception {
        TerminalFactory terminalFactory = new TerminalFactory();
        try {
            String term = System.getenv("TERM");
            JLineTerminal terminal = new JLineTerminal(terminalFactory.getTerminal(), term);
            Session session = this.createSession(sessionFactory, command.length() > 0 ? null : in, out, err, terminal);
            session.put("USER", this.user);
            session.put("APPLICATION", this.application);
            this.discoverCommands(session, cl, this.getDiscoveryResource());
            if (command.length() > 0) {
                session.put("MULTI_SCOPE_MODE", Boolean.toString(this.isMultiScopeMode()));
                session.put("karaf.printStackTraces", "execution");
                try {
                    session.execute(command);
                }
                catch (Throwable t) {
                    ShellUtil.logException(session, t);
                }
            } else {
                session.run();
            }
        }
        finally {
            terminalFactory.destroy();
        }
    }

    protected Session createSession(SessionFactory sessionFactory, InputStream in, PrintStream out, PrintStream err, Terminal terminal) throws Exception {
        return sessionFactory.create(in, out, err, terminal, null, null);
    }

    protected SessionFactory createSessionFactory(ThreadIO threadio) {
        SessionFactoryImpl sessionFactory = new SessionFactoryImpl(threadio);
        sessionFactory.register(new ManagerImpl(sessionFactory, sessionFactory));
        return sessionFactory;
    }

    public String getDiscoveryResource() {
        return "META-INF/services/org/apache/karaf/shell/commands";
    }

    protected void discoverCommands(Session session, ClassLoader cl, String resource) throws IOException, ClassNotFoundException {
        ManagerImpl manager = new ManagerImpl(session.getRegistry(), session.getFactory().getRegistry(), true);
        Enumeration<URL> urls = cl.getResources(resource);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = r.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0 && line.charAt(0) != '#') {
                    Class<?> actionClass = cl.loadClass(line);
                    manager.register(actionClass);
                }
                line = r.readLine();
            }
            r.close();
        }
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean isMultiScopeMode() {
        return true;
    }

    private static PrintStream wrap(PrintStream stream) {
        OutputStream o = AnsiConsole.wrapOutputStream((OutputStream)stream);
        if (o instanceof PrintStream) {
            return (PrintStream)o;
        }
        return new PrintStream(o);
    }

    private static <T> T unwrap(T stream) {
        try {
            Method mth = stream.getClass().getMethod("getRoot", new Class[0]);
            return (T)mth.invoke(stream, new Object[0]);
        }
        catch (Throwable t) {
            return stream;
        }
    }

    private static List<URL> getFiles(File base) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Main.getFiles(base, urls);
        return urls;
    }

    private static void getFiles(File base, List<URL> urls) throws MalformedURLException {
        for (File f : base.listFiles()) {
            if (f.isDirectory()) {
                Main.getFiles(f, urls);
                continue;
            }
            if (!f.getName().endsWith(".jar")) continue;
            urls.add(f.toURI().toURL());
        }
    }
}

