/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.spi;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.rule.InFixToPostFix;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public final class LoggingEventFieldResolver {
    public static final List KEYWORD_LIST = new ArrayList();
    public static final String LOGGER_FIELD = "LOGGER";
    public static final String LEVEL_FIELD = "LEVEL";
    public static final String CLASS_FIELD = "CLASS";
    public static final String FILE_FIELD = "FILE";
    public static final String LINE_FIELD = "LINE";
    public static final String METHOD_FIELD = "METHOD";
    public static final String MSG_FIELD = "MSG";
    public static final String NDC_FIELD = "NDC";
    public static final String EXCEPTION_FIELD = "EXCEPTION";
    public static final String TIMESTAMP_FIELD = "TIMESTAMP";
    public static final String THREAD_FIELD = "THREAD";
    public static final String PROP_FIELD = "PROP.";
    public static final String EMPTY_STRING = "";
    private static final LoggingEventFieldResolver RESOLVER = new LoggingEventFieldResolver();

    private LoggingEventFieldResolver() {
        KEYWORD_LIST.add(LOGGER_FIELD);
        KEYWORD_LIST.add(LEVEL_FIELD);
        KEYWORD_LIST.add(CLASS_FIELD);
        KEYWORD_LIST.add(FILE_FIELD);
        KEYWORD_LIST.add(LINE_FIELD);
        KEYWORD_LIST.add(METHOD_FIELD);
        KEYWORD_LIST.add(MSG_FIELD);
        KEYWORD_LIST.add(NDC_FIELD);
        KEYWORD_LIST.add(EXCEPTION_FIELD);
        KEYWORD_LIST.add(TIMESTAMP_FIELD);
        KEYWORD_LIST.add(THREAD_FIELD);
        KEYWORD_LIST.add(PROP_FIELD);
    }

    public String applyFields(String replaceText, LoggingEvent event) {
        if (replaceText == null) {
            return null;
        }
        InFixToPostFix.CustomTokenizer tokenizer = new InFixToPostFix.CustomTokenizer(replaceText);
        StringBuffer result = new StringBuffer();
        boolean found = false;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (this.isField(token) || token.toUpperCase(Locale.US).startsWith(PROP_FIELD)) {
                result.append(this.getValue(token, event).toString());
                found = true;
                continue;
            }
            result.append(token);
        }
        if (found) {
            return result.toString();
        }
        return null;
    }

    public static LoggingEventFieldResolver getInstance() {
        return RESOLVER;
    }

    public boolean isField(String fieldName) {
        if (fieldName != null) {
            return KEYWORD_LIST.contains(fieldName.toUpperCase(Locale.US)) || fieldName.toUpperCase().startsWith(PROP_FIELD);
        }
        return false;
    }

    public Object getValue(String fieldName, LoggingEvent event) {
        String upperField = fieldName.toUpperCase(Locale.US);
        if (LOGGER_FIELD.equals(upperField)) {
            return event.getLoggerName();
        }
        if (LEVEL_FIELD.equals(upperField)) {
            return event.getLevel();
        }
        if (MSG_FIELD.equals(upperField)) {
            return event.getMessage();
        }
        if (NDC_FIELD.equals(upperField)) {
            String ndcValue = event.getNDC();
            return ndcValue == null ? EMPTY_STRING : ndcValue;
        }
        if (EXCEPTION_FIELD.equals(upperField)) {
            String[] throwableRep = event.getThrowableStrRep();
            if (throwableRep == null) {
                return EMPTY_STRING;
            }
            return LoggingEventFieldResolver.getExceptionMessage(throwableRep);
        }
        if (TIMESTAMP_FIELD.equals(upperField)) {
            return new Long(event.timeStamp);
        }
        if (THREAD_FIELD.equals(upperField)) {
            return event.getThreadName();
        }
        if (upperField.startsWith(PROP_FIELD)) {
            Object propValue = event.getMDC(fieldName.substring(5));
            if (propValue == null) {
                String lowerPropKey = fieldName.substring(5).toLowerCase();
                Set entrySet = event.getProperties().entrySet();
                for (Map.Entry thisEntry : entrySet) {
                    if (!thisEntry.getKey().toString().equalsIgnoreCase(lowerPropKey)) continue;
                    propValue = thisEntry.getValue();
                }
            }
            return propValue == null ? EMPTY_STRING : propValue.toString();
        }
        LocationInfo info = event.getLocationInformation();
        if (CLASS_FIELD.equals(upperField)) {
            return info == null ? EMPTY_STRING : info.getClassName();
        }
        if (FILE_FIELD.equals(upperField)) {
            return info == null ? EMPTY_STRING : info.getFileName();
        }
        if (LINE_FIELD.equals(upperField)) {
            return info == null ? EMPTY_STRING : info.getLineNumber();
        }
        if (METHOD_FIELD.equals(upperField)) {
            return info == null ? EMPTY_STRING : info.getMethodName();
        }
        throw new IllegalArgumentException("Unsupported field name: " + fieldName);
    }

    private static String getExceptionMessage(String[] exception) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < exception.length; ++i) {
            buff.append(exception[i]);
        }
        return buff.toString();
    }
}

