/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.zookeeper.ClientCnxn;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class InjectSessionExpiration {
    private static final Field cnxnField;
    private static final Field stateField;
    private static final Field eventThreadField;
    private static final Field sendThreadField;
    private static final Method queueEventMethod;
    private static final Method queueEventOfDeathMethod;
    private static final Method getClientCnxnSocketMethod;
    private static final Method wakeupCnxnMethod;

    public static void injectSessionExpiration(ZooKeeper zooKeeper) {
        try {
            WatchedEvent event = new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, null);
            ClientCnxn clientCnxn = (ClientCnxn)cnxnField.get(zooKeeper);
            Object eventThread = eventThreadField.get(clientCnxn);
            queueEventMethod.invoke(eventThread, event);
            queueEventOfDeathMethod.invoke(eventThread, new Object[0]);
            stateField.set(clientCnxn, ZooKeeper.States.CLOSED);
            Object sendThread = sendThreadField.get(clientCnxn);
            Object clientCnxnSocket = getClientCnxnSocketMethod.invoke(sendThread, new Object[0]);
            wakeupCnxnMethod.invoke(clientCnxnSocket, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not inject session expiration using reflection", e);
        }
    }

    static {
        Method localWakeupCnxnMethod;
        Method localGetClientCnxnSocketMethod;
        Method localEventOfDeathMethod;
        Method localQueueEventMethod;
        Field localSendThreadField;
        Field localEventThreadField;
        Field localStateField;
        Field localCnxnField;
        try {
            Class<?> eventThreadClass = Class.forName("org.apache.zookeeper.ClientCnxn$EventThread");
            Class<?> sendThreadClass = Class.forName("org.apache.zookeeper.ClientCnxn$SendThread");
            Class<?> clientCnxnSocketClass = Class.forName("org.apache.zookeeper.ClientCnxnSocket");
            localCnxnField = ZooKeeper.class.getDeclaredField("cnxn");
            localCnxnField.setAccessible(true);
            localStateField = ClientCnxn.class.getDeclaredField("state");
            localStateField.setAccessible(true);
            localEventThreadField = ClientCnxn.class.getDeclaredField("eventThread");
            localEventThreadField.setAccessible(true);
            localSendThreadField = ClientCnxn.class.getDeclaredField("sendThread");
            localSendThreadField.setAccessible(true);
            localQueueEventMethod = eventThreadClass.getDeclaredMethod("queueEvent", WatchedEvent.class);
            localQueueEventMethod.setAccessible(true);
            localEventOfDeathMethod = eventThreadClass.getDeclaredMethod("queueEventOfDeath", new Class[0]);
            localEventOfDeathMethod.setAccessible(true);
            localGetClientCnxnSocketMethod = sendThreadClass.getDeclaredMethod("getClientCnxnSocket", new Class[0]);
            localGetClientCnxnSocketMethod.setAccessible(true);
            localWakeupCnxnMethod = clientCnxnSocketClass.getDeclaredMethod("wakeupCnxn", new Class[0]);
            localWakeupCnxnMethod.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not access internal ZooKeeper fields", e);
        }
        cnxnField = localCnxnField;
        stateField = localStateField;
        eventThreadField = localEventThreadField;
        sendThreadField = localSendThreadField;
        queueEventMethod = localQueueEventMethod;
        queueEventOfDeathMethod = localEventOfDeathMethod;
        getClientCnxnSocketMethod = localGetClientCnxnSocketMethod;
        wakeupCnxnMethod = localWakeupCnxnMethod;
    }
}

