/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.interceptor.context;

import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.OperationEnum;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.interceptor.context.AbstractChangeOperationContext;

public class AddOperationContext
extends AbstractChangeOperationContext {
    public AddOperationContext(CoreSession session) {
        super(session);
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.ADD));
        }
    }

    public AddOperationContext(CoreSession session, Dn dn) {
        super(session, dn);
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.ADD));
        }
    }

    public AddOperationContext(CoreSession session, Entry entry) {
        super(session, entry.getDn());
        this.entry = new ClonedServerEntry(entry);
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.ADD));
        }
    }

    public AddOperationContext(CoreSession session, Dn dn, Entry entry) {
        super(session, dn);
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.ADD));
        }
        this.entry = new ClonedServerEntry(entry);
    }

    public AddOperationContext(CoreSession session, AddRequest addRequest) throws LdapException {
        super(session);
        if (session == null) {
            throw new LdapOperationErrorException("No session to proceed the operation");
        }
        this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.ADD));
        Entry addEntry = addRequest.getEntry();
        this.entry = addEntry.isSchemaAware() ? new ClonedServerEntry(addEntry) : new ClonedServerEntry(new DefaultEntry(session.getDirectoryService().getSchemaManager(), addRequest.getEntry()));
        this.dn = addRequest.getEntry().getDn();
        this.requestControls = addRequest.getControls();
        if (this.requestControls.containsKey("2.16.840.1.113730.3.4.2")) {
            this.ignoreReferral();
        } else {
            this.throwReferral();
        }
    }

    @Override
    public String getName() {
        return MessageTypeEnum.ADD_REQUEST.name();
    }

    public String toString() {
        return "AddContext for Dn '" + this.getDn().getName() + "', added entry: " + this.entry;
    }
}

