/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.ad_impl;

import java.util.Set;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.extras.controls.ad.AdDirSyncFlag;
import org.apache.directory.api.ldap.extras.controls.ad_impl.AdDirSyncContainer;
import org.apache.directory.api.ldap.extras.controls.ad_impl.AdDirSyncStatesEnum;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AdDirSyncGrammar
extends AbstractGrammar<AdDirSyncContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(AdDirSyncGrammar.class);
    private static final AdDirSyncGrammar INSTANCE = new AdDirSyncGrammar();

    private AdDirSyncGrammar() {
        this.setName(AdDirSyncGrammar.class.getName());
        this.transitions = new GrammarTransition[AdDirSyncStatesEnum.LAST_AD_DIR_SYNC_STATE.ordinal()][256];
        this.transitions[AdDirSyncStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)AdDirSyncStatesEnum.START_STATE, (Enum)AdDirSyncStatesEnum.AD_DIR_SYNC_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new GrammarAction<AdDirSyncContainer>("Initialization"){

            public void action(AdDirSyncContainer container) throws DecoderException {
            }
        });
        this.transitions[AdDirSyncStatesEnum.AD_DIR_SYNC_SEQUENCE_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition((Enum)AdDirSyncStatesEnum.AD_DIR_SYNC_SEQUENCE_STATE, (Enum)AdDirSyncStatesEnum.FLAG_STATE, (int)UniversalTag.INTEGER.getValue(), (Action)new GrammarAction<AdDirSyncContainer>("Set AdDirSyncControl parentFirst"){

            public void action(AdDirSyncContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    int flagValue = IntegerDecoder.parse((BerValue)value);
                    Set flags = AdDirSyncFlag.getFlags((int)flagValue);
                    if (flags == null) {
                        String msg = I18n.err((I18n)I18n.ERR_08104_AD_DIR_SYNC_FLAG_DECODING_FAILURE, (Object[])new Object[]{flagValue});
                        LOG.error(msg);
                        throw new DecoderException(msg);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg((I18n)I18n.MSG_08101_FLAGS, (Object[])new Object[]{flags.toString()}));
                    }
                    container.getAdDirSyncControl().setFlags(flags);
                }
                catch (IntegerDecoderException ide) {
                    String msg = I18n.err((I18n)I18n.ERR_08105_AD_DIR_SYNC_FLAG_DECODING_ERROR, (Object[])new Object[]{ide.getMessage()});
                    LOG.error(msg, (Throwable)ide);
                    throw new DecoderException(msg, (Throwable)ide);
                }
            }
        });
        this.transitions[AdDirSyncStatesEnum.FLAG_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition((Enum)AdDirSyncStatesEnum.FLAG_STATE, (Enum)AdDirSyncStatesEnum.MAX_RETURN_LENGTH_STATE, (int)UniversalTag.INTEGER.getValue(), (Action)new GrammarAction<AdDirSyncContainer>("Set AdDirSyncControl maxReturnLength"){

            public void action(AdDirSyncContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    int maxReturnLength = IntegerDecoder.parse((BerValue)value);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg((I18n)I18n.MSG_08102_MAX_RETURN_LENGTH, (Object[])new Object[]{maxReturnLength}));
                    }
                    container.getAdDirSyncControl().setMaxReturnLength(maxReturnLength);
                }
                catch (IntegerDecoderException ide) {
                    String msg = I18n.err((I18n)I18n.ERR_08106_AD_DIR_SYNC_MAX_RETURN_LENGTH_DECODING_ERROR, (Object[])new Object[]{ide.getMessage()});
                    LOG.error(msg, (Throwable)ide);
                    throw new DecoderException(msg, (Throwable)ide);
                }
            }
        });
        this.transitions[AdDirSyncStatesEnum.MAX_RETURN_LENGTH_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)AdDirSyncStatesEnum.MAX_RETURN_LENGTH_STATE, (Enum)AdDirSyncStatesEnum.COOKIE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<AdDirSyncContainer>("Set AdDirSyncControl cookie"){

            public void action(AdDirSyncContainer container) {
                BerValue value = container.getCurrentTLV().getValue();
                byte[] cookie = value.getData();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_08000_COOKIE, (Object[])new Object[]{Strings.dumpBytes((byte[])cookie)}));
                }
                container.getAdDirSyncControl().setCookie(cookie);
                container.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar<AdDirSyncContainer> getInstance() {
        return INSTANCE;
    }
}

