/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.certGeneration;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.ExtendedRequestDecorator;
import org.apache.directory.api.ldap.extras.extended.ads_impl.certGeneration.CertGenerationDecoder;
import org.apache.directory.api.ldap.extras.extended.certGeneration.CertGenerationRequest;
import org.apache.directory.api.ldap.extras.extended.certGeneration.CertGenerationResponse;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertGenerationRequestDecorator
extends ExtendedRequestDecorator<CertGenerationRequest>
implements CertGenerationRequest {
    private static final Logger LOG = LoggerFactory.getLogger(CertGenerationRequestDecorator.class);
    private CertGenerationRequest certGenerationRequest;
    private int requestLength = 0;

    public CertGenerationRequestDecorator(LdapApiService codec, CertGenerationRequest decoratedMessage) {
        super(codec, (ExtendedRequest)decoratedMessage);
        this.certGenerationRequest = decoratedMessage;
    }

    public CertGenerationRequest getCertGenerationRequest() {
        return this.certGenerationRequest;
    }

    public void setRequestValue(byte[] requestValue) {
        CertGenerationDecoder decoder = new CertGenerationDecoder();
        try {
            this.certGenerationRequest = decoder.decode(requestValue);
            if (requestValue != null) {
                this.requestValue = new byte[requestValue.length];
                System.arraycopy(requestValue, 0, this.requestValue, 0, requestValue.length);
            } else {
                this.requestValue = null;
            }
        }
        catch (DecoderException e) {
            LOG.error(I18n.err((I18n)I18n.ERR_08217_PAYLOAD_DECODING_ERROR, (Object[])new Object[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public byte[] getRequestValue() {
        if (this.requestValue == null) {
            try {
                this.requestValue = this.encodeInternal().array();
            }
            catch (EncoderException e) {
                LOG.error(I18n.err((I18n)I18n.ERR_08218_CERT_GENERATE_PAYLOAD_ENCODING_FAILED, (Object[])new Object[0]), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        byte[] copy = new byte[this.requestValue.length];
        System.arraycopy(this.requestValue, 0, copy, 0, this.requestValue.length);
        return copy;
    }

    public CertGenerationResponse getResultResponse() {
        return (CertGenerationResponse)((CertGenerationRequest)this.getDecorated()).getResultResponse();
    }

    public String getTargetDN() {
        return ((CertGenerationRequest)this.getDecorated()).getTargetDN();
    }

    public void setTargetDN(String targetDN) {
        ((CertGenerationRequest)this.getDecorated()).setTargetDN(targetDN);
    }

    public String getIssuerDN() {
        return ((CertGenerationRequest)this.getDecorated()).getIssuerDN();
    }

    public void setIssuerDN(String issuerDN) {
        ((CertGenerationRequest)this.getDecorated()).setIssuerDN(issuerDN);
    }

    public String getSubjectDN() {
        return ((CertGenerationRequest)this.getDecorated()).getSubjectDN();
    }

    public void setSubjectDN(String subjectDN) {
        ((CertGenerationRequest)this.getDecorated()).setSubjectDN(subjectDN);
    }

    public String getKeyAlgorithm() {
        return ((CertGenerationRequest)this.getDecorated()).getKeyAlgorithm();
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        ((CertGenerationRequest)this.getDecorated()).setKeyAlgorithm(keyAlgorithm);
    }

    int computeLengthInternal() {
        int len = Strings.getBytesUtf8((String)this.certGenerationRequest.getTargetDN()).length;
        this.requestLength = 1 + TLV.getNbBytes((int)len) + len;
        len = Strings.getBytesUtf8((String)this.certGenerationRequest.getIssuerDN()).length;
        this.requestLength += 1 + TLV.getNbBytes((int)len) + len;
        len = Strings.getBytesUtf8((String)this.certGenerationRequest.getSubjectDN()).length;
        this.requestLength += 1 + TLV.getNbBytes((int)len) + len;
        len = Strings.getBytesUtf8((String)this.certGenerationRequest.getKeyAlgorithm()).length;
        this.requestLength += 1 + TLV.getNbBytes((int)len) + len;
        return 1 + TLV.getNbBytes((int)this.requestLength) + this.requestLength;
    }

    ByteBuffer encodeInternal() throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLengthInternal());
        bb.put(UniversalTag.SEQUENCE.getValue());
        bb.put(TLV.getBytes((int)this.requestLength));
        BerValue.encode((ByteBuffer)bb, (String)this.certGenerationRequest.getTargetDN());
        BerValue.encode((ByteBuffer)bb, (String)this.certGenerationRequest.getIssuerDN());
        BerValue.encode((ByteBuffer)bb, (String)this.certGenerationRequest.getSubjectDN());
        BerValue.encode((ByteBuffer)bb, (String)this.certGenerationRequest.getKeyAlgorithm());
        return bb;
    }
}

