/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.controls;

import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.MessageDecorator;
import org.apache.directory.api.ldap.model.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitControls
extends GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitControls.class);

    public InitControls() {
        super("Initialize a control");
    }

    public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) {
        TLV tlv = container.getCurrentTLV();
        int expectedLength = tlv.getLength();
        if (expectedLength != 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_05100_NEW_LIST_CONTROLS_INITIALIZED, (Object[])new Object[0]));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05101_NEW_EMPTY_CONTROLS_INITIALIZED, (Object[])new Object[0]));
        }
        container.setGrammarEndAllowed(true);
    }
}

