/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.response.extended;

import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.ExtendedResponseDecorator;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreExtendedResponseValue
extends GrammarAction<LdapMessageContainer<ExtendedResponseDecorator<?>>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreExtendedResponseValue.class);

    public StoreExtendedResponseValue() {
        super("Store response value");
    }

    public void action(LdapMessageContainer<ExtendedResponseDecorator<?>> container) {
        ExtendedResponseDecorator<?> extendedResponse = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            extendedResponse.setResponseValue(Strings.EMPTY_BYTES);
        } else {
            extendedResponse.setResponseValue(tlv.getValue().getData());
        }
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05173_EXTENDED_VALUE, (Object[])new Object[]{extendedResponse.getResponseValue()}));
        }
    }
}

