/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.authorization.generator;

import org.pac4j.core.authorization.generator.AuthorizationGenerator;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.CommonHelper;

public class RememberMeAuthorizationGenerator<U extends CommonProfile>
implements AuthorizationGenerator<U> {
    private String rememberMeParameterName = "rme";
    private String rememberMeValue = "true";

    public RememberMeAuthorizationGenerator() {
    }

    public RememberMeAuthorizationGenerator(String rememberMeParameterName, String rememberMeValue) {
        this.setRememberMeParameterName(rememberMeParameterName);
        this.setRememberMeValue(rememberMeValue);
    }

    public U generate(WebContext context, U profile) {
        String rmeValue = context.getRequestParameter(this.rememberMeParameterName);
        if (this.rememberMeValue.equals(rmeValue)) {
            profile.setRemembered(true);
        }
        return profile;
    }

    public String getRememberMeParameterName() {
        return this.rememberMeParameterName;
    }

    public void setRememberMeParameterName(String rememberMeParameterName) {
        CommonHelper.assertNotBlank((String)"rememberMeParameterName", (String)rememberMeParameterName);
        this.rememberMeParameterName = rememberMeParameterName;
    }

    public String getRememberMeValue() {
        return this.rememberMeValue;
    }

    public void setRememberMeValue(String rememberMeValue) {
        CommonHelper.assertNotBlank((String)"rememberMeValue", (String)rememberMeValue);
        this.rememberMeValue = rememberMeValue;
    }

    public String toString() {
        return CommonHelper.toNiceString(this.getClass(), (Object[])new Object[]{"rememberMeParameterName", this.rememberMeParameterName, "rememberMeValue", this.rememberMeValue});
    }
}

