/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.vault.VaultException;
import org.springframework.vault.authentication.AuthenticationSteps;
import org.springframework.vault.authentication.AuthenticationStepsFactory;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.CubbyholeAuthenticationOptions;
import org.springframework.vault.authentication.LoginToken;
import org.springframework.vault.authentication.LoginTokenAdapter;
import org.springframework.vault.authentication.LoginTokenUtil;
import org.springframework.vault.authentication.TokenAuthentication;
import org.springframework.vault.authentication.VaultLoginException;
import org.springframework.vault.client.VaultHttpHeaders;
import org.springframework.vault.client.VaultResponses;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.VaultResponseSupport;
import org.springframework.vault.support.VaultToken;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

public class CubbyholeAuthentication
implements ClientAuthentication,
AuthenticationStepsFactory {
    private static final Log logger = LogFactory.getLog(CubbyholeAuthentication.class);
    private final CubbyholeAuthenticationOptions options;
    private final RestOperations restOperations;

    public CubbyholeAuthentication(CubbyholeAuthenticationOptions options, RestOperations restOperations) {
        Assert.notNull((Object)options, (String)"CubbyholeAuthenticationOptions must not be null");
        Assert.notNull((Object)restOperations, (String)"RestOperations must not be null");
        this.options = options;
        this.restOperations = restOperations;
    }

    public static AuthenticationSteps createAuthenticationSteps(CubbyholeAuthenticationOptions options) {
        Assert.notNull((Object)options, (String)"CubbyholeAuthenticationOptions must not be null");
        AuthenticationSteps.HttpRequest<VaultResponse> initialRequest = AuthenticationSteps.HttpRequestBuilder.get(options.getPath(), new String[0]).with(VaultHttpHeaders.from(options.getInitialToken())).as(VaultResponse.class);
        return AuthenticationSteps.fromHttpRequest(initialRequest).map(VaultResponseSupport::getData).login(map -> CubbyholeAuthentication.getToken(options, map));
    }

    @Override
    public VaultToken login() throws VaultException {
        Map<String, Object> data = this.lookupToken();
        VaultToken tokenToUse = CubbyholeAuthentication.getToken(this.options, data);
        if (this.shouldEnhanceTokenWithSelfLookup(tokenToUse)) {
            LoginTokenAdapter adapter = new LoginTokenAdapter(new TokenAuthentication(tokenToUse), this.restOperations);
            tokenToUse = adapter.login();
        }
        logger.debug((Object)"Login successful using Cubbyhole authentication");
        return tokenToUse;
    }

    @Override
    public AuthenticationSteps getAuthenticationSteps() {
        return CubbyholeAuthentication.createAuthenticationSteps(this.options);
    }

    @Nullable
    private Map<String, Object> lookupToken() {
        try {
            ResponseEntity entity = this.restOperations.exchange(this.options.getPath(), HttpMethod.GET, new HttpEntity((MultiValueMap)VaultHttpHeaders.from(this.options.getInitialToken())), VaultResponse.class, new Object[0]);
            Assert.state((entity.getBody() != null ? 1 : 0) != 0, (String)"Auth response must not be null");
            return (Map)((VaultResponse)entity.getBody()).getData();
        }
        catch (RestClientException e) {
            throw VaultLoginException.create("Cubbyhole", e);
        }
    }

    private boolean shouldEnhanceTokenWithSelfLookup(VaultToken token) {
        LoginToken loginToken;
        if (!this.options.isSelfLookup()) {
            return false;
        }
        return !(token instanceof LoginToken) || !(loginToken = (LoginToken)token).getLeaseDuration().isZero();
    }

    private static VaultToken getToken(CubbyholeAuthenticationOptions options, @Nullable Map<String, Object> data) {
        if (options.isWrappedToken()) {
            Assert.state((data != null ? 1 : 0) != 0, (String)"Auth data must not be null");
            VaultResponse response = VaultResponses.unwrap((String)data.get("response"), VaultResponse.class);
            Assert.state((response.getAuth() != null ? 1 : 0) != 0, (String)"Auth field must not be null");
            return LoginTokenUtil.from(response.getAuth());
        }
        if (data == null || data.isEmpty()) {
            throw new VaultLoginException(String.format("Cannot retrieve Token from Cubbyhole: Response at %s does not contain a token", options.getPath()));
        }
        if (data.size() == 1) {
            String token = (String)data.get(data.keySet().iterator().next());
            return VaultToken.of(token);
        }
        throw new VaultLoginException(String.format("Cannot retrieve Token from Cubbyhole: Response at %s does not contain an unique token", options.getPath()));
    }
}

