/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.time.Duration;
import org.springframework.util.Assert;
import org.springframework.vault.support.VaultToken;

public class LoginToken
extends VaultToken {
    private final boolean renewable;
    private final Duration leaseDuration;

    private LoginToken(char[] token, Duration duration, boolean renewable) {
        super(token);
        this.leaseDuration = duration;
        this.renewable = renewable;
    }

    public static LoginToken of(String token) {
        Assert.hasText((String)token, (String)"Token must not be empty");
        return LoginToken.of(token.toCharArray(), Duration.ZERO);
    }

    public static LoginToken of(char[] token) {
        return LoginToken.of(token, Duration.ZERO);
    }

    @Deprecated
    public static LoginToken of(String token, long leaseDurationSeconds) {
        Assert.hasText((String)token, (String)"Token must not be empty");
        Assert.isTrue((leaseDurationSeconds >= 0L ? 1 : 0) != 0, (String)"Lease duration must not be negative");
        return LoginToken.of(token.toCharArray(), Duration.ofSeconds(leaseDurationSeconds));
    }

    @Deprecated
    public static LoginToken of(char[] token, long leaseDurationSeconds) {
        Assert.notNull((Object)token, (String)"Token must not be null");
        Assert.isTrue((token.length > 0 ? 1 : 0) != 0, (String)"Token must not be empty");
        Assert.isTrue((leaseDurationSeconds >= 0L ? 1 : 0) != 0, (String)"Lease duration must not be negative");
        return new LoginToken(token, Duration.ofSeconds(leaseDurationSeconds), false);
    }

    public static LoginToken of(char[] token, Duration leaseDuration) {
        Assert.notNull((Object)token, (String)"Token must not be null");
        Assert.isTrue((token.length > 0 ? 1 : 0) != 0, (String)"Token must not be empty");
        Assert.notNull((Object)leaseDuration, (String)"Lease duration must not be null");
        Assert.isTrue((!leaseDuration.isNegative() ? 1 : 0) != 0, (String)"Lease duration must not be negative");
        return new LoginToken(token, leaseDuration, false);
    }

    @Deprecated
    public static LoginToken renewable(String token, long leaseDurationSeconds) {
        Assert.hasText((String)token, (String)"Token must not be empty");
        Assert.isTrue((leaseDurationSeconds >= 0L ? 1 : 0) != 0, (String)"Lease duration must not be negative");
        return LoginToken.renewable(token.toCharArray(), Duration.ofSeconds(leaseDurationSeconds));
    }

    @Deprecated
    public static LoginToken renewable(char[] token, long leaseDurationSeconds) {
        Assert.notNull((Object)token, (String)"Token must not be null");
        Assert.isTrue((token.length > 0 ? 1 : 0) != 0, (String)"Token must not be empty");
        Assert.isTrue((leaseDurationSeconds >= 0L ? 1 : 0) != 0, (String)"Lease duration must not be negative");
        return new LoginToken(token, Duration.ofSeconds(leaseDurationSeconds), true);
    }

    public static LoginToken renewable(VaultToken token, Duration leaseDuration) {
        Assert.notNull((Object)token, (String)"Token must not be null");
        return LoginToken.renewable(token.toCharArray(), leaseDuration);
    }

    public static LoginToken renewable(char[] token, Duration leaseDuration) {
        Assert.notNull((Object)token, (String)"Token must not be null");
        Assert.isTrue((token.length > 0 ? 1 : 0) != 0, (String)"Token must not be empty");
        Assert.notNull((Object)leaseDuration, (String)"Lease duration must not be null");
        Assert.isTrue((!leaseDuration.isNegative() ? 1 : 0) != 0, (String)"Lease duration must not be negative");
        return new LoginToken(token, leaseDuration, true);
    }

    public Duration getLeaseDuration() {
        return this.leaseDuration;
    }

    public boolean isRenewable() {
        return this.renewable;
    }

    @Override
    public String toString() {
        return "LoginToken(renewable=" + this.isRenewable() + ", leaseDuration=" + this.getLeaseDuration() + ")";
    }
}

