/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.hue;

import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class HueLBServiceModelGenerator
extends AbstractServiceModelGenerator {
    private static final String SERVICE = "HUE";
    private static final String SERVICE_TYPE = "HUE";
    private static final String ROLE_TYPE = "HUE_LOAD_BALANCER";

    @Override
    public boolean handles(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        return "HUE".equals(service.getType()) && ROLE_TYPE.equals(role.getType());
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        String hostname = role.getHostRef().getHostname();
        String scheme = "http";
        String port = this.getRoleConfigValue(roleConfig, "listen");
        return new ServiceModel(ServiceModel.Type.UI, "HUE", String.format(Locale.getDefault(), "%s://%s:%s", scheme, hostname, port));
    }
}

