/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.filter;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.filter.AbstractExprNode;
import org.apache.directory.api.ldap.model.filter.AssertionType;
import org.apache.directory.api.ldap.model.filter.FilterVisitor;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.util.Strings;

public abstract class LeafNode
extends AbstractExprNode {
    protected AttributeType attributeType;
    protected String attribute;

    protected LeafNode(AttributeType attributeType, AssertionType assertionType) {
        super(assertionType);
        this.attributeType = attributeType;
        if (attributeType == null) {
            throw new NullPointerException(I18n.err((I18n)I18n.ERR_13302_CANNOT_CREATE_NODE_NULL_ATTR, (Object[])new Object[0]));
        }
        this.attribute = attributeType.getName();
    }

    protected LeafNode(String attribute, AssertionType assertionType) {
        super(assertionType);
        this.attributeType = null;
        this.attribute = attribute;
    }

    @Override
    public final boolean isLeaf() {
        return true;
    }

    public final AttributeType getAttributeType() {
        return this.attributeType;
    }

    public final String getAttribute() {
        return this.attribute;
    }

    public void setAttributeType(AttributeType attributeType) {
        this.attributeType = attributeType;
        if (attributeType != null) {
            this.attribute = attributeType.getName();
        }
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    @Override
    public final Object accept(FilterVisitor visitor) {
        if (visitor.canVisit(this)) {
            return visitor.visit(this);
        }
        return null;
    }

    @Override
    public boolean isSchemaAware() {
        return this.attributeType != null;
    }

    private static String escapeBytes(byte[] bytes) {
        char[] chars = new char[bytes.length * 3];
        int pos = 0;
        for (byte bb : bytes) {
            chars[pos++] = 92;
            chars[pos++] = Strings.dumpHex((byte)((byte)(bb >> 4)));
            chars[pos++] = Strings.dumpHex((byte)((byte)(bb & 0xF)));
        }
        return new String(chars, 0, pos);
    }

    private static String escapeString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length);
        block9: for (byte b : bytes) {
            switch (b) {
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: {
                    sb.append((char)b);
                    continue block9;
                }
                case 40: {
                    sb.append("\\28");
                    continue block9;
                }
                case 41: {
                    sb.append("\\29");
                    continue block9;
                }
                case 42: {
                    sb.append("\\2A");
                    continue block9;
                }
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: {
                    sb.append((char)b);
                    continue block9;
                }
                case 92: {
                    sb.append("\\5C");
                    continue block9;
                }
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: {
                    sb.append((char)b);
                    continue block9;
                }
                default: {
                    return null;
                }
            }
        }
        return sb.toString();
    }

    protected static String escapeFilterValue(AttributeType attributeType, byte[] value) {
        if (value == null) {
            return null;
        }
        if (attributeType != null) {
            if (attributeType.isHR()) {
                String result = LeafNode.escapeString(value);
                if (result == null) {
                    return LeafNode.escapeBytes(value);
                }
                return result;
            }
            return LeafNode.escapeBytes(value);
        }
        String result = LeafNode.escapeString(value);
        if (result == null) {
            return LeafNode.escapeBytes(value);
        }
        return result;
    }

    protected static String escapeFilterValue(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(value.length());
        block7: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\u0000': {
                    sb.append("\\00");
                    continue block7;
                }
                case '(': {
                    sb.append("\\28");
                    continue block7;
                }
                case ')': {
                    sb.append("\\29");
                    continue block7;
                }
                case '*': {
                    sb.append("\\2A");
                    continue block7;
                }
                case '\\': {
                    sb.append("\\5C");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int h = 37;
        h = h * 17 + super.hashCode();
        h = this.attributeType != null ? h * 17 + this.attributeType.hashCode() : h * 17 + this.attribute.hashCode();
        return h;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LeafNode)) {
            return false;
        }
        LeafNode otherNode = (LeafNode)other;
        if (other.getClass() != this.getClass()) {
            return false;
        }
        if (this.attributeType != null) {
            return this.attributeType.equals(otherNode.getAttributeType());
        }
        return this.attribute.equalsIgnoreCase(otherNode.getAttribute());
    }
}

