/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.credentials.extractor;

import org.pac4j.core.context.HttpConstants;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.util.CommonHelper;

public class ParameterExtractor
implements CredentialsExtractor<TokenCredentials> {
    private final String parameterName;
    private boolean supportGetRequest;
    private boolean supportPostRequest;

    public ParameterExtractor(String parameterName) {
        this(parameterName, false, true);
    }

    public ParameterExtractor(String parameterName, boolean supportGetRequest, boolean supportPostRequest) {
        this.parameterName = parameterName;
        this.supportGetRequest = supportGetRequest;
        this.supportPostRequest = supportPostRequest;
    }

    @Override
    public TokenCredentials extract(WebContext context) {
        String method = context.getRequestMethod();
        if (HttpConstants.HTTP_METHOD.GET.name().equalsIgnoreCase(method) && !this.supportGetRequest) {
            throw new CredentialsException("GET requests not supported");
        }
        if (HttpConstants.HTTP_METHOD.POST.name().equalsIgnoreCase(method) && !this.supportPostRequest) {
            throw new CredentialsException("POST requests not supported");
        }
        String value = context.getRequestParameter(this.parameterName);
        if (value == null) {
            return null;
        }
        return new TokenCredentials(value);
    }

    public String toString() {
        return CommonHelper.toNiceString(this.getClass(), "parameterName", this.parameterName, "supportGetRequest", this.supportGetRequest, "supportPostRequest", this.supportPostRequest);
    }
}

