/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.webappsec.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class XSSProtectionFilter
implements Filter {
    public static final String X_XSS_PROTECTION = "X-XSS-Protection";
    public static final String CUSTOM_HEADER_PARAM = "xss.protection";
    public static final String DEFAULT_VALUE = "1;mode=block";
    private String option = "1;mode=block";

    public void init(FilterConfig config) throws ServletException {
        String customOption = config.getInitParameter(CUSTOM_HEADER_PARAM);
        if (customOption != null) {
            this.option = customOption;
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        ((HttpServletResponse)res).setHeader(X_XSS_PROTECTION, this.option);
        chain.doFilter(req, (ServletResponse)new XSSProtectionResponseWrapper((HttpServletResponse)res));
    }

    public void destroy() {
    }

    class XSSProtectionResponseWrapper
    extends HttpServletResponseWrapper {
        XSSProtectionResponseWrapper(HttpServletResponse res) {
            super(res);
        }

        public void addHeader(String name, String value) {
            if (!name.equals(XSSProtectionFilter.X_XSS_PROTECTION)) {
                super.addHeader(name, value);
            }
        }

        public void setHeader(String name, String value) {
            if (!name.equals(XSSProtectionFilter.X_XSS_PROTECTION)) {
                super.setHeader(name, value);
            }
        }

        public String getHeader(String name) {
            String headerValue = name.equals(XSSProtectionFilter.X_XSS_PROTECTION) ? XSSProtectionFilter.this.option : super.getHeader(name);
            return headerValue;
        }

        public Collection<String> getHeaderNames() {
            ArrayList<String> names = (ArrayList<String>)super.getHeaderNames();
            if (names == null) {
                names = new ArrayList<String>();
            }
            names.add(XSSProtectionFilter.X_XSS_PROTECTION);
            return names;
        }

        public Collection<String> getHeaders(String name) {
            ArrayList<String> values = (ArrayList<String>)super.getHeaders(name);
            if (name.equals(XSSProtectionFilter.X_XSS_PROTECTION)) {
                if (values == null) {
                    values = new ArrayList<String>();
                }
                values.add(XSSProtectionFilter.this.option);
            }
            return values;
        }
    }
}

