
export interface TelephoneNumber extends String { }
export type CountryCode = 'AD' | 'AE' | 'AF' | 'AG' | 'AI' | 'AL' | 'AM' | 'AO' | 'AQ' | 'AR' | 'AS' | 'AT' | 'AU' | 'AW' | 'AX' | 'AZ' | 'BA' | 'BB' | 'BD' | 'BE' | 'BF' | 'BG' | 'BH' | 'BI' | 'BJ' | 'BL' | 'BM' | 'BN' | 'BO' | 'BQ' | 'BR' | 'BS' | 'BT' | 'BV' | 'BW' | 'BY' | 'BZ' | 'CA' | 'CC' | 'CD' | 'CF' | 'CG' | 'CH' | 'CI' | 'CK' | 'CL' | 'CM' | 'CN' | 'CO' | 'CR' | 'CU' | 'CV' | 'CW' | 'CX' | 'CY' | 'CZ' | 'DE' | 'DJ' | 'DK' | 'DM' | 'DO' | 'DZ' | 'EC' | 'EE' | 'EG' | 'EH' | 'ER' | 'ES' | 'ET' | 'FI' | 'FJ' | 'FK' | 'FM' | 'FO' | 'FR' | 'GA' | 'GB' | 'GD' | 'GE' | 'GF' | 'GG' | 'GH' | 'GI' | 'GL' | 'GM' | 'GN' | 'GP' | 'GQ' | 'GR' | 'GS' | 'GT' | 'GU' | 'GW' | 'GY' | 'HK' | 'HM' | 'HN' | 'HR' | 'HT' | 'HU' | 'ID' | 'IE' | 'IL' | 'IM' | 'IN' | 'IO' | 'IQ' | 'IR' | 'IS' | 'IT' | 'JE' | 'JM' | 'JO' | 'JP' | 'KE' | 'KG' | 'KH' | 'KI' | 'KM' | 'KN' | 'KP' | 'KR' | 'KW' | 'KY' | 'KZ' | 'LA' | 'LB' | 'LC' | 'LI' | 'LK' | 'LR' | 'LS' | 'LT' | 'LU' | 'LV' | 'LY' | 'MA' | 'MC' | 'MD' | 'ME' | 'MF' | 'MG' | 'MH' | 'MK' | 'ML' | 'MM' | 'MN' | 'MO' | 'MP' | 'MQ' | 'MR' | 'MS' | 'MT' | 'MU' | 'MV' | 'MW' | 'MX' | 'MY' | 'MZ' | 'NA' | 'NC' | 'NE' | 'NF' | 'NG' | 'NI' | 'NL' | 'NO' | 'NP' | 'NR' | 'NU' | 'NZ' | 'OM' | 'PA' | 'PE' | 'PF' | 'PG' | 'PH' | 'PK' | 'PL' | 'PM' | 'PN' | 'PR' | 'PS' | 'PT' | 'PW' | 'PY' | 'QA' | 'RE' | 'RO' | 'RS' | 'RU' | 'RW' | 'SA' | 'SB' | 'SC' | 'SD' | 'SE' | 'SG' | 'SH' | 'SI' | 'SJ' | 'SK' | 'SL' | 'SM' | 'SN' | 'SO' | 'SR' | 'SS' | 'ST' | 'SV' | 'SX' | 'SY' | 'SZ' | 'TC' | 'TD' | 'TF' | 'TG' | 'TH' | 'TJ' | 'TK' | 'TL' | 'TM' | 'TN' | 'TO' | 'TR' | 'TT' | 'TV' | 'TW' | 'TZ' | 'UA' | 'UG' | 'UM' | 'US' | 'UY' | 'UZ' | 'VA' | 'VC' | 'VE' | 'VG' | 'VI' | 'VN' | 'VU' | 'WF' | 'WS' | 'YE' | 'YT' | 'ZA' | 'ZM' | 'ZW';
//export interface CountryCode extends String { }
export interface PhoneCode extends String { }

export interface ParsedNumber {
    phone: TelephoneNumber,
    country: CountryCode,
}

export function parse(text: string, options?: CountryCode | { country: { restrict?: CountryCode, default?: CountryCode }}): ParsedNumber;

export function format(parsed_number: ParsedNumber, format: 'International' | 'International_plaintext' | 'E.164' | 'National'): string;
export function format(phone: TelephoneNumber, country: CountryCode, format: 'International' | 'International_plaintext' | 'E.164' | 'National'): string;

export function getNumberType(parsed_number: ParsedNumber): string;
export function getNumberType(phone: TelephoneNumber, country: CountryCode): string;
export function getNumberTypeCustom(phone: TelephoneNumber, country: CountryCode, metadata: object): string;

export function isValidNumber(parsed_number: ParsedNumber): boolean;
export function isValidNumber(phone: TelephoneNumber, country: CountryCode): boolean;

export function getPhoneCode(country_code: CountryCode): PhoneCode;
export function getPhoneCodeCustom(country_code: CountryCode, metadata: object): PhoneCode;

// `asYouType` name is deprecated
export class asYouType {
    constructor(default_country_code?: CountryCode);
    input(text: string): string;
    reset(): void;
    country: CountryCode;
    country_phone_code: PhoneCode;
    national_number: string;
    template: string;
}

export class AsYouType {
    constructor(default_country_code?: CountryCode);
    input(text: string): string;
    reset(): void;
    country: CountryCode;
    country_phone_code: PhoneCode;
    national_number: string;
    template: string;
}
