/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@angular/cdk/a11y"),require("@angular/cdk/overlay"),require("@angular/cdk/platform"),require("@angular/common"),require("@angular/core"),require("@angular/material/core"),require("@angular/cdk/layout"),require("@angular/cdk/bidi"),require("@angular/cdk/coercion"),require("@angular/cdk/keycodes"),require("@angular/cdk/portal"),require("rxjs/operators/take"),require("rxjs/observable/merge"),require("@angular/cdk/scrolling"),require("rxjs/Subject"),require("@angular/animations")):"function"==typeof define&&define.amd?define(["exports","@angular/cdk/a11y","@angular/cdk/overlay","@angular/cdk/platform","@angular/common","@angular/core","@angular/material/core","@angular/cdk/layout","@angular/cdk/bidi","@angular/cdk/coercion","@angular/cdk/keycodes","@angular/cdk/portal","rxjs/operators/take","rxjs/observable/merge","@angular/cdk/scrolling","rxjs/Subject","@angular/animations"],e):e((t.ng=t.ng||{},t.ng.material=t.ng.material||{},t.ng.material.tooltip=t.ng.material.tooltip||{}),t.ng.cdk.a11y,t.ng.cdk.overlay,t.ng.cdk.platform,t.ng.common,t.ng.core,t.ng.material.core,t.ng.cdk.layout,t.ng.cdk.bidi,t.ng.cdk.coercion,t.ng.cdk.keycodes,t.ng.cdk.portal,t.Rx.operators,t.Rx.Observable,t.ng.cdk.scrolling,t.Rx,t.ng.animations)}(this,function(t,e,i,o,n,s,r,a,l,p,c,h,u,d,_,m,f){"use strict";function y(t){return Error('Tooltip position "'+t+'" is invalid.')}function g(t){return function(){return t.scrollStrategies.reposition({scrollThrottle:b})}}var v={tooltipState:f.trigger("state",[f.state("initial, void, hidden",f.style({transform:"scale(0)"})),f.state("visible",f.style({transform:"scale(1)"})),f.transition("* => visible",f.animate("150ms cubic-bezier(0.0, 0.0, 0.2, 1)")),f.transition("* => hidden",f.animate("150ms cubic-bezier(0.4, 0.0, 1, 1)"))])},b=20,T=new s.InjectionToken("mat-tooltip-scroll-strategy"),O={provide:T,deps:[i.Overlay],useFactory:g},I=new s.InjectionToken("mat-tooltip-default-options"),k=function(){function t(t,e,i,o,n,s,r,a,l,p,c){var h=this;this._overlay=t,this._elementRef=e,this._scrollDispatcher=i,this._viewContainerRef=o,this._ngZone=n,this._platform=s,this._ariaDescriber=r,this._focusMonitor=a,this._scrollStrategy=l,this._dir=p,this._defaultOptions=c,this._position="below",this._disabled=!1,this.showDelay=this._defaultOptions?this._defaultOptions.showDelay:0,this.hideDelay=this._defaultOptions?this._defaultOptions.hideDelay:0,this._message="",this._manualListeners=new Map;var u=e.nativeElement;s.IOS?"INPUT"!==u.nodeName&&"TEXTAREA"!==u.nodeName||(u.style.webkitUserSelect=u.style.userSelect=""):(this._manualListeners.set("mouseenter",function(){return h.show()}),this._manualListeners.set("mouseleave",function(){return h.hide()}),this._manualListeners.forEach(function(t,i){return e.nativeElement.addEventListener(i,t)})),a.monitor(u).subscribe(function(t){t?"program"!==t&&n.run(function(){return h.show()}):n.run(function(){return h.hide(0)})})}return Object.defineProperty(t.prototype,"position",{get:function(){return this._position},set:function(t){t!==this._position&&(this._position=t,this._tooltipInstance&&this._disposeTooltip())},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"disabled",{get:function(){return this._disabled},set:function(t){this._disabled=p.coerceBooleanProperty(t),this._disabled&&this.hide(0)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_positionDeprecated",{get:function(){return this._position},set:function(t){this._position=t},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"message",{get:function(){return this._message},set:function(t){this._ariaDescriber.removeDescription(this._elementRef.nativeElement,this._message),this._message=null!=t?(""+t).trim():"",!this._message&&this._isTooltipVisible()?this.hide(0):(this._updateTooltipMessage(),this._ariaDescriber.describe(this._elementRef.nativeElement,this.message))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"tooltipClass",{get:function(){return this._tooltipClass},set:function(t){this._tooltipClass=t,this._tooltipInstance&&this._setTooltipClass(this._tooltipClass)},enumerable:!0,configurable:!0}),t.prototype.ngOnDestroy=function(){var t=this;this._tooltipInstance&&this._disposeTooltip(),this._platform.IOS||(this._manualListeners.forEach(function(e,i){t._elementRef.nativeElement.removeEventListener(i,e)}),this._manualListeners.clear()),this._ariaDescriber.removeDescription(this._elementRef.nativeElement,this.message),this._focusMonitor.stopMonitoring(this._elementRef.nativeElement)},t.prototype.show=function(t){void 0===t&&(t=this.showDelay),!this.disabled&&this.message&&(this._tooltipInstance||this._createTooltip(),this._setTooltipClass(this._tooltipClass),this._updateTooltipMessage(),this._tooltipInstance.show(this._position,t))},t.prototype.hide=function(t){void 0===t&&(t=this.hideDelay),this._tooltipInstance&&this._tooltipInstance.hide(t)},t.prototype.toggle=function(){this._isTooltipVisible()?this.hide():this.show()},t.prototype._isTooltipVisible=function(){return!!this._tooltipInstance&&this._tooltipInstance.isVisible()},t.prototype._handleKeydown=function(t){this._isTooltipVisible()&&t.keyCode===c.ESCAPE&&(t.stopPropagation(),this.hide(0))},t.prototype._handleTouchend=function(){this.hide(this._defaultOptions?this._defaultOptions.touchendHideDelay:1500)},t.prototype._createTooltip=function(){var t=this,e=this._createOverlay(),i=new h.ComponentPortal(C,this._viewContainerRef);this._tooltipInstance=e.attach(i).instance,d.merge(this._tooltipInstance.afterHidden(),e.detachments()).subscribe(function(){t._tooltipInstance&&t._disposeTooltip()})},t.prototype._createOverlay=function(){var t=this,e=this._getOrigin(),o=this._getOverlayPosition(),n=this._overlay.position().connectedTo(this._elementRef,e.main,o.main).withFallbackPosition(e.fallback,o.fallback),s=this._scrollDispatcher.getAncestorScrollContainers(this._elementRef);n.withScrollableContainers(s),n.onPositionChange.subscribe(function(e){t._tooltipInstance&&(e.scrollableViewProperties.isOverlayClipped&&t._tooltipInstance.isVisible()?t._ngZone.run(function(){return t.hide(0)}):t._tooltipInstance._setTransformOrigin(e.connectionPair))});var r=new i.OverlayConfig({direction:this._dir?this._dir.value:"ltr",positionStrategy:n,panelClass:"mat-tooltip-panel",scrollStrategy:this._scrollStrategy()});return this._overlayRef=this._overlay.create(r),this._overlayRef},t.prototype._disposeTooltip=function(){this._overlayRef&&(this._overlayRef.dispose(),this._overlayRef=null),this._tooltipInstance=null},t.prototype._getOrigin=function(){var t,e=!this._dir||"ltr"==this._dir.value;if("above"==this.position||"below"==this.position)t={originX:"center",originY:"above"==this.position?"top":"bottom"};else if("left"==this.position||"before"==this.position&&e||"after"==this.position&&!e)t={originX:"start",originY:"center"};else{if(!("right"==this.position||"after"==this.position&&e||"before"==this.position&&!e))throw y(this.position);t={originX:"end",originY:"center"}}var i=this._invertPosition(t.originX,t.originY);return{main:t,fallback:{originX:i.x,originY:i.y}}},t.prototype._getOverlayPosition=function(){var t,e=!this._dir||"ltr"==this._dir.value;if("above"==this.position)t={overlayX:"center",overlayY:"bottom"};else if("below"==this.position)t={overlayX:"center",overlayY:"top"};else if("left"==this.position||"before"==this.position&&e||"after"==this.position&&!e)t={overlayX:"end",overlayY:"center"};else{if(!("right"==this.position||"after"==this.position&&e||"before"==this.position&&!e))throw y(this.position);t={overlayX:"start",overlayY:"center"}}var i=this._invertPosition(t.overlayX,t.overlayY);return{main:t,fallback:{overlayX:i.x,overlayY:i.y}}},t.prototype._updateTooltipMessage=function(){var t=this;this._tooltipInstance&&(this._tooltipInstance.message=this.message,this._tooltipInstance._markForCheck(),this._ngZone.onMicrotaskEmpty.asObservable().pipe(u.take(1)).subscribe(function(){t._tooltipInstance&&t._overlayRef.updatePosition()}))},t.prototype._setTooltipClass=function(t){this._tooltipInstance&&(this._tooltipInstance.tooltipClass=t,this._tooltipInstance._markForCheck())},t.prototype._invertPosition=function(t,e){return"above"===this.position||"below"===this.position?"top"===e?e="bottom":"bottom"===e&&(e="top"):"end"===t?t="start":"start"===t&&(t="end"),{x:t,y:e}},t.decorators=[{type:s.Directive,args:[{selector:"[matTooltip]",exportAs:"matTooltip",host:{"(longpress)":"show()","(keydown)":"_handleKeydown($event)","(touchend)":"_handleTouchend()"}}]}],t.ctorParameters=function(){return[{type:i.Overlay},{type:s.ElementRef},{type:_.ScrollDispatcher},{type:s.ViewContainerRef},{type:s.NgZone},{type:o.Platform},{type:e.AriaDescriber},{type:e.FocusMonitor},{type:void 0,decorators:[{type:s.Inject,args:[T]}]},{type:l.Directionality,decorators:[{type:s.Optional}]},{type:void 0,decorators:[{type:s.Optional},{type:s.Inject,args:[I]}]}]},t.propDecorators={position:[{type:s.Input,args:["matTooltipPosition"]}],disabled:[{type:s.Input,args:["matTooltipDisabled"]}],_positionDeprecated:[{type:s.Input,args:["tooltip-position"]}],showDelay:[{type:s.Input,args:["matTooltipShowDelay"]}],hideDelay:[{type:s.Input,args:["matTooltipHideDelay"]}],message:[{type:s.Input,args:["matTooltip"]}],tooltipClass:[{type:s.Input,args:["matTooltipClass"]}]},t}(),C=function(){function t(t,e){this._changeDetectorRef=t,this._breakpointObserver=e,this._visibility="initial",this._closeOnInteraction=!1,this._transformOrigin="bottom",this._onHide=new m.Subject,this._isHandset=this._breakpointObserver.observe(a.Breakpoints.Handset)}return t.prototype.show=function(t,e){var i=this;this._hideTimeoutId&&clearTimeout(this._hideTimeoutId),this._closeOnInteraction=!0,this._position=t,this._showTimeoutId=setTimeout(function(){i._visibility="visible",i._markForCheck()},e)},t.prototype.hide=function(t){var e=this;this._showTimeoutId&&clearTimeout(this._showTimeoutId),this._hideTimeoutId=setTimeout(function(){e._visibility="hidden",e._markForCheck()},t)},t.prototype.afterHidden=function(){return this._onHide.asObservable()},t.prototype.isVisible=function(){return"visible"===this._visibility},t.prototype._setTransformOrigin=function(t){var e="above"===this._position||"below"===this._position?"Y":"X",i="X"==e?t.overlayX:t.overlayY;if("top"===i||"bottom"===i)this._transformOrigin=i;else if("start"===i)this._transformOrigin="left";else{if("end"!==i)throw y(this._position);this._transformOrigin="right"}},t.prototype._animationStart=function(){this._closeOnInteraction=!1},t.prototype._animationDone=function(t){var e=t.toState;"hidden"!==e||this.isVisible()||this._onHide.next(),"visible"!==e&&"hidden"!==e||(this._closeOnInteraction=!0)},t.prototype._handleBodyInteraction=function(){this._closeOnInteraction&&this.hide(0)},t.prototype._markForCheck=function(){this._changeDetectorRef.markForCheck()},t.decorators=[{type:s.Component,args:[{selector:"mat-tooltip-component",template:'<div class="mat-tooltip" [ngClass]="tooltipClass" [class.mat-tooltip-handset]="(_isHandset | async)!.matches" [style.transform-origin]="_transformOrigin" [@state]="_visibility" (@state.start)="_animationStart()" (@state.done)="_animationDone($event)">{{message}}</div>',styles:[".mat-tooltip-panel{pointer-events:none!important}.mat-tooltip{color:#fff;border-radius:2px;margin:14px;max-width:250px;padding-left:8px;padding-right:8px}@media screen and (-ms-high-contrast:active){.mat-tooltip{outline:solid 1px}}.mat-tooltip-handset{margin:24px;padding-left:16px;padding-right:16px}"],encapsulation:s.ViewEncapsulation.None,preserveWhitespaces:!1,changeDetection:s.ChangeDetectionStrategy.OnPush,animations:[v.tooltipState],host:{"[style.zoom]":'_visibility === "visible" ? 1 : null',"(body:click)":"this._handleBodyInteraction()","aria-hidden":"true"}}]}],t.ctorParameters=function(){return[{type:s.ChangeDetectorRef},{type:a.BreakpointObserver}]},t}(),D={showDelay:0,hideDelay:0,touchendHideDelay:1500},R=function(){function t(){}return t.decorators=[{type:s.NgModule,args:[{imports:[n.CommonModule,i.OverlayModule,r.MatCommonModule,o.PlatformModule,e.A11yModule,a.LayoutModule],exports:[k,C,r.MatCommonModule],declarations:[k,C],entryComponents:[C],providers:[O,e.ARIA_DESCRIBER_PROVIDER,{provide:I,useValue:D}]}]}],t.ctorParameters=function(){return[]},t}();t.MatTooltipModule=R,t.SCROLL_THROTTLE_MS=b,t.TOOLTIP_PANEL_CLASS="mat-tooltip-panel",t.getMatTooltipInvalidPositionError=y,t.MAT_TOOLTIP_SCROLL_STRATEGY=T,t.MAT_TOOLTIP_SCROLL_STRATEGY_PROVIDER_FACTORY=g,t.MAT_TOOLTIP_SCROLL_STRATEGY_PROVIDER=O,t.MAT_TOOLTIP_DEFAULT_OPTIONS=I,t.MatTooltip=k,t.TooltipComponent=C,t.matTooltipAnimations=v,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=material-tooltip.umd.min.js.map
