/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { ElementRef, SimpleChanges, OnChanges } from '@angular/core';
import { CanColor } from '@angular/material/core';
import { Platform } from '@angular/cdk/platform';
/** Possible mode for a progress spinner. */
export declare type ProgressSpinnerMode = 'determinate' | 'indeterminate';
/** @docs-private */
export declare class MatProgressSpinnerBase {
    _elementRef: ElementRef;
    constructor(_elementRef: ElementRef);
}
export declare const _MatProgressSpinnerMixinBase: (new (...args: any[]) => CanColor) & typeof MatProgressSpinnerBase;
/**
 * `<mat-progress-spinner>` component.
 */
export declare class MatProgressSpinner extends _MatProgressSpinnerMixinBase implements CanColor, OnChanges {
    _elementRef: ElementRef;
    private _document;
    private _value;
    private _strokeWidth;
    private _fallbackAnimation;
    /** The width and height of the host element. Will grow with stroke width. */
    _elementSize: number;
    /** Tracks diameters of existing instances to de-dupe generated styles (default d = 100) */
    private static diameters;
    /**
     * Used for storing all of the generated keyframe animations.
     * @dynamic
     */
    private static styleTag;
    /** The diameter of the progress spinner (will set width and height of svg). */
    diameter: number;
    private _diameter;
    /** Stroke width of the progress spinner. */
    strokeWidth: number;
    /** Mode of the progress circle */
    mode: ProgressSpinnerMode;
    /** Value of the progress circle. */
    value: number;
    constructor(_elementRef: ElementRef, platform: Platform, _document: any);
    ngOnChanges(changes: SimpleChanges): void;
    /** The radius of the spinner, adjusted for stroke width. */
    readonly _circleRadius: number;
    /** The view box of the spinner's svg element. */
    readonly _viewBox: string;
    /** The stroke circumference of the svg circle. */
    readonly _strokeCircumference: number;
    /** The dash offset of the svg circle. */
    readonly _strokeDashOffset: number | null;
    /** Stroke width of the circle in percent. */
    readonly _circleStrokeWidth: number;
    /** Dynamically generates a style tag containing the correct animation for this diameter. */
    private _attachStyleNode();
    /** Generates animation styles adjusted for the spinner's diameter. */
    private _getAnimationText();
    /** Updates the spinner element size based on its diameter. */
    private _updateElementSize();
}
/**
 * `<mat-spinner>` component.
 *
 * This is a component definition to be used as a convenience reference to create an
 * indeterminate `<mat-progress-spinner>` instance.
 */
export declare class MatSpinner extends MatProgressSpinner {
    constructor(elementRef: ElementRef, platform: Platform, document: any);
}
