/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.credentials.extractor;

import com.github.scribejava.core.model.OAuth1RequestToken;
import com.github.scribejava.core.utils.OAuthEncoder;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.oauth.config.OAuth10Configuration;
import org.pac4j.oauth.credentials.OAuth10Credentials;
import org.pac4j.oauth.credentials.extractor.OAuthCredentialsExtractor;
import org.pac4j.oauth.exception.OAuthCredentialsException;

public class OAuth10CredentialsExtractor
extends OAuthCredentialsExtractor<OAuth10Credentials, OAuth10Configuration> {
    public OAuth10CredentialsExtractor(OAuth10Configuration configuration, IndirectClient client) {
        super(configuration, client);
    }

    @Override
    protected OAuth10Credentials getOAuthCredentials(WebContext context) {
        String tokenParameter = context.getRequestParameter("oauth_token");
        String verifierParameter = context.getRequestParameter("oauth_verifier");
        if (tokenParameter != null && verifierParameter != null) {
            OAuth1RequestToken tokenSession = (OAuth1RequestToken)context.getSessionStore().get(context, ((OAuth10Configuration)this.configuration).getRequestTokenSessionAttributeName(this.client.getName()));
            this.logger.debug("tokenRequest: {}", (Object)tokenSession);
            String token = OAuthEncoder.decode((String)tokenParameter);
            String verifier = OAuthEncoder.decode((String)verifierParameter);
            this.logger.debug("token: {} / verifier: {}", (Object)token, (Object)verifier);
            return new OAuth10Credentials(tokenSession, token, verifier);
        }
        String message = "No credential found";
        throw new OAuthCredentialsException("No credential found");
    }
}

