/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.javassist;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import javassist.CannotCompileException;
import javassist.bytecode.Bytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.StackMapTable;
import javassist.util.proxy.FactoryHelper;
import javassist.util.proxy.RuntimeSupport;
import org.hibernate.bytecode.internal.javassist.BulkAccessor;
import org.hibernate.bytecode.internal.javassist.BulkAccessorException;

class BulkAccessorFactory {
    private static final String PACKAGE_NAME_PREFIX = "org.javassist.tmp.";
    private static final String BULKACESSOR_CLASS_NAME = BulkAccessor.class.getName();
    private static final String OBJECT_CLASS_NAME = Object.class.getName();
    private static final String GENERATED_GETTER_NAME = "getPropertyValues";
    private static final String GENERATED_SETTER_NAME = "setPropertyValues";
    private static final String GET_SETTER_DESC = "(Ljava/lang/Object;[Ljava/lang/Object;)V";
    private static final String THROWABLE_CLASS_NAME = Throwable.class.getName();
    private static final String BULKEXCEPTION_CLASS_NAME = BulkAccessorException.class.getName();
    private static int counter;
    private Class targetBean;
    private String[] getterNames;
    private String[] setterNames;
    private Class[] types;
    public String writeDirectory;

    BulkAccessorFactory(Class target, String[] getterNames, String[] setterNames, Class[] types) {
        this.targetBean = target;
        this.getterNames = getterNames;
        this.setterNames = setterNames;
        this.types = types;
        this.writeDirectory = null;
    }

    BulkAccessor create() {
        Method[] getters = new Method[this.getterNames.length];
        Method[] setters = new Method[this.setterNames.length];
        BulkAccessorFactory.findAccessors(this.targetBean, this.getterNames, this.setterNames, this.types, getters, setters);
        try {
            ClassFile classfile = this.make(getters, setters);
            ClassLoader loader = this.getClassLoader();
            if (this.writeDirectory != null) {
                FactoryHelper.writeFile((ClassFile)classfile, (String)this.writeDirectory);
            }
            Class beanClass = FactoryHelper.toClass((ClassFile)classfile, (ClassLoader)loader, (ProtectionDomain)this.getDomain());
            return (BulkAccessor)this.newInstance(beanClass);
        }
        catch (Exception e) {
            throw new BulkAccessorException(e.getMessage(), e);
        }
    }

    private ProtectionDomain getDomain() {
        Class<?> cl = this.targetBean != null ? this.targetBean : this.getClass();
        return cl.getProtectionDomain();
    }

    private ClassFile make(Method[] getters, Method[] setters) throws CannotCompileException {
        String className = this.targetBean.getName();
        if ((className = className + "_$$_bulkaccess_" + counter++).startsWith("java.")) {
            className = PACKAGE_NAME_PREFIX + className;
        }
        ClassFile classfile = new ClassFile(false, className, BULKACESSOR_CLASS_NAME);
        classfile.setAccessFlags(1);
        this.addDefaultConstructor(classfile);
        this.addGetter(classfile, getters);
        this.addSetter(classfile, setters);
        return classfile;
    }

    private ClassLoader getClassLoader() {
        if (this.targetBean != null && this.targetBean.getName().equals(OBJECT_CLASS_NAME)) {
            return this.targetBean.getClassLoader();
        }
        return this.getClass().getClassLoader();
    }

    private Object newInstance(Class type) throws Exception {
        BulkAccessor instance = (BulkAccessor)type.newInstance();
        instance.target = this.targetBean;
        int len = this.getterNames.length;
        instance.getters = new String[len];
        instance.setters = new String[len];
        instance.types = new Class[len];
        for (int i = 0; i < len; ++i) {
            instance.getters[i] = this.getterNames[i];
            instance.setters[i] = this.setterNames[i];
            instance.types[i] = this.types[i];
        }
        return instance;
    }

    private void addDefaultConstructor(ClassFile classfile) throws CannotCompileException {
        ConstPool constPool = classfile.getConstPool();
        String constructorSignature = "()V";
        MethodInfo constructorMethodInfo = new MethodInfo(constPool, "<init>", "()V");
        Bytecode code = new Bytecode(constPool, 0, 1);
        code.addAload(0);
        code.addInvokespecial(BulkAccessor.class.getName(), "<init>", "()V");
        code.addOpcode(177);
        constructorMethodInfo.setCodeAttribute(code.toCodeAttribute());
        constructorMethodInfo.setAccessFlags(1);
        classfile.addMethod(constructorMethodInfo);
    }

    private void addGetter(ClassFile classfile, Method[] getters) throws CannotCompileException {
        ConstPool constPool = classfile.getConstPool();
        int targetBeanConstPoolIndex = constPool.addClassInfo(this.targetBean.getName());
        String desc = GET_SETTER_DESC;
        MethodInfo getterMethodInfo = new MethodInfo(constPool, GENERATED_GETTER_NAME, GET_SETTER_DESC);
        Bytecode code = new Bytecode(constPool, 6, 4);
        if (getters.length >= 0) {
            code.addAload(1);
            code.addCheckcast(this.targetBean.getName());
            code.addAstore(3);
            for (int i = 0; i < getters.length; ++i) {
                if (getters[i] == null) continue;
                Method getter = getters[i];
                code.addAload(2);
                code.addIconst(i);
                Class<?> returnType = getter.getReturnType();
                int typeIndex = -1;
                if (returnType.isPrimitive()) {
                    typeIndex = FactoryHelper.typeIndex(returnType);
                    code.addNew(FactoryHelper.wrapperTypes[typeIndex]);
                    code.addOpcode(89);
                }
                code.addAload(3);
                String getterSignature = RuntimeSupport.makeDescriptor((Method)getter);
                String getterName = getter.getName();
                if (this.targetBean.isInterface()) {
                    code.addInvokeinterface(targetBeanConstPoolIndex, getterName, getterSignature, 1);
                } else {
                    code.addInvokevirtual(targetBeanConstPoolIndex, getterName, getterSignature);
                }
                if (typeIndex >= 0) {
                    code.addInvokespecial(FactoryHelper.wrapperTypes[typeIndex], "<init>", FactoryHelper.wrapperDesc[typeIndex]);
                }
                code.add(83);
                code.growStack(-3);
            }
        }
        code.addOpcode(177);
        getterMethodInfo.setCodeAttribute(code.toCodeAttribute());
        getterMethodInfo.setAccessFlags(1);
        classfile.addMethod(getterMethodInfo);
    }

    private void addSetter(ClassFile classfile, Method[] setters) throws CannotCompileException {
        ConstPool constPool = classfile.getConstPool();
        int targetTypeConstPoolIndex = constPool.addClassInfo(this.targetBean.getName());
        String desc = GET_SETTER_DESC;
        MethodInfo setterMethodInfo = new MethodInfo(constPool, GENERATED_SETTER_NAME, GET_SETTER_DESC);
        Bytecode code = new Bytecode(constPool, 4, 6);
        StackMapTable stackmap = null;
        if (setters.length > 0) {
            code.addIconst(0);
            code.addIstore(3);
            code.addAload(1);
            code.addCheckcast(this.targetBean.getName());
            code.addAstore(4);
            int start = code.currentPc();
            int lastIndex = 0;
            for (int i = 0; i < setters.length; ++i) {
                int diff;
                if (setters[i] != null && (diff = i - lastIndex) > 0) {
                    code.addOpcode(132);
                    code.add(3);
                    code.add(diff);
                    lastIndex = i;
                }
                code.addAload(4);
                code.addAload(2);
                code.addIconst(i);
                code.addOpcode(50);
                Class<?>[] setterParamTypes = setters[i].getParameterTypes();
                Class<?> setterParamType = setterParamTypes[0];
                if (setterParamType.isPrimitive()) {
                    this.addUnwrapper(code, setterParamType);
                } else {
                    code.addCheckcast(setterParamType.getName());
                }
                String rawSetterMethodDesc = RuntimeSupport.makeDescriptor((Method)setters[i]);
                if (!this.targetBean.isInterface()) {
                    code.addInvokevirtual(targetTypeConstPoolIndex, setters[i].getName(), rawSetterMethodDesc);
                    continue;
                }
                Class<?>[] params = setters[i].getParameterTypes();
                int size = params[0].equals(Double.TYPE) || params[0].equals(Long.TYPE) ? 3 : 2;
                code.addInvokeinterface(targetTypeConstPoolIndex, setters[i].getName(), rawSetterMethodDesc, size);
            }
            int end = code.currentPc();
            code.addOpcode(177);
            int throwableTypeIndex = constPool.addClassInfo(THROWABLE_CLASS_NAME);
            int handlerPc = code.currentPc();
            code.addExceptionHandler(start, end, handlerPc, throwableTypeIndex);
            code.addAstore(5);
            code.addNew(BULKEXCEPTION_CLASS_NAME);
            code.addOpcode(89);
            code.addAload(5);
            code.addIload(3);
            String consDesc = "(Ljava/lang/Throwable;I)V";
            code.addInvokespecial(BULKEXCEPTION_CLASS_NAME, "<init>", "(Ljava/lang/Throwable;I)V");
            code.addOpcode(191);
            StackMapTable.Writer writer = new StackMapTable.Writer(32);
            int[] localTags = new int[]{7, 7, 7, 1};
            int[] localData = new int[]{constPool.getThisClassInfo(), constPool.addClassInfo("java/lang/Object"), constPool.addClassInfo("[Ljava/lang/Object;"), 0};
            int[] stackTags = new int[]{7};
            int[] stackData = new int[]{throwableTypeIndex};
            writer.fullFrame(handlerPc, localTags, localData, stackTags, stackData);
            stackmap = writer.toStackMapTable(constPool);
        } else {
            code.addOpcode(177);
        }
        CodeAttribute ca = code.toCodeAttribute();
        if (stackmap != null) {
            ca.setAttribute(stackmap);
        }
        setterMethodInfo.setCodeAttribute(ca);
        setterMethodInfo.setAccessFlags(1);
        classfile.addMethod(setterMethodInfo);
    }

    private void addUnwrapper(Bytecode code, Class type) {
        int index = FactoryHelper.typeIndex((Class)type);
        String wrapperType = FactoryHelper.wrapperTypes[index];
        code.addCheckcast(wrapperType);
        code.addInvokevirtual(wrapperType, FactoryHelper.unwarpMethods[index], FactoryHelper.unwrapDesc[index]);
    }

    private static void findAccessors(Class clazz, String[] getterNames, String[] setterNames, Class[] types, Method[] getters, Method[] setters) {
        int length = types.length;
        if (setterNames.length != length || getterNames.length != length) {
            throw new BulkAccessorException("bad number of accessors");
        }
        Class[] getParam = new Class[]{};
        Class[] setParam = new Class[1];
        for (int i = 0; i < length; ++i) {
            if (getterNames[i] != null) {
                Method getter = BulkAccessorFactory.findAccessor(clazz, getterNames[i], getParam, i);
                if (getter.getReturnType() != types[i]) {
                    throw new BulkAccessorException("wrong return type: " + getterNames[i], i);
                }
                getters[i] = getter;
            }
            if (setterNames[i] == null) continue;
            setParam[0] = types[i];
            setters[i] = BulkAccessorFactory.findAccessor(clazz, setterNames[i], setParam, i);
        }
    }

    private static Method findAccessor(Class clazz, String name, Class[] params, int index) throws BulkAccessorException {
        try {
            Method method = clazz.getDeclaredMethod(name, params);
            if (Modifier.isPrivate(method.getModifiers())) {
                throw new BulkAccessorException("private property", index);
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new BulkAccessorException("cannot find an accessor", index);
        }
    }
}

