/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.build.internal;

import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.loader.plan.build.internal.AbstractLoadPlanBuildingAssociationVisitationStrategy;
import org.hibernate.loader.plan.build.internal.LoadPlanImpl;
import org.hibernate.loader.plan.spi.CollectionReturn;
import org.hibernate.loader.plan.spi.EntityReturn;
import org.hibernate.loader.plan.spi.LoadPlan;
import org.hibernate.loader.plan.spi.QuerySpaces;
import org.hibernate.loader.plan.spi.Return;
import org.hibernate.persister.walking.spi.AssociationAttributeDefinition;
import org.jboss.logging.Logger;

public class FetchStyleLoadPlanBuildingAssociationVisitationStrategy
extends AbstractLoadPlanBuildingAssociationVisitationStrategy {
    private static final Logger log = CoreLogging.logger(FetchStyleLoadPlanBuildingAssociationVisitationStrategy.class);
    private final LoadQueryInfluencers loadQueryInfluencers;
    private final LockMode lockMode;
    private Return rootReturn;

    public FetchStyleLoadPlanBuildingAssociationVisitationStrategy(SessionFactoryImplementor sessionFactory, LoadQueryInfluencers loadQueryInfluencers, LockMode lockMode) {
        super(sessionFactory);
        this.loadQueryInfluencers = loadQueryInfluencers;
        this.lockMode = lockMode;
    }

    @Override
    protected boolean supportsRootEntityReturns() {
        return true;
    }

    @Override
    protected boolean supportsRootCollectionReturns() {
        return true;
    }

    @Override
    protected void addRootReturn(Return rootReturn) {
        if (this.rootReturn != null) {
            throw new HibernateException("Root return already identified");
        }
        this.rootReturn = rootReturn;
    }

    @Override
    public LoadPlan buildLoadPlan() {
        log.debug((Object)"Building LoadPlan...");
        if (EntityReturn.class.isInstance(this.rootReturn)) {
            return new LoadPlanImpl((EntityReturn)this.rootReturn, (QuerySpaces)this.getQuerySpaces());
        }
        if (CollectionReturn.class.isInstance(this.rootReturn)) {
            return new LoadPlanImpl((CollectionReturn)this.rootReturn, (QuerySpaces)this.getQuerySpaces());
        }
        throw new IllegalStateException("Unexpected root Return type : " + this.rootReturn);
    }

    @Override
    protected FetchStrategy determineFetchStrategy(AssociationAttributeDefinition attributeDefinition) {
        FetchStrategy fetchStrategy = attributeDefinition.determineFetchPlan(this.loadQueryInfluencers, this.currentPropertyPath);
        if (fetchStrategy.getTiming() == FetchTiming.IMMEDIATE && fetchStrategy.getStyle() == FetchStyle.JOIN) {
            fetchStrategy = this.adjustJoinFetchIfNeeded(attributeDefinition, fetchStrategy);
        }
        return fetchStrategy;
    }

    protected FetchStrategy adjustJoinFetchIfNeeded(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy) {
        if (this.lockMode.greaterThan(LockMode.READ)) {
            return new FetchStrategy(fetchStrategy.getTiming(), FetchStyle.SELECT);
        }
        Integer maxFetchDepth = this.sessionFactory().getSettings().getMaximumFetchDepth();
        if (maxFetchDepth != null && this.currentDepth() > maxFetchDepth) {
            return new FetchStrategy(fetchStrategy.getTiming(), FetchStyle.SELECT);
        }
        if (attributeDefinition.getType().isCollectionType() && this.isTooManyCollections()) {
            return new FetchStrategy(fetchStrategy.getTiming(), FetchStyle.SELECT);
        }
        return fetchStrategy;
    }

    @Override
    protected boolean isTooManyCollections() {
        return CollectionReturn.class.isInstance(this.rootReturn);
    }
}

