/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.dispatch;

import java.io.IOException;
import java.security.KeyStore;
import java.security.Principal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.servlet.FilterConfig;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.knox.gateway.SpiGatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.dispatch.HadoopAuthCookieStore;
import org.apache.knox.gateway.dispatch.HttpClientFactory;
import org.apache.knox.gateway.dispatch.KnoxSpnegoAuthSchemeFactory;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.metrics.MetricsService;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.joda.time.Period;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class DefaultHttpClientFactory
implements HttpClientFactory {
    private static final SpiGatewayMessages LOG = (SpiGatewayMessages)MessagesFactory.get(SpiGatewayMessages.class);
    private static final String PARAMETER_SERVICE_ROLE = "serviceRole";
    static final String PARAMETER_USE_TWO_WAY_SSL = "useTwoWaySsl";

    @Override
    public HttpClient createHttpClient(FilterConfig filterConfig) {
        HttpClientBuilder builder;
        String serviceRole = filterConfig.getInitParameter(PARAMETER_SERVICE_ROLE);
        GatewayConfig gatewayConfig = (GatewayConfig)filterConfig.getServletContext().getAttribute("org.apache.knox.gateway.config");
        GatewayServices services = (GatewayServices)filterConfig.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        if (gatewayConfig != null && gatewayConfig.isMetricsEnabled()) {
            MetricsService metricsService = (MetricsService)services.getService(ServiceType.METRICS_SERVICE);
            builder = metricsService.getInstrumented(HttpClientBuilder.class);
        } else {
            builder = HttpClients.custom();
        }
        SSLContext sslContext = this.createSSLContext(services, filterConfig, serviceRole);
        if (sslContext != null) {
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext));
        }
        if (Boolean.parseBoolean(System.getProperty("gateway.hadoop.kerberos.secured"))) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UseJaasCredentials());
            Registry authSchemeRegistry = RegistryBuilder.create().register("Negotiate", (Object)new KnoxSpnegoAuthSchemeFactory(true)).build();
            builder.setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry).setDefaultCookieStore((CookieStore)new HadoopAuthCookieStore(gatewayConfig)).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        } else {
            builder.setDefaultCookieStore((CookieStore)new NoCookieStore());
        }
        builder.setKeepAliveStrategy((ConnectionKeepAliveStrategy)DefaultConnectionKeepAliveStrategy.INSTANCE);
        builder.setConnectionReuseStrategy((ConnectionReuseStrategy)DefaultConnectionReuseStrategy.INSTANCE);
        builder.setRedirectStrategy((RedirectStrategy)new NeverRedirectStrategy());
        builder.setRetryHandler((HttpRequestRetryHandler)new NeverRetryHandler());
        int maxConnections = this.getMaxConnections(filterConfig);
        builder.setMaxConnTotal(maxConnections);
        builder.setMaxConnPerRoute(maxConnections);
        builder.setDefaultRequestConfig(DefaultHttpClientFactory.getRequestConfig(filterConfig, serviceRole));
        builder.disableContentCompression();
        return builder.build();
    }

    SSLContext createSSLContext(GatewayServices services, FilterConfig filterConfig, String serviceRole) {
        KeystoreService ks = (KeystoreService)services.getService(ServiceType.KEYSTORE_SERVICE);
        try {
            KeyStore trustKeystore;
            char[] identityKeyPassphrase;
            KeyStore identityKeystore;
            if (Boolean.parseBoolean(filterConfig.getInitParameter(PARAMETER_USE_TWO_WAY_SSL))) {
                LOG.usingTwoWaySsl(serviceRole);
                AliasService as = (AliasService)services.getService(ServiceType.ALIAS_SERVICE);
                identityKeystore = ks.getKeystoreForGateway();
                identityKeyPassphrase = as.getGatewayIdentityPassphrase();
                trustKeystore = ks.getTruststoreForHttpClient();
                if (trustKeystore == null) {
                    trustKeystore = identityKeystore;
                }
            } else {
                identityKeystore = null;
                identityKeyPassphrase = null;
                trustKeystore = ks.getTruststoreForHttpClient();
            }
            if (identityKeystore != null || trustKeystore != null) {
                SSLContextBuilder sslContextBuilder = SSLContexts.custom();
                if (identityKeystore != null) {
                    sslContextBuilder.loadKeyMaterial(identityKeystore, identityKeyPassphrase);
                }
                if (trustKeystore != null) {
                    sslContextBuilder.loadTrustMaterial(trustKeystore, null);
                }
                return sslContextBuilder.build();
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to create SSLContext", e);
        }
    }

    static RequestConfig getRequestConfig(FilterConfig config, String serviceRole) {
        int socketTimeout;
        RequestConfig.Builder builder = RequestConfig.custom();
        int connectionTimeout = DefaultHttpClientFactory.getConnectionTimeout(config);
        if (connectionTimeout != -1) {
            builder.setConnectTimeout(connectionTimeout);
            builder.setConnectionRequestTimeout(connectionTimeout);
            LOG.setHttpClientConnectionTimeout(connectionTimeout, serviceRole == null ? "N/A" : serviceRole);
        }
        if ((socketTimeout = DefaultHttpClientFactory.getSocketTimeout(config)) != -1) {
            builder.setSocketTimeout(socketTimeout);
            LOG.setHttpClientSocketTimeout(socketTimeout, serviceRole == null ? "N/A" : serviceRole);
        }
        builder.setNormalizeUri(true);
        return builder.build();
    }

    private int getMaxConnections(FilterConfig filterConfig) {
        String str;
        int maxConnections = 32;
        GatewayConfig config = (GatewayConfig)filterConfig.getServletContext().getAttribute("org.apache.knox.gateway.config");
        if (config != null) {
            maxConnections = config.getHttpClientMaxConnections();
        }
        if ((str = filterConfig.getInitParameter("httpclient.maxConnections")) != null) {
            try {
                maxConnections = Integer.parseInt(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return maxConnections;
    }

    private static int getConnectionTimeout(FilterConfig filterConfig) {
        String str;
        int timeout = -1;
        GatewayConfig globalConfig = (GatewayConfig)filterConfig.getServletContext().getAttribute("org.apache.knox.gateway.config");
        if (globalConfig != null) {
            timeout = globalConfig.getHttpClientConnectionTimeout();
        }
        if ((str = filterConfig.getInitParameter("httpclient.connectionTimeout")) != null) {
            try {
                timeout = (int)DefaultHttpClientFactory.parseTimeout(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return timeout;
    }

    private static int getSocketTimeout(FilterConfig filterConfig) {
        String str;
        int timeout = -1;
        GatewayConfig globalConfig = (GatewayConfig)filterConfig.getServletContext().getAttribute("org.apache.knox.gateway.config");
        if (globalConfig != null) {
            timeout = globalConfig.getHttpClientSocketTimeout();
        }
        if ((str = filterConfig.getInitParameter("httpclient.socketTimeout")) != null) {
            try {
                timeout = (int)DefaultHttpClientFactory.parseTimeout(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return timeout;
    }

    private static long parseTimeout(String s) {
        PeriodFormatter f = new PeriodFormatterBuilder().appendMinutes().appendSuffix("m", " min").appendSeconds().appendSuffix("s", " sec").appendMillis().toFormatter();
        Period p = Period.parse((String)s, (PeriodFormatter)f);
        return p.toStandardDuration().getMillis();
    }

    private static class UseJaasCredentials
    implements Credentials {
        private UseJaasCredentials() {
        }

        public String getPassword() {
            return null;
        }

        public Principal getUserPrincipal() {
            return null;
        }
    }

    private static class NeverRetryHandler
    implements HttpRequestRetryHandler {
        private NeverRetryHandler() {
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            return false;
        }
    }

    private static class NeverRedirectStrategy
    implements RedirectStrategy {
        private NeverRedirectStrategy() {
        }

        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            return false;
        }

        public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            return null;
        }
    }

    private static class NoCookieStore
    implements CookieStore {
        private NoCookieStore() {
        }

        public void addCookie(Cookie cookie) {
        }

        public List<Cookie> getCookies() {
            return Collections.emptyList();
        }

        public boolean clearExpired(Date date) {
            return true;
        }

        public void clear() {
        }
    }
}

