/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.pac4j.filter;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Optional;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.gateway.audit.api.AuditService;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.security.PrimaryPrincipal;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pac4jIdentityAdapter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(Pac4jIdentityAdapter.class);
    public static final String PAC4J_ID_ATTRIBUTE = "pac4j.id_attribute";
    private static final String PAC4J_CONFIG = "pac4j.config";
    private static AuditService auditService = AuditServiceFactory.getAuditService();
    private static Auditor auditor = auditService.getAuditor("audit", "knox", "knox");
    private String testIdentifier;
    private String idAttribute;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.idAttribute = filterConfig.getInitParameter(PAC4J_ID_ATTRIBUTE);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        JEEContext context = new JEEContext(request, response, ((Config)request.getAttribute(PAC4J_CONFIG)).getSessionStore());
        ProfileManager manager = new ProfileManager((WebContext)context);
        Optional optional = manager.get(true);
        if (optional.isPresent()) {
            CommonProfile profile = (CommonProfile)optional.get();
            logger.debug("User authenticated as: {}", (Object)profile);
            manager.remove(true);
            String id = null;
            if (this.idAttribute != null) {
                Object attribute = profile.getAttribute(this.idAttribute);
                if (attribute != null) {
                    id = attribute.toString();
                }
                if (id == null) {
                    logger.error("Invalid attribute_id: {} configured to be used as principal falling back to default id", (Object)this.idAttribute);
                }
            }
            if (id == null) {
                id = profile.getId();
            }
            this.testIdentifier = id;
            PrimaryPrincipal pp = new PrimaryPrincipal(id);
            Subject subject = new Subject();
            subject.getPrincipals().add((Principal)pp);
            auditService.getContext().setUsername(id);
            String sourceUri = (String)request.getAttribute("sourceRequestContextUrl");
            auditor.audit("authentication", sourceUri, "uri", "success");
            this.doAs((ServletRequest)request, (ServletResponse)response, chain, subject);
        }
    }

    private void doAs(final ServletRequest request, final ServletResponse response, final FilterChain chain, Subject subject) throws IOException, ServletException {
        try {
            Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    chain.doFilter(request, response);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException(t);
        }
    }

    public static void setAuditService(AuditService auditService) {
        Pac4jIdentityAdapter.auditService = auditService;
    }

    public static void setAuditor(Auditor auditor) {
        Pac4jIdentityAdapter.auditor = auditor;
    }

    public String getTestIdentifier() {
        return this.testIdentifier;
    }
}

