/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.knoxtoken;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.KeyLengthException;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.util.ByteUtils;
import java.nio.charset.StandardCharsets;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.security.SubjectUtils;
import org.apache.knox.gateway.service.knoxtoken.TokenServiceMessages;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.services.security.token.JWTokenAttributes;
import org.apache.knox.gateway.services.security.token.JWTokenAttributesBuilder;
import org.apache.knox.gateway.services.security.token.JWTokenAuthority;
import org.apache.knox.gateway.services.security.token.TokenMetadata;
import org.apache.knox.gateway.services.security.token.TokenServiceException;
import org.apache.knox.gateway.services.security.token.TokenStateService;
import org.apache.knox.gateway.services.security.token.TokenUtils;
import org.apache.knox.gateway.services.security.token.UnknownTokenException;
import org.apache.knox.gateway.services.security.token.impl.JWT;
import org.apache.knox.gateway.services.security.token.impl.JWTToken;
import org.apache.knox.gateway.services.security.token.impl.TokenMAC;
import org.apache.knox.gateway.util.JsonUtils;
import org.apache.knox.gateway.util.Tokens;

@Singleton
@Path(value="knoxtoken/api/v1/token")
public class TokenResource {
    static final String LIFESPAN = "lifespan";
    static final String COMMENT = "comment";
    private static final String EXPIRES_IN = "expires_in";
    private static final String TOKEN_TYPE = "token_type";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String TOKEN_ID = "token_id";
    private static final String PASSCODE = "passcode";
    private static final String MANAGED_TOKEN = "managed";
    private static final String TARGET_URL = "target_url";
    private static final String ENDPOINT_PUBLIC_CERT = "endpoint_public_cert";
    private static final String BEARER = "Bearer";
    private static final String TOKEN_TTL_PARAM = "knox.token.ttl";
    private static final String TOKEN_AUDIENCES_PARAM = "knox.token.audiences";
    private static final String TOKEN_TARGET_URL = "knox.token.target.url";
    static final String TOKEN_CLIENT_DATA = "knox.token.client.data";
    private static final String TOKEN_CLIENT_CERT_REQUIRED = "knox.token.client.cert.required";
    private static final String TOKEN_ALLOWED_PRINCIPALS = "knox.token.allowed.principals";
    private static final String TOKEN_SIG_ALG = "knox.token.sigalg";
    private static final String TOKEN_EXP_RENEWAL_INTERVAL = "knox.token.exp.renew-interval";
    private static final String TOKEN_EXP_RENEWAL_MAX_LIFETIME = "knox.token.exp.max-lifetime";
    private static final String TOKEN_EXP_TOKENGEN_ALLOWED_TSS_BACKENDS = "knox.token.exp.tokengen.allowed.tss.backends";
    private static final String TOKEN_RENEWER_WHITELIST = "knox.token.renewer.whitelist";
    private static final String TSS_STATUS_IS_MANAGEMENT_ENABLED = "tokenManagementEnabled";
    private static final String TSS_STATUS_CONFIFURED_BACKEND = "configuredTssBackend";
    private static final String TSS_STATUS_ACTUAL_BACKEND = "actualTssBackend";
    private static final String TSS_ALLOWED_BACKEND_FOR_TOKENGEN = "allowedTssForTokengen";
    private static final String TSS_MAXIMUM_LIFETIME_SECONDS = "maximumLifetimeSeconds";
    private static final String TSS_MAXIMUM_LIFETIME_TEXT = "maximumLifetimeText";
    private static final String LIFESPAN_INPUT_ENABLED_PARAM = "knox.token.lifespan.input.enabled";
    private static final String LIFESPAN_INPUT_ENABLED_TEXT = "lifespanInputEnabled";
    private static final long TOKEN_TTL_DEFAULT = 30000L;
    static final String TOKEN_API_PATH = "knoxtoken/api/v1";
    static final String RESOURCE_PATH = "knoxtoken/api/v1/token";
    static final String GET_USER_TOKENS = "/getUserTokens";
    static final String GET_TSS_STATUS_PATH = "/getTssStatus";
    static final String RENEW_PATH = "/renew";
    static final String REVOKE_PATH = "/revoke";
    static final String ENABLE_PATH = "/enable";
    static final String DISABLE_PATH = "/disable";
    private static final String TARGET_ENDPOINT_PULIC_CERT_PEM = "knox.token.target.endpoint.cert.pem";
    private static TokenServiceMessages log = (TokenServiceMessages)MessagesFactory.get(TokenServiceMessages.class);
    private long tokenTTL = 30000L;
    private String tokenTTLAsText;
    private List<String> targetAudiences = new ArrayList<String>();
    private String tokenTargetUrl;
    private Map<String, Object> tokenClientDataMap;
    private List<String> allowedDNs = new ArrayList<String>();
    private boolean clientCertRequired;
    private String signatureAlgorithm;
    private String endpointPublicCert;
    private TokenStateService tokenStateService;
    private TokenMAC tokenMAC;
    private final Map<String, String> tokenStateServiceStatusMap = new HashMap<String, String>();
    private Optional<Long> renewInterval = Optional.empty();
    private Optional<Long> maxTokenLifetime = Optional.empty();
    private int tokenLimitPerUser;
    private List<String> allowedRenewers;
    @Context
    HttpServletRequest request;
    @Context
    ServletContext context;

    @PostConstruct
    public void init() throws AliasServiceException, ServiceLifecycleException, KeyLengthException {
        String ttl;
        String audiences = this.context.getInitParameter(TOKEN_AUDIENCES_PARAM);
        if (audiences != null) {
            String[] auds;
            for (String aud : auds = audiences.split(",")) {
                this.targetAudiences.add(aud.trim());
            }
        }
        String clientCert = this.context.getInitParameter(TOKEN_CLIENT_CERT_REQUIRED);
        this.clientCertRequired = "true".equals(clientCert);
        String principals = this.context.getInitParameter(TOKEN_ALLOWED_PRINCIPALS);
        if (principals != null) {
            String[] dns;
            for (String dn : dns = principals.split(";")) {
                this.allowedDNs.add(dn.replaceAll("\\s+", ""));
            }
        }
        if ((ttl = this.context.getInitParameter(TOKEN_TTL_PARAM)) != null) {
            try {
                this.tokenTTL = Long.parseLong(ttl);
                if (this.tokenTTL < -1L || this.tokenTTL + System.currentTimeMillis() < 0L) {
                    log.invalidTokenTTLEncountered(ttl);
                    this.tokenTTL = 30000L;
                }
            }
            catch (NumberFormatException nfe) {
                log.invalidTokenTTLEncountered(ttl);
            }
        }
        this.tokenTTLAsText = this.getTokenTTLAsText();
        this.tokenTargetUrl = this.context.getInitParameter(TOKEN_TARGET_URL);
        String clientData = this.context.getInitParameter(TOKEN_CLIENT_DATA);
        if (clientData != null) {
            this.tokenClientDataMap = new HashMap<String, Object>();
            String[] tokenClientData = clientData.split(",");
            this.addClientDataToMap(tokenClientData, this.tokenClientDataMap);
        }
        this.setSignatureAlogrithm();
        String targetEndpointPublicCert = this.context.getInitParameter(TARGET_ENDPOINT_PULIC_CERT_PEM);
        if (targetEndpointPublicCert != null) {
            this.endpointPublicCert = targetEndpointPublicCert;
        }
        if (this.isServerManagedTokenStateEnabled()) {
            String maxLifetimeValue;
            String topologyName = this.getTopologyName();
            log.serverManagedTokenStateEnabled(topologyName);
            GatewayServices services = (GatewayServices)this.context.getAttribute("org.apache.knox.gateway.gateway.services");
            this.tokenStateService = (TokenStateService)services.getService(ServiceType.TOKEN_STATE_SERVICE);
            GatewayConfig gatewayConfig = (GatewayConfig)this.context.getAttribute("org.apache.knox.gateway.config");
            AliasService aliasService = (AliasService)services.getService(ServiceType.ALIAS_SERVICE);
            this.tokenMAC = new TokenMAC(gatewayConfig.getKnoxTokenHashAlgorithm(), aliasService.getPasswordFromAliasForGateway("knox.token.hash.key"));
            this.tokenLimitPerUser = gatewayConfig.getMaximumNumberOfTokensPerUser();
            String renewIntervalValue = this.context.getInitParameter(TOKEN_EXP_RENEWAL_INTERVAL);
            if (renewIntervalValue != null && !renewIntervalValue.isEmpty()) {
                try {
                    this.renewInterval = Optional.of(Long.parseLong(renewIntervalValue));
                }
                catch (NumberFormatException e) {
                    log.invalidConfigValue(topologyName, TOKEN_EXP_RENEWAL_INTERVAL, renewIntervalValue, e);
                }
            }
            if ((maxLifetimeValue = this.context.getInitParameter(TOKEN_EXP_RENEWAL_MAX_LIFETIME)) != null && !maxLifetimeValue.isEmpty()) {
                try {
                    this.maxTokenLifetime = Optional.of(Long.parseLong(maxLifetimeValue));
                }
                catch (NumberFormatException e) {
                    log.invalidConfigValue(topologyName, TOKEN_EXP_RENEWAL_MAX_LIFETIME, maxLifetimeValue, e);
                }
            }
            this.allowedRenewers = new ArrayList<String>();
            String renewerList = this.context.getInitParameter(TOKEN_RENEWER_WHITELIST);
            if (renewerList != null && !renewerList.isEmpty()) {
                for (String renewer : renewerList.split(",")) {
                    this.allowedRenewers.add(renewer.trim());
                }
            } else {
                log.noRenewersConfigured(topologyName);
            }
        }
        this.setTokenStateServiceStatusMap();
    }

    private String getTokenTTLAsText() {
        if (this.tokenTTL == -1L) {
            return "Unlimited lifetime";
        }
        Duration tokenTTLDuration = Duration.ofMillis(this.tokenTTL);
        long daysPart = tokenTTLDuration.toDays();
        long hoursPart = daysPart > 0L ? tokenTTLDuration.minusDays(daysPart).toHours() : tokenTTLDuration.toHours();
        long minutesPart = tokenTTLDuration.toHours() > 0L ? tokenTTLDuration.minusHours(tokenTTLDuration.toHours()).toMinutes() : tokenTTLDuration.toMinutes();
        long secondsPart = tokenTTLDuration.toMinutes() > 0L ? tokenTTLDuration.minusMinutes(tokenTTLDuration.toMinutes()).getSeconds() : tokenTTLDuration.getSeconds();
        StringBuilder sb = new StringBuilder(32);
        if (daysPart > 0L) {
            sb.append(daysPart).append(" days ");
        }
        if (hoursPart > 0L) {
            sb.append(hoursPart).append(" hours ");
        }
        if (minutesPart > 0L) {
            sb.append(minutesPart).append(" minutes ");
        }
        if (secondsPart > 0L) {
            sb.append(secondsPart).append(" seconds");
        }
        return sb.toString();
    }

    private void setTokenStateServiceStatusMap() {
        if (this.isServerManagedTokenStateEnabled()) {
            this.tokenStateServiceStatusMap.put(TSS_STATUS_IS_MANAGEMENT_ENABLED, "true");
            GatewayConfig config = (GatewayConfig)this.request.getServletContext().getAttribute("org.apache.knox.gateway.config");
            String configuredTokenStateServiceImpl = config.getServiceParameter(ServiceType.TOKEN_STATE_SERVICE.getShortName(), "impl");
            String configuredTokenServiceName = StringUtils.isBlank((CharSequence)configuredTokenStateServiceImpl) ? "" : configuredTokenStateServiceImpl.substring(configuredTokenStateServiceImpl.lastIndexOf(46) + 1);
            String actualTokenStateServiceImpl = this.tokenStateService.getClass().getCanonicalName();
            String actualTokenServiceName = actualTokenStateServiceImpl.substring(actualTokenStateServiceImpl.lastIndexOf(46) + 1);
            this.tokenStateServiceStatusMap.put(TSS_STATUS_CONFIFURED_BACKEND, configuredTokenServiceName);
            this.tokenStateServiceStatusMap.put(TSS_STATUS_ACTUAL_BACKEND, actualTokenServiceName);
            this.populateAllowedTokenStateBackendForTokenGenApp(actualTokenServiceName);
            this.tokenStateServiceStatusMap.put(TSS_MAXIMUM_LIFETIME_SECONDS, String.valueOf(this.tokenTTL == -1L ? this.tokenTTL : this.tokenTTL / 1000L));
            this.tokenStateServiceStatusMap.put(TSS_MAXIMUM_LIFETIME_TEXT, this.tokenTTLAsText);
        } else {
            this.tokenStateServiceStatusMap.put(TSS_STATUS_IS_MANAGEMENT_ENABLED, "false");
        }
        String lifespanInputEnabledValue = this.context.getInitParameter(LIFESPAN_INPUT_ENABLED_PARAM);
        Boolean lifespanInputEnabled = lifespanInputEnabledValue == null ? Boolean.TRUE : Boolean.parseBoolean(lifespanInputEnabledValue);
        this.tokenStateServiceStatusMap.put(LIFESPAN_INPUT_ENABLED_TEXT, lifespanInputEnabled.toString());
    }

    private void populateAllowedTokenStateBackendForTokenGenApp(String actualTokenServiceName) {
        this.tokenStateServiceStatusMap.put(TSS_ALLOWED_BACKEND_FOR_TOKENGEN, "false");
        String allowedTssBackends = this.context.getInitParameter(TOKEN_EXP_TOKENGEN_ALLOWED_TSS_BACKENDS);
        if (allowedTssBackends != null && !allowedTssBackends.isEmpty()) {
            for (String allowedTssBackend : allowedTssBackends.split(",")) {
                if (!allowedTssBackend.trim().equals(actualTokenServiceName)) continue;
                this.tokenStateServiceStatusMap.put(TSS_ALLOWED_BACKEND_FOR_TOKENGEN, "true");
                break;
            }
        } else if ("AliasBasedTokenStateService".equals(actualTokenServiceName) || "JDBCTokenStateService".equals(actualTokenServiceName)) {
            this.tokenStateServiceStatusMap.put(TSS_ALLOWED_BACKEND_FOR_TOKENGEN, "true");
        }
    }

    private void setSignatureAlogrithm() throws AliasServiceException, KeyLengthException {
        String configuredSigAlg = this.context.getInitParameter(TOKEN_SIG_ALG);
        GatewayConfig config = (GatewayConfig)this.request.getServletContext().getAttribute("org.apache.knox.gateway.config");
        GatewayServices services = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        AliasService aliasService = (AliasService)services.getService(ServiceType.ALIAS_SERVICE);
        this.signatureAlgorithm = TokenUtils.getSignatureAlgorithm((String)configuredSigAlg, (AliasService)aliasService, (String)config.getSigningKeystoreName());
        char[] hmacSecret = aliasService.getPasswordFromAliasForGateway("gateway.signing.hmac.secret");
        if (hmacSecret != null && !this.isAlgCompatibleWithSecret(this.signatureAlgorithm, hmacSecret)) {
            throw new KeyLengthException((Algorithm)JWSAlgorithm.parse((String)this.signatureAlgorithm));
        }
    }

    private boolean isAlgCompatibleWithSecret(String algName, char[] secret) {
        return MACSigner.getCompatibleAlgorithms((int)ByteUtils.bitLength((int)secret.length)).contains(JWSAlgorithm.parse((String)algName));
    }

    private boolean isServerManagedTokenStateEnabled() {
        GatewayConfig config;
        String serviceParamValue = this.context.getInitParameter("knox.token.exp.server-managed");
        boolean isServerManaged = serviceParamValue == null || serviceParamValue.isEmpty() ? (config = (GatewayConfig)this.context.getAttribute("org.apache.knox.gateway.config")) != null && config.isServerManagedTokenStateEnabled() : Boolean.valueOf(serviceParamValue);
        return isServerManaged;
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response doGet() {
        return this.getAuthenticationToken();
    }

    @POST
    @Produces(value={"application/json", "application/xml"})
    public Response doPost() {
        return this.getAuthenticationToken();
    }

    @GET
    @Path(value="/getUserTokens")
    @Produces(value={"application/json", "application/xml"})
    public Response getUserTokens(@QueryParam(value="userName") String userName) {
        if (this.tokenStateService == null) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"{\n  \"error\": \"Token management is not configured\"\n}\n").build();
        }
        Collection tokens = this.tokenStateService.getTokens(userName);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)JsonUtils.renderAsJsonString(Collections.singletonMap("tokens", tokens))).build();
    }

    @GET
    @Path(value="/getTssStatus")
    @Produces(value={"application/json"})
    public Response getTokenStateServiceStatus() {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)JsonUtils.renderAsJsonString(this.tokenStateServiceStatusMap)).build();
    }

    @PUT
    @Path(value="/renew")
    @Produces(value={"application/json"})
    public Response renew(String token) {
        Response resp;
        long expiration = 0L;
        String error = "";
        ErrorCode errorCode = ErrorCode.UNKNOWN;
        Response.Status errorStatus = Response.Status.BAD_REQUEST;
        if (this.tokenStateService == null) {
            try {
                JWTToken jwt = new JWTToken(token);
                log.renewalDisabled(this.getTopologyName(), Tokens.getTokenDisplayText((String)token), Tokens.getTokenIDDisplayText((String)TokenUtils.getTokenId((JWT)jwt)));
                expiration = Long.parseLong(jwt.getExpires());
            }
            catch (ParseException e) {
                log.invalidToken(this.getTopologyName(), Tokens.getTokenDisplayText((String)token), e);
                error = this.safeGetMessage(e);
                errorCode = ErrorCode.INVALID_TOKEN;
            }
            catch (Exception e) {
                error = this.safeGetMessage(e);
                errorCode = ErrorCode.INTERNAL_ERROR;
            }
        } else {
            String renewer = SubjectUtils.getCurrentEffectivePrincipalName();
            if (this.allowedRenewers.contains(renewer)) {
                try {
                    JWTToken jwt = new JWTToken(token);
                    expiration = this.tokenStateService.renewToken(jwt, this.renewInterval.orElse(this.tokenStateService.getDefaultRenewInterval()).longValue());
                    log.renewedToken(this.getTopologyName(), Tokens.getTokenDisplayText((String)token), Tokens.getTokenIDDisplayText((String)TokenUtils.getTokenId((JWT)jwt)), renewer);
                }
                catch (ParseException e) {
                    log.invalidToken(this.getTopologyName(), Tokens.getTokenDisplayText((String)token), e);
                    errorCode = ErrorCode.INVALID_TOKEN;
                    error = this.safeGetMessage(e);
                }
                catch (Exception e) {
                    error = this.safeGetMessage(e);
                    errorCode = ErrorCode.INTERNAL_ERROR;
                }
            } else {
                errorStatus = Response.Status.FORBIDDEN;
                error = "Caller (" + renewer + ") not authorized to renew tokens.";
                errorCode = ErrorCode.UNAUTHORIZED;
            }
        }
        if (error.isEmpty()) {
            resp = Response.status((Response.Status)Response.Status.OK).entity((Object)("{\n  \"renewed\": \"true\",\n  \"expires\": \"" + expiration + "\"\n}\n")).build();
        } else {
            log.badRenewalRequest(this.getTopologyName(), Tokens.getTokenDisplayText((String)token), error);
            resp = Response.status((Response.Status)errorStatus).entity((Object)("{\n  \"renewed\": \"false\",\n  \"error\": \"" + error + "\",\n  \"code\": " + errorCode.toInt() + "\n}\n")).build();
        }
        return resp;
    }

    @DELETE
    @Path(value="/revoke")
    @Produces(value={"application/json"})
    public Response revoke(String token) {
        Response resp;
        String error = "";
        ErrorCode errorCode = ErrorCode.UNKNOWN;
        Response.Status errorStatus = Response.Status.BAD_REQUEST;
        if (this.tokenStateService == null) {
            error = "Token revocation support is not configured";
            errorCode = ErrorCode.CONFIGURATION_ERROR;
        } else {
            try {
                String revoker = SubjectUtils.getCurrentEffectivePrincipalName();
                String tokenId = this.getTokenId(token);
                if (this.triesToRevokeOwnToken(tokenId, revoker) || this.allowedRenewers.contains(revoker)) {
                    this.tokenStateService.revokeToken(tokenId);
                    log.revokedToken(this.getTopologyName(), Tokens.getTokenDisplayText((String)token), Tokens.getTokenIDDisplayText((String)tokenId), revoker);
                } else {
                    errorStatus = Response.Status.FORBIDDEN;
                    error = "Caller (" + revoker + ") not authorized to revoke tokens.";
                    errorCode = ErrorCode.UNAUTHORIZED;
                }
            }
            catch (ParseException e) {
                log.invalidToken(this.getTopologyName(), Tokens.getTokenDisplayText((String)token), e);
                error = this.safeGetMessage(e);
                errorCode = ErrorCode.INVALID_TOKEN;
            }
            catch (UnknownTokenException e) {
                error = this.safeGetMessage(e);
                errorCode = ErrorCode.UNKNOWN_TOKEN;
            }
        }
        if (error.isEmpty()) {
            resp = Response.status((Response.Status)Response.Status.OK).entity((Object)"{\n  \"revoked\": \"true\"\n}\n").build();
        } else {
            log.badRevocationRequest(this.getTopologyName(), Tokens.getTokenDisplayText((String)token), error);
            resp = Response.status((Response.Status)errorStatus).entity((Object)("{\n  \"revoked\": \"false\",\n  \"error\": \"" + error + "\",\n  \"code\": " + errorCode.toInt() + "\n}\n")).build();
        }
        return resp;
    }

    private boolean triesToRevokeOwnToken(String tokenId, String revoker) throws UnknownTokenException {
        TokenMetadata metadata = this.tokenStateService.getTokenMetadata(tokenId);
        String tokenUserName = metadata == null ? "" : metadata.getUserName();
        return StringUtils.isNotBlank((CharSequence)revoker) && revoker.equals(tokenUserName);
    }

    private String getTokenId(String token) throws ParseException {
        try {
            UUID.fromString(token);
            return token;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JWTToken jwt = new JWTToken(token);
            return TokenUtils.getTokenId((JWT)jwt);
        }
    }

    @PUT
    @Path(value="/enable")
    @Produces(value={"application/json"})
    public Response enable(String tokenId) {
        return this.setTokenEnabledFlag(tokenId, true);
    }

    @PUT
    @Path(value="/disable")
    @Produces(value={"application/json"})
    public Response disable(String tokenId) {
        return this.setTokenEnabledFlag(tokenId, false);
    }

    private Response setTokenEnabledFlag(String tokenId, boolean enabled) {
        String error = "";
        ErrorCode errorCode = ErrorCode.UNKNOWN;
        if (this.tokenStateService == null) {
            error = "Unable to " + (enabled ? "enable" : "disable") + " tokens because token management is not configured";
            errorCode = ErrorCode.CONFIGURATION_ERROR;
        } else {
            try {
                TokenMetadata tokenMetadata = this.tokenStateService.getTokenMetadata(tokenId);
                if (enabled && tokenMetadata.isEnabled()) {
                    error = "Token is already enabled";
                    errorCode = ErrorCode.ALREADY_ENABLED;
                } else if (!enabled && !tokenMetadata.isEnabled()) {
                    error = "Token is already disabled";
                    errorCode = ErrorCode.ALREADY_DISABLED;
                } else {
                    tokenMetadata.setEnabled(enabled);
                    this.tokenStateService.addMetadata(tokenId, tokenMetadata);
                }
            }
            catch (UnknownTokenException e) {
                error = this.safeGetMessage(e);
                errorCode = ErrorCode.UNKNOWN_TOKEN;
            }
        }
        if (error.isEmpty()) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)("{\n  \"setEnabledFlag\": \"true\",\n  \"isEnabled\": \"" + enabled + "\"\n}\n")).build();
        }
        log.badSetEnabledFlagRequest(this.getTopologyName(), Tokens.getTokenIDDisplayText((String)tokenId), error);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\n  \"setEnabledFlag\": \"false\",\n  \"error\": \"" + error + "\",\n  \"code\": " + errorCode.toInt() + "\n}\n")).build();
    }

    private X509Certificate extractCertificate(HttpServletRequest req) {
        X509Certificate[] certs = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate");
        if (null != certs && certs.length > 0) {
            return certs[0];
        }
        return null;
    }

    private Response getAuthenticationToken() {
        KeystoreService ks;
        if (this.clientCertRequired) {
            X509Certificate cert = this.extractCertificate(this.request);
            if (cert != null) {
                if (!this.allowedDNs.contains(cert.getSubjectDN().getName().replaceAll("\\s+", ""))) {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"{ \"Unable to get token - untrusted client cert.\" }").build();
                }
            } else {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"{ \"Unable to get token - client cert required.\" }").build();
            }
        }
        GatewayServices services = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        JWTokenAuthority ts = (JWTokenAuthority)services.getService(ServiceType.TOKEN_SERVICE);
        Principal p = this.request.getUserPrincipal();
        long expires = this.getExpiry();
        if (this.endpointPublicCert == null && (ks = (KeystoreService)services.getService(ServiceType.KEYSTORE_SERVICE)) != null) {
            try {
                Certificate cert = ks.getCertificateForGateway();
                byte[] bytes = cert.getEncoded();
                this.endpointPublicCert = Base64.encodeBase64String((byte[])bytes);
            }
            catch (KeyStoreException | CertificateEncodingException | KeystoreServiceException e) {
                log.unableToAcquireCertForEndpointClients((Exception)e);
            }
        }
        String jku = null;
        int idx = this.request.getRequestURL().lastIndexOf("/");
        if (idx > 1) {
            jku = this.request.getRequestURL().substring(0, idx) + "/jwks.json";
        }
        if (this.tokenStateService != null && this.tokenLimitPerUser != -1 && this.tokenStateService.getTokens(p.getName()).size() >= this.tokenLimitPerUser) {
            log.tokenLimitExceeded(p.getName());
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"{ \"Unable to get token - token limit exceeded.\" }").build();
        }
        try {
            JWTokenAttributes jwtAttributes;
            JWT token;
            boolean managedToken = this.tokenStateService != null;
            JWTokenAttributesBuilder jwtAttributesBuilder = new JWTokenAttributesBuilder();
            jwtAttributesBuilder.setPrincipal(p).setAlgorithm(this.signatureAlgorithm).setExpires(expires).setManaged(managedToken).setJku(jku);
            if (!this.targetAudiences.isEmpty()) {
                jwtAttributesBuilder.setAudiences(this.targetAudiences);
            }
            if ((token = ts.issueToken(jwtAttributes = jwtAttributesBuilder.build())) != null) {
                String accessToken = token.toString();
                String tokenId = TokenUtils.getTokenId((JWT)token);
                log.issuedToken(this.getTopologyName(), Tokens.getTokenDisplayText((String)accessToken), Tokens.getTokenIDDisplayText((String)tokenId));
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(ACCESS_TOKEN, accessToken);
                map.put(TOKEN_ID, tokenId);
                map.put(MANAGED_TOKEN, String.valueOf(managedToken));
                map.put(TOKEN_TYPE, BEARER);
                map.put(EXPIRES_IN, expires);
                if (this.tokenTargetUrl != null) {
                    map.put(TARGET_URL, this.tokenTargetUrl);
                }
                if (this.tokenClientDataMap != null) {
                    map.putAll(this.tokenClientDataMap);
                }
                if (this.endpointPublicCert != null) {
                    map.put(ENDPOINT_PUBLIC_CERT, this.endpointPublicCert);
                }
                String passcode = UUID.randomUUID().toString();
                map.put(PASSCODE, this.generatePasscodeField(tokenId, passcode));
                String jsonResponse = JsonUtils.renderAsJsonString(map);
                if (this.tokenStateService != null) {
                    long issueTime = System.currentTimeMillis();
                    this.tokenStateService.addToken(tokenId, issueTime, expires, this.maxTokenLifetime.orElse(this.tokenStateService.getDefaultMaxLifetimeDuration()).longValue());
                    String comment = this.request.getParameter(COMMENT);
                    TokenMetadata tokenMetadata = new TokenMetadata(p.getName(), StringUtils.isBlank((CharSequence)comment) ? null : comment);
                    tokenMetadata.setPasscode(this.tokenMAC.hash(tokenId, issueTime, p.getName(), passcode));
                    this.tokenStateService.addMetadata(tokenId, tokenMetadata);
                    log.storedToken(this.getTopologyName(), Tokens.getTokenDisplayText((String)accessToken), Tokens.getTokenIDDisplayText((String)tokenId));
                }
                return Response.ok().entity((Object)jsonResponse).build();
            }
            return Response.serverError().build();
        }
        catch (TokenServiceException e) {
            log.unableToIssueToken((Exception)((Object)e));
            return Response.ok().entity((Object)"{ \"Unable to acquire token.\" }").build();
        }
    }

    private String generatePasscodeField(String tokenId, String passcode) {
        String base64TokenIdPasscode = Base64.encodeBase64String((byte[])tokenId.getBytes(StandardCharsets.UTF_8)) + "::" + Base64.encodeBase64String((byte[])passcode.getBytes(StandardCharsets.UTF_8));
        return Base64.encodeBase64String((byte[])base64TokenIdPasscode.getBytes(StandardCharsets.UTF_8));
    }

    void addClientDataToMap(String[] tokenClientData, Map<String, Object> map) {
        for (String tokenClientDatum : tokenClientData) {
            String[] kv = tokenClientDatum.split("=", 2);
            if (kv.length != 2) continue;
            map.put(kv[0], kv[1]);
        }
    }

    private long getExpiry() {
        long expiry = 0L;
        long millis = this.tokenTTL;
        String lifetimeStr = this.request.getParameter(LIFESPAN);
        if (lifetimeStr == null || lifetimeStr.isEmpty()) {
            if (this.tokenTTL == -1L) {
                return -1L;
            }
        } else {
            try {
                long lifetime = Duration.parse(lifetimeStr).toMillis();
                if (this.tokenTTL == -1L) {
                    millis = lifetime;
                } else if (lifetime <= this.tokenTTL) {
                    millis = lifetime;
                }
            }
            catch (DateTimeParseException e) {
                log.invalidLifetimeValue(lifetimeStr);
            }
        }
        expiry = System.currentTimeMillis() + millis;
        return expiry;
    }

    private String getTopologyName() {
        return (String)this.context.getAttribute("org.apache.knox.gateway.gateway.cluster");
    }

    private String safeGetMessage(Throwable t) {
        String message = t.getMessage();
        return message != null ? message : "null";
    }

    public static enum ErrorCode {
        UNKNOWN(0),
        CONFIGURATION_ERROR(10),
        UNAUTHORIZED(20),
        INTERNAL_ERROR(30),
        INVALID_TOKEN(40),
        UNKNOWN_TOKEN(50),
        ALREADY_DISABLED(60),
        ALREADY_ENABLED(70);

        private final int code;

        private ErrorCode(int code) {
            this.code = code;
        }

        public int toInt() {
            return this.code;
        }
    }
}

