/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.job;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.knox.gateway.shell.AbstractRequest;
import org.apache.knox.gateway.shell.BasicResponse;
import org.apache.knox.gateway.shell.KnoxSession;

public class Hive {

    public static class Response
    extends BasicResponse {
        protected Response(HttpResponse response) {
            super(response);
        }

        public String getJobId() throws IOException {
            return (String)JsonPath.read((String)this.getString(), (String)"$.id", (Predicate[])new Predicate[0]);
        }
    }

    public static class Request
    extends AbstractRequest<Response> {
        private String group;
        private String file;
        private String statusDir;
        List<NameValuePair> params = new ArrayList<NameValuePair>();

        public Request(KnoxSession session) {
            super(session);
        }

        public Request group(String group) {
            this.group = group;
            return this;
        }

        public Request file(String file) {
            this.file = file;
            return this;
        }

        public Request statusDir(String dir) {
            this.statusDir = dir;
            return this;
        }

        public Request arg(String value) {
            this.addParam(this.params, "arg", value);
            return this;
        }

        @Override
        protected Callable<Response> callable() {
            return new Callable<Response>(){

                @Override
                public Response call() throws Exception {
                    URIBuilder uri = this.uri(new String[]{"/templeton/v1", "/hive"});
                    this.addParam(params, "group", group);
                    this.addParam(params, "file", file);
                    this.addParam(params, "statusdir", statusDir);
                    UrlEncodedFormEntity form = new UrlEncodedFormEntity(params);
                    HttpPost request = new HttpPost(uri.build());
                    request.setEntity((HttpEntity)form);
                    return new Response((HttpResponse)this.execute((HttpRequest)request));
                }
            };
        }
    }
}

