/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.token.impl;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.token.TokenMetadata;
import org.apache.knox.gateway.services.security.token.UnknownTokenException;
import org.apache.knox.gateway.services.token.TokenStateServiceStatistics;
import org.apache.knox.gateway.services.token.impl.AbstractPersistentTokenStateService;
import org.apache.knox.gateway.services.token.impl.TokenStatePeristerMonitorListener;
import org.apache.knox.gateway.services.token.impl.TokenStatePersisterMonitor;
import org.apache.knox.gateway.services.token.impl.state.TokenStateJournalFactory;
import org.apache.knox.gateway.services.token.state.JournalEntry;
import org.apache.knox.gateway.services.token.state.TokenStateJournal;
import org.apache.knox.gateway.util.ExecutorServiceUtils;
import org.apache.knox.gateway.util.Tokens;

public class AliasBasedTokenStateService
extends AbstractPersistentTokenStateService
implements TokenStatePeristerMonitorListener {
    static final String TOKEN_ALIAS_SUFFIX_DELIM = "--";
    static final String TOKEN_ISSUE_TIME_POSTFIX = "--iss";
    static final String TOKEN_MAX_LIFETIME_POSTFIX = "--max";
    static final String TOKEN_META_POSTFIX = "--meta";
    protected AliasService aliasService;
    protected long statePersistenceInterval = TimeUnit.SECONDS.toSeconds(15L);
    private ScheduledExecutorService statePersistenceScheduler;
    private final Set<TokenState> unpersistedState = new HashSet<TokenState>();
    private final AtomicBoolean readyForEviction = new AtomicBoolean(false);
    private TokenStateJournal journal;
    private Path gatewayCredentialsFilePath;

    public void setAliasService(AliasService aliasService) {
        this.aliasService = aliasService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        super.init(config, options);
        if (this.aliasService == null) {
            throw new ServiceLifecycleException("The required AliasService reference has not been set.");
        }
        try {
            this.journal = TokenStateJournalFactory.create(config);
            List<JournalEntry> entries = this.journal.get();
            for (JournalEntry entry : entries) {
                String id = entry.getTokenId();
                try {
                    long issueTime = Long.parseLong(entry.getIssueTime());
                    long expiration = Long.parseLong(entry.getExpiration());
                    long maxLifetime = Long.parseLong(entry.getMaxLifetime());
                    super.addToken(id, issueTime, expiration, maxLifetime);
                    Set<TokenState> set = this.unpersistedState;
                    synchronized (set) {
                        this.unpersistedState.add(new TokenExpiration(id, expiration));
                    }
                }
                catch (Exception e) {
                    log.failedToLoadJournalEntry(Tokens.getTokenIDDisplayText((String)id), e);
                }
            }
        }
        catch (IOException e) {
            throw new ServiceLifecycleException("Failed to load persisted state from the token state journal", (Exception)e);
        }
        this.statePersistenceInterval = config.getKnoxTokenStateAliasPersistenceInterval();
        if (this.tokenStateServiceStatistics != null) {
            this.gatewayCredentialsFilePath = Paths.get(config.getGatewayKeystoreDir(), new String[0]).resolve("__gateway-credentials." + config.getCredentialStoreType().toLowerCase(Locale.ROOT));
            this.tokenStateServiceStatistics.setGatewayCredentialsFileSize(this.gatewayCredentialsFilePath.toFile().length());
        }
    }

    @Override
    public void start() throws ServiceLifecycleException {
        super.start();
        if (this.statePersistenceInterval > 0L) {
            this.scheduleTokenStatePersistence();
        }
        ExecutorService gatewayCredentialsLoader = Executors.newSingleThreadExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("PersistenceStoreLoader").build());
        gatewayCredentialsLoader.execute(this::loadTokenAliasesFromPersistenceStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadTokenAliasesFromPersistenceStore() {
        try {
            log.loadingTokenAliasesFromPersistenceStore();
            long start = System.currentTimeMillis();
            Map passwordAliasMap = this.aliasService.getPasswordsForGateway();
            int count = 0;
            for (Map.Entry passwordAliasMapEntry : passwordAliasMap.entrySet()) {
                String tokenId;
                String alias = (String)passwordAliasMapEntry.getKey();
                if (alias.endsWith(TOKEN_MAX_LIFETIME_POSTFIX)) {
                    tokenId = alias.substring(0, alias.indexOf(TOKEN_MAX_LIFETIME_POSTFIX));
                    long expiration = this.convertCharArrayToLong((char[])passwordAliasMap.get(tokenId));
                    long maxLifeTime = this.convertCharArrayToLong((char[])passwordAliasMapEntry.getValue());
                    super.updateExpiration(tokenId, expiration);
                    super.setMaxLifetime(tokenId, maxLifeTime);
                    count += 2;
                } else if (alias.endsWith(TOKEN_META_POSTFIX)) {
                    tokenId = alias.substring(0, alias.indexOf(TOKEN_META_POSTFIX));
                    super.addMetadata(tokenId, TokenMetadata.fromJSON((String)new String((char[])passwordAliasMapEntry.getValue())));
                } else if (alias.endsWith(TOKEN_ISSUE_TIME_POSTFIX)) {
                    tokenId = alias.substring(0, alias.indexOf(TOKEN_ISSUE_TIME_POSTFIX));
                    this.setIssueTimeInMemory(tokenId, this.convertCharArrayToLong((char[])passwordAliasMapEntry.getValue()));
                }
                if (count % 100 != 0) continue;
                log.loadedTokenAliasesFromPersistenceStore(count, System.currentTimeMillis() - start);
            }
            log.loadedTokenAliasesFromPersistenceStore(count * 2, System.currentTimeMillis() - start);
        }
        catch (AliasServiceException e) {
            log.errorWhileLoadingTokenAliasesFromPersistenceStore(e.getMessage(), e);
        }
        finally {
            this.readyForEviction.set(true);
        }
    }

    @Override
    protected boolean readyForEviction() {
        return this.readyForEviction.get();
    }

    @Override
    public void stop() throws ServiceLifecycleException {
        super.stop();
        if (this.statePersistenceScheduler != null) {
            this.statePersistenceScheduler.shutdown();
        }
        this.persistTokenState();
    }

    private void scheduleTokenStatePersistence() {
        if (this.statePersistenceScheduler != null) {
            ExecutorServiceUtils.shutdownAndAwaitTermination((ExecutorService)this.statePersistenceScheduler, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
        this.statePersistenceScheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("TokenStatePerister-%d").build());
        ScheduledFuture<?> persistTokenStateTask = this.statePersistenceScheduler.scheduleAtFixedRate(this::persistTokenState, this.statePersistenceInterval, this.statePersistenceInterval, TimeUnit.SECONDS);
        log.runningTokenStateAliasePersisterTask(this.statePersistenceInterval, TimeUnit.SECONDS.toString());
        TokenStatePersisterMonitor taskMonitor = new TokenStatePersisterMonitor(persistTokenStateTask, this);
        taskMonitor.startMonitor();
    }

    @Override
    public void onTokenStatePeristerTaskError(Throwable error) {
        this.scheduleTokenStatePersistence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistTokenState() {
        ArrayList<TokenState> processing;
        HashSet<String> tokenIds = new HashSet<String>();
        Set<TokenState> set = this.unpersistedState;
        synchronized (set) {
            processing = new ArrayList<TokenState>(this.unpersistedState);
            this.unpersistedState.clear();
        }
        HashMap<String, String> aliases = new HashMap<String, String>();
        for (TokenState state : processing) {
            tokenIds.add(state.getTokenId());
            aliases.put(state.getAlias(), state.getAliasValue());
        }
        for (String tokenId : tokenIds) {
            log.creatingTokenStateAliases(Tokens.getTokenIDDisplayText((String)tokenId));
        }
        if (!aliases.isEmpty()) {
            log.creatingTokenStateAliases();
            try {
                this.aliasService.addAliasesForCluster("__gateway", aliases);
                if (this.tokenStateServiceStatistics != null) {
                    this.tokenStateServiceStatistics.interactKeystore(TokenStateServiceStatistics.KeystoreInteraction.SAVE_ALIAS);
                    this.tokenStateServiceStatistics.setGatewayCredentialsFileSize(this.gatewayCredentialsFilePath.toFile().length());
                }
                for (String tokenId : tokenIds) {
                    log.createdTokenStateAliases(Tokens.getTokenIDDisplayText((String)tokenId));
                    try {
                        this.journal.remove(tokenId);
                    }
                    catch (IOException e) {
                        log.failedToRemoveJournalEntry(Tokens.getTokenIDDisplayText((String)tokenId), e);
                    }
                }
            }
            catch (AliasServiceException e) {
                log.failedToCreateTokenStateAliases((Exception)((Object)e));
                Set<TokenState> set2 = this.unpersistedState;
                synchronized (set2) {
                    this.unpersistedState.addAll(processing);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToken(String tokenId, long issueTime, long expiration, long maxLifetimeDuration) {
        super.addToken(tokenId, issueTime, expiration, maxLifetimeDuration);
        Set<TokenState> set = this.unpersistedState;
        synchronized (set) {
            this.unpersistedState.add(new TokenExpiration(tokenId, expiration));
        }
        try {
            this.journal.add(tokenId, issueTime, expiration, maxLifetimeDuration, null);
        }
        catch (IOException e) {
            log.failedToAddJournalEntry(Tokens.getTokenIDDisplayText((String)tokenId), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setIssueTime(String tokenId, long issueTime) {
        Set<TokenState> set = this.unpersistedState;
        synchronized (set) {
            this.unpersistedState.add(new TokenIssueTime(tokenId, issueTime));
        }
        this.setIssueTimeInMemory(tokenId, issueTime);
    }

    protected void setIssueTimeInMemory(String tokenId, long issueTime) {
        super.setIssueTime(tokenId, issueTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setMaxLifetime(String tokenId, long issueTime, long maxLifetimeDuration) {
        super.setMaxLifetime(tokenId, issueTime, maxLifetimeDuration);
        Set<TokenState> set = this.unpersistedState;
        synchronized (set) {
            this.unpersistedState.add(new TokenMaxLifetime(tokenId, issueTime, maxLifetimeDuration));
        }
    }

    @Override
    protected long getMaxLifetime(String tokenId) {
        long result = super.getMaxLifetime(tokenId);
        if (result < 1L) {
            try {
                char[] maxLifetimeStr = this.getPasswordUsingAliasService(tokenId + TOKEN_MAX_LIFETIME_POSTFIX);
                if (maxLifetimeStr != null) {
                    result = this.convertCharArrayToLong(maxLifetimeStr);
                }
            }
            catch (AliasServiceException e) {
                log.errorAccessingTokenState(Tokens.getTokenIDDisplayText((String)tokenId), (Exception)((Object)e));
            }
        }
        return result;
    }

    protected char[] getPasswordUsingAliasService(String alias) throws AliasServiceException {
        char[] password = this.aliasService.getPasswordFromAliasForCluster("__gateway", alias);
        if (this.tokenStateServiceStatistics != null) {
            this.tokenStateServiceStatistics.interactKeystore(TokenStateServiceStatistics.KeystoreInteraction.GET_PASSWORD);
        }
        return password;
    }

    protected long convertCharArrayToLong(char[] charArray) {
        return Long.parseLong(new String(charArray));
    }

    @Override
    public long getTokenIssueTime(String tokenId) throws UnknownTokenException {
        try {
            return super.getTokenIssueTime(tokenId);
        }
        catch (UnknownTokenException unknownTokenException) {
            long issueTime = 0L;
            try {
                char[] issueTimeStr = this.getPasswordUsingAliasService(tokenId + TOKEN_ISSUE_TIME_POSTFIX);
                if (issueTimeStr == null) {
                    throw new UnknownTokenException(tokenId);
                }
                issueTime = this.convertCharArrayToLong(issueTimeStr);
                this.setIssueTimeInMemory(tokenId, issueTime);
            }
            catch (UnknownTokenException e) {
                throw e;
            }
            catch (Exception e) {
                log.errorAccessingTokenState(Tokens.getTokenIDDisplayText((String)tokenId), e);
            }
            return issueTime;
        }
    }

    @Override
    public long getTokenExpiration(String tokenId, boolean validate) throws UnknownTokenException {
        try {
            return super.getTokenExpiration(tokenId, validate);
        }
        catch (UnknownTokenException unknownTokenException) {
            if (validate) {
                this.validateToken(tokenId);
            }
            long expiration = 0L;
            try {
                char[] expStr = this.getPasswordUsingAliasService(tokenId);
                if (expStr == null) {
                    throw new UnknownTokenException(tokenId);
                }
                expiration = Long.parseLong(new String(expStr));
                super.updateExpiration(tokenId, expiration);
            }
            catch (UnknownTokenException e) {
                throw e;
            }
            catch (Exception e) {
                log.errorAccessingTokenState(Tokens.getTokenIDDisplayText((String)tokenId), e);
            }
            return expiration;
        }
    }

    @Override
    protected boolean isUnknown(String tokenId) {
        boolean isUnknown = super.isUnknown(tokenId);
        if (isUnknown) {
            try {
                isUnknown = this.getPasswordUsingAliasService(tokenId) == null;
            }
            catch (AliasServiceException e) {
                log.errorAccessingTokenState(Tokens.getTokenIDDisplayText((String)tokenId), (Exception)((Object)e));
            }
        }
        return isUnknown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeTokens(Set<String> tokenIds) {
        Set<TokenState> set = this.unpersistedState;
        synchronized (set) {
            ArrayList<TokenState> unpersistedToRemove = new ArrayList<TokenState>();
            for (TokenState state : this.unpersistedState) {
                if (!tokenIds.contains(state.getTokenId())) continue;
                unpersistedToRemove.add(state);
            }
            this.unpersistedState.removeAll(unpersistedToRemove);
        }
        HashSet<String> aliasesToRemove = new HashSet<String>(tokenIds);
        for (String tokenId : tokenIds) {
            aliasesToRemove.add(tokenId + TOKEN_MAX_LIFETIME_POSTFIX);
            aliasesToRemove.add(tokenId + TOKEN_META_POSTFIX);
            aliasesToRemove.add(tokenId + TOKEN_ISSUE_TIME_POSTFIX);
        }
        if (!aliasesToRemove.isEmpty()) {
            log.removingTokenStateAliases();
            try {
                this.aliasService.removeAliasesForCluster("__gateway", aliasesToRemove);
                if (this.tokenStateServiceStatistics != null) {
                    this.tokenStateServiceStatistics.interactKeystore(TokenStateServiceStatistics.KeystoreInteraction.REMOVE_ALIAS);
                    this.tokenStateServiceStatistics.setGatewayCredentialsFileSize(this.gatewayCredentialsFilePath.toFile().length());
                }
                log.removedTokenStateAliases(String.join((CharSequence)", ", Tokens.getDisplayableTokenIDsText(tokenIds)));
            }
            catch (AliasServiceException e) {
                log.failedToRemoveTokenStateAliases((Exception)((Object)e));
            }
        }
        this.removeTokensFromMemory(tokenIds);
    }

    protected void removeTokensFromMemory(Set<String> tokenIds) {
        super.removeTokens(tokenIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateExpiration(String tokenId, long expiration) {
        this.updateExpirationInMemory(tokenId, expiration);
        Set<TokenState> set = this.unpersistedState;
        synchronized (set) {
            this.unpersistedState.add(new TokenExpiration(tokenId, expiration));
        }
    }

    protected void updateExpirationInMemory(String tokenId, long expiration) {
        super.updateExpiration(tokenId, expiration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetadata(String tokenId, TokenMetadata metadata) {
        this.addMetadataInMemory(tokenId, metadata);
        try {
            JournalEntry entry = this.journal.get(tokenId);
            if (entry != null) {
                this.journal.add(entry.getTokenId(), Long.parseLong(entry.getIssueTime()), Long.parseLong(entry.getExpiration()), Long.parseLong(entry.getMaxLifetime()), metadata);
            }
        }
        catch (IOException e) {
            log.failedToAddJournalEntry(Tokens.getTokenIDDisplayText((String)tokenId), e);
        }
        Set<TokenState> set = this.unpersistedState;
        synchronized (set) {
            this.unpersistedState.add(new TokenMetadataState(tokenId, metadata));
        }
    }

    protected void addMetadataInMemory(String tokenId, TokenMetadata metadata) {
        super.addMetadata(tokenId, metadata);
    }

    @Override
    public TokenMetadata getTokenMetadata(String tokenId) throws UnknownTokenException {
        TokenMetadata tokenMetadata = null;
        try {
            tokenMetadata = super.getTokenMetadata(tokenId);
        }
        catch (UnknownTokenException unknownTokenException) {
            // empty catch block
        }
        if (tokenMetadata == null) {
            try {
                char[] tokenMetadataAliasValue = this.getPasswordUsingAliasService(tokenId + TOKEN_META_POSTFIX);
                if (tokenMetadataAliasValue == null) {
                    throw new UnknownTokenException(tokenId);
                }
                tokenMetadata = TokenMetadata.fromJSON((String)new String(tokenMetadataAliasValue));
            }
            catch (AliasServiceException e) {
                log.errorAccessingTokenState(Tokens.getTokenIDDisplayText((String)tokenId), (Exception)((Object)e));
            }
        }
        return tokenMetadata;
    }

    private static final class TokenMetadataState
    implements TokenState {
        private final String tokenId;
        private final TokenMetadata metadata;

        TokenMetadataState(String tokenId, TokenMetadata metadata) {
            this.tokenId = tokenId;
            this.metadata = metadata;
        }

        @Override
        public String getTokenId() {
            return this.tokenId;
        }

        @Override
        public String getAlias() {
            return this.tokenId + AliasBasedTokenStateService.TOKEN_META_POSTFIX;
        }

        @Override
        public String getAliasValue() {
            return this.metadata.toJSON();
        }

        @Override
        public TokenStateType getType() {
            return TokenStateType.META;
        }
    }

    private static final class TokenIssueTime
    implements TokenState {
        private String tokenId;
        private long issueTime;

        TokenIssueTime(String tokenId, long issueTime) {
            this.tokenId = tokenId;
            this.issueTime = issueTime;
        }

        @Override
        public String getTokenId() {
            return this.tokenId;
        }

        @Override
        public String getAlias() {
            return this.tokenId + AliasBasedTokenStateService.TOKEN_ISSUE_TIME_POSTFIX;
        }

        @Override
        public String getAliasValue() {
            return String.valueOf(this.issueTime);
        }

        @Override
        public TokenStateType getType() {
            return TokenStateType.ISS;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.tokenId).append(this.getType().id).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            TokenIssueTime rhs = (TokenIssueTime)obj;
            return new EqualsBuilder().append((Object)this.tokenId, (Object)rhs.tokenId).append(this.getType().id, rhs.getType().id).isEquals();
        }
    }

    private static final class TokenExpiration
    implements TokenState {
        private String tokenId;
        private long expiration;

        TokenExpiration(String tokenId, long expiration) {
            this.tokenId = tokenId;
            this.expiration = expiration;
        }

        @Override
        public String getTokenId() {
            return this.tokenId;
        }

        @Override
        public String getAlias() {
            return this.tokenId;
        }

        @Override
        public String getAliasValue() {
            return String.valueOf(this.expiration);
        }

        @Override
        public TokenStateType getType() {
            return TokenStateType.EXP;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.tokenId).append(this.getType().id).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            TokenExpiration rhs = (TokenExpiration)obj;
            return new EqualsBuilder().append((Object)this.tokenId, (Object)rhs.tokenId).append(this.getType().id, rhs.getType().id).isEquals();
        }
    }

    private static final class TokenMaxLifetime
    implements TokenState {
        private String tokenId;
        private long issueTime;
        private long maxLifetime;

        TokenMaxLifetime(String tokenId, long issueTime, long maxLifetime) {
            this.tokenId = tokenId;
            this.issueTime = issueTime;
            this.maxLifetime = maxLifetime;
        }

        @Override
        public String getTokenId() {
            return this.tokenId;
        }

        @Override
        public String getAlias() {
            return this.tokenId + AliasBasedTokenStateService.TOKEN_MAX_LIFETIME_POSTFIX;
        }

        @Override
        public String getAliasValue() {
            return String.valueOf(this.issueTime + this.maxLifetime);
        }

        @Override
        public TokenStateType getType() {
            return TokenStateType.MAX;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.tokenId).append(this.getType().id).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            TokenMaxLifetime rhs = (TokenMaxLifetime)obj;
            return new EqualsBuilder().append((Object)this.tokenId, (Object)rhs.tokenId).append(this.getType().id, rhs.getType().id).isEquals();
        }
    }

    static interface TokenState {
        public String getTokenId();

        public String getAlias();

        public String getAliasValue();

        public TokenStateType getType();
    }

    static enum TokenStateType {
        EXP(1),
        MAX(2),
        META(3),
        ISS(4);

        private final int id;

        private TokenStateType(int id) {
            this.id = id;
        }
    }
}

