/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.provider.impl;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.knox.gateway.ha.provider.HaServiceConfig;
import org.apache.knox.gateway.ha.provider.impl.DefaultURLManager;
import org.apache.knox.gateway.ha.provider.impl.i18n.HaMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;

public class AtlasZookeeperURLManager
extends DefaultURLManager {
    private static final String DEFAULT_ZOOKEEPER_NAMESPACE = "/apache_atlas";
    private static final String APACHE_ATLAS_ACTIVE_SERVER_INFO = "/active_server_info";
    private static final HaMessages LOG = (HaMessages)MessagesFactory.get(HaMessages.class);
    private String zooKeeperEnsemble;
    private String zooKeeperNamespace;

    @Override
    public boolean supportsConfig(HaServiceConfig config) {
        if (!config.getServiceName().equalsIgnoreCase("ATLAS") && !config.getServiceName().equalsIgnoreCase("ATLAS-API")) {
            return false;
        }
        String zookeeperEnsemble = config.getZookeeperEnsemble();
        return zookeeperEnsemble != null && !zookeeperEnsemble.trim().isEmpty();
    }

    @Override
    public void setConfig(HaServiceConfig config) {
        this.zooKeeperEnsemble = config.getZookeeperEnsemble();
        this.zooKeeperNamespace = config.getZookeeperNamespace();
        if (this.zooKeeperNamespace != null && !this.zooKeeperNamespace.isEmpty()) {
            if (!this.zooKeeperNamespace.startsWith("/")) {
                this.zooKeeperNamespace = "/" + this.zooKeeperNamespace;
            }
        } else {
            this.zooKeeperNamespace = DEFAULT_ZOOKEEPER_NAMESPACE;
        }
        this.setURLs(this.lookupURLs());
    }

    public List<String> lookupURLs() {
        ArrayList<String> serverHosts = new ArrayList<String>();
        try (CuratorFramework zooKeeperClient = CuratorFrameworkFactory.builder().connectString(this.zooKeeperEnsemble).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 3)).build();){
            zooKeeperClient.start();
            zooKeeperClient.blockUntilConnected(10, TimeUnit.SECONDS);
            byte[] bytes = (byte[])zooKeeperClient.getData().forPath(this.zooKeeperNamespace + APACHE_ATLAS_ACTIVE_SERVER_INFO);
            String activeURL = new String(bytes, StandardCharsets.UTF_8);
            serverHosts.add(activeURL);
        }
        catch (Exception e) {
            LOG.failedToGetZookeeperUrls(e);
            throw new RuntimeException(e);
        }
        return serverHosts;
    }

    @Override
    public synchronized void markFailed(String url) {
        this.setURLs(this.lookupURLs());
        super.markFailed(url);
    }
}

