/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.Storage;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A HBase snapshot operation error.")
public class ApiHBaseSnapshotError {
    @SerializedName(value="tableName")
    private String tableName = null;
    @SerializedName(value="snapshotName")
    private String snapshotName = null;
    @SerializedName(value="storage")
    private Storage storage = null;
    @SerializedName(value="storageLocation")
    private String storageLocation = null;
    @SerializedName(value="error")
    private String error = null;

    public ApiHBaseSnapshotError tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    @ApiModelProperty(value="Name of the table.")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public ApiHBaseSnapshotError snapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
        return this;
    }

    @ApiModelProperty(value="Name of the snapshot.")
    public String getSnapshotName() {
        return this.snapshotName;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public ApiHBaseSnapshotError storage(Storage storage) {
        this.storage = storage;
        return this;
    }

    @ApiModelProperty(value="Whether the snapshot is local or remote.")
    public Storage getStorage() {
        return this.storage;
    }

    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    public ApiHBaseSnapshotError storageLocation(String storageLocation) {
        this.storageLocation = storageLocation;
        return this;
    }

    @ApiModelProperty(value="The remote location where a snapshot is stored. /_*  Optional - location comes from HBase service config if this is not defined")
    public String getStorageLocation() {
        return this.storageLocation;
    }

    public void setStorageLocation(String storageLocation) {
        this.storageLocation = storageLocation;
    }

    public ApiHBaseSnapshotError error(String error) {
        this.error = error;
        return this;
    }

    @ApiModelProperty(value="Description of the error.")
    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHBaseSnapshotError apiHBaseSnapshotError = (ApiHBaseSnapshotError)o;
        return Objects.equals(this.tableName, apiHBaseSnapshotError.tableName) && Objects.equals(this.snapshotName, apiHBaseSnapshotError.snapshotName) && Objects.equals((Object)this.storage, (Object)apiHBaseSnapshotError.storage) && Objects.equals(this.storageLocation, apiHBaseSnapshotError.storageLocation) && Objects.equals(this.error, apiHBaseSnapshotError.error);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tableName, this.snapshotName, this.storage, this.storageLocation, this.error});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHBaseSnapshotError {\n");
        sb.append("    tableName: ").append(this.toIndentedString(this.tableName)).append("\n");
        sb.append("    snapshotName: ").append(this.toIndentedString(this.snapshotName)).append("\n");
        sb.append("    storage: ").append(this.toIndentedString((Object)this.storage)).append("\n");
        sb.append("    storageLocation: ").append(this.toIndentedString(this.storageLocation)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

