/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Schema(description="This is the model for a component in the host.")
public class ApiComponentInfo {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="cdhVersion")
    private String cdhVersion = null;
    @SerializedName(value="cdhRelease")
    private String cdhRelease = null;
    @SerializedName(value="componentVersion")
    private String componentVersion = null;
    @SerializedName(value="componentRelease")
    private String componentRelease = null;
    @SerializedName(value="componentInfoSource")
    private String componentInfoSource = null;
    @SerializedName(value="isActive")
    private Boolean isActive = null;
    @SerializedName(value="componentConfig")
    private Map<String, String> componentConfig = null;

    public ApiComponentInfo name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="The name of the component.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiComponentInfo cdhVersion(String cdhVersion) {
        this.cdhVersion = cdhVersion;
        return this;
    }

    @Schema(description="The CDH version on the host.")
    public String getCdhVersion() {
        return this.cdhVersion;
    }

    public void setCdhVersion(String cdhVersion) {
        this.cdhVersion = cdhVersion;
    }

    public ApiComponentInfo cdhRelease(String cdhRelease) {
        this.cdhRelease = cdhRelease;
        return this;
    }

    @Schema(description="CDH release on the host.")
    public String getCdhRelease() {
        return this.cdhRelease;
    }

    public void setCdhRelease(String cdhRelease) {
        this.cdhRelease = cdhRelease;
    }

    public ApiComponentInfo componentVersion(String componentVersion) {
        this.componentVersion = componentVersion;
        return this;
    }

    @Schema(description="Component version on the host.")
    public String getComponentVersion() {
        return this.componentVersion;
    }

    public void setComponentVersion(String componentVersion) {
        this.componentVersion = componentVersion;
    }

    public ApiComponentInfo componentRelease(String componentRelease) {
        this.componentRelease = componentRelease;
        return this;
    }

    @Schema(description="Component release on the host.")
    public String getComponentRelease() {
        return this.componentRelease;
    }

    public void setComponentRelease(String componentRelease) {
        this.componentRelease = componentRelease;
    }

    public ApiComponentInfo componentInfoSource(String componentInfoSource) {
        this.componentInfoSource = componentInfoSource;
        return this;
    }

    @Schema(description="Source from which component is taken.")
    public String getComponentInfoSource() {
        return this.componentInfoSource;
    }

    public void setComponentInfoSource(String componentInfoSource) {
        this.componentInfoSource = componentInfoSource;
    }

    public ApiComponentInfo isActive(Boolean isActive) {
        this.isActive = isActive;
        return this;
    }

    @Schema(description="returns true if component is active.")
    public Boolean isIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public ApiComponentInfo componentConfig(Map<String, String> componentConfig) {
        this.componentConfig = componentConfig;
        return this;
    }

    public ApiComponentInfo putComponentConfigItem(String key, String componentConfigItem) {
        if (this.componentConfig == null) {
            this.componentConfig = new HashMap<String, String>();
        }
        this.componentConfig.put(key, componentConfigItem);
        return this;
    }

    @Schema(description="list of config name and value pair associated with component.")
    public Map<String, String> getComponentConfig() {
        return this.componentConfig;
    }

    public void setComponentConfig(Map<String, String> componentConfig) {
        this.componentConfig = componentConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiComponentInfo apiComponentInfo = (ApiComponentInfo)o;
        return Objects.equals(this.name, apiComponentInfo.name) && Objects.equals(this.cdhVersion, apiComponentInfo.cdhVersion) && Objects.equals(this.cdhRelease, apiComponentInfo.cdhRelease) && Objects.equals(this.componentVersion, apiComponentInfo.componentVersion) && Objects.equals(this.componentRelease, apiComponentInfo.componentRelease) && Objects.equals(this.componentInfoSource, apiComponentInfo.componentInfoSource) && Objects.equals(this.isActive, apiComponentInfo.isActive) && Objects.equals(this.componentConfig, apiComponentInfo.componentConfig);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.cdhVersion, this.cdhRelease, this.componentVersion, this.componentRelease, this.componentInfoSource, this.isActive, this.componentConfig);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiComponentInfo {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    cdhVersion: ").append(this.toIndentedString(this.cdhVersion)).append("\n");
        sb.append("    cdhRelease: ").append(this.toIndentedString(this.cdhRelease)).append("\n");
        sb.append("    componentVersion: ").append(this.toIndentedString(this.componentVersion)).append("\n");
        sb.append("    componentRelease: ").append(this.toIndentedString(this.componentRelease)).append("\n");
        sb.append("    componentInfoSource: ").append(this.toIndentedString(this.componentInfoSource)).append("\n");
        sb.append("    isActive: ").append(this.toIndentedString(this.isActive)).append("\n");
        sb.append("    componentConfig: ").append(this.toIndentedString(this.componentConfig)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

