/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.weaver;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.weaver.ClassConversionHandler;
import org.apache.logging.log4j.weaver.Constants;
import org.apache.logging.log4j.weaver.LocationCacheGenerator;
import org.apache.logging.log4j.weaver.LocationMethodVisitor;
import org.apache.logging.log4j.weaver.SupplierLambdaType;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class LocationClassVisitor
extends ClassVisitor {
    private final LocationCacheGenerator locationCache;
    private final Map<String, ClassConversionHandler> conversionHandlers;
    private String fileName;
    private String declaringClass;
    private String methodName;

    protected LocationClassVisitor(ClassVisitor cv, LocationCacheGenerator locationCache) {
        super(589824, cv);
        this.locationCache = locationCache;
        this.conversionHandlers = new HashMap<String, ClassConversionHandler>();
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.declaringClass = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitSource(String source, String debug) {
        this.fileName = source;
        super.visitSource(source, debug);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        this.methodName = name;
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        return mv != null ? new LocationMethodVisitor(this, Collections.unmodifiableMap(this.conversionHandlers), mv, access, name, descriptor) : null;
    }

    public void addClassConversionHandler(ClassConversionHandler handler) {
        this.conversionHandlers.put(handler.getOwner(), handler);
    }

    public LocationCacheGenerator.LocationCacheValue addStackTraceElement(int lineNumber) {
        return this.locationCache.addLocation(this.declaringClass, this.methodName, this.fileName, lineNumber);
    }

    public Handle createLambda(SupplierLambdaType type) {
        switch (type) {
            case MESSAGE_SUPPLIER: {
                return new Handle(9, Constants.MESSAGE_SUPPLIER_TYPE.getInternalName(), "get", Type.getMethodDescriptor((Type)Constants.MESSAGE_TYPE, (Type[])new Type[0]), true);
            }
        }
        return this.locationCache.createLambda(this.declaringClass, type);
    }
}

