/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.volcano;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptListener;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.AbstractConverter;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.Converter;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Spool;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.trace.CalciteTrace;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;

class RelSet {
    private static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    final List<RelNode> rels = new ArrayList<RelNode>();
    final List<RelNode> parents = new ArrayList<RelNode>();
    final List<RelSubset> subsets = new ArrayList<RelSubset>();
    @MonotonicNonNull RelSet equivalentSet;
    @MonotonicNonNull RelNode rel;
    @Nullable ExploringState exploringState;
    final Set<Pair<RelTraitSet, RelTraitSet>> conversions = new HashSet<Pair<RelTraitSet, RelTraitSet>>();
    final Set<CorrelationId> variablesPropagated;
    final Set<CorrelationId> variablesUsed;
    final int id;
    boolean inMetadataQuery;

    RelSet(int id, Set<CorrelationId> variablesPropagated, Set<CorrelationId> variablesUsed) {
        this.id = id;
        this.variablesPropagated = variablesPropagated;
        this.variablesUsed = variablesUsed;
    }

    public List<RelNode> getParentRels() {
        return this.parents;
    }

    public Set<RelSet> getChildSets(VolcanoPlanner planner) {
        HashSet<RelSet> childSets = new HashSet<RelSet>();
        for (RelNode node : this.rels) {
            if (node instanceof Converter) continue;
            for (RelNode child : node.getInputs()) {
                RelSet childSet = VolcanoPlanner.equivRoot(((RelSubset)child).getSet());
                if (childSet.id == this.id) continue;
                childSets.add(childSet);
            }
        }
        return childSets;
    }

    public List<RelNode> getRelsFromAllSubsets() {
        return this.rels;
    }

    public @Nullable RelSubset getSubset(RelTraitSet traits) {
        for (RelSubset subset : this.subsets) {
            if (!subset.getTraitSet().equals(traits)) continue;
            return subset;
        }
        return null;
    }

    void obliterateRelNode(RelNode rel) {
        this.parents.remove(rel);
    }

    public RelSubset add(RelNode rel) {
        assert (this.equivalentSet == null) : "adding to a dead set";
        RelTraitSet traitSet = rel.getTraitSet().simplify();
        RelSubset subset = this.getOrCreateSubset(rel.getCluster(), traitSet, rel.isEnforcer());
        subset.add(rel);
        return subset;
    }

    void addConverters(RelSubset subset, boolean required, boolean useAbstractConverter) {
        RelOptCluster cluster = subset.getCluster();
        List others = this.subsets.stream().filter(n -> required ? n.isDelivered() : n.isRequired()).collect(Collectors.toList());
        for (RelSubset other : others) {
            RelNode enforcer;
            assert (other.getTraitSet().size() == subset.getTraitSet().size());
            RelSubset from = subset;
            RelSubset to = other;
            if (required) {
                from = other;
                to = subset;
            }
            if (from == to || to.isEnforceDisabled() || useAbstractConverter && from.getConvention() != null && !from.getConvention().useAbstractConvertersForConversion(from.getTraitSet(), to.getTraitSet()) || !this.conversions.add(Pair.of(from.getTraitSet(), to.getTraitSet()))) continue;
            ImmutableList<RelTrait> difference = to.getTraitSet().difference(from.getTraitSet());
            boolean needsConverter = false;
            for (RelTrait fromTrait : difference) {
                RelTraitDef traitDef = fromTrait.getTraitDef();
                Object toTrait = to.getTraitSet().getTrait(traitDef);
                if (toTrait == null || !traitDef.canConvert(cluster.getPlanner(), fromTrait, toTrait)) {
                    needsConverter = false;
                    break;
                }
                if (fromTrait.satisfies((RelTrait)toTrait)) continue;
                needsConverter = true;
            }
            if (!needsConverter) continue;
            if (useAbstractConverter) {
                enforcer = new AbstractConverter(cluster, from, null, to.getTraitSet());
            } else {
                Convention convention = Objects.requireNonNull(subset.getConvention(), () -> "convention is null for " + subset);
                enforcer = convention.enforce(from, to.getTraitSet());
            }
            if (enforcer == null) continue;
            cluster.getPlanner().register(enforcer, to);
        }
    }

    RelSubset getOrCreateSubset(RelOptCluster cluster, RelTraitSet traits, boolean required) {
        boolean needsConverter = false;
        VolcanoPlanner planner = (VolcanoPlanner)cluster.getPlanner();
        RelSubset subset = this.getSubset(traits);
        if (subset == null) {
            needsConverter = true;
            subset = new RelSubset(cluster, this, traits);
            this.subsets.add(subset);
            if (planner.getListener() != null) {
                this.postEquivalenceEvent(planner, subset);
            }
        } else if (required && !subset.isRequired() || !required && !subset.isDelivered()) {
            needsConverter = true;
        }
        if (subset.getConvention() == Convention.NONE) {
            needsConverter = false;
        } else if (required) {
            subset.setRequired();
        } else {
            subset.setDelivered();
        }
        if (needsConverter) {
            this.addConverters(subset, required, !planner.topDownOpt);
        }
        return subset;
    }

    private void postEquivalenceEvent(VolcanoPlanner planner, RelNode rel) {
        RelOptListener listener = planner.getListener();
        if (listener == null) {
            return;
        }
        RelOptListener.RelEquivalenceEvent event = new RelOptListener.RelEquivalenceEvent(planner, rel, "equivalence class " + this.id, false);
        listener.relEquivalenceFound(event);
    }

    void addInternal(RelNode rel) {
        if (!this.rels.contains(rel)) {
            this.rels.add(rel);
            for (RelTrait trait : rel.getTraitSet()) {
                assert (trait == trait.getTraitDef().canonize(trait));
            }
            VolcanoPlanner planner = (VolcanoPlanner)rel.getCluster().getPlanner();
            if (planner.getListener() != null) {
                this.postEquivalenceEvent(planner, rel);
            }
        }
        if (this.rel == null) {
            this.rel = rel;
        } else {
            RelOptUtil.verifyTypeEquivalence(this.rel, rel, this);
        }
    }

    void mergeWith(VolcanoPlanner planner, RelSet otherSet) {
        assert (this != otherSet);
        assert (this.equivalentSet == null);
        assert (otherSet.equivalentSet == null);
        LOGGER.trace("Merge set#{} into set#{}", (Object)otherSet.id, (Object)this.id);
        otherSet.equivalentSet = this;
        RelOptCluster cluster = ((RelNode)Nullness.castNonNull((Object)this.rel)).getCluster();
        boolean existed = planner.allSets.remove(otherSet);
        assert (existed) : "merging with a dead otherSet";
        HashSet<RelNode> changedRels = new HashSet<RelNode>();
        for (RelSubset relSubset : otherSet.subsets) {
            RelSubset subset = null;
            RelTraitSet otherTraits = relSubset.getTraitSet();
            if (relSubset.isDelivered() || !relSubset.isRequired()) {
                subset = this.getOrCreateSubset(cluster, otherTraits, false);
            }
            if (relSubset.isRequired()) {
                subset = this.getOrCreateSubset(cluster, otherTraits, true);
            }
            assert (subset != null);
            if (subset.passThroughCache == null) {
                subset.passThroughCache = relSubset.passThroughCache;
            } else if (relSubset.passThroughCache != null) {
                subset.passThroughCache.addAll(relSubset.passThroughCache);
            }
            if (!relSubset.bestCost.isLt(subset.bestCost) || relSubset.best == null) continue;
            changedRels.add(relSubset.best);
        }
        HashSet<RelNode> parentRels = new HashSet<RelNode>(this.parents);
        for (RelNode otherRel : otherSet.rels) {
            if (!(otherRel instanceof Spool) && !otherRel.isEnforcer() && parentRels.contains(otherRel) && (otherRel.getInputs().size() != 1 || otherRel.getInput(0).getTraitSet().satisfies(otherRel.getTraitSet()))) {
                planner.prune(otherRel);
            }
            planner.reregister(this, otherRel);
        }
        assert (this.equivalentSet == null);
        for (RelNode rel : changedRels) {
            planner.propagateCostImprovements(rel);
        }
        ImmutableList immutableList = ImmutableList.copyOf(otherSet.getParentRels());
        for (RelNode parentRel : immutableList) {
            planner.rename(parentRel);
        }
        if (this.equivalentSet != null) {
            return;
        }
        for (RelNode parentRel : this.getParentRels()) {
            planner.propagateCostImprovements(parentRel);
        }
        assert (this.equivalentSet == null);
        for (RelNode rel : this.rels) {
            assert (planner.getSet(rel) == this);
            planner.fireRules(rel);
        }
        for (RelSubset subset : this.subsets) {
            planner.fireRules(subset);
        }
    }

    static enum ExploringState {
        EXPLORING,
        EXPLORED;

    }
}

