/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.ArrayList;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.LuceneQParser;
import org.apache.solr.search.SyntaxError;

public class MaxScoreQParser
extends LuceneQParser {
    float tie = 0.0f;

    public MaxScoreQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
        if (this.getParam("tie") != null) {
            this.tie = Float.parseFloat(this.getParam("tie"));
        }
    }

    @Override
    public Query parse() throws SyntaxError {
        Query q = super.parse();
        float boost = 1.0f;
        if (q instanceof BoostQuery) {
            BoostQuery bq = (BoostQuery)q;
            boost = bq.getBoost();
            q = bq.getQuery();
        }
        if (!(q instanceof BooleanQuery)) {
            if (boost != 1.0f) {
                q = new BoostQuery(q, boost);
            }
            return q;
        }
        BooleanQuery obq = (BooleanQuery)q;
        ArrayList<BooleanQuery> should = new ArrayList<BooleanQuery>();
        ArrayList<BooleanClause> prohibOrReq = new ArrayList<BooleanClause>();
        BooleanQuery.Builder newqb = new BooleanQuery.Builder();
        for (BooleanClause clause : obq) {
            if (clause.isProhibited() || clause.isRequired()) {
                prohibOrReq.add(clause);
                continue;
            }
            BooleanQuery.Builder bq = new BooleanQuery.Builder();
            bq.add(clause);
            should.add(bq.build());
        }
        if (should.size() > 0) {
            DisjunctionMaxQuery dmq = new DisjunctionMaxQuery(should, this.tie);
            newqb.add((Query)dmq, BooleanClause.Occur.SHOULD);
        }
        for (BooleanClause c : prohibOrReq) {
            newqb.add(c);
        }
        BooleanQuery newq = newqb.build();
        if (boost != 1.0f) {
            newq = new BoostQuery((Query)newq, boost);
        }
        return newq;
    }
}

