/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.FieldValueHitQueue;
import org.apache.lucene.search.HitsThresholdChecker;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.MaxScoreAccumulator;
import org.apache.lucene.search.MultiLeafFieldComparator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.FutureObjects;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class TopFieldCollector
extends TopDocsCollector<FieldValueHitQueue.Entry> {
    private static final ScoreDoc[] EMPTY_SCOREDOCS = new ScoreDoc[0];
    final int numHits;
    final HitsThresholdChecker hitsThresholdChecker;
    final FieldComparator<?> firstComparator;
    final boolean canSetMinScore;
    Boolean searchSortPartOfIndexSort = null;
    final MaxScoreAccumulator minScoreAcc;
    float minCompetitiveScore;
    final int numComparators;
    FieldValueHitQueue.Entry bottom = null;
    boolean queueFull;
    int docBase;
    final boolean needsScores;
    final ScoreMode scoreMode;

    static boolean canEarlyTerminate(Sort searchSort, Sort indexSort) {
        return TopFieldCollector.canEarlyTerminateOnDocId(searchSort) || TopFieldCollector.canEarlyTerminateOnPrefix(searchSort, indexSort);
    }

    private static boolean canEarlyTerminateOnDocId(Sort searchSort) {
        SortField[] fields1 = searchSort.getSort();
        return SortField.FIELD_DOC.equals(fields1[0]);
    }

    private static boolean canEarlyTerminateOnPrefix(Sort searchSort, Sort indexSort) {
        if (indexSort != null) {
            SortField[] fields2;
            SortField[] fields1 = searchSort.getSort();
            if (fields1.length > (fields2 = indexSort.getSort()).length) {
                return false;
            }
            return Arrays.asList(fields1).equals(Arrays.asList(fields2).subList(0, fields1.length));
        }
        return false;
    }

    private TopFieldCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> pq, int numHits, HitsThresholdChecker hitsThresholdChecker, boolean needsScores, MaxScoreAccumulator minScoreAcc) {
        super(pq);
        this.needsScores = needsScores;
        this.numHits = numHits;
        this.hitsThresholdChecker = hitsThresholdChecker;
        this.numComparators = pq.getComparators().length;
        this.firstComparator = pq.getComparators()[0];
        int reverseMul = pq.reverseMul[0];
        if (this.firstComparator.getClass().equals(FieldComparator.RelevanceComparator.class) && reverseMul == 1 && hitsThresholdChecker.getHitsThreshold() != Integer.MAX_VALUE) {
            this.scoreMode = ScoreMode.TOP_SCORES;
            this.canSetMinScore = true;
        } else {
            this.canSetMinScore = false;
            this.scoreMode = hitsThresholdChecker.getHitsThreshold() != Integer.MAX_VALUE ? (needsScores ? ScoreMode.TOP_DOCS_WITH_SCORES : ScoreMode.TOP_DOCS) : (needsScores ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES);
        }
        this.minScoreAcc = minScoreAcc;
    }

    @Override
    public ScoreMode scoreMode() {
        return this.scoreMode;
    }

    protected void updateGlobalMinCompetitiveScore(Scorable scorer) throws IOException {
        MaxScoreAccumulator.DocAndScore maxMinScore;
        assert (this.minScoreAcc != null);
        if (this.canSetMinScore && this.hitsThresholdChecker.isThresholdReached() && (maxMinScore = this.minScoreAcc.get()) != null && maxMinScore.score > this.minCompetitiveScore) {
            scorer.setMinCompetitiveScore(maxMinScore.score);
            this.minCompetitiveScore = maxMinScore.score;
            this.totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
        }
    }

    protected void updateMinCompetitiveScore(Scorable scorer) throws IOException {
        if (this.canSetMinScore && this.queueFull && this.hitsThresholdChecker.isThresholdReached()) {
            assert (this.bottom != null);
            float minScore = ((Float)this.firstComparator.value(this.bottom.slot)).floatValue();
            if (minScore > this.minCompetitiveScore) {
                scorer.setMinCompetitiveScore(minScore);
                this.minCompetitiveScore = minScore;
                this.totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
                if (this.minScoreAcc != null) {
                    this.minScoreAcc.accumulate(this.docBase, minScore);
                }
            }
        }
    }

    public static TopFieldCollector create(Sort sort, int numHits, int totalHitsThreshold) {
        return TopFieldCollector.create(sort, numHits, null, totalHitsThreshold);
    }

    public static TopFieldCollector create(Sort sort, int numHits, FieldDoc after, int totalHitsThreshold) {
        if (totalHitsThreshold < 0) {
            throw new IllegalArgumentException("totalHitsThreshold must be >= 0, got " + totalHitsThreshold);
        }
        return TopFieldCollector.create(sort, numHits, after, HitsThresholdChecker.create(Math.max(totalHitsThreshold, numHits)), null);
    }

    static TopFieldCollector create(Sort sort, int numHits, FieldDoc after, HitsThresholdChecker hitsThresholdChecker, MaxScoreAccumulator minScoreAcc) {
        if (sort.fields.length == 0) {
            throw new IllegalArgumentException("Sort must contain at least one field");
        }
        if (numHits <= 0) {
            throw new IllegalArgumentException("numHits must be > 0; please use TotalHitCountCollector if you just need the total hit count");
        }
        if (hitsThresholdChecker == null) {
            throw new IllegalArgumentException("hitsThresholdChecker should not be null");
        }
        FieldValueHitQueue<FieldValueHitQueue.Entry> queue = FieldValueHitQueue.create(sort.fields, numHits);
        if (after == null) {
            if (queue.comparators.length == 1) {
                queue.comparators[0].setSingleSort();
            }
            return new SimpleFieldCollector(sort, queue, numHits, hitsThresholdChecker, minScoreAcc);
        }
        if (after.fields == null) {
            throw new IllegalArgumentException("after.fields wasn't set; you must pass fillFields=true for the previous search");
        }
        if (after.fields.length != sort.getSort().length) {
            throw new IllegalArgumentException("after.fields has " + after.fields.length + " values but sort has " + sort.getSort().length);
        }
        return new PagingFieldCollector(sort, queue, after, numHits, hitsThresholdChecker, minScoreAcc);
    }

    public static CollectorManager<TopFieldCollector, TopFieldDocs> createSharedManager(final Sort sort, final int numHits, final FieldDoc after, final int totalHitsThreshold) {
        return new CollectorManager<TopFieldCollector, TopFieldDocs>(){
            private final HitsThresholdChecker hitsThresholdChecker;
            private final MaxScoreAccumulator minScoreAcc;
            {
                this.hitsThresholdChecker = HitsThresholdChecker.createShared(Math.max(totalHitsThreshold, numHits));
                this.minScoreAcc = new MaxScoreAccumulator();
            }

            @Override
            public TopFieldCollector newCollector() throws IOException {
                return TopFieldCollector.create(sort, numHits, after, this.hitsThresholdChecker, this.minScoreAcc);
            }

            @Override
            public TopFieldDocs reduce(Collection<TopFieldCollector> collectors) throws IOException {
                TopFieldDocs[] topDocs = new TopFieldDocs[collectors.size()];
                int i = 0;
                for (TopFieldCollector collector : collectors) {
                    topDocs[i++] = collector.topDocs();
                }
                return TopDocs.merge(sort, numHits, topDocs);
            }
        };
    }

    public static void populateScores(ScoreDoc[] topDocs, IndexSearcher searcher, Query query) throws IOException {
        topDocs = (ScoreDoc[])topDocs.clone();
        Arrays.sort(topDocs, Comparator.comparingInt(scoreDoc -> scoreDoc.doc));
        Weight weight = searcher.createWeight(searcher.rewrite(query), ScoreMode.COMPLETE, 1.0f);
        List<LeafReaderContext> contexts = searcher.getIndexReader().leaves();
        LeafReaderContext currentContext = null;
        Scorer currentScorer = null;
        for (ScoreDoc scoreDoc2 : topDocs) {
            if (currentContext == null || scoreDoc2.doc >= currentContext.docBase + currentContext.reader().maxDoc()) {
                FutureObjects.checkIndex(scoreDoc2.doc, searcher.getIndexReader().maxDoc());
                int newContextIndex = ReaderUtil.subIndex(scoreDoc2.doc, contexts);
                currentContext = contexts.get(newContextIndex);
                ScorerSupplier scorerSupplier = weight.scorerSupplier(currentContext);
                if (scorerSupplier == null) {
                    throw new IllegalArgumentException("Doc id " + scoreDoc2.doc + " doesn't match the query");
                }
                currentScorer = scorerSupplier.get(1L);
            }
            int leafDoc = scoreDoc2.doc - currentContext.docBase;
            assert (leafDoc >= 0);
            int advanced = currentScorer.iterator().advance(leafDoc);
            if (leafDoc != advanced) {
                throw new IllegalArgumentException("Doc id " + scoreDoc2.doc + " doesn't match the query");
            }
            scoreDoc2.score = currentScorer.score();
        }
    }

    final void add(int slot, int doc) {
        this.bottom = this.pq.add(new FieldValueHitQueue.Entry(slot, this.docBase + doc));
        this.queueFull = this.totalHits == this.numHits;
    }

    final void updateBottom(int doc) {
        this.bottom.doc = this.docBase + doc;
        this.bottom = (FieldValueHitQueue.Entry)this.pq.updateTop();
    }

    @Override
    protected void populateResults(ScoreDoc[] results, int howMany) {
        FieldValueHitQueue queue = (FieldValueHitQueue)this.pq;
        for (int i = howMany - 1; i >= 0; --i) {
            results[i] = queue.fillFields((FieldValueHitQueue.Entry)queue.pop());
        }
    }

    @Override
    protected TopDocs newTopDocs(ScoreDoc[] results, int start) {
        if (results == null) {
            results = EMPTY_SCOREDOCS;
        }
        return new TopFieldDocs(new TotalHits(this.totalHits, this.totalHitsRelation), results, ((FieldValueHitQueue)this.pq).getFields());
    }

    @Override
    public TopFieldDocs topDocs() {
        return (TopFieldDocs)super.topDocs();
    }

    public boolean isEarlyTerminated() {
        return this.totalHitsRelation == TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
    }

    private static final class PagingFieldCollector
    extends TopFieldCollector {
        final Sort sort;
        int collectedHits;
        final FieldValueHitQueue<FieldValueHitQueue.Entry> queue;
        final FieldDoc after;

        public PagingFieldCollector(Sort sort, FieldValueHitQueue<FieldValueHitQueue.Entry> queue, FieldDoc after, int numHits, HitsThresholdChecker hitsThresholdChecker, MaxScoreAccumulator minScoreAcc) {
            super(queue, numHits, hitsThresholdChecker, sort.needsScores(), minScoreAcc);
            this.sort = sort;
            this.queue = queue;
            this.after = after;
            FieldComparator<?>[] comparators = queue.comparators;
            for (int i = 0; i < comparators.length; ++i) {
                FieldComparator<?> comparator = comparators[i];
                comparator.setTopValue(after.fields[i]);
            }
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            this.minCompetitiveScore = 0.0f;
            this.docBase = context.docBase;
            final int afterDoc = this.after.doc - this.docBase;
            if (this.searchSortPartOfIndexSort == null) {
                Sort indexSort = context.reader().getMetaData().getSort();
                this.searchSortPartOfIndexSort = PagingFieldCollector.canEarlyTerminate(this.sort, indexSort);
                if (this.searchSortPartOfIndexSort.booleanValue()) {
                    this.firstComparator.disableSkipping();
                }
            }
            return new MultiComparatorLeafCollector(this.queue.getComparators(context), this.queue.getReverseMul()){
                boolean collectedAllCompetitiveHits;
                {
                    super(comparators, reverseMul);
                    this.collectedAllCompetitiveHits = false;
                }

                @Override
                public void setScorer(Scorable scorer) throws IOException {
                    super.setScorer(scorer);
                    if (minScoreAcc == null) {
                        this.updateMinCompetitiveScore(scorer);
                    } else {
                        this.updateGlobalMinCompetitiveScore(scorer);
                    }
                }

                @Override
                public void collect(int doc) throws IOException {
                    ++totalHits;
                    hitsThresholdChecker.incrementHitCount();
                    if (minScoreAcc != null && ((long)totalHits & minScoreAcc.modInterval) == 0L) {
                        this.updateGlobalMinCompetitiveScore(this.scorer);
                    }
                    if (!scoreMode.isExhaustive() && totalHitsRelation == TotalHits.Relation.EQUAL_TO && hitsThresholdChecker.isThresholdReached()) {
                        this.comparator.setHitsThresholdReached();
                        totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
                    }
                    if (queueFull && (this.collectedAllCompetitiveHits || this.reverseMul * this.comparator.compareBottom(doc) <= 0)) {
                        if (searchSortPartOfIndexSort.booleanValue()) {
                            if (hitsThresholdChecker.isThresholdReached()) {
                                totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
                                throw new CollectionTerminatedException();
                            }
                            this.collectedAllCompetitiveHits = true;
                        } else if (totalHitsRelation == TotalHits.Relation.EQUAL_TO) {
                            this.updateMinCompetitiveScore(this.scorer);
                        }
                        return;
                    }
                    int topCmp = this.reverseMul * this.comparator.compareTop(doc);
                    if (topCmp > 0 || topCmp == 0 && doc <= afterDoc) {
                        if (totalHitsRelation == TotalHits.Relation.EQUAL_TO) {
                            this.updateMinCompetitiveScore(this.scorer);
                        }
                        return;
                    }
                    if (queueFull) {
                        this.comparator.copy(bottom.slot, doc);
                        this.updateBottom(doc);
                        this.comparator.setBottom(bottom.slot);
                        this.updateMinCompetitiveScore(this.scorer);
                    } else {
                        ++collectedHits;
                        int slot = collectedHits - 1;
                        this.comparator.copy(slot, doc);
                        bottom = pq.add(new FieldValueHitQueue.Entry(slot, docBase + doc));
                        boolean bl = queueFull = collectedHits == numHits;
                        if (queueFull) {
                            this.comparator.setBottom(bottom.slot);
                            this.updateMinCompetitiveScore(this.scorer);
                        }
                    }
                }

                @Override
                public DocIdSetIterator competitiveIterator() throws IOException {
                    return this.comparator.competitiveIterator();
                }
            };
        }
    }

    private static class SimpleFieldCollector
    extends TopFieldCollector {
        final Sort sort;
        final FieldValueHitQueue<FieldValueHitQueue.Entry> queue;

        public SimpleFieldCollector(Sort sort, FieldValueHitQueue<FieldValueHitQueue.Entry> queue, int numHits, HitsThresholdChecker hitsThresholdChecker, MaxScoreAccumulator minScoreAcc) {
            super(queue, numHits, hitsThresholdChecker, sort.needsScores(), minScoreAcc);
            this.sort = sort;
            this.queue = queue;
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            this.minCompetitiveScore = 0.0f;
            this.docBase = context.docBase;
            if (this.searchSortPartOfIndexSort == null) {
                Sort indexSort = context.reader().getMetaData().getSort();
                this.searchSortPartOfIndexSort = SimpleFieldCollector.canEarlyTerminate(this.sort, indexSort);
                if (this.searchSortPartOfIndexSort.booleanValue()) {
                    this.firstComparator.disableSkipping();
                }
            }
            LeafFieldComparator[] comparators = this.queue.getComparators(context);
            int[] reverseMul = this.queue.getReverseMul();
            return new MultiComparatorLeafCollector(comparators, reverseMul){
                boolean collectedAllCompetitiveHits;
                {
                    super(comparators, reverseMul);
                    this.collectedAllCompetitiveHits = false;
                }

                @Override
                public void setScorer(Scorable scorer) throws IOException {
                    super.setScorer(scorer);
                    if (minScoreAcc == null) {
                        this.updateMinCompetitiveScore(scorer);
                    } else {
                        this.updateGlobalMinCompetitiveScore(scorer);
                    }
                }

                @Override
                public void collect(int doc) throws IOException {
                    ++totalHits;
                    hitsThresholdChecker.incrementHitCount();
                    if (minScoreAcc != null && ((long)totalHits & minScoreAcc.modInterval) == 0L) {
                        this.updateGlobalMinCompetitiveScore(this.scorer);
                    }
                    if (!scoreMode.isExhaustive() && totalHitsRelation == TotalHits.Relation.EQUAL_TO && hitsThresholdChecker.isThresholdReached()) {
                        this.comparator.setHitsThresholdReached();
                        totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
                    }
                    if (queueFull) {
                        if (this.collectedAllCompetitiveHits || this.reverseMul * this.comparator.compareBottom(doc) <= 0) {
                            if (searchSortPartOfIndexSort.booleanValue()) {
                                if (hitsThresholdChecker.isThresholdReached()) {
                                    totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
                                    throw new CollectionTerminatedException();
                                }
                                this.collectedAllCompetitiveHits = true;
                            } else if (totalHitsRelation == TotalHits.Relation.EQUAL_TO) {
                                this.updateMinCompetitiveScore(this.scorer);
                            }
                            return;
                        }
                        this.comparator.copy(bottom.slot, doc);
                        this.updateBottom(doc);
                        this.comparator.setBottom(bottom.slot);
                        this.updateMinCompetitiveScore(this.scorer);
                    } else {
                        int slot = totalHits - 1;
                        this.comparator.copy(slot, doc);
                        this.add(slot, doc);
                        if (queueFull) {
                            this.comparator.setBottom(bottom.slot);
                            this.updateMinCompetitiveScore(this.scorer);
                        }
                    }
                }

                @Override
                public DocIdSetIterator competitiveIterator() throws IOException {
                    return this.comparator.competitiveIterator();
                }
            };
        }
    }

    private static abstract class MultiComparatorLeafCollector
    implements LeafCollector {
        final LeafFieldComparator comparator;
        final int reverseMul;
        Scorable scorer;

        MultiComparatorLeafCollector(LeafFieldComparator[] comparators, int[] reverseMul) {
            if (comparators.length == 1) {
                this.reverseMul = reverseMul[0];
                this.comparator = comparators[0];
            } else {
                this.reverseMul = 1;
                this.comparator = new MultiLeafFieldComparator(comparators, reverseMul);
            }
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
            this.comparator.setScorer(scorer);
            this.scorer = scorer;
        }
    }
}

