/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.IntConsumer;
import org.apache.solr.analytics.function.mapping.LambdaFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.analytics.value.IntValueStream;

class IntStreamInIntValueOutFunction
extends IntValue.AbstractIntValue
implements IntConsumer {
    private final IntValueStream param;
    private final LambdaFunction.TwoIntInIntOutLambda lambda;
    private final String name;
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    private boolean exists = false;
    private int value;

    public IntStreamInIntValueOutFunction(String name, LambdaFunction.TwoIntInIntOutLambda lambda, IntValueStream param) {
        this.name = name;
        this.lambda = lambda;
        this.param = param;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
    }

    @Override
    public int getInt() {
        this.exists = false;
        this.param.streamInts(this);
        return this.value;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public void accept(int paramValue) {
        if (!this.exists) {
            this.exists = true;
            this.value = paramValue;
        } else {
            this.value = this.lambda.apply(this.value, paramValue);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

