/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.Consumer;
import org.apache.solr.analytics.function.mapping.LambdaFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;

class StringStreamInStringValueOutFunction
extends StringValue.AbstractStringValue
implements Consumer<String> {
    private final StringValueStream param;
    private final LambdaFunction.TwoStringInStringOutLambda lambda;
    private final String name;
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    private boolean exists = false;
    private String value;

    public StringStreamInStringValueOutFunction(String name, LambdaFunction.TwoStringInStringOutLambda lambda, StringValueStream param) {
        this.name = name;
        this.lambda = lambda;
        this.param = param;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
    }

    @Override
    public String getString() {
        this.exists = false;
        this.param.streamStrings(this);
        return this.value;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public void accept(String paramValue) {
        if (!this.exists) {
            this.exists = true;
            this.value = paramValue;
        } else {
            this.value = this.lambda.apply(this.value, paramValue);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

