﻿using Lucene.Net.Analysis.TokenAttributes;
using System;
using System.IO;

namespace Lucene.Net.Analysis.Standard.Std40
{
    /*
     * Licensed to the Apache Software Foundation (ASF) under one or more
     * contributor license agreements.  See the NOTICE file distributed with
     * this work for additional information regarding copyright ownership.
     * The ASF licenses this file to You under the Apache License, Version 2.0
     * (the "License"); you may not use this file except in compliance with
     * the License.  You may obtain a copy of the License at
     *
     *     http://www.apache.org/licenses/LICENSE-2.0
     *
     * Unless required by applicable law or agreed to in writing, software
     * distributed under the License is distributed on an "AS IS" BASIS,
     * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
     * See the License for the specific language governing permissions and
     * limitations under the License.
     */

    /// <summary>
    /// This class implements StandardTokenizer using Unicode 6.1.0.
    /// 
    /// @deprecated This class is only for exact backwards compatibility
    /// </summary>
    [Obsolete("This class is only for exact backwards compatibility")]
    public sealed class StandardTokenizerImpl40 : IStandardTokenizerInterface
    {
        /// <summary>This character denotes the end of file</summary>
        public static readonly int YYEOF = -1;

        /// <summary>initial size of the lookahead buffer</summary>
        private static readonly int ZZ_BUFFERSIZE = 4096;

        /// <summary>lexical states</summary>
        public const int YYINITIAL = 0;

        /// <summary>
        /// ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
        /// ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
        ///     at the beginning of a line
        /// l is of the form l = 2*k, k a non negative integer
        /// </summary>
        private static readonly int[] ZZ_LEXSTATE = { 0, 0 };

        /// <summary>
        /// Translates characters to character classes
        /// </summary>
        private const string ZZ_CMAP_PACKED =
            "\x0027\x0000\x0001\x0082\x0004\x0000\x0001\x0081\x0001\x0000\x0001\x0082\x0001\x0000\x000A\x007E\x0001\x0080\x0001\x0081" +
            "\x0005\x0000\x001A\x007C\x0004\x0000\x0001\x0083\x0001\x0000\x001A\x007C\x002F\x0000\x0001\x007C\x0002\x0000\x0001\x007D" +
            "\x0007\x0000\x0001\x007C\x0001\x0000\x0001\x0080\x0002\x0000\x0001\x007C\x0005\x0000\x0017\x007C\x0001\x0000\x001F\x007C" +
            "\x0001\x0000\u01ca\x007C\x0004\x0000\x000C\x007C\x000E\x0000\x0005\x007C\x0007\x0000\x0001\x007C\x0001\x0000\x0001\x007C" +
            "\x0011\x0000\x0070\x007D\x0005\x007C\x0001\x0000\x0002\x007C\x0002\x0000\x0004\x007C\x0001\x0081\x0007\x0000\x0001\x007C" +
            "\x0001\x0080\x0003\x007C\x0001\x0000\x0001\x007C\x0001\x0000\x0014\x007C\x0001\x0000\x0053\x007C\x0001\x0000\x008B\x007C" +
            "\x0001\x0000\x0007\x007D\x009E\x007C\x0009\x0000\x0026\x007C\x0002\x0000\x0001\x007C\x0007\x0000\x0027\x007C\x0001\x0000" +
            "\x0001\x0081\x0007\x0000\x002D\x007D\x0001\x0000\x0001\x007D\x0001\x0000\x0002\x007D\x0001\x0000\x0002\x007D\x0001\x0000" +
            "\x0001\x007D\x0008\x0000\x001B\x007C\x0005\x0000\x0004\x007C\x0001\x0080\x000B\x0000\x0005\x007D\x0007\x0000\x0002\x0081" +
            "\x0002\x0000\x000B\x007D\x0005\x0000\x002B\x007C\x0015\x007D\x000A\x007E\x0001\x0000\x0001\x007E\x0001\x0081\x0001\x0000" +
            "\x0002\x007C\x0001\x007D\x0063\x007C\x0001\x0000\x0001\x007C\x0007\x007D\x0001\x007D\x0001\x0000\x0006\x007D\x0002\x007C" +
            "\x0002\x007D\x0001\x0000\x0004\x007D\x0002\x007C\x000A\x007E\x0003\x007C\x0002\x0000\x0001\x007C\x000F\x0000\x0001\x007D" +
            "\x0001\x007C\x0001\x007D\x001E\x007C\x001B\x007D\x0002\x0000\x0059\x007C\x000B\x007D\x0001\x007C\x000E\x0000\x000A\x007E" +
            "\x0021\x007C\x0009\x007D\x0002\x007C\x0002\x0000\x0001\x0081\x0001\x0000\x0001\x007C\x0005\x0000\x0016\x007C\x0004\x007D" +
            "\x0001\x007C\x0009\x007D\x0001\x007C\x0003\x007D\x0001\x007C\x0005\x007D\x0012\x0000\x0019\x007C\x0003\x007D\x0044\x0000" +
            "\x0001\x007C\x0001\x0000\x000B\x007C\x0037\x0000\x001B\x007D\x0001\x0000\x0004\x007D\x0036\x007C\x0003\x007D\x0001\x007C" +
            "\x0012\x007D\x0001\x007C\x0007\x007D\x000A\x007C\x0002\x007D\x0002\x0000\x000A\x007E\x0001\x0000\x0007\x007C\x0001\x0000" +
            "\x0007\x007C\x0001\x0000\x0003\x007D\x0001\x0000\x0008\x007C\x0002\x0000\x0002\x007C\x0002\x0000\x0016\x007C\x0001\x0000" +
            "\x0007\x007C\x0001\x0000\x0001\x007C\x0003\x0000\x0004\x007C\x0002\x0000\x0001\x007D\x0001\x007C\x0007\x007D\x0002\x0000" +
            "\x0002\x007D\x0002\x0000\x0003\x007D\x0001\x007C\x0008\x0000\x0001\x007D\x0004\x0000\x0002\x007C\x0001\x0000\x0003\x007C" +
            "\x0002\x007D\x0002\x0000\x000A\x007E\x0002\x007C\x000F\x0000\x0003\x007D\x0001\x0000\x0006\x007C\x0004\x0000\x0002\x007C" +
            "\x0002\x0000\x0016\x007C\x0001\x0000\x0007\x007C\x0001\x0000\x0002\x007C\x0001\x0000\x0002\x007C\x0001\x0000\x0002\x007C" +
            "\x0002\x0000\x0001\x007D\x0001\x0000\x0005\x007D\x0004\x0000\x0002\x007D\x0002\x0000\x0003\x007D\x0003\x0000\x0001\x007D" +
            "\x0007\x0000\x0004\x007C\x0001\x0000\x0001\x007C\x0007\x0000\x000A\x007E\x0002\x007D\x0003\x007C\x0001\x007D\x000B\x0000" +
            "\x0003\x007D\x0001\x0000\x0009\x007C\x0001\x0000\x0003\x007C\x0001\x0000\x0016\x007C\x0001\x0000\x0007\x007C\x0001\x0000" +
            "\x0002\x007C\x0001\x0000\x0005\x007C\x0002\x0000\x0001\x007D\x0001\x007C\x0008\x007D\x0001\x0000\x0003\x007D\x0001\x0000" +
            "\x0003\x007D\x0002\x0000\x0001\x007C\x000F\x0000\x0002\x007C\x0002\x007D\x0002\x0000\x000A\x007E\x0011\x0000\x0003\x007D" +
            "\x0001\x0000\x0008\x007C\x0002\x0000\x0002\x007C\x0002\x0000\x0016\x007C\x0001\x0000\x0007\x007C\x0001\x0000\x0002\x007C" +
            "\x0001\x0000\x0005\x007C\x0002\x0000\x0001\x007D\x0001\x007C\x0007\x007D\x0002\x0000\x0002\x007D\x0002\x0000\x0003\x007D" +
            "\x0008\x0000\x0002\x007D\x0004\x0000\x0002\x007C\x0001\x0000\x0003\x007C\x0002\x007D\x0002\x0000\x000A\x007E\x0001\x0000" +
            "\x0001\x007C\x0010\x0000\x0001\x007D\x0001\x007C\x0001\x0000\x0006\x007C\x0003\x0000\x0003\x007C\x0001\x0000\x0004\x007C" +
            "\x0003\x0000\x0002\x007C\x0001\x0000\x0001\x007C\x0001\x0000\x0002\x007C\x0003\x0000\x0002\x007C\x0003\x0000\x0003\x007C" +
            "\x0003\x0000\x000C\x007C\x0004\x0000\x0005\x007D\x0003\x0000\x0003\x007D\x0001\x0000\x0004\x007D\x0002\x0000\x0001\x007C" +
            "\x0006\x0000\x0001\x007D\x000E\x0000\x000A\x007E\x0011\x0000\x0003\x007D\x0001\x0000\x0008\x007C\x0001\x0000\x0003\x007C" +
            "\x0001\x0000\x0017\x007C\x0001\x0000\x000A\x007C\x0001\x0000\x0005\x007C\x0003\x0000\x0001\x007C\x0007\x007D\x0001\x0000" +
            "\x0003\x007D\x0001\x0000\x0004\x007D\x0007\x0000\x0002\x007D\x0001\x0000\x0002\x007C\x0006\x0000\x0002\x007C\x0002\x007D" +
            "\x0002\x0000\x000A\x007E\x0012\x0000\x0002\x007D\x0001\x0000\x0008\x007C\x0001\x0000\x0003\x007C\x0001\x0000\x0017\x007C" +
            "\x0001\x0000\x000A\x007C\x0001\x0000\x0005\x007C\x0002\x0000\x0001\x007D\x0001\x007C\x0007\x007D\x0001\x0000\x0003\x007D" +
            "\x0001\x0000\x0004\x007D\x0007\x0000\x0002\x007D\x0007\x0000\x0001\x007C\x0001\x0000\x0002\x007C\x0002\x007D\x0002\x0000" +
            "\x000A\x007E\x0001\x0000\x0002\x007C\x000F\x0000\x0002\x007D\x0001\x0000\x0008\x007C\x0001\x0000\x0003\x007C\x0001\x0000" +
            "\x0029\x007C\x0002\x0000\x0001\x007C\x0007\x007D\x0001\x0000\x0003\x007D\x0001\x0000\x0004\x007D\x0001\x007C\x0008\x0000" +
            "\x0001\x007D\x0008\x0000\x0002\x007C\x0002\x007D\x0002\x0000\x000A\x007E\x000A\x0000\x0006\x007C\x0002\x0000\x0002\x007D" +
            "\x0001\x0000\x0012\x007C\x0003\x0000\x0018\x007C\x0001\x0000\x0009\x007C\x0001\x0000\x0001\x007C\x0002\x0000\x0007\x007C" +
            "\x0003\x0000\x0001\x007D\x0004\x0000\x0006\x007D\x0001\x0000\x0001\x007D\x0001\x0000\x0008\x007D\x0012\x0000\x0002\x007D" +
            "\x000D\x0000\x0030\x0084\x0001\x0085\x0002\x0084\x0007\x0085\x0005\x0000\x0007\x0084\x0008\x0085\x0001\x0000\x000A\x007E" +
            "\x0027\x0000\x0002\x0084\x0001\x0000\x0001\x0084\x0002\x0000\x0002\x0084\x0001\x0000\x0001\x0084\x0002\x0000\x0001\x0084" +
            "\x0006\x0000\x0004\x0084\x0001\x0000\x0007\x0084\x0001\x0000\x0003\x0084\x0001\x0000\x0001\x0084\x0001\x0000\x0001\x0084" +
            "\x0002\x0000\x0002\x0084\x0001\x0000\x0004\x0084\x0001\x0085\x0002\x0084\x0006\x0085\x0001\x0000\x0002\x0085\x0001\x0084" +
            "\x0002\x0000\x0005\x0084\x0001\x0000\x0001\x0084\x0001\x0000\x0006\x0085\x0002\x0000\x000A\x007E\x0002\x0000\x0004\x0084" +
            "\x0020\x0000\x0001\x007C\x0017\x0000\x0002\x007D\x0006\x0000\x000A\x007E\x000B\x0000\x0001\x007D\x0001\x0000\x0001\x007D" +
            "\x0001\x0000\x0001\x007D\x0004\x0000\x0002\x007D\x0008\x007C\x0001\x0000\x0024\x007C\x0004\x0000\x0014\x007D\x0001\x0000" +
            "\x0002\x007D\x0005\x007C\x000B\x007D\x0001\x0000\x0024\x007D\x0009\x0000\x0001\x007D\x0039\x0000\x002B\x0084\x0014\x0085" +
            "\x0001\x0084\x000A\x007E\x0006\x0000\x0006\x0084\x0004\x0085\x0004\x0084\x0003\x0085\x0001\x0084\x0003\x0085\x0002\x0084" +
            "\x0007\x0085\x0003\x0084\x0004\x0085\x000D\x0084\x000C\x0085\x0001\x0084\x0001\x0085\x000A\x007E\x0004\x0085\x0002\x0084" +
            "\x0026\x007C\x0001\x0000\x0001\x007C\x0005\x0000\x0001\x007C\x0002\x0000\x002B\x007C\x0001\x0000\x0004\x007C\u0100\x0088" +
            "\x0049\x007C\x0001\x0000\x0004\x007C\x0002\x0000\x0007\x007C\x0001\x0000\x0001\x007C\x0001\x0000\x0004\x007C\x0002\x0000" +
            "\x0029\x007C\x0001\x0000\x0004\x007C\x0002\x0000\x0021\x007C\x0001\x0000\x0004\x007C\x0002\x0000\x0007\x007C\x0001\x0000" +
            "\x0001\x007C\x0001\x0000\x0004\x007C\x0002\x0000\x000F\x007C\x0001\x0000\x0039\x007C\x0001\x0000\x0004\x007C\x0002\x0000" +
            "\x0043\x007C\x0002\x0000\x0003\x007D\x0020\x0000\x0010\x007C\x0010\x0000\x0055\x007C\x000C\x0000\u026c\x007C\x0002\x0000" +
            "\x0011\x007C\x0001\x0000\x001A\x007C\x0005\x0000\x004B\x007C\x0003\x0000\x0003\x007C\x000F\x0000\x000D\x007C\x0001\x0000" +
            "\x0004\x007C\x0003\x007D\x000B\x0000\x0012\x007C\x0003\x007D\x000B\x0000\x0012\x007C\x0002\x007D\x000C\x0000\x000D\x007C" +
            "\x0001\x0000\x0003\x007C\x0001\x0000\x0002\x007D\x000C\x0000\x0034\x0084\x0020\x0085\x0003\x0000\x0001\x0084\x0004\x0000" +
            "\x0001\x0084\x0001\x0085\x0002\x0000\x000A\x007E\x0021\x0000\x0003\x007D\x0002\x0000\x000A\x007E\x0006\x0000\x0058\x007C" +
            "\x0008\x0000\x0029\x007C\x0001\x007D\x0001\x007C\x0005\x0000\x0046\x007C\x000A\x0000\x001D\x007C\x0003\x0000\x000C\x007D" +
            "\x0004\x0000\x000C\x007D\x000A\x0000\x000A\x007E\x001E\x0084\x0002\x0000\x0005\x0084\x000B\x0000\x002C\x0084\x0004\x0000" +
            "\x0011\x0085\x0007\x0084\x0002\x0085\x0006\x0000\x000A\x007E\x0001\x0084\x0003\x0000\x0002\x0084\x0020\x0000\x0017\x007C" +
            "\x0005\x007D\x0004\x0000\x0035\x0084\x000A\x0085\x0001\x0000\x001D\x0085\x0002\x0000\x0001\x007D\x000A\x007E\x0006\x0000" +
            "\x000A\x007E\x0006\x0000\x000E\x0084\x0052\x0000\x0005\x007D\x002F\x007C\x0011\x007D\x0007\x007C\x0004\x0000\x000A\x007E" +
            "\x0011\x0000\x0009\x007D\x000C\x0000\x0003\x007D\x001E\x007C\x000D\x007D\x0002\x007C\x000A\x007E\x002C\x007C\x000E\x007D" +
            "\x000C\x0000\x0024\x007C\x0014\x007D\x0008\x0000\x000A\x007E\x0003\x0000\x0003\x007C\x000A\x007E\x0024\x007C\x0052\x0000" +
            "\x0003\x007D\x0001\x0000\x0015\x007D\x0004\x007C\x0001\x007D\x0004\x007C\x0003\x007D\x0002\x007C\x0009\x0000\x00C0\x007C" +
            "\x0027\x007D\x0015\x0000\x0004\x007D\u0116\x007C\x0002\x0000\x0006\x007C\x0002\x0000\x0026\x007C\x0002\x0000\x0006\x007C" +
            "\x0002\x0000\x0008\x007C\x0001\x0000\x0001\x007C\x0001\x0000\x0001\x007C\x0001\x0000\x0001\x007C\x0001\x0000\x001F\x007C" +
            "\x0002\x0000\x0035\x007C\x0001\x0000\x0007\x007C\x0001\x0000\x0001\x007C\x0003\x0000\x0003\x007C\x0001\x0000\x0007\x007C" +
            "\x0003\x0000\x0004\x007C\x0002\x0000\x0006\x007C\x0004\x0000\x000D\x007C\x0005\x0000\x0003\x007C\x0001\x0000\x0007\x007C" +
            "\x000F\x0000\x0002\x007D\x0002\x007D\x0008\x0000\x0002\x0082\x000A\x0000\x0001\x0082\x0002\x0000\x0001\x0080\x0002\x0000" +
            "\x0005\x007D\x0010\x0000\x0002\x0083\x0003\x0000\x0001\x0081\x000F\x0000\x0001\x0083\x000B\x0000\x0005\x007D\x0005\x0000" +
            "\x0006\x007D\x0001\x0000\x0001\x007C\x000D\x0000\x0001\x007C\x0010\x0000\x000D\x007C\x0033\x0000\x0021\x007D\x0011\x0000" +
            "\x0001\x007C\x0004\x0000\x0001\x007C\x0002\x0000\x000A\x007C\x0001\x0000\x0001\x007C\x0003\x0000\x0005\x007C\x0006\x0000" +
            "\x0001\x007C\x0001\x0000\x0001\x007C\x0001\x0000\x0001\x007C\x0001\x0000\x0004\x007C\x0001\x0000\x000B\x007C\x0002\x0000" +
            "\x0004\x007C\x0005\x0000\x0005\x007C\x0004\x0000\x0001\x007C\x0011\x0000\x0029\x007C\u032d\x0000\x0034\x007C\u0716\x0000" +
            "\x002F\x007C\x0001\x0000\x002F\x007C\x0001\x0000\x0085\x007C\x0006\x0000\x0004\x007C\x0003\x007D\x0002\x007C\x000C\x0000" +
            "\x0026\x007C\x0001\x0000\x0001\x007C\x0005\x0000\x0001\x007C\x0002\x0000\x0038\x007C\x0007\x0000\x0001\x007C\x000F\x0000" +
            "\x0001\x007D\x0017\x007C\x0009\x0000\x0007\x007C\x0001\x0000\x0007\x007C\x0001\x0000\x0007\x007C\x0001\x0000\x0007\x007C" +
            "\x0001\x0000\x0007\x007C\x0001\x0000\x0007\x007C\x0001\x0000\x0007\x007C\x0001\x0000\x0007\x007C\x0001\x0000\x0020\x007D" +
            "\x002F\x0000\x0001\x007C\x0050\x0000\x001A\x0086\x0001\x0000\x0059\x0086\x000C\x0000\x00D6\x0086\x002F\x0000\x0001\x007C" +
            "\x0001\x0000\x0001\x0086\x0019\x0000\x0009\x0086\x0004\x007D\x0002\x007D\x0001\x0000\x0005\x007F\x0002\x0000\x0003\x0086" +
            "\x0001\x007C\x0001\x007C\x0004\x0000\x0056\x0087\x0002\x0000\x0002\x007D\x0002\x007F\x0003\x0087\x005B\x007F\x0001\x0000" +
            "\x0004\x007F\x0005\x0000\x0029\x007C\x0003\x0000\x005E\x0088\x0011\x0000\x001B\x007C\x0035\x0000\x0010\x007F\x001F\x0000" +
            "\x0041\x0000\x001F\x0000\x0051\x0000\x002F\x007F\x0001\x0000\x0058\x007F\x00A8\x0000\u19b6\x0086\x004A\x0000\u51cd\x0086" +
            "\x0033\x0000\u048d\x007C\x0043\x0000\x002E\x007C\x0002\x0000\u010d\x007C\x0003\x0000\x0010\x007C\x000A\x007E\x0002\x007C" +
            "\x0014\x0000\x002F\x007C\x0004\x007D\x0001\x0000\x000A\x007D\x0001\x0000\x0019\x007C\x0007\x0000\x0001\x007D\x0050\x007C" +
            "\x0002\x007D\x0025\x0000\x0009\x007C\x0002\x0000\x0067\x007C\x0002\x0000\x0004\x007C\x0001\x0000\x0004\x007C\x000C\x0000" +
            "\x000B\x007C\x004D\x0000\x000A\x007C\x0001\x007D\x0003\x007C\x0001\x007D\x0004\x007C\x0001\x007D\x0017\x007C\x0005\x007D" +
            "\x0018\x0000\x0034\x007C\x000C\x0000\x0002\x007D\x0032\x007C\x0011\x007D\x000B\x0000\x000A\x007E\x0006\x0000\x0012\x007D" +
            "\x0006\x007C\x0003\x0000\x0001\x007C\x0004\x0000\x000A\x007E\x001C\x007C\x0008\x007D\x0002\x0000\x0017\x007C\x000D\x007D" +
            "\x000C\x0000\x001D\x0088\x0003\x0000\x0004\x007D\x002F\x007C\x000E\x007D\x000E\x0000\x0001\x007C\x000A\x007E\x0026\x0000" +
            "\x0029\x007C\x000E\x007D\x0009\x0000\x0003\x007C\x0001\x007D\x0008\x007C\x0002\x007D\x0002\x0000\x000A\x007E\x0006\x0000" +
            "\x001B\x0084\x0001\x0085\x0004\x0000\x0030\x0084\x0001\x0085\x0001\x0084\x0003\x0085\x0002\x0084\x0002\x0085\x0005\x0084" +
            "\x0002\x0085\x0001\x0084\x0001\x0085\x0001\x0084\x0018\x0000\x0005\x0084\x000B\x007C\x0005\x007D\x0002\x0000\x0003\x007C" +
            "\x0002\x007D\x000A\x0000\x0006\x007C\x0002\x0000\x0006\x007C\x0002\x0000\x0006\x007C\x0009\x0000\x0007\x007C\x0001\x0000" +
            "\x0007\x007C\x0091\x0000\x0023\x007C\x0008\x007D\x0001\x0000\x0002\x007D\x0002\x0000\x000A\x007E\x0006\x0000\u2ba4\x0088" +
            "\x000C\x0000\x0017\x0088\x0004\x0000\x0031\x0088\x0004\x0000\x0001\x0024\x0001\x0020\x0001\x0037\x0001\x0034\x0001\x001B" +
            "\x0001\x0018\x0002\x0000\x0001\x0014\x0001\x0011\x0002\x0000\x0001\x000F\x0001\x000D\x000C\x0000\x0001\x0003\x0001\x0006" +
            "\x0010\x0000\x0001\x006E\x0007\x0000\x0001\x0049\x0001\x0008\x0005\x0000\x0001\x0001\x0001\x007A\x0003\x0000\x0001\x0073" +
            "\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073" +
            "\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073" +
            "\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073" +
            "\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0073" +
            "\x0001\x0074\x0001\x0073\x0001\x0073\x0001\x0073\x0001\x0078\x0001\x0076\x000F\x0000\x0001\x0070\u02c1\x0000\x0001\x004C" +
            "\x00BF\x0000\x0001\x006F\x0001\x004D\x0001\x000E\x0003\x0077\x0002\x0032\x0001\x0077\x0001\x0032\x0002\x0077\x0001\x001E" +
            "\x0011\x0077\x0002\x0046\x0007\x004F\x0001\x004E\x0007\x004F\x0007\x0042\x0001\x001F\x0001\x0042\x0001\x0058\x0002\x0036" +
            "\x0001\x0035\x0001\x0058\x0001\x0036\x0001\x0035\x0008\x0058\x0002\x0047\x0005\x0043\x0002\x003D\x0005\x0043\x0001\x0012" +
            "\x0008\x002B\x0005\x0013\x0003\x0021\x000A\x0067\x0010\x0021\x0003\x0033\x001A\x0023\x0001\x0022\x0002\x0031\x0002\x006C" +
            "\x0001\x006D\x0002\x006C\x0002\x006D\x0002\x006C\x0001\x006D\x0003\x0031\x0001\x0030\x0002\x0031\x000A\x0048\x0001\x0056" +
            "\x0001\x0028\x0001\x0025\x0001\x0048\x0006\x0028\x0001\x0025\x000B\x0028\x0019\x0031\x0007\x0028\x000A\x0068\x0001\x0028" +
            "\x0005\x000B\x0003\x0057\x0003\x0041\x0001\x0040\x0004\x0041\x0002\x0040\x0008\x0041\x0001\x0040\x0007\x001D\x0001\x001C" +
            "\x0002\x001D\x0007\x0041\x000E\x0057\x0001\x0061\x0004\x006A\x0001\x0004\x0004\x0069\x0001\x0004\x0005\x0060\x0001\x005F" +
            "\x0001\x0060\x0003\x005F\x0007\x0060\x0001\x005F\x0013\x0060\x0005\x004B\x0003\x0060\x0006\x004B\x0002\x004B\x0006\x004A" +
            "\x0005\x004A\x0003\x005C\x0002\x0041\x0007\x005B\x001E\x0041\x0004\x005B\x0005\x0041\x0005\x0057\x0006\x0055\x0002\x0057" +
            "\x0001\x0055\x0004\x001D\x000B\x005E\x000A\x0069\x0016\x005E\x000D\x000B\x0001\x005D\x0002\x000B\x0001\x007B\x0003\x0062" +
            "\x0001\x000B\x0002\x0062\x0005\x0071\x0004\x0062\x0004\x0072\x0001\x0071\x0003\x0072\x0001\x0071\x0005\x0072\x0002\x0038" +
            "\x0001\x003B\x0002\x0038\x0001\x003B\x0001\x0038\x0002\x003B\x0001\x0038\x0001\x003B\x000A\x0038\x0001\x003B\x0004\x0005" +
            "\x0001\x0064\x0001\x0063\x0001\x0065\x0001\x000A\x0003\x0075\x0001\x0065\x0002\x0075\x0001\x0059\x0002\x005A\x0002\x0075" +
            "\x0001\x000A\x0001\x0075\x0001\x000A\x0001\x0075\x0001\x000A\x0001\x0075\x0003\x000A\x0001\x0075\x0002\x000A\x0001\x0075" +
            "\x0001\x000A\x0002\x0075\x0001\x000A\x0001\x0075\x0001\x000A\x0001\x0075\x0001\x000A\x0001\x0075\x0001\x000A\x0001\x0075" +
            "\x0001\x000A\x0001\x003E\x0002\x003A\x0001\x003E\x0001\x003A\x0002\x003E\x0004\x003A\x0001\x003E\x0007\x003A\x0001\x003E" +
            "\x0004\x003A\x0001\x003E\x0004\x003A\x0001\x0075\x0001\x000A\x0001\x0075\x000A\x0019\x0001\x002F\x0011\x0019\x0001\x002F" +
            "\x0003\x001A\x0001\x002F\x0003\x0019\x0001\x002F\x0001\x0019\x0002\x0002\x0002\x0019\x0001\x002F\x000D\x0054\x0004\x0027" +
            "\x0004\x002C\x0001\x0066\x0001\x002E\x0008\x0066\x0007\x002C\x0006\x0075\x0004\x0015\x0001\x0017\x001F\x0015\x0001\x0017" +
            "\x0004\x0015\x0015\x0045\x0001\x0079\x0009\x0045\x0011\x0016\x0005\x0045\x0001\x0007\x000A\x002D\x0005\x0045\x0006\x0044" +
            "\x0004\x003E\x0001\x003F\x0001\x0016\x0005\x0053\x000A\x0051\x000F\x0053\x0001\x003C\x0003\x0039\x000C\x0050\x0001\x0009" +
            "\x0009\x0026\x0001\x002A\x0005\x0026\x0004\x0052\x000B\x0029\x0002\x000C\x0009\x0026\x0001\x002A\x0019\x0026\x0001\x002A" +
            "\x0004\x0009\x0004\x0026\x0002\x002A\x0002\x006B\x0001\x0010\x0005\x006B\x002A\x0010\u1900\x0000\u016e\x0086\x0002\x0000" +
            "\x006A\x0086\x0026\x0000\x0007\x007C\x000C\x0000\x0005\x007C\x0005\x0000\x0001\x007C\x0001\x007D\x000A\x007C\x0001\x0000" +
            "\x000D\x007C\x0001\x0000\x0005\x007C\x0001\x0000\x0001\x007C\x0001\x0000\x0002\x007C\x0001\x0000\x0002\x007C\x0001\x0000" +
            "\x006C\x007C\x0021\x0000\u016b\x007C\x0012\x0000\x0040\x007C\x0002\x0000\x0036\x007C\x0028\x0000\x000C\x007C\x0004\x0000" +
            "\x0010\x007D\x0001\x0081\x0002\x0000\x0001\x0080\x0001\x0081\x000B\x0000\x0007\x007D\x000C\x0000\x0002\x0083\x0018\x0000" +
            "\x0003\x0083\x0001\x0081\x0001\x0000\x0001\x0082\x0001\x0000\x0001\x0081\x0001\x0080\x001A\x0000\x0005\x007C\x0001\x0000" +
            "\x0087\x007C\x0002\x0000\x0001\x007D\x0007\x0000\x0001\x0082\x0004\x0000\x0001\x0081\x0001\x0000\x0001\x0082\x0001\x0000" +
            "\x000A\x007E\x0001\x0080\x0001\x0081\x0005\x0000\x001A\x007C\x0004\x0000\x0001\x0083\x0001\x0000\x001A\x007C\x000B\x0000" +
            "\x0038\x007F\x0002\x007D\x001F\x0088\x0003\x0000\x0006\x0088\x0002\x0000\x0006\x0088\x0002\x0000\x0006\x0088\x0002\x0000" +
            "\x0003\x0088\x001C\x0000\x0003\x007D\x0004\x0000";

        /// <summary>
        /// Translates characters to character classes
        /// </summary>
        private static readonly char[] ZZ_CMAP = ZzUnpackCMap(ZZ_CMAP_PACKED);

        /// <summary>
        /// Translates DFA states to action switch labels.
        /// </summary>
        private static readonly int[] ZZ_ACTION = ZzUnpackAction();

        private const string ZZ_ACTION_PACKED_0 =
            "\x0001\x0000\x0016\x0001\x0001\x0002\x0001\x0003\x0001\x0004\x0001\x0001\x0001\x0005\x0001\x0006" +
            "\x0001\x0007\x0001\x0008\x0010\x0000\x0001\x0002\x0001\x0000\x0001\x0002\x000A\x0000\x0001\x0003" +
            "\x0011\x0000\x0001\x0002\x004D\x0000";

        private static int[] ZzUnpackAction()
        {
            int[] result = new int[156];
            int offset = 0;
            offset = ZzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
            return result;
        }

        private static int ZzUnpackAction(string packed, int offset, int[] result)
        {
            int i = 0;       /* index in packed string  */
            int j = offset;  /* index in unpacked array */
            int l = packed.Length;
            while (i < l)
            {
                int count = packed[i++];
                int value = packed[i++];
                do result[j++] = value; while (--count > 0);
            }
            return j;
        }


        /// <summary>
        /// Translates a state to a row index in the transition table
        /// </summary>
        private static readonly int[] ZZ_ROWMAP = ZzUnpackRowMap();

        private const string ZZ_ROWMAP_PACKED_0 =
            "\x0000\x0000\x0000\x0089\x0000\u0112\x0000\u019b\x0000\u0224\x0000\u02ad\x0000\u0336\x0000\u03bf" +
            "\x0000\u0448\x0000\u04d1\x0000\u055a\x0000\u05e3\x0000\u066c\x0000\u06f5\x0000\u077e\x0000\u0807" +
            "\x0000\u0890\x0000\u0919\x0000\u09a2\x0000\u0a2b\x0000\u0ab4\x0000\u0b3d\x0000\u0bc6\x0000\u0c4f" +
            "\x0000\u0cd8\x0000\u0d61\x0000\u0dea\x0000\u0e73\x0000\u0efc\x0000\u0f85\x0000\u100e\x0000\u0112" +
            "\x0000\u019b\x0000\u1097\x0000\u1120\x0000\u0336\x0000\u03bf\x0000\u0448\x0000\u04d1\x0000\u11a9" +
            "\x0000\u1232\x0000\u12bb\x0000\u1344\x0000\u077e\x0000\u13cd\x0000\u1456\x0000\u14df\x0000\u1568" +
            "\x0000\u15f1\x0000\u167a\x0000\u1703\x0000\u02ad\x0000\u178c\x0000\u1815\x0000\u066c\x0000\u189e" +
            "\x0000\u1927\x0000\u19b0\x0000\u1a39\x0000\u1ac2\x0000\u1b4b\x0000\u1bd4\x0000\u1c5d\x0000\u1ce6" +
            "\x0000\u1d6f\x0000\u1df8\x0000\u1e81\x0000\u1f0a\x0000\u1f93\x0000\u201c\x0000\u20a5\x0000\u212e" +
            "\x0000\u21b7\x0000\u2240\x0000\u22c9\x0000\u2352\x0000\u23db\x0000\u0dea\x0000\u2464\x0000\u24ed" +
            "\x0000\u2576\x0000\u25ff\x0000\u2688\x0000\u2711\x0000\u279a\x0000\u2823\x0000\u28ac\x0000\u2935" +
            "\x0000\u29be\x0000\u2a47\x0000\u2ad0\x0000\u2b59\x0000\u2be2\x0000\u2c6b\x0000\u2cf4\x0000\u2d7d" +
            "\x0000\u2e06\x0000\u2e8f\x0000\u2f18\x0000\u2fa1\x0000\u302a\x0000\u30b3\x0000\u313c\x0000\u31c5" +
            "\x0000\u324e\x0000\u32d7\x0000\u3360\x0000\u33e9\x0000\u3472\x0000\u34fb\x0000\u3584\x0000\u360d" +
            "\x0000\u3696\x0000\u371f\x0000\u37a8\x0000\u3831\x0000\u38ba\x0000\u3943\x0000\u39cc\x0000\u3a55" +
            "\x0000\u3ade\x0000\u3b67\x0000\u3bf0\x0000\u3c79\x0000\u3d02\x0000\u3d8b\x0000\u3e14\x0000\u3e9d" +
            "\x0000\u3f26\x0000\u3faf\x0000\u4038\x0000\u40c1\x0000\u414a\x0000\u41d3\x0000\u425c\x0000\u42e5" +
            "\x0000\u436e\x0000\u43f7\x0000\u4480\x0000\u4509\x0000\u4592\x0000\u461b\x0000\u46a4\x0000\u472d" +
            "\x0000\u47b6\x0000\u483f\x0000\u48c8\x0000\u4951\x0000\u49da\x0000\u4a63\x0000\u4aec\x0000\u4b75" +
            "\x0000\u4bfe\x0000\u4c87\x0000\u4d10\x0000\u4d99";

        private static int[] ZzUnpackRowMap()
        {
            int[] result = new int[156];
            int offset = 0;
            offset = ZzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
            return result;
        }

        private static int ZzUnpackRowMap(string packed, int offset, int[] result)
        {
            int i = 0;  /* index in packed string  */
            int j = offset;  /* index in unpacked array */
            int l = packed.Length;
            while (i < l)
            {
                int high = packed[i++] << 16;
                result[j++] = high | packed[i++];
            }
            return j;
        }

        /// <summary>
        /// The transition table of the DFA
        /// </summary>
        private static readonly int[] ZZ_TRANS = ZzUnpackTrans();

        private const string ZZ_TRANS_PACKED_0 =
            "\x0001\x0002\x0001\x0003\x0001\x0002\x0001\x0004\x0002\x0002\x0001\x0005\x0001\x0002\x0001\x0006" +
            "\x0004\x0002\x0001\x0007\x0001\x0002\x0001\x0008\x0001\x0002\x0001\x0009\x0002\x0002\x0001\x000A" +
            "\x0003\x0002\x0001\x000B\x0002\x0002\x0001\x000C\x0004\x0002\x0001\x000D\x0003\x0002\x0001\x000E" +
            "\x000F\x0002\x0001\x000F\x0002\x0002\x0001\x0010\x0036\x0002\x0001\x0011\x0001\x0002\x0001\x0012" +
            "\x0002\x0002\x0001\x0013\x0001\x0014\x0001\x0002\x0001\x0015\x0001\x0002\x0001\x0016\x0001\x0002" +
            "\x0001\x0017\x0001\x0002\x0001\x0018\x0001\x0002\x0001\x0019\x0001\x001A\x0003\x0002\x0001\x001B" +
            "\x0002\x001C\x0001\x001D\x0001\x001E\x0001\x001F\x008B\x0000\x0001\x0018\x0002\x0000\x0001\x0018" +
            "\x0004\x0000\x0001\x0018\x000E\x0000\x0001\x0018\x000D\x0000\x0001\x0018\x0010\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0018\x0019\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0008\x0000\x0002\x0018" +
            "\x000D\x0000\x0002\x0018\x0008\x0000\x0001\x0018\x0011\x0000\x0002\x0018\x0005\x0000\x0001\x0018" +
            "\x0002\x0000\x0001\x0018\x0003\x0000\x0002\x0018\x0008\x0000\x0004\x0018\x0001\x0000\x0003\x0018" +
            "\x0001\x0000\x0001\x0018\x0002\x0000\x0001\x0018\x0002\x0000\x0001\x0018\x0004\x0000\x0004\x0018" +
            "\x0001\x0000\x0002\x0018\x0001\x0000\x0001\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0002\x0000\x0004\x0018\x0002\x0000\x0003\x0018\x0001\x0000\x0002\x0018\x0001\x0000\x0003\x0018" +
            "\x0005\x0000\x0004\x0018\x0002\x0000\x0008\x0018\x0001\x0000\x0001\x0018\x0002\x0000\x0004\x0018" +
            "\x0001\x0000\x0002\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0004\x0000\x0001\x0018" +
            "\x0003\x0000\x0001\x0018\x0014\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0009\x0000\x0001\x0018" +
            "\x0012\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0017\x0000\x0001\x0018\x0033\x0000\x0001\x0018" +
            "\x0014\x0000\x0001\x0018\x0003\x0000\x0004\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0019" +
            "\x0002\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0002\x0000\x0002\x0018\x0002\x0000\x0003\x0018" +
            "\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0002\x0000\x0004\x0018\x0001\x0000\x0003\x0018" +
            "\x0001\x0000\x0001\x0018\x0001\x0000\x0003\x0018\x0001\x0000\x0002\x0018\x0001\x0000\x0004\x0018" +
            "\x0001\x0000\x0002\x0018\x0002\x0000\x0008\x0018\x0001\x0000\x0002\x0018\x0001\x0000\x0009\x0018" +
            "\x0001\x0000\x0008\x0018\x0001\x0000\x000B\x0018\x0001\x0019\x0001\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x0001\x0000\x0002\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0003\x0000" +
            "\x0001\x0018\x001B\x0000\x0001\x0018\x000F\x0000\x0001\x0018\x0013\x0000\x0001\x0018\x0013\x0000" +
            "\x0001\x0018\x0006\x0000\x0003\x0018\x001F\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0013\x0000" +
            "\x0001\x0018\x0001\x0000\x0002\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0004\x0018\x0001\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0001\x0000\x0003\x0018\x0001\x0000" +
            "\x0002\x0018\x0001\x0000\x0004\x0018\x0001\x0000\x0003\x0018\x0001\x0000\x000F\x0018\x0001\x0000" +
            "\x0002\x0018\x0001\x0000\x0011\x0018\x0001\x0000\x0002\x0018\x0001\x0000\x0021\x0018\x0001\x0000" +
            "\x0001\x0018\x0001\x0000\x0002\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0018\x001B\x0000\x0001\x0018\x0003\x0000\x0002\x0018\x000A\x0000" +
            "\x0002\x0018\x000B\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0002\x0000\x0002\x0018\x0006\x0000" +
            "\x0001\x0018\x0004\x0000\x0002\x0018\x0002\x0000\x0002\x0018\x0005\x0000\x0003\x0018\x0008\x0000" +
            "\x0001\x0018\x0016\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0013\x0000\x0001\x0018\x0001\x0000" +
            "\x0002\x0018\x0001\x0000\x0001\x0018\x0002\x0000\x0002\x0018\x0002\x0000\x0001\x0018\x0003\x0000" +
            "\x0002\x0018\x0001\x0000\x0003\x0018\x0001\x0000\x0002\x0018\x0001\x0000\x0004\x0018\x0001\x0000" +
            "\x0003\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0002\x0000\x0009\x0018\x0001\x0000" +
            "\x0002\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0001\x0000\x000C\x0018\x0001\x0000" +
            "\x0002\x0018\x0001\x0000\x0003\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0018\x0018\x0001\x0000" +
            "\x0002\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0002\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x000F\x0000\x0001\x0018\x0016\x0000" +
            "\x0002\x0018\x0013\x0000\x0001\x0019\x0001\x0018\x0036\x0000\x0001\x0019\x0026\x0000\x0001\x0019" +
            "\x0017\x0000\x0004\x0018\x0002\x0000\x0002\x0018\x000C\x0000\x0003\x0018\x000D\x0000\x0003\x0018" +
            "\x0003\x0000\x0001\x0018\x0007\x0000\x0002\x0018\x000B\x0000\x0001\x0018\x000B\x0000\x0004\x0019" +
            "\x0001\x0000\x0002\x0018\x0009\x0000\x0001\x0018\x001F\x0000\x0001\x0018\x0003\x0000\x0002\x0018" +
            "\x000A\x0000\x0002\x0018\x0001\x0000\x0003\x0018\x0007\x0000\x0001\x0018\x0006\x0000\x0002\x0018" +
            "\x0001\x0000\x0002\x0018\x0006\x0000\x0001\x0018\x0004\x0000\x0002\x0018\x0002\x0000\x0002\x0018" +
            "\x0005\x0000\x0003\x0018\x0008\x0000\x0001\x0018\x000E\x0000\x0001\x0018\x0004\x0000\x0002\x0019" +
            "\x0001\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0013\x0000\x0001\x0018\x0004\x0000\x0001\x0018" +
            "\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0005\x0000\x0001\x0018" +
            "\x0002\x0000\x0002\x0018\x0001\x0000\x000F\x0018\x0002\x0000\x0001\x0018\x000B\x0000\x0007\x0018" +
            "\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0002\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0006\x0000\x0002\x0018" +
            "\x0005\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0002\x0000\x0003\x0018\x0001\x0000\x0001\x0018" +
            "\x0007\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x001D\x0000\x0001\x0018\x000F\x0000\x0002\x0018" +
            "\x0012\x0000\x0001\x0018\x0002\x0000\x0002\x0018\x000B\x0000\x0001\x0018\x0003\x0000\x0002\x0018" +
            "\x0005\x0000\x0003\x0018\x0008\x0000\x0001\x0018\x0016\x0000\x0001\x0018\x0007\x0000\x0001\x0018" +
            "\x0018\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0003\x0000\x0001\x0018" +
            "\x0007\x0000\x0001\x0018\x0019\x0000\x0010\x0018\x0005\x0000\x0003\x0018\x0003\x0000\x0001\x0018" +
            "\x0003\x0000\x0002\x0018\x0002\x0000\x0002\x0018\x0004\x0000\x0001\x0018\x0008\x0000\x0001\x0018" +
            "\x0004\x0000\x0001\x0018\x0002\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0018\x005A\x0000\x0001\x001E\x0021\x0000\x0001\x001A\x001D\x0000\x0001\x001D" +
            "\x0006\x0000\x0001\x001D\x0002\x0000\x0001\x001D\x0003\x0000\x0002\x001D\x0008\x0000\x0004\x001D" +
            "\x0001\x0000\x0003\x001D\x0001\x0000\x0001\x001D\x0002\x0000\x0001\x001D\x0002\x0000\x0001\x001D" +
            "\x0004\x0000\x0004\x001D\x0001\x0000\x0002\x001D\x0006\x0000\x0001\x001D\x0002\x0000\x0004\x001D" +
            "\x0002\x0000\x0003\x001D\x0001\x0000\x0002\x001D\x0001\x0000\x0003\x001D\x0005\x0000\x0004\x001D" +
            "\x0002\x0000\x0008\x001D\x0004\x0000\x0004\x001D\x0001\x0000\x0002\x001D\x0001\x0000\x0001\x001D" +
            "\x0001\x0000\x0002\x001D\x0004\x0000\x0001\x001D\x0003\x0000\x0001\x001D\x000F\x0000\x0001\x001D" +
            "\x0001\x0000\x0002\x001D\x0001\x0000\x0001\x001D\x0001\x0000\x0004\x001D\x0001\x0000\x0001\x001D" +
            "\x0001\x0000\x0001\x001D\x0001\x0000\x0002\x001D\x0001\x0000\x0003\x001D\x0001\x0000\x0002\x001D" +
            "\x0001\x0000\x0004\x001D\x0001\x0000\x0003\x001D\x0001\x0000\x000F\x001D\x0001\x0000\x0002\x001D" +
            "\x0001\x0000\x0011\x001D\x0001\x0000\x0002\x001D\x0001\x0000\x0021\x001D\x0001\x0000\x0001\x001D" +
            "\x0001\x0000\x0002\x001D\x0002\x0000\x0001\x001D\x0001\x0000\x0001\x001D\x0001\x0000\x0001\x001D" +
            "\x0001\x0000\x0001\x001D\x000F\x0000\x0001\x001D\x0001\x0000\x0002\x001D\x0001\x0000\x0001\x001D" +
            "\x0001\x0000\x0004\x001D\x0001\x0000\x0001\x001D\x0001\x0000\x0001\x001D\x0001\x0000\x0002\x001D" +
            "\x0002\x0000\x0001\x001D\x0002\x0000\x0002\x001D\x0001\x0000\x0004\x001D\x0001\x0000\x0003\x001D" +
            "\x0001\x0000\x000F\x001D\x0001\x0000\x0002\x001D\x0001\x0000\x0011\x001D\x0001\x0000\x0002\x001D" +
            "\x0001\x0000\x0021\x001D\x0001\x0000\x0001\x001D\x0001\x0000\x0002\x001D\x0002\x0000\x0001\x001D" +
            "\x0001\x0000\x0001\x001D\x0001\x0000\x0001\x001D\x0001\x0000\x0001\x001D\x001B\x0000\x0001\x001D" +
            "\x000F\x0000\x0001\x001D\x0013\x0000\x0001\x001D\x001A\x0000\x0001\x001D\x0021\x0000\x0001\x001D" +
            "\x0007\x0000\x0001\x001D\x0013\x0000\x0001\x001D\x0001\x0000\x0002\x001D\x0003\x0000\x0004\x001D" +
            "\x0001\x0000\x0001\x001D\x0001\x0000\x0001\x001D\x0001\x0000\x0002\x001D\x0001\x0000\x0003\x001D" +
            "\x0001\x0000\x0002\x001D\x0001\x0000\x0004\x001D\x0001\x0000\x0003\x001D\x0001\x0000\x0008\x001D" +
            "\x0001\x0000\x0006\x001D\x0001\x0000\x0002\x001D\x0001\x0000\x0011\x001D\x0001\x0000\x0002\x001D" +
            "\x0001\x0000\x0021\x001D\x0001\x0000\x0001\x001D\x0001\x0000\x0002\x001D\x0002\x0000\x0001\x001D" +
            "\x0001\x0000\x0001\x001D\x0001\x0000\x0001\x001D\x0001\x0000\x0001\x001D\x0088\x0000\x0001\x001E" +
            "\x000E\x0000\x0001\x0020\x0001\x0000\x0001\x0021\x0002\x0000\x0001\x0022\x0001\x0000\x0001\x0023" +
            "\x0004\x0000\x0001\x0024\x0001\x0000\x0001\x0025\x0001\x0000\x0001\x0026\x0002\x0000\x0001\x0027" +
            "\x0003\x0000\x0001\x0028\x0002\x0000\x0001\x0029\x0004\x0000\x0001\x002A\x0003\x0000\x0001\x002B" +
            "\x000F\x0000\x0001\x002C\x0002\x0000\x0001\x002D\x0011\x0000\x0001\x002E\x0002\x0000\x0001\x002F" +
            "\x002F\x0000\x0002\x0018\x0001\x0030\x0001\x0000\x0001\x0031\x0001\x0000\x0001\x0031\x0001\x0032" +
            "\x0001\x0000\x0001\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0020\x0001\x0000\x0001\x0021" +
            "\x0002\x0000\x0001\x0033\x0001\x0000\x0001\x0034\x0004\x0000\x0001\x0024\x0001\x0000\x0001\x0025" +
            "\x0001\x0000\x0001\x0026\x0002\x0000\x0001\x0027\x0003\x0000\x0001\x0035\x0002\x0000\x0001\x0036" +
            "\x0004\x0000\x0001\x0037\x0003\x0000\x0001\x0038\x000F\x0000\x0001\x002C\x0002\x0000\x0001\x0039" +
            "\x0011\x0000\x0001\x003A\x0002\x0000\x0001\x003B\x002F\x0000\x0001\x0018\x0002\x0019\x0002\x0000" +
            "\x0002\x003C\x0001\x003D\x0001\x0000\x0001\x0019\x0002\x0000\x0001\x0018\x0006\x0000\x0001\x003E" +
            "\x0011\x0000\x0001\x003F\x0002\x0000\x0001\x0040\x0008\x0000\x0001\x0041\x0012\x0000\x0001\x0042" +
            "\x0011\x0000\x0001\x0043\x0002\x0000\x0001\x0044\x0021\x0000\x0001\x0045\x000E\x0000\x0001\x001A" +
            "\x0001\x0000\x0001\x001A\x0003\x0000\x0001\x0032\x0001\x0000\x0001\x001A\x0004\x0000\x0001\x0020" +
            "\x0001\x0000\x0001\x0021\x0002\x0000\x0001\x0046\x0001\x0000\x0001\x0034\x0004\x0000\x0001\x0024" +
            "\x0001\x0000\x0001\x0025\x0001\x0000\x0001\x0026\x0002\x0000\x0001\x0027\x0003\x0000\x0001\x0047" +
            "\x0002\x0000\x0001\x0048\x0004\x0000\x0001\x0037\x0003\x0000\x0001\x0049\x000F\x0000\x0001\x002C" +
            "\x0002\x0000\x0001\x004A\x0011\x0000\x0001\x004B\x0002\x0000\x0001\x004C\x0021\x0000\x0001\x004D" +
            "\x000D\x0000\x0001\x0018\x0001\x004E\x0001\x0019\x0001\x004F\x0003\x0000\x0001\x004E\x0001\x0000" +
            "\x0001\x004E\x0002\x0000\x0001\x0018\x0084\x0000\x0002\x001C\x0009\x0000\x0001\x0050\x0011\x0000" +
            "\x0001\x0051\x0002\x0000\x0001\x0052\x0008\x0000\x0001\x0053\x0012\x0000\x0001\x0054\x0011\x0000" +
            "\x0001\x0055\x0002\x0000\x0001\x0056\x0030\x0000\x0001\x001D\x0007\x0000\x0001\x001D\x0009\x0000" +
            "\x0001\x0057\x0011\x0000\x0001\x0058\x0002\x0000\x0001\x0059\x0008\x0000\x0001\x005A\x0012\x0000" +
            "\x0001\x005B\x0011\x0000\x0001\x005C\x0002\x0000\x0001\x005D\x0030\x0000\x0001\x001E\x0007\x0000" +
            "\x0001\x001E\x0004\x0000\x0001\x0020\x0001\x0000\x0001\x0021\x0002\x0000\x0001\x005E\x0001\x0000" +
            "\x0001\x0023\x0004\x0000\x0001\x0024\x0001\x0000\x0001\x0025\x0001\x0000\x0001\x0026\x0002\x0000" +
            "\x0001\x0027\x0003\x0000\x0001\x005F\x0002\x0000\x0001\x0060\x0004\x0000\x0001\x002A\x0003\x0000" +
            "\x0001\x0061\x000F\x0000\x0001\x002C\x0002\x0000\x0001\x0062\x0011\x0000\x0001\x0063\x0002\x0000" +
            "\x0001\x0064\x002F\x0000\x0001\x0018\x0001\x001F\x0001\x0030\x0001\x0000\x0001\x0031\x0001\x0000" +
            "\x0001\x0031\x0001\x0032\x0001\x0000\x0001\x001F\x0002\x0000\x0001\x001F\x0007\x0000\x0001\x0018" +
            "\x0004\x0000\x0001\x0018\x0009\x0000\x0001\x0018\x0012\x0000\x0001\x0018\x0003\x0000\x0001\x0018" +
            "\x000B\x0000\x0001\x0018\x0002\x0000\x0001\x0018\x0008\x0000\x0001\x0018\x000A\x0000\x0004\x0018" +
            "\x0025\x0000\x0001\x0018\x0014\x0000\x0001\x0018\x0003\x0000\x0004\x0018\x0001\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0030\x0002\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0002\x0000\x0002\x0018" +
            "\x0002\x0000\x0003\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0002\x0000\x0004\x0018" +
            "\x0001\x0000\x0003\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0003\x0018\x0001\x0000\x0002\x0018" +
            "\x0001\x0000\x0004\x0018\x0001\x0000\x0002\x0018\x0002\x0000\x0008\x0018\x0001\x0000\x0002\x0018" +
            "\x0001\x0000\x0009\x0018\x0001\x0000\x0008\x0018\x0001\x0000\x000B\x0018\x0001\x0030\x0001\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0002\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x0003\x0000\x0001\x0018\x000F\x0000\x0001\x0018\x0016\x0000\x0002\x0018\x0013\x0000" +
            "\x0001\x0030\x0001\x0018\x0024\x0000\x0001\x0018\x0011\x0000\x0001\x0030\x0026\x0000\x0001\x0030" +
            "\x0009\x0000\x0001\x0018\x000D\x0000\x0004\x0018\x0002\x0000\x0002\x0018\x000C\x0000\x0004\x0018" +
            "\x0001\x0000\x0002\x0018\x0009\x0000\x0003\x0018\x0003\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0004\x0000\x0003\x0018\x0005\x0000\x0004\x0018\x0002\x0000\x0002\x0018\x000A\x0000\x0004\x0030" +
            "\x0001\x0000\x0002\x0018\x0001\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x001F\x0000\x0001\x0018" +
            "\x0003\x0000\x0002\x0018\x000A\x0000\x0002\x0018\x0001\x0000\x0003\x0018\x0007\x0000\x0001\x0018" +
            "\x0006\x0000\x0002\x0018\x0001\x0000\x0002\x0018\x0006\x0000\x0001\x0018\x0004\x0000\x0002\x0018" +
            "\x0002\x0000\x0002\x0018\x0005\x0000\x0003\x0018\x0008\x0000\x0001\x0018\x000E\x0000\x0001\x0018" +
            "\x0004\x0000\x0002\x0030\x0001\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0013\x0000\x0001\x0018" +
            "\x0004\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0006\x0000\x0001\x0018" +
            "\x0005\x0000\x0001\x0018\x0002\x0000\x0002\x0018\x0001\x0000\x000F\x0018\x0002\x0000\x0001\x0018" +
            "\x000B\x0000\x0007\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0004\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0005\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0002\x0000\x0003\x0018\x0001\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0016\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0003\x0000\x0001\x0018" +
            "\x0007\x0000\x0001\x0018\x0019\x0000\x0010\x0018\x0005\x0000\x0003\x0018\x0003\x0000\x0001\x0018" +
            "\x0003\x0000\x0002\x0018\x0002\x0000\x0002\x0018\x0004\x0000\x0005\x0018\x0004\x0000\x0001\x0018" +
            "\x0004\x0000\x0001\x0018\x0002\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0018\x0057\x0000\x0002\x0018\x000D\x0000\x0004\x0018\x0030\x0000\x0001\x0018" +
            "\x000D\x0000\x0002\x0018\x0008\x0000\x0002\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0009\x0000\x0001\x0018\x0009\x0000\x0002\x0018\x0006\x0000\x0001\x0018\x0002\x0000\x0004\x0018" +
            "\x0003\x0000\x0001\x0018\x0002\x0000\x0002\x0018\x0001\x0000\x0003\x0018\x0005\x0000\x0001\x0018" +
            "\x0001\x0000\x0002\x0018\x0002\x0000\x0002\x0018\x0001\x0000\x0004\x0018\x0005\x0000\x0001\x0018" +
            "\x0001\x0000\x0002\x0018\x001F\x0000\x0001\x0020\x0001\x0000\x0001\x0021\x0002\x0000\x0001\x0065" +
            "\x0001\x0000\x0001\x0023\x0004\x0000\x0001\x0024\x0001\x0000\x0001\x0025\x0001\x0000\x0001\x0026" +
            "\x0002\x0000\x0001\x0027\x0003\x0000\x0001\x0066\x0002\x0000\x0001\x0067\x0004\x0000\x0001\x002A" +
            "\x0003\x0000\x0001\x0068\x000F\x0000\x0001\x002C\x0002\x0000\x0001\x0069\x0011\x0000\x0001\x006A" +
            "\x0002\x0000\x0001\x006B\x002F\x0000\x0001\x0018\x0002\x0030\x0002\x0000\x0002\x006C\x0001\x0032" +
            "\x0001\x0000\x0001\x0030\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0020\x0001\x0000\x0001\x0021" +
            "\x0002\x0000\x0001\x006D\x0001\x0000\x0001\x006E\x0004\x0000\x0001\x0024\x0001\x0000\x0001\x0025" +
            "\x0001\x0000\x0001\x0026\x0002\x0000\x0001\x0027\x0003\x0000\x0001\x006F\x0002\x0000\x0001\x0070" +
            "\x0004\x0000\x0001\x0071\x0003\x0000\x0001\x0072\x000F\x0000\x0001\x002C\x0002\x0000\x0001\x0073" +
            "\x0011\x0000\x0001\x0074\x0002\x0000\x0001\x0075\x002F\x0000\x0001\x0018\x0001\x0031\x0007\x0000" +
            "\x0001\x0031\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0020\x0001\x0000\x0001\x0021\x0002\x0000" +
            "\x0001\x0076\x0001\x0000\x0001\x0023\x0004\x0000\x0001\x0024\x0001\x0000\x0001\x0025\x0001\x0000" +
            "\x0001\x0026\x0002\x0000\x0001\x0027\x0003\x0000\x0001\x0077\x0002\x0000\x0001\x0078\x0004\x0000" +
            "\x0001\x002A\x0003\x0000\x0001\x0079\x000F\x0000\x0001\x002C\x0002\x0000\x0001\x007A\x0011\x0000" +
            "\x0001\x007B\x0002\x0000\x0001\x007C\x0021\x0000\x0001\x004D\x000D\x0000\x0001\x0018\x0001\x0032" +
            "\x0001\x0030\x0001\x004F\x0003\x0000\x0001\x0032\x0001\x0000\x0001\x0032\x0002\x0000\x0001\x0018" +
            "\x0007\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0009\x0000\x0001\x0018\x0012\x0000\x0001\x0018" +
            "\x0003\x0000\x0001\x0018\x000B\x0000\x0001\x0019\x0002\x0000\x0001\x0019\x0008\x0000\x0001\x0018" +
            "\x000A\x0000\x0004\x0019\x0025\x0000\x0001\x0018\x0011\x0000\x0001\x0018\x0016\x0000\x0002\x0018" +
            "\x0013\x0000\x0001\x0019\x0001\x0018\x0024\x0000\x0001\x0019\x0011\x0000\x0001\x0019\x0026\x0000" +
            "\x0001\x0019\x0009\x0000\x0001\x0019\x000D\x0000\x0004\x0018\x0002\x0000\x0002\x0018\x000C\x0000" +
            "\x0003\x0018\x0001\x0019\x0001\x0000\x0002\x0019\x0009\x0000\x0003\x0018\x0003\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0019\x0004\x0000\x0001\x0019\x0002\x0018\x0005\x0000\x0004\x0019\x0002\x0000" +
            "\x0001\x0018\x0001\x0019\x000A\x0000\x0004\x0019\x0001\x0000\x0002\x0018\x0001\x0000\x0001\x0019" +
            "\x0007\x0000\x0001\x0018\x0013\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0006\x0000\x0001\x0018" +
            "\x0003\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0005\x0000\x0001\x0018\x0002\x0000\x0002\x0018" +
            "\x0001\x0000\x000F\x0018\x0002\x0000\x0001\x0018\x000B\x0000\x0007\x0018\x0002\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0004\x0000\x0001\x0019\x0001\x0000\x0002\x0018" +
            "\x0005\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0002\x0000\x0003\x0018\x0001\x0000\x0001\x0018" +
            "\x0007\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0016\x0000\x0001\x0018\x0006\x0000\x0001\x0018" +
            "\x0003\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0019\x0000\x0010\x0018" +
            "\x0005\x0000\x0003\x0018\x0003\x0000\x0001\x0018\x0003\x0000\x0002\x0018\x0002\x0000\x0002\x0018" +
            "\x0004\x0000\x0001\x0018\x0004\x0019\x0004\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0002\x0000" +
            "\x0001\x0018\x0004\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0057\x0000" +
            "\x0002\x0019\x000D\x0000\x0004\x0019\x0030\x0000\x0001\x0019\x000D\x0000\x0002\x0019\x0008\x0000" +
            "\x0002\x0019\x0001\x0000\x0001\x0019\x0001\x0000\x0001\x0019\x0009\x0000\x0001\x0019\x0009\x0000" +
            "\x0002\x0019\x0006\x0000\x0001\x0019\x0002\x0000\x0004\x0019\x0003\x0000\x0001\x0019\x0002\x0000" +
            "\x0002\x0019\x0001\x0000\x0003\x0019\x0005\x0000\x0001\x0019\x0001\x0000\x0002\x0019\x0002\x0000" +
            "\x0002\x0019\x0001\x0000\x0004\x0019\x0005\x0000\x0001\x0019\x0001\x0000\x0002\x0019\x0024\x0000" +
            "\x0001\x007D\x0001\x0000\x0001\x007E\x000F\x0000\x0001\x007F\x0002\x0000\x0001\x0080\x0004\x0000" +
            "\x0001\x0081\x0003\x0000\x0001\x0082\x0012\x0000\x0001\x0083\x0011\x0000\x0001\x0084\x0002\x0000" +
            "\x0001\x0085\x0030\x0000\x0001\x003C\x0001\x0019\x0006\x0000\x0001\x003C\x0004\x0000\x0001\x0020" +
            "\x0001\x0000\x0001\x0021\x0002\x0000\x0001\x0086\x0001\x0000\x0001\x0034\x0004\x0000\x0001\x0024" +
            "\x0001\x0000\x0001\x0025\x0001\x0000\x0001\x0026\x0002\x0000\x0001\x0027\x0003\x0000\x0001\x0087" +
            "\x0002\x0000\x0001\x0088\x0004\x0000\x0001\x0037\x0003\x0000\x0001\x0089\x000F\x0000\x0001\x002C" +
            "\x0002\x0000\x0001\x008A\x0011\x0000\x0001\x008B\x0002\x0000\x0001\x008C\x0021\x0000\x0001\x004D" +
            "\x000D\x0000\x0001\x0018\x0001\x003D\x0001\x0019\x0001\x004F\x0003\x0000\x0001\x003D\x0001\x0000" +
            "\x0001\x003D\x0002\x0000\x0001\x0018\x0039\x0000\x0001\x001A\x0002\x0000\x0001\x001A\x0013\x0000" +
            "\x0004\x001A\x0089\x0000\x0001\x001A\x0042\x0000\x0001\x001A\x0024\x0000\x0001\x001A\x0001\x0000" +
            "\x0002\x001A\x0011\x0000\x0001\x001A\x0004\x0000\x0001\x001A\x0007\x0000\x0004\x001A\x0003\x0000" +
            "\x0001\x001A\x0012\x0000\x0001\x001A\x0076\x0000\x0001\x001A\x008D\x0000\x0004\x001A\x006D\x0000" +
            "\x0002\x001A\x000D\x0000\x0004\x001A\x0030\x0000\x0001\x001A\x000D\x0000\x0002\x001A\x0008\x0000" +
            "\x0002\x001A\x0001\x0000\x0001\x001A\x0001\x0000\x0001\x001A\x0009\x0000\x0001\x001A\x0009\x0000" +
            "\x0002\x001A\x0006\x0000\x0001\x001A\x0002\x0000\x0004\x001A\x0003\x0000\x0001\x001A\x0002\x0000" +
            "\x0002\x001A\x0001\x0000\x0003\x001A\x0005\x0000\x0001\x001A\x0001\x0000\x0002\x001A\x0002\x0000" +
            "\x0002\x001A\x0001\x0000\x0004\x001A\x0005\x0000\x0001\x001A\x0001\x0000\x0002\x001A\x008D\x0000" +
            "\x0001\x001A\x0020\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0009\x0000\x0001\x0018\x0012\x0000" +
            "\x0001\x0018\x0003\x0000\x0001\x0018\x000B\x0000\x0001\x004E\x0002\x0000\x0001\x004E\x0008\x0000" +
            "\x0001\x0018\x000A\x0000\x0004\x004E\x0025\x0000\x0001\x0018\x0011\x0000\x0001\x0018\x0016\x0000" +
            "\x0002\x0018\x0013\x0000\x0001\x0019\x0001\x0018\x0024\x0000\x0001\x004E\x0011\x0000\x0001\x0019" +
            "\x0026\x0000\x0001\x0019\x0009\x0000\x0001\x004E\x000D\x0000\x0004\x0018\x0002\x0000\x0002\x0018" +
            "\x000C\x0000\x0003\x0018\x0001\x004E\x0001\x0000\x0002\x004E\x0009\x0000\x0003\x0018\x0003\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x004E\x0004\x0000\x0001\x004E\x0002\x0018\x0005\x0000\x0004\x004E" +
            "\x0002\x0000\x0001\x0018\x0001\x004E\x000A\x0000\x0004\x0019\x0001\x0000\x0002\x0018\x0001\x0000" +
            "\x0001\x004E\x0007\x0000\x0001\x0018\x0013\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0006\x0000" +
            "\x0001\x0018\x0003\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0005\x0000\x0001\x0018\x0002\x0000" +
            "\x0002\x0018\x0001\x0000\x000F\x0018\x0002\x0000\x0001\x0018\x000B\x0000\x0007\x0018\x0002\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0002\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0004\x0000\x0001\x004E\x0001\x0000" +
            "\x0002\x0018\x0005\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0002\x0000\x0003\x0018\x0001\x0000" +
            "\x0001\x0018\x0007\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0016\x0000\x0001\x0018\x0006\x0000" +
            "\x0001\x0018\x0003\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0019\x0000" +
            "\x0010\x0018\x0005\x0000\x0003\x0018\x0003\x0000\x0001\x0018\x0003\x0000\x0002\x0018\x0002\x0000" +
            "\x0002\x0018\x0004\x0000\x0001\x0018\x0004\x004E\x0004\x0000\x0001\x0018\x0004\x0000\x0001\x0018" +
            "\x0002\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0057\x0000\x0002\x004E\x000D\x0000\x0004\x004E\x0030\x0000\x0001\x004E\x000D\x0000\x0002\x004E" +
            "\x0008\x0000\x0002\x004E\x0001\x0000\x0001\x004E\x0001\x0000\x0001\x004E\x0009\x0000\x0001\x004E" +
            "\x0009\x0000\x0002\x004E\x0006\x0000\x0001\x004E\x0002\x0000\x0004\x004E\x0003\x0000\x0001\x004E" +
            "\x0002\x0000\x0002\x004E\x0001\x0000\x0003\x004E\x0005\x0000\x0001\x004E\x0001\x0000\x0002\x004E" +
            "\x0002\x0000\x0002\x004E\x0001\x0000\x0004\x004E\x0005\x0000\x0001\x004E\x0001\x0000\x0002\x004E" +
            "\x008D\x0000\x0001\x004F\x001F\x0000\x0001\x008D\x0011\x0000\x0001\x008E\x0002\x0000\x0001\x008F" +
            "\x0008\x0000\x0001\x0090\x0012\x0000\x0001\x0091\x0011\x0000\x0001\x0092\x0002\x0000\x0001\x0093" +
            "\x0021\x0000\x0001\x004D\x000E\x0000\x0001\x004F\x0001\x0000\x0001\x004F\x0003\x0000\x0001\x0032" +
            "\x0001\x0000\x0001\x004F\x003C\x0000\x0001\x001D\x0002\x0000\x0001\x001D\x0013\x0000\x0004\x001D" +
            "\x0089\x0000\x0001\x001D\x0042\x0000\x0001\x001D\x0024\x0000\x0001\x001D\x0001\x0000\x0002\x001D" +
            "\x0011\x0000\x0001\x001D\x0004\x0000\x0001\x001D\x0007\x0000\x0004\x001D\x0003\x0000\x0001\x001D" +
            "\x0012\x0000\x0001\x001D\x0076\x0000\x0001\x001D\x008D\x0000\x0004\x001D\x006D\x0000\x0002\x001D" +
            "\x000D\x0000\x0004\x001D\x0030\x0000\x0001\x001D\x000D\x0000\x0002\x001D\x0008\x0000\x0002\x001D" +
            "\x0001\x0000\x0001\x001D\x0001\x0000\x0001\x001D\x0009\x0000\x0001\x001D\x0009\x0000\x0002\x001D" +
            "\x0006\x0000\x0001\x001D\x0002\x0000\x0004\x001D\x0003\x0000\x0001\x001D\x0002\x0000\x0002\x001D" +
            "\x0001\x0000\x0003\x001D\x0005\x0000\x0001\x001D\x0001\x0000\x0002\x001D\x0002\x0000\x0002\x001D" +
            "\x0001\x0000\x0004\x001D\x0005\x0000\x0001\x001D\x0001\x0000\x0002\x001D\x0057\x0000\x0001\x001E" +
            "\x0002\x0000\x0001\x001E\x0013\x0000\x0004\x001E\x0089\x0000\x0001\x001E\x0042\x0000\x0001\x001E" +
            "\x0024\x0000\x0001\x001E\x0001\x0000\x0002\x001E\x0011\x0000\x0001\x001E\x0004\x0000\x0001\x001E" +
            "\x0007\x0000\x0004\x001E\x0003\x0000\x0001\x001E\x0012\x0000\x0001\x001E\x0076\x0000\x0001\x001E" +
            "\x008D\x0000\x0004\x001E\x006D\x0000\x0002\x001E\x000D\x0000\x0004\x001E\x0030\x0000\x0001\x001E" +
            "\x000D\x0000\x0002\x001E\x0008\x0000\x0002\x001E\x0001\x0000\x0001\x001E\x0001\x0000\x0001\x001E" +
            "\x0009\x0000\x0001\x001E\x0009\x0000\x0002\x001E\x0006\x0000\x0001\x001E\x0002\x0000\x0004\x001E" +
            "\x0003\x0000\x0001\x001E\x0002\x0000\x0002\x001E\x0001\x0000\x0003\x001E\x0005\x0000\x0001\x001E" +
            "\x0001\x0000\x0002\x001E\x0002\x0000\x0002\x001E\x0001\x0000\x0004\x001E\x0005\x0000\x0001\x001E" +
            "\x0001\x0000\x0002\x001E\x0025\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0009\x0000\x0001\x0018" +
            "\x0012\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x000B\x0000\x0001\x001F\x0002\x0000\x0001\x001F" +
            "\x0008\x0000\x0001\x0018\x000A\x0000\x0004\x001F\x0025\x0000\x0001\x0018\x0011\x0000\x0001\x0018" +
            "\x0016\x0000\x0002\x0018\x0013\x0000\x0001\x0030\x0001\x0018\x0024\x0000\x0001\x001F\x0011\x0000" +
            "\x0001\x0030\x0026\x0000\x0001\x0030\x0009\x0000\x0001\x001F\x000D\x0000\x0004\x0018\x0002\x0000" +
            "\x0002\x0018\x000C\x0000\x0003\x0018\x0001\x001F\x0001\x0000\x0002\x001F\x0009\x0000\x0003\x0018" +
            "\x0003\x0000\x0001\x0018\x0001\x0000\x0001\x001F\x0004\x0000\x0001\x001F\x0002\x0018\x0005\x0000" +
            "\x0004\x001F\x0002\x0000\x0001\x0018\x0001\x001F\x000A\x0000\x0004\x0030\x0001\x0000\x0002\x0018" +
            "\x0001\x0000\x0001\x001F\x0007\x0000\x0001\x0018\x0013\x0000\x0001\x0018\x0004\x0000\x0001\x0018" +
            "\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0005\x0000\x0001\x0018" +
            "\x0002\x0000\x0002\x0018\x0001\x0000\x000F\x0018\x0002\x0000\x0001\x0018\x000B\x0000\x0007\x0018" +
            "\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0002\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0004\x0000\x0001\x001F" +
            "\x0001\x0000\x0002\x0018\x0005\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0002\x0000\x0003\x0018" +
            "\x0001\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0016\x0000\x0001\x0018" +
            "\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0007\x0000\x0001\x0018" +
            "\x0019\x0000\x0010\x0018\x0005\x0000\x0003\x0018\x0003\x0000\x0001\x0018\x0003\x0000\x0002\x0018" +
            "\x0002\x0000\x0002\x0018\x0004\x0000\x0001\x0018\x0004\x001F\x0004\x0000\x0001\x0018\x0004\x0000" +
            "\x0001\x0018\x0002\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x0057\x0000\x0002\x001F\x000D\x0000\x0004\x001F\x0030\x0000\x0001\x001F\x000D\x0000" +
            "\x0002\x001F\x0008\x0000\x0002\x001F\x0001\x0000\x0001\x001F\x0001\x0000\x0001\x001F\x0009\x0000" +
            "\x0001\x001F\x0009\x0000\x0002\x001F\x0006\x0000\x0001\x001F\x0002\x0000\x0004\x001F\x0003\x0000" +
            "\x0001\x001F\x0002\x0000\x0002\x001F\x0001\x0000\x0003\x001F\x0005\x0000\x0001\x001F\x0001\x0000" +
            "\x0002\x001F\x0002\x0000\x0002\x001F\x0001\x0000\x0004\x001F\x0005\x0000\x0001\x001F\x0001\x0000" +
            "\x0002\x001F\x0025\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0009\x0000\x0001\x0018\x0012\x0000" +
            "\x0001\x0018\x0003\x0000\x0001\x0018\x000B\x0000\x0001\x0030\x0002\x0000\x0001\x0030\x0008\x0000" +
            "\x0001\x0018\x000A\x0000\x0004\x0030\x0025\x0000\x0001\x0018\x0011\x0000\x0001\x0018\x0016\x0000" +
            "\x0002\x0018\x0013\x0000\x0001\x0030\x0001\x0018\x0024\x0000\x0001\x0030\x0011\x0000\x0001\x0030" +
            "\x0026\x0000\x0001\x0030\x0009\x0000\x0001\x0030\x000D\x0000\x0004\x0018\x0002\x0000\x0002\x0018" +
            "\x000C\x0000\x0003\x0018\x0001\x0030\x0001\x0000\x0002\x0030\x0009\x0000\x0003\x0018\x0003\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0030\x0004\x0000\x0001\x0030\x0002\x0018\x0005\x0000\x0004\x0030" +
            "\x0002\x0000\x0001\x0018\x0001\x0030\x000A\x0000\x0004\x0030\x0001\x0000\x0002\x0018\x0001\x0000" +
            "\x0001\x0030\x0007\x0000\x0001\x0018\x0013\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0006\x0000" +
            "\x0001\x0018\x0003\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0005\x0000\x0001\x0018\x0002\x0000" +
            "\x0002\x0018\x0001\x0000\x000F\x0018\x0002\x0000\x0001\x0018\x000B\x0000\x0007\x0018\x0002\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0002\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0004\x0000\x0001\x0030\x0001\x0000" +
            "\x0002\x0018\x0005\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0002\x0000\x0003\x0018\x0001\x0000" +
            "\x0001\x0018\x0007\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0016\x0000\x0001\x0018\x0006\x0000" +
            "\x0001\x0018\x0003\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0019\x0000" +
            "\x0010\x0018\x0005\x0000\x0003\x0018\x0003\x0000\x0001\x0018\x0003\x0000\x0002\x0018\x0002\x0000" +
            "\x0002\x0018\x0004\x0000\x0001\x0018\x0004\x0030\x0004\x0000\x0001\x0018\x0004\x0000\x0001\x0018" +
            "\x0002\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0057\x0000\x0002\x0030\x000D\x0000\x0004\x0030\x0030\x0000\x0001\x0030\x000D\x0000\x0002\x0030" +
            "\x0008\x0000\x0002\x0030\x0001\x0000\x0001\x0030\x0001\x0000\x0001\x0030\x0009\x0000\x0001\x0030" +
            "\x0009\x0000\x0002\x0030\x0006\x0000\x0001\x0030\x0002\x0000\x0004\x0030\x0003\x0000\x0001\x0030" +
            "\x0002\x0000\x0002\x0030\x0001\x0000\x0003\x0030\x0005\x0000\x0001\x0030\x0001\x0000\x0002\x0030" +
            "\x0002\x0000\x0002\x0030\x0001\x0000\x0004\x0030\x0005\x0000\x0001\x0030\x0001\x0000\x0002\x0030" +
            "\x0024\x0000\x0001\x0094\x0001\x0000\x0001\x0095\x000F\x0000\x0001\x0096\x0002\x0000\x0001\x0097" +
            "\x0004\x0000\x0001\x0098\x0003\x0000\x0001\x0099\x0012\x0000\x0001\x009A\x0011\x0000\x0001\x009B" +
            "\x0002\x0000\x0001\x009C\x0030\x0000\x0001\x006C\x0001\x0030\x0006\x0000\x0001\x006C\x000A\x0000" +
            "\x0001\x0018\x0004\x0000\x0001\x0018\x0009\x0000\x0001\x0018\x0012\x0000\x0001\x0018\x0003\x0000" +
            "\x0001\x0018\x000B\x0000\x0001\x0031\x0002\x0000\x0001\x0031\x0008\x0000\x0001\x0018\x000A\x0000" +
            "\x0004\x0031\x0025\x0000\x0001\x0018\x0014\x0000\x0001\x0018\x0003\x0000\x0004\x0018\x0001\x0000" +
            "\x0001\x0018\x0004\x0000\x0001\x0018\x0001\x0000\x0002\x0018\x0002\x0000\x0002\x0018\x0002\x0000" +
            "\x0003\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0002\x0000\x0004\x0018\x0001\x0000" +
            "\x0003\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0003\x0018\x0001\x0000\x0002\x0018\x0001\x0000" +
            "\x0004\x0018\x0001\x0000\x0002\x0018\x0002\x0000\x0008\x0018\x0001\x0000\x0002\x0018\x0001\x0000" +
            "\x0009\x0018\x0001\x0000\x0008\x0018\x0001\x0000\x000B\x0018\x0002\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x0001\x0000\x0002\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0003\x0000" +
            "\x0001\x0018\x000F\x0000\x0001\x0018\x0016\x0000\x0002\x0018\x0014\x0000\x0001\x0018\x0024\x0000" +
            "\x0001\x0031\x0042\x0000\x0001\x0031\x000D\x0000\x0004\x0018\x0002\x0000\x0002\x0018\x000C\x0000" +
            "\x0003\x0018\x0001\x0031\x0001\x0000\x0002\x0031\x0009\x0000\x0003\x0018\x0003\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0031\x0004\x0000\x0001\x0031\x0002\x0018\x0005\x0000\x0004\x0031\x0002\x0000" +
            "\x0001\x0018\x0001\x0031\x000F\x0000\x0002\x0018\x0001\x0000\x0001\x0031\x0007\x0000\x0001\x0018" +
            "\x001F\x0000\x0001\x0018\x0003\x0000\x0002\x0018\x000A\x0000\x0002\x0018\x0001\x0000\x0003\x0018" +
            "\x0007\x0000\x0001\x0018\x0006\x0000\x0002\x0018\x0001\x0000\x0002\x0018\x0006\x0000\x0001\x0018" +
            "\x0004\x0000\x0002\x0018\x0002\x0000\x0002\x0018\x0005\x0000\x0003\x0018\x0008\x0000\x0001\x0018" +
            "\x000E\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0013\x0000\x0001\x0018" +
            "\x0004\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0006\x0000\x0001\x0018" +
            "\x0005\x0000\x0001\x0018\x0002\x0000\x0002\x0018\x0001\x0000\x000F\x0018\x0002\x0000\x0001\x0018" +
            "\x000B\x0000\x0007\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0004\x0000\x0001\x0031\x0001\x0000\x0002\x0018\x0005\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0002\x0000\x0003\x0018\x0001\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0016\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0003\x0000\x0001\x0018" +
            "\x0007\x0000\x0001\x0018\x0019\x0000\x0010\x0018\x0005\x0000\x0003\x0018\x0003\x0000\x0001\x0018" +
            "\x0003\x0000\x0002\x0018\x0002\x0000\x0002\x0018\x0004\x0000\x0001\x0018\x0004\x0031\x0004\x0000" +
            "\x0001\x0018\x0004\x0000\x0001\x0018\x0002\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0018\x0057\x0000\x0002\x0031\x000D\x0000\x0004\x0031\x0030\x0000" +
            "\x0001\x0031\x000D\x0000\x0002\x0031\x0008\x0000\x0002\x0031\x0001\x0000\x0001\x0031\x0001\x0000" +
            "\x0001\x0031\x0009\x0000\x0001\x0031\x0009\x0000\x0002\x0031\x0006\x0000\x0001\x0031\x0002\x0000" +
            "\x0004\x0031\x0003\x0000\x0001\x0031\x0002\x0000\x0002\x0031\x0001\x0000\x0003\x0031\x0005\x0000" +
            "\x0001\x0031\x0001\x0000\x0002\x0031\x0002\x0000\x0002\x0031\x0001\x0000\x0004\x0031\x0005\x0000" +
            "\x0001\x0031\x0001\x0000\x0002\x0031\x0025\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0009\x0000" +
            "\x0001\x0018\x0012\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x000B\x0000\x0001\x0032\x0002\x0000" +
            "\x0001\x0032\x0008\x0000\x0001\x0018\x000A\x0000\x0004\x0032\x0025\x0000\x0001\x0018\x0011\x0000" +
            "\x0001\x0018\x0016\x0000\x0002\x0018\x0013\x0000\x0001\x0030\x0001\x0018\x0024\x0000\x0001\x0032" +
            "\x0011\x0000\x0001\x0030\x0026\x0000\x0001\x0030\x0009\x0000\x0001\x0032\x000D\x0000\x0004\x0018" +
            "\x0002\x0000\x0002\x0018\x000C\x0000\x0003\x0018\x0001\x0032\x0001\x0000\x0002\x0032\x0009\x0000" +
            "\x0003\x0018\x0003\x0000\x0001\x0018\x0001\x0000\x0001\x0032\x0004\x0000\x0001\x0032\x0002\x0018" +
            "\x0005\x0000\x0004\x0032\x0002\x0000\x0001\x0018\x0001\x0032\x000A\x0000\x0004\x0030\x0001\x0000" +
            "\x0002\x0018\x0001\x0000\x0001\x0032\x0007\x0000\x0001\x0018\x0013\x0000\x0001\x0018\x0004\x0000" +
            "\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0005\x0000" +
            "\x0001\x0018\x0002\x0000\x0002\x0018\x0001\x0000\x000F\x0018\x0002\x0000\x0001\x0018\x000B\x0000" +
            "\x0007\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0002\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0004\x0000" +
            "\x0001\x0032\x0001\x0000\x0002\x0018\x0005\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0002\x0000" +
            "\x0003\x0018\x0001\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0016\x0000" +
            "\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0007\x0000" +
            "\x0001\x0018\x0019\x0000\x0010\x0018\x0005\x0000\x0003\x0018\x0003\x0000\x0001\x0018\x0003\x0000" +
            "\x0002\x0018\x0002\x0000\x0002\x0018\x0004\x0000\x0001\x0018\x0004\x0032\x0004\x0000\x0001\x0018" +
            "\x0004\x0000\x0001\x0018\x0002\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0001\x0000\x0001\x0018\x0057\x0000\x0002\x0032\x000D\x0000\x0004\x0032\x0030\x0000\x0001\x0032" +
            "\x000D\x0000\x0002\x0032\x0008\x0000\x0002\x0032\x0001\x0000\x0001\x0032\x0001\x0000\x0001\x0032" +
            "\x0009\x0000\x0001\x0032\x0009\x0000\x0002\x0032\x0006\x0000\x0001\x0032\x0002\x0000\x0004\x0032" +
            "\x0003\x0000\x0001\x0032\x0002\x0000\x0002\x0032\x0001\x0000\x0003\x0032\x0005\x0000\x0001\x0032" +
            "\x0001\x0000\x0002\x0032\x0002\x0000\x0002\x0032\x0001\x0000\x0004\x0032\x0005\x0000\x0001\x0032" +
            "\x0001\x0000\x0002\x0032\x0057\x0000\x0001\x003C\x0002\x0000\x0001\x003C\x0013\x0000\x0004\x003C" +
            "\x0045\x0000\x0001\x0019\x005A\x0000\x0001\x0019\x004B\x0000\x0001\x0019\x0025\x0000\x0001\x003C" +
            "\x0011\x0000\x0001\x0019\x0026\x0000\x0001\x0019\x0009\x0000\x0001\x003C\x0024\x0000\x0001\x003C" +
            "\x0001\x0000\x0002\x003C\x0011\x0000\x0001\x003C\x0004\x0000\x0001\x003C\x0007\x0000\x0004\x003C" +
            "\x0003\x0000\x0001\x003C\x000A\x0000\x0004\x0019\x0004\x0000\x0001\x003C\x0085\x0000\x0002\x0019" +
            "\x0078\x0000\x0001\x003C\x008D\x0000\x0004\x003C\x006D\x0000\x0002\x003C\x000D\x0000\x0004\x003C" +
            "\x0030\x0000\x0001\x003C\x000D\x0000\x0002\x003C\x0008\x0000\x0002\x003C\x0001\x0000\x0001\x003C" +
            "\x0001\x0000\x0001\x003C\x0009\x0000\x0001\x003C\x0009\x0000\x0002\x003C\x0006\x0000\x0001\x003C" +
            "\x0002\x0000\x0004\x003C\x0003\x0000\x0001\x003C\x0002\x0000\x0002\x003C\x0001\x0000\x0003\x003C" +
            "\x0005\x0000\x0001\x003C\x0001\x0000\x0002\x003C\x0002\x0000\x0002\x003C\x0001\x0000\x0004\x003C" +
            "\x0005\x0000\x0001\x003C\x0001\x0000\x0002\x003C\x0025\x0000\x0001\x0018\x0004\x0000\x0001\x0018" +
            "\x0009\x0000\x0001\x0018\x0012\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x000B\x0000\x0001\x003D" +
            "\x0002\x0000\x0001\x003D\x0008\x0000\x0001\x0018\x000A\x0000\x0004\x003D\x0025\x0000\x0001\x0018" +
            "\x0011\x0000\x0001\x0018\x0016\x0000\x0002\x0018\x0013\x0000\x0001\x0019\x0001\x0018\x0024\x0000" +
            "\x0001\x003D\x0011\x0000\x0001\x0019\x0026\x0000\x0001\x0019\x0009\x0000\x0001\x003D\x000D\x0000" +
            "\x0004\x0018\x0002\x0000\x0002\x0018\x000C\x0000\x0003\x0018\x0001\x003D\x0001\x0000\x0002\x003D" +
            "\x0009\x0000\x0003\x0018\x0003\x0000\x0001\x0018\x0001\x0000\x0001\x003D\x0004\x0000\x0001\x003D" +
            "\x0002\x0018\x0005\x0000\x0004\x003D\x0002\x0000\x0001\x0018\x0001\x003D\x000A\x0000\x0004\x0019" +
            "\x0001\x0000\x0002\x0018\x0001\x0000\x0001\x003D\x0007\x0000\x0001\x0018\x0013\x0000\x0001\x0018" +
            "\x0004\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0006\x0000\x0001\x0018" +
            "\x0005\x0000\x0001\x0018\x0002\x0000\x0002\x0018\x0001\x0000\x000F\x0018\x0002\x0000\x0001\x0018" +
            "\x000B\x0000\x0007\x0018\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0002\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0004\x0000\x0001\x003D\x0001\x0000\x0002\x0018\x0005\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0002\x0000\x0003\x0018\x0001\x0000\x0001\x0018\x0007\x0000\x0001\x0018\x0001\x0000\x0001\x0018" +
            "\x0016\x0000\x0001\x0018\x0006\x0000\x0001\x0018\x0003\x0000\x0001\x0018\x0003\x0000\x0001\x0018" +
            "\x0007\x0000\x0001\x0018\x0019\x0000\x0010\x0018\x0005\x0000\x0003\x0018\x0003\x0000\x0001\x0018" +
            "\x0003\x0000\x0002\x0018\x0002\x0000\x0002\x0018\x0004\x0000\x0001\x0018\x0004\x003D\x0004\x0000" +
            "\x0001\x0018\x0004\x0000\x0001\x0018\x0002\x0000\x0001\x0018\x0004\x0000\x0001\x0018\x0001\x0000" +
            "\x0001\x0018\x0001\x0000\x0001\x0018\x0057\x0000\x0002\x003D\x000D\x0000\x0004\x003D\x0030\x0000" +
            "\x0001\x003D\x000D\x0000\x0002\x003D\x0008\x0000\x0002\x003D\x0001\x0000\x0001\x003D\x0001\x0000" +
            "\x0001\x003D\x0009\x0000\x0001\x003D\x0009\x0000\x0002\x003D\x0006\x0000\x0001\x003D\x0002\x0000" +
            "\x0004\x003D\x0003\x0000\x0001\x003D\x0002\x0000\x0002\x003D\x0001\x0000\x0003\x003D\x0005\x0000" +
            "\x0001\x003D\x0001\x0000\x0002\x003D\x0002\x0000\x0002\x003D\x0001\x0000\x0004\x003D\x0005\x0000" +
            "\x0001\x003D\x0001\x0000\x0002\x003D\x0057\x0000\x0001\x004F\x0002\x0000\x0001\x004F\x0013\x0000" +
            "\x0004\x004F\x0089\x0000\x0001\x004F\x0042\x0000\x0001\x004F\x0024\x0000\x0001\x004F\x0001\x0000" +
            "\x0002\x004F\x0011\x0000\x0001\x004F\x0004\x0000\x0001\x004F\x0007\x0000\x0004\x004F\x0003\x0000" +
            "\x0001\x004F\x0012\x0000\x0001\x004F\x0076\x0000\x0001\x004F\x008D\x0000\x0004\x004F\x006D\x0000" +
            "\x0002\x004F\x000D\x0000\x0004\x004F\x0030\x0000\x0001\x004F\x000D\x0000\x0002\x004F\x0008\x0000" +
            "\x0002\x004F\x0001\x0000\x0001\x004F\x0001\x0000\x0001\x004F\x0009\x0000\x0001\x004F\x0009\x0000" +
            "\x0002\x004F\x0006\x0000\x0001\x004F\x0002\x0000\x0004\x004F\x0003\x0000\x0001\x004F\x0002\x0000" +
            "\x0002\x004F\x0001\x0000\x0003\x004F\x0005\x0000\x0001\x004F\x0001\x0000\x0002\x004F\x0002\x0000" +
            "\x0002\x004F\x0001\x0000\x0004\x004F\x0005\x0000\x0001\x004F\x0001\x0000\x0002\x004F\x0057\x0000" +
            "\x0001\x006C\x0002\x0000\x0001\x006C\x0013\x0000\x0004\x006C\x0045\x0000\x0001\x0030\x005A\x0000" +
            "\x0001\x0030\x004B\x0000\x0001\x0030\x0025\x0000\x0001\x006C\x0011\x0000\x0001\x0030\x0026\x0000" +
            "\x0001\x0030\x0009\x0000\x0001\x006C\x0024\x0000\x0001\x006C\x0001\x0000\x0002\x006C\x0011\x0000" +
            "\x0001\x006C\x0004\x0000\x0001\x006C\x0007\x0000\x0004\x006C\x0003\x0000\x0001\x006C\x000A\x0000" +
            "\x0004\x0030\x0004\x0000\x0001\x006C\x0085\x0000\x0002\x0030\x0078\x0000\x0001\x006C\x008D\x0000" +
            "\x0004\x006C\x006D\x0000\x0002\x006C\x000D\x0000\x0004\x006C\x0030\x0000\x0001\x006C\x000D\x0000" +
            "\x0002\x006C\x0008\x0000\x0002\x006C\x0001\x0000\x0001\x006C\x0001\x0000\x0001\x006C\x0009\x0000" +
            "\x0001\x006C\x0009\x0000\x0002\x006C\x0006\x0000\x0001\x006C\x0002\x0000\x0004\x006C\x0003\x0000" +
            "\x0001\x006C\x0002\x0000\x0002\x006C\x0001\x0000\x0003\x006C\x0005\x0000\x0001\x006C\x0001\x0000" +
            "\x0002\x006C\x0002\x0000\x0002\x006C\x0001\x0000\x0004\x006C\x0005\x0000\x0001\x006C\x0001\x0000" +
            "\x0002\x006C\x001E\x0000";

        private static int[] ZzUnpackTrans()
        {
            int[] result = new int[20002];
            int offset = 0;
            offset = ZzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
            return result;
        }

        private static int ZzUnpackTrans(string packed, int offset, int[] result)
        {
            int i = 0;       /* index in packed string  */
            int j = offset;  /* index in unpacked array */
            int l = packed.Length;
            while (i < l)
            {
                int count = packed[i++];
                int value = packed[i++];
                value--;
                do result[j++] = value; while (--count > 0);
            }
            return j;
        }


        /* error codes */
        private const int ZZ_UNKNOWN_ERROR = 0;
        private const int ZZ_NO_MATCH = 1;
        private const int ZZ_PUSHBACK_2BIG = 2;

        /* error messages for the codes above */
        private static readonly string[] ZZ_ERROR_MSG = {
            "Unkown internal scanner error",
            "Error: could not match input",
            "Error: pushback value was too large"
        };

        /// <summary>
        /// ZZ_ATTRIBUTE[aState] contains the attributes of state <c>aState</c>
        /// </summary>
        private static readonly int[] ZZ_ATTRIBUTE = ZzUnpackAttribute();

        private const string ZZ_ATTRIBUTE_PACKED_0 =
            "\x0001\x0000\x0001\x0009\x001D\x0001\x0010\x0000\x0001\x0001\x0001\x0000\x0001\x0001\x000A\x0000" +
            "\x0001\x0001\x0011\x0000\x0001\x0001\x004D\x0000";

        private static int[] ZzUnpackAttribute()
        {
            int[] result = new int[156];
            int offset = 0;
            offset = ZzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
            return result;
        }

        private static int ZzUnpackAttribute(string packed, int offset, int[] result)
        {
            int i = 0;       /* index in packed string  */
            int j = offset;  /* index in unpacked array */
            int l = packed.Length;
            while (i < l)
            {
                int count = packed[i++];
                int value = packed[i++];
                do result[j++] = value; while (--count > 0);
            }
            return j;
        }

        /// <summary>the input device</summary>
        private TextReader zzReader;

        /// <summary>the current state of the DFA</summary>
        private int zzState;

        /// <summary>the current lexical state</summary>
        private int zzLexicalState = YYINITIAL;

        /// <summary>
        /// this buffer contains the current text to be matched and is
        /// the source of the YyText string 
        /// </summary>
        private char[] zzBuffer = new char[ZZ_BUFFERSIZE];

        /// <summary>the textposition at the last accepting state</summary>
        private int zzMarkedPos;

        /// <summary>the current text position in the buffer</summary>
        private int zzCurrentPos;

        /// <summary>startRead marks the beginning of the YyText string in the buffer</summary>
        private int zzStartRead;

        /// <summary>
        /// endRead marks the last character in the buffer, that has been read
        /// from input
        /// </summary>
        private int zzEndRead;

        /// <summary>number of newlines encountered up to the start of the matched text</summary>
        private int yyline;

        /// <summary>the number of characters up to the start of the matched text</summary>
        private int yyChar;

#pragma warning disable 169, 414
        /// <summary>
        /// the number of characters from the last newline up to the start of the
        /// matched text
        /// </summary>
        private int yycolumn;

        /// <summary>
        /// zzAtBOL == true &lt;=&gt; the scanner is currently at the beginning of a line
        /// </summary>
        private bool zzAtBOL = true;

        /// <summary>zzAtEOF == true &lt;=&gt; the scanner is at the EOF</summary>
        private bool zzAtEOF;

        /// <summary>denotes if the user-EOF-code has already been executed</summary>
        private bool zzEOFDone;

#pragma warning restore 169, 414

        /* user code: */
        /// <summary>Alphanumeric sequences</summary>
        public static readonly int WORD_TYPE = StandardTokenizer.ALPHANUM;

        /// <summary>Numbers</summary>
        public static readonly int NUMERIC_TYPE = StandardTokenizer.NUM;

        /// <summary>
        /// Chars in class \p{Line_Break = Complex_Context} are from South East Asian
        /// scripts (Thai, Lao, Myanmar, Khmer, etc.).  Sequences of these are kept 
        /// together as as a single token rather than broken up, because the logic
        /// required to break them at word boundaries is too complex for UAX#29.
        /// <para/>
        /// See Unicode Line Breaking Algorithm: http://www.unicode.org/reports/tr14/#SA
        /// </summary>
        public static readonly int SOUTH_EAST_ASIAN_TYPE = StandardTokenizer.SOUTHEAST_ASIAN;

        public static readonly int IDEOGRAPHIC_TYPE = StandardTokenizer.IDEOGRAPHIC;

        public static readonly int HIRAGANA_TYPE = StandardTokenizer.HIRAGANA;

        public static readonly int KATAKANA_TYPE = StandardTokenizer.KATAKANA;

        public static readonly int HANGUL_TYPE = StandardTokenizer.HANGUL;

        public int YyChar
        {
            get { return yyChar; }
        }

        /// <summary>
        /// Fills ICharTermAttribute with the current token text.
        /// </summary>
        public void GetText(ICharTermAttribute t)
        {
            t.CopyBuffer(zzBuffer, zzStartRead, zzMarkedPos - zzStartRead);
        }


        /// <summary>
        /// Creates a new scanner
        /// </summary>
        /// <param name="in">the TextReader to read input from.</param>
        public StandardTokenizerImpl40(TextReader @in)
        {
            this.zzReader = @in;
        }


        /// <summary>
        /// Unpacks the compressed character translation table.
        /// </summary>
        /// <param name="packed">the packed character translation table</param>
        /// <returns>the unpacked character translation table</returns>
        private static char[] ZzUnpackCMap(string packed)
        {
            char[] map = new char[0x10000];
            int i = 0;  /* index in packed string  */
            int j = 0;  /* index in unpacked array */
            while (i < 2848)
            {
                int count = packed[i++];
                char value = packed[i++];
                do map[j++] = value; while (--count > 0);
            }
            return map;
        }


        /// <summary>
        /// Refills the input buffer.
        /// </summary>
        /// <returns><c>false</c>, iff there was new input.</returns>
        /// <exception cref="IOException">if any I/O-Error occurs</exception>
        private bool ZzRefill()
        {

            /* first: make room (if you can) */
            if (zzStartRead > 0)
            {
                System.Array.Copy(zzBuffer, zzStartRead,
                                 zzBuffer, 0,
                                 zzEndRead - zzStartRead);

                /* translate stored positions */
                zzEndRead -= zzStartRead;
                zzCurrentPos -= zzStartRead;
                zzMarkedPos -= zzStartRead;
                zzStartRead = 0;
            }

            /* is the buffer big enough? */
            if (zzCurrentPos >= zzBuffer.Length)
            {
                /* if not: blow it up */
                char[] newBuffer = new char[zzCurrentPos * 2];
                System.Array.Copy(zzBuffer, 0, newBuffer, 0, zzBuffer.Length);
                zzBuffer = newBuffer;
            }

            /* readonlyly: fill the buffer with new input */
            int numRead = zzReader.Read(zzBuffer, zzEndRead,
                                                    zzBuffer.Length - zzEndRead);

            if (numRead > 0)
            {
                zzEndRead += numRead;
                return false;
            }
            // unlikely but not impossible: read 0 characters, but not at end of stream    
            if (numRead == 0)
            {
                int c = zzReader.Read();
                if (c == -1)
                {
                    return true;
                }
                else
                {
                    zzBuffer[zzEndRead++] = (char)c;
                    return false;
                }
            }

            // numRead < 0
            return true;
        }


        /// <summary>
        /// Disposes the input stream.
        /// </summary>
        public void YyClose()
        {
            zzAtEOF = true;            /* indicate end of file */
            zzEndRead = zzStartRead;  /* invalidate buffer    */

            if (zzReader != null)
                zzReader.Dispose();
        }


        /// <summary>
        /// Resets the scanner to read from a new input stream.
        /// Does not close the old reader.
        /// <para/>
        /// All internal variables are reset, the old input stream 
        /// <b>cannot</b> be reused (internal buffer is discarded and lost).
        /// Lexical state is set to <see cref="YYINITIAL"/>.
        /// <para/>
        /// Internal scan buffer is resized down to its initial length, if it has grown.
        /// </summary>
        /// <param name="reader">the new input stream </param>
        public void YyReset(TextReader reader)
        {
            zzReader = reader;
            zzAtBOL = true;
            zzAtEOF = false;
            zzEOFDone = false;
            zzEndRead = zzStartRead = 0;
            zzCurrentPos = zzMarkedPos = 0;
            yyline = yyChar = yycolumn = 0;
            zzLexicalState = YYINITIAL;
            if (zzBuffer.Length > ZZ_BUFFERSIZE)
                zzBuffer = new char[ZZ_BUFFERSIZE];
        }


        /// <summary>
        /// Returns the current lexical state.
        /// </summary>
        public int YyState
        {
            get { return zzLexicalState; }
        }


        /// <summary>
        /// Enters a new lexical state
        /// </summary>
        /// <param name="newState">the new lexical state</param>
        public void YyBegin(int newState)
        {
            zzLexicalState = newState;
        }


        /// <summary>
        /// Returns the text matched by the current regular expression.
        /// </summary>
        public string YyText
        {
            get { return new string(zzBuffer, zzStartRead, zzMarkedPos - zzStartRead); }
        }


        /// <summary>
        /// Returns the character at position <paramref name="pos"/> from the 
        /// matched text.
        /// <para/>
        /// It is equivalent to YyText[pos], but faster
        /// </summary>
        /// <param name="pos">
        /// the position of the character to fetch. 
        /// A value from 0 to YyLength-1.
        /// </param>
        /// <returns>the character at position pos</returns>
        public char YyCharAt(int pos)
        {
            return zzBuffer[zzStartRead + pos];
        }


        /// <summary>
        /// Returns the length of the matched text region.
        /// </summary>
        public int YyLength
        {
            get { return zzMarkedPos - zzStartRead; }
        }


        /// <summary>
        /// Reports an error that occured while scanning.
        /// <para/>
        /// In a wellformed scanner (no or only correct usage of 
        /// YyPushBack(int) and a match-all fallback rule) this method 
        /// will only be called with things that "Can't Possibly Happen".
        /// If this method is called, something is seriously wrong
        /// (e.g. a JFlex bug producing a faulty scanner etc.).
        /// <para/>
        /// Usual syntax/scanner level error handling should be done
        /// in error fallback rules.
        /// </summary>
        /// <param name="errorCode">the code of the errormessage to display</param>
        private void ZzScanError(int errorCode)
        {
            string message;
            try
            {
                message = ZZ_ERROR_MSG[errorCode];
            }
            catch (IndexOutOfRangeException /*e*/)
            {
                message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
            }

            throw new Exception(message);
        }


        /// <summary>
        /// Pushes the specified amount of characters back into the input stream.
        /// <para/>
        /// They will be read again by then next call of the scanning method
        /// </summary>
        /// <param name="number">
        /// the number of characters to be read again.
        /// This number must not be greater than YyLength!
        /// </param>
        public void YyPushBack(int number)
        {
            if (number > YyLength)
                ZzScanError(ZZ_PUSHBACK_2BIG);

            zzMarkedPos -= number;
        }


        /// <summary>
        /// Resumes scanning until the next regular expression is matched,
        /// the end of input is encountered or an I/O-Error occurs.
        /// </summary>
        /// <returns>the next token</returns>
        /// <exception cref="IOException">if any I/O-Error occurs</exception>
        public int GetNextToken()
        {
            int zzInput;
            int zzAction;

            // cached fields:
            int zzCurrentPosL;
            int zzMarkedPosL;
            int zzEndReadL = zzEndRead;
            char[] zzBufferL = zzBuffer;
            char[] zzCMapL = ZZ_CMAP;

            int[] zzTransL = ZZ_TRANS;
            int[] zzRowMapL = ZZ_ROWMAP;
            int[] zzAttrL = ZZ_ATTRIBUTE;

            while (true)
            {
                zzMarkedPosL = zzMarkedPos;

                yyChar += zzMarkedPosL - zzStartRead;

                zzAction = -1;

                zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

                zzState = ZZ_LEXSTATE[zzLexicalState];

                // set up zzAction for empty match case:
                int zzAttributes = zzAttrL[zzState];
                if ((zzAttributes & 1) == 1)
                {
                    zzAction = zzState;
                }



                while (true)
                {

                    if (zzCurrentPosL < zzEndReadL)
                        zzInput = zzBufferL[zzCurrentPosL++];
                    else if (zzAtEOF)
                    {
                        zzInput = YYEOF;
                        goto zzForActionBreak;
                    }
                    else
                    {
                        // store back cached positions
                        zzCurrentPos = zzCurrentPosL;
                        zzMarkedPos = zzMarkedPosL;
                        bool eof = ZzRefill();
                        // get translated positions and possibly new buffer
                        zzCurrentPosL = zzCurrentPos;
                        zzMarkedPosL = zzMarkedPos;
                        zzBufferL = zzBuffer;
                        zzEndReadL = zzEndRead;
                        if (eof)
                        {
                            zzInput = YYEOF;
                            goto zzForActionBreak;
                        }
                        else
                        {
                            zzInput = zzBufferL[zzCurrentPosL++];
                        }
                    }
                    int zzNext = zzTransL[zzRowMapL[zzState] + zzCMapL[zzInput]];
                    if (zzNext == -1) goto zzForActionBreak;
                    zzState = zzNext;

                    zzAttributes = zzAttrL[zzState];
                    if ((zzAttributes & 1) == 1)
                    {
                        zzAction = zzState;
                        zzMarkedPosL = zzCurrentPosL;
                        if ((zzAttributes & 8) == 8) goto zzForActionBreak;
                    }

                }
                zzForActionBreak:

                // store back cached position
                zzMarkedPos = zzMarkedPosL;

                switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction])
                {
                    case 1:
                        { /* Break so we don't hit fall-through warning: */
                            break; /* Not numeric, word, ideographic, hiragana, or SE Asian -- ignore it. */
                        }
                    case 9: break;
                    case 2:
                        {
                            return WORD_TYPE;
                        }
                    case 10: break;
                    case 3:
                        {
                            return NUMERIC_TYPE;
                        }
                    case 11: break;
                    case 4:
                        {
                            return KATAKANA_TYPE;
                        }
                    case 12: break;
                    case 5:
                        {
                            return SOUTH_EAST_ASIAN_TYPE;
                        }
                    case 13: break;
                    case 6:
                        {
                            return IDEOGRAPHIC_TYPE;
                        }
                    case 14: break;
                    case 7:
                        {
                            return HIRAGANA_TYPE;
                        }
                    case 15: break;
                    case 8:
                        {
                            return HANGUL_TYPE;
                        }
                    case 16: break;
                    default:
                        if (zzInput == YYEOF && zzStartRead == zzCurrentPos)
                        {
                            zzAtEOF = true;
                            {
                                return StandardTokenizerInterface.YYEOF;
                            }
                        }
                        else
                        {
                            ZzScanError(ZZ_NO_MATCH);
                        }
                        break;
                }
            }
        }
    }
}
