﻿/*

Copyright (c) 2001, Dr Martin Porter
Copyright (c) 2002, Richard Boulton
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
    * this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
    * notice, this list of conditions and the following disclaimer in the
    * documentation and/or other materials provided with the distribution.
    * Neither the name of the copyright holders nor the names of its contributors
    * may be used to endorse or promote products derived from this software
    * without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 */

namespace Lucene.Net.Tartarus.Snowball.Ext
{
    /// <summary>
    /// This class was automatically generated by a Snowball to Java compiler
    /// It implements the stemming algorithm defined by a snowball script.
    /// </summary>
    public class LovinsStemmer : SnowballProgram
    {
        private readonly static LovinsStemmer methodObject = new LovinsStemmer();

        private readonly static Among[] a_0 = {
                    new Among ( "d", -1, -1, "", methodObject ),
                    new Among ( "f", -1, -1, "", methodObject ),
                    new Among ( "ph", -1, -1, "", methodObject ),
                    new Among ( "th", -1, -1, "", methodObject ),
                    new Among ( "l", -1, -1, "", methodObject ),
                    new Among ( "er", -1, -1, "", methodObject ),
                    new Among ( "or", -1, -1, "", methodObject ),
                    new Among ( "es", -1, -1, "", methodObject ),
                    new Among ( "t", -1, -1, "", methodObject )
                };

        private readonly static Among[] a_1 = {
                    new Among ( "s'", -1, 1, "r_A", methodObject ),
                    new Among ( "a", -1, 1, "r_A", methodObject ),
                    new Among ( "ia", 1, 1, "r_A", methodObject ),
                    new Among ( "ata", 1, 1, "r_A", methodObject ),
                    new Among ( "ic", -1, 1, "r_A", methodObject ),
                    new Among ( "aic", 4, 1, "r_A", methodObject ),
                    new Among ( "allic", 4, 1, "r_BB", methodObject ),
                    new Among ( "aric", 4, 1, "r_A", methodObject ),
                    new Among ( "atic", 4, 1, "r_B", methodObject ),
                    new Among ( "itic", 4, 1, "r_H", methodObject ),
                    new Among ( "antic", 4, 1, "r_C", methodObject ),
                    new Among ( "istic", 4, 1, "r_A", methodObject ),
                    new Among ( "alistic", 11, 1, "r_B", methodObject ),
                    new Among ( "aristic", 11, 1, "r_A", methodObject ),
                    new Among ( "ivistic", 11, 1, "r_A", methodObject ),
                    new Among ( "ed", -1, 1, "r_E", methodObject ),
                    new Among ( "anced", 15, 1, "r_B", methodObject ),
                    new Among ( "enced", 15, 1, "r_A", methodObject ),
                    new Among ( "ished", 15, 1, "r_A", methodObject ),
                    new Among ( "ied", 15, 1, "r_A", methodObject ),
                    new Among ( "ened", 15, 1, "r_E", methodObject ),
                    new Among ( "ioned", 15, 1, "r_A", methodObject ),
                    new Among ( "ated", 15, 1, "r_I", methodObject ),
                    new Among ( "ented", 15, 1, "r_C", methodObject ),
                    new Among ( "ized", 15, 1, "r_F", methodObject ),
                    new Among ( "arized", 24, 1, "r_A", methodObject ),
                    new Among ( "oid", -1, 1, "r_A", methodObject ),
                    new Among ( "aroid", 26, 1, "r_A", methodObject ),
                    new Among ( "hood", -1, 1, "r_A", methodObject ),
                    new Among ( "ehood", 28, 1, "r_A", methodObject ),
                    new Among ( "ihood", 28, 1, "r_A", methodObject ),
                    new Among ( "elihood", 30, 1, "r_E", methodObject ),
                    new Among ( "ward", -1, 1, "r_A", methodObject ),
                    new Among ( "e", -1, 1, "r_A", methodObject ),
                    new Among ( "ae", 33, 1, "r_A", methodObject ),
                    new Among ( "ance", 33, 1, "r_B", methodObject ),
                    new Among ( "icance", 35, 1, "r_A", methodObject ),
                    new Among ( "ence", 33, 1, "r_A", methodObject ),
                    new Among ( "ide", 33, 1, "r_L", methodObject ),
                    new Among ( "icide", 38, 1, "r_A", methodObject ),
                    new Among ( "otide", 38, 1, "r_A", methodObject ),
                    new Among ( "age", 33, 1, "r_B", methodObject ),
                    new Among ( "able", 33, 1, "r_A", methodObject ),
                    new Among ( "atable", 42, 1, "r_A", methodObject ),
                    new Among ( "izable", 42, 1, "r_E", methodObject ),
                    new Among ( "arizable", 44, 1, "r_A", methodObject ),
                    new Among ( "ible", 33, 1, "r_A", methodObject ),
                    new Among ( "encible", 46, 1, "r_A", methodObject ),
                    new Among ( "ene", 33, 1, "r_E", methodObject ),
                    new Among ( "ine", 33, 1, "r_M", methodObject ),
                    new Among ( "idine", 49, 1, "r_I", methodObject ),
                    new Among ( "one", 33, 1, "r_R", methodObject ),
                    new Among ( "ature", 33, 1, "r_E", methodObject ),
                    new Among ( "eature", 52, 1, "r_Z", methodObject ),
                    new Among ( "ese", 33, 1, "r_A", methodObject ),
                    new Among ( "wise", 33, 1, "r_A", methodObject ),
                    new Among ( "ate", 33, 1, "r_A", methodObject ),
                    new Among ( "entiate", 56, 1, "r_A", methodObject ),
                    new Among ( "inate", 56, 1, "r_A", methodObject ),
                    new Among ( "ionate", 56, 1, "r_D", methodObject ),
                    new Among ( "ite", 33, 1, "r_AA", methodObject ),
                    new Among ( "ive", 33, 1, "r_A", methodObject ),
                    new Among ( "ative", 61, 1, "r_A", methodObject ),
                    new Among ( "ize", 33, 1, "r_F", methodObject ),
                    new Among ( "alize", 63, 1, "r_A", methodObject ),
                    new Among ( "icalize", 64, 1, "r_A", methodObject ),
                    new Among ( "ialize", 64, 1, "r_A", methodObject ),
                    new Among ( "entialize", 66, 1, "r_A", methodObject ),
                    new Among ( "ionalize", 64, 1, "r_A", methodObject ),
                    new Among ( "arize", 63, 1, "r_A", methodObject ),
                    new Among ( "ing", -1, 1, "r_N", methodObject ),
                    new Among ( "ancing", 70, 1, "r_B", methodObject ),
                    new Among ( "encing", 70, 1, "r_A", methodObject ),
                    new Among ( "aging", 70, 1, "r_B", methodObject ),
                    new Among ( "ening", 70, 1, "r_E", methodObject ),
                    new Among ( "ioning", 70, 1, "r_A", methodObject ),
                    new Among ( "ating", 70, 1, "r_I", methodObject ),
                    new Among ( "enting", 70, 1, "r_C", methodObject ),
                    new Among ( "ying", 70, 1, "r_B", methodObject ),
                    new Among ( "izing", 70, 1, "r_F", methodObject ),
                    new Among ( "arizing", 79, 1, "r_A", methodObject ),
                    new Among ( "ish", -1, 1, "r_C", methodObject ),
                    new Among ( "yish", 81, 1, "r_A", methodObject ),
                    new Among ( "i", -1, 1, "r_A", methodObject ),
                    new Among ( "al", -1, 1, "r_BB", methodObject ),
                    new Among ( "ical", 84, 1, "r_A", methodObject ),
                    new Among ( "aical", 85, 1, "r_A", methodObject ),
                    new Among ( "istical", 85, 1, "r_A", methodObject ),
                    new Among ( "oidal", 84, 1, "r_A", methodObject ),
                    new Among ( "eal", 84, 1, "r_Y", methodObject ),
                    new Among ( "ial", 84, 1, "r_A", methodObject ),
                    new Among ( "ancial", 90, 1, "r_A", methodObject ),
                    new Among ( "arial", 90, 1, "r_A", methodObject ),
                    new Among ( "ential", 90, 1, "r_A", methodObject ),
                    new Among ( "ional", 84, 1, "r_A", methodObject ),
                    new Among ( "ational", 94, 1, "r_B", methodObject ),
                    new Among ( "izational", 95, 1, "r_A", methodObject ),
                    new Among ( "ental", 84, 1, "r_A", methodObject ),
                    new Among ( "ful", -1, 1, "r_A", methodObject ),
                    new Among ( "eful", 98, 1, "r_A", methodObject ),
                    new Among ( "iful", 98, 1, "r_A", methodObject ),
                    new Among ( "yl", -1, 1, "r_R", methodObject ),
                    new Among ( "ism", -1, 1, "r_B", methodObject ),
                    new Among ( "icism", 102, 1, "r_A", methodObject ),
                    new Among ( "oidism", 102, 1, "r_A", methodObject ),
                    new Among ( "alism", 102, 1, "r_B", methodObject ),
                    new Among ( "icalism", 105, 1, "r_A", methodObject ),
                    new Among ( "ionalism", 105, 1, "r_A", methodObject ),
                    new Among ( "inism", 102, 1, "r_J", methodObject ),
                    new Among ( "ativism", 102, 1, "r_A", methodObject ),
                    new Among ( "um", -1, 1, "r_U", methodObject ),
                    new Among ( "ium", 110, 1, "r_A", methodObject ),
                    new Among ( "ian", -1, 1, "r_A", methodObject ),
                    new Among ( "ician", 112, 1, "r_A", methodObject ),
                    new Among ( "en", -1, 1, "r_F", methodObject ),
                    new Among ( "ogen", 114, 1, "r_A", methodObject ),
                    new Among ( "on", -1, 1, "r_S", methodObject ),
                    new Among ( "ion", 116, 1, "r_Q", methodObject ),
                    new Among ( "ation", 117, 1, "r_B", methodObject ),
                    new Among ( "ication", 118, 1, "r_G", methodObject ),
                    new Among ( "entiation", 118, 1, "r_A", methodObject ),
                    new Among ( "ination", 118, 1, "r_A", methodObject ),
                    new Among ( "isation", 118, 1, "r_A", methodObject ),
                    new Among ( "arisation", 122, 1, "r_A", methodObject ),
                    new Among ( "entation", 118, 1, "r_A", methodObject ),
                    new Among ( "ization", 118, 1, "r_F", methodObject ),
                    new Among ( "arization", 125, 1, "r_A", methodObject ),
                    new Among ( "action", 117, 1, "r_G", methodObject ),
                    new Among ( "o", -1, 1, "r_A", methodObject ),
                    new Among ( "ar", -1, 1, "r_X", methodObject ),
                    new Among ( "ear", 129, 1, "r_Y", methodObject ),
                    new Among ( "ier", -1, 1, "r_A", methodObject ),
                    new Among ( "ariser", -1, 1, "r_A", methodObject ),
                    new Among ( "izer", -1, 1, "r_F", methodObject ),
                    new Among ( "arizer", 133, 1, "r_A", methodObject ),
                    new Among ( "or", -1, 1, "r_T", methodObject ),
                    new Among ( "ator", 135, 1, "r_A", methodObject ),
                    new Among ( "s", -1, 1, "r_W", methodObject ),
                    new Among ( "'s", 137, 1, "r_A", methodObject ),
                    new Among ( "as", 137, 1, "r_B", methodObject ),
                    new Among ( "ics", 137, 1, "r_A", methodObject ),
                    new Among ( "istics", 140, 1, "r_A", methodObject ),
                    new Among ( "es", 137, 1, "r_E", methodObject ),
                    new Among ( "ances", 142, 1, "r_B", methodObject ),
                    new Among ( "ences", 142, 1, "r_A", methodObject ),
                    new Among ( "ides", 142, 1, "r_L", methodObject ),
                    new Among ( "oides", 145, 1, "r_A", methodObject ),
                    new Among ( "ages", 142, 1, "r_B", methodObject ),
                    new Among ( "ies", 142, 1, "r_P", methodObject ),
                    new Among ( "acies", 148, 1, "r_A", methodObject ),
                    new Among ( "ancies", 148, 1, "r_A", methodObject ),
                    new Among ( "encies", 148, 1, "r_A", methodObject ),
                    new Among ( "aries", 148, 1, "r_A", methodObject ),
                    new Among ( "ities", 148, 1, "r_A", methodObject ),
                    new Among ( "alities", 153, 1, "r_A", methodObject ),
                    new Among ( "ivities", 153, 1, "r_A", methodObject ),
                    new Among ( "ines", 142, 1, "r_M", methodObject ),
                    new Among ( "nesses", 142, 1, "r_A", methodObject ),
                    new Among ( "ates", 142, 1, "r_A", methodObject ),
                    new Among ( "atives", 142, 1, "r_A", methodObject ),
                    new Among ( "ings", 137, 1, "r_N", methodObject ),
                    new Among ( "is", 137, 1, "r_A", methodObject ),
                    new Among ( "als", 137, 1, "r_BB", methodObject ),
                    new Among ( "ials", 162, 1, "r_A", methodObject ),
                    new Among ( "entials", 163, 1, "r_A", methodObject ),
                    new Among ( "ionals", 162, 1, "r_A", methodObject ),
                    new Among ( "isms", 137, 1, "r_B", methodObject ),
                    new Among ( "ians", 137, 1, "r_A", methodObject ),
                    new Among ( "icians", 167, 1, "r_A", methodObject ),
                    new Among ( "ions", 137, 1, "r_B", methodObject ),
                    new Among ( "ations", 169, 1, "r_B", methodObject ),
                    new Among ( "arisations", 170, 1, "r_A", methodObject ),
                    new Among ( "entations", 170, 1, "r_A", methodObject ),
                    new Among ( "izations", 170, 1, "r_A", methodObject ),
                    new Among ( "arizations", 173, 1, "r_A", methodObject ),
                    new Among ( "ars", 137, 1, "r_O", methodObject ),
                    new Among ( "iers", 137, 1, "r_A", methodObject ),
                    new Among ( "izers", 137, 1, "r_F", methodObject ),
                    new Among ( "ators", 137, 1, "r_A", methodObject ),
                    new Among ( "less", 137, 1, "r_A", methodObject ),
                    new Among ( "eless", 179, 1, "r_A", methodObject ),
                    new Among ( "ness", 137, 1, "r_A", methodObject ),
                    new Among ( "eness", 181, 1, "r_E", methodObject ),
                    new Among ( "ableness", 182, 1, "r_A", methodObject ),
                    new Among ( "eableness", 183, 1, "r_E", methodObject ),
                    new Among ( "ibleness", 182, 1, "r_A", methodObject ),
                    new Among ( "ateness", 182, 1, "r_A", methodObject ),
                    new Among ( "iteness", 182, 1, "r_A", methodObject ),
                    new Among ( "iveness", 182, 1, "r_A", methodObject ),
                    new Among ( "ativeness", 188, 1, "r_A", methodObject ),
                    new Among ( "ingness", 181, 1, "r_A", methodObject ),
                    new Among ( "ishness", 181, 1, "r_A", methodObject ),
                    new Among ( "iness", 181, 1, "r_A", methodObject ),
                    new Among ( "ariness", 192, 1, "r_E", methodObject ),
                    new Among ( "alness", 181, 1, "r_A", methodObject ),
                    new Among ( "icalness", 194, 1, "r_A", methodObject ),
                    new Among ( "antialness", 194, 1, "r_A", methodObject ),
                    new Among ( "entialness", 194, 1, "r_A", methodObject ),
                    new Among ( "ionalness", 194, 1, "r_A", methodObject ),
                    new Among ( "fulness", 181, 1, "r_A", methodObject ),
                    new Among ( "lessness", 181, 1, "r_A", methodObject ),
                    new Among ( "ousness", 181, 1, "r_A", methodObject ),
                    new Among ( "eousness", 201, 1, "r_A", methodObject ),
                    new Among ( "iousness", 201, 1, "r_A", methodObject ),
                    new Among ( "itousness", 201, 1, "r_A", methodObject ),
                    new Among ( "entness", 181, 1, "r_A", methodObject ),
                    new Among ( "ants", 137, 1, "r_B", methodObject ),
                    new Among ( "ists", 137, 1, "r_A", methodObject ),
                    new Among ( "icists", 207, 1, "r_A", methodObject ),
                    new Among ( "us", 137, 1, "r_V", methodObject ),
                    new Among ( "ous", 209, 1, "r_A", methodObject ),
                    new Among ( "eous", 210, 1, "r_A", methodObject ),
                    new Among ( "aceous", 211, 1, "r_A", methodObject ),
                    new Among ( "antaneous", 211, 1, "r_A", methodObject ),
                    new Among ( "ious", 210, 1, "r_A", methodObject ),
                    new Among ( "acious", 214, 1, "r_B", methodObject ),
                    new Among ( "itous", 210, 1, "r_A", methodObject ),
                    new Among ( "ant", -1, 1, "r_B", methodObject ),
                    new Among ( "icant", 217, 1, "r_A", methodObject ),
                    new Among ( "ent", -1, 1, "r_C", methodObject ),
                    new Among ( "ement", 219, 1, "r_A", methodObject ),
                    new Among ( "izement", 220, 1, "r_A", methodObject ),
                    new Among ( "ist", -1, 1, "r_A", methodObject ),
                    new Among ( "icist", 222, 1, "r_A", methodObject ),
                    new Among ( "alist", 222, 1, "r_A", methodObject ),
                    new Among ( "icalist", 224, 1, "r_A", methodObject ),
                    new Among ( "ialist", 224, 1, "r_A", methodObject ),
                    new Among ( "ionist", 222, 1, "r_A", methodObject ),
                    new Among ( "entist", 222, 1, "r_A", methodObject ),
                    new Among ( "y", -1, 1, "r_B", methodObject ),
                    new Among ( "acy", 229, 1, "r_A", methodObject ),
                    new Among ( "ancy", 229, 1, "r_B", methodObject ),
                    new Among ( "ency", 229, 1, "r_A", methodObject ),
                    new Among ( "ly", 229, 1, "r_B", methodObject ),
                    new Among ( "ealy", 233, 1, "r_Y", methodObject ),
                    new Among ( "ably", 233, 1, "r_A", methodObject ),
                    new Among ( "ibly", 233, 1, "r_A", methodObject ),
                    new Among ( "edly", 233, 1, "r_E", methodObject ),
                    new Among ( "iedly", 237, 1, "r_A", methodObject ),
                    new Among ( "ely", 233, 1, "r_E", methodObject ),
                    new Among ( "ately", 239, 1, "r_A", methodObject ),
                    new Among ( "ively", 239, 1, "r_A", methodObject ),
                    new Among ( "atively", 241, 1, "r_A", methodObject ),
                    new Among ( "ingly", 233, 1, "r_B", methodObject ),
                    new Among ( "atingly", 243, 1, "r_A", methodObject ),
                    new Among ( "ily", 233, 1, "r_A", methodObject ),
                    new Among ( "lily", 245, 1, "r_A", methodObject ),
                    new Among ( "arily", 245, 1, "r_A", methodObject ),
                    new Among ( "ally", 233, 1, "r_B", methodObject ),
                    new Among ( "ically", 248, 1, "r_A", methodObject ),
                    new Among ( "aically", 249, 1, "r_A", methodObject ),
                    new Among ( "allically", 249, 1, "r_C", methodObject ),
                    new Among ( "istically", 249, 1, "r_A", methodObject ),
                    new Among ( "alistically", 252, 1, "r_B", methodObject ),
                    new Among ( "oidally", 248, 1, "r_A", methodObject ),
                    new Among ( "ially", 248, 1, "r_A", methodObject ),
                    new Among ( "entially", 255, 1, "r_A", methodObject ),
                    new Among ( "ionally", 248, 1, "r_A", methodObject ),
                    new Among ( "ationally", 257, 1, "r_B", methodObject ),
                    new Among ( "izationally", 258, 1, "r_B", methodObject ),
                    new Among ( "entally", 248, 1, "r_A", methodObject ),
                    new Among ( "fully", 233, 1, "r_A", methodObject ),
                    new Among ( "efully", 261, 1, "r_A", methodObject ),
                    new Among ( "ifully", 261, 1, "r_A", methodObject ),
                    new Among ( "enly", 233, 1, "r_E", methodObject ),
                    new Among ( "arly", 233, 1, "r_K", methodObject ),
                    new Among ( "early", 265, 1, "r_Y", methodObject ),
                    new Among ( "lessly", 233, 1, "r_A", methodObject ),
                    new Among ( "ously", 233, 1, "r_A", methodObject ),
                    new Among ( "eously", 268, 1, "r_A", methodObject ),
                    new Among ( "iously", 268, 1, "r_A", methodObject ),
                    new Among ( "ently", 233, 1, "r_A", methodObject ),
                    new Among ( "ary", 229, 1, "r_F", methodObject ),
                    new Among ( "ery", 229, 1, "r_E", methodObject ),
                    new Among ( "icianry", 229, 1, "r_A", methodObject ),
                    new Among ( "atory", 229, 1, "r_A", methodObject ),
                    new Among ( "ity", 229, 1, "r_A", methodObject ),
                    new Among ( "acity", 276, 1, "r_A", methodObject ),
                    new Among ( "icity", 276, 1, "r_A", methodObject ),
                    new Among ( "eity", 276, 1, "r_A", methodObject ),
                    new Among ( "ality", 276, 1, "r_A", methodObject ),
                    new Among ( "icality", 280, 1, "r_A", methodObject ),
                    new Among ( "iality", 280, 1, "r_A", methodObject ),
                    new Among ( "antiality", 282, 1, "r_A", methodObject ),
                    new Among ( "entiality", 282, 1, "r_A", methodObject ),
                    new Among ( "ionality", 280, 1, "r_A", methodObject ),
                    new Among ( "elity", 276, 1, "r_A", methodObject ),
                    new Among ( "ability", 276, 1, "r_A", methodObject ),
                    new Among ( "izability", 287, 1, "r_A", methodObject ),
                    new Among ( "arizability", 288, 1, "r_A", methodObject ),
                    new Among ( "ibility", 276, 1, "r_A", methodObject ),
                    new Among ( "inity", 276, 1, "r_CC", methodObject ),
                    new Among ( "arity", 276, 1, "r_B", methodObject ),
                    new Among ( "ivity", 276, 1, "r_A", methodObject )
                };

        private readonly static Among[] a_2 = {
                    new Among ( "bb", -1, -1, "", methodObject ),
                    new Among ( "dd", -1, -1, "", methodObject ),
                    new Among ( "gg", -1, -1, "", methodObject ),
                    new Among ( "ll", -1, -1, "", methodObject ),
                    new Among ( "mm", -1, -1, "", methodObject ),
                    new Among ( "nn", -1, -1, "", methodObject ),
                    new Among ( "pp", -1, -1, "", methodObject ),
                    new Among ( "rr", -1, -1, "", methodObject ),
                    new Among ( "ss", -1, -1, "", methodObject ),
                    new Among ( "tt", -1, -1, "", methodObject )
                };

        private readonly static Among[] a_3 = {
                    new Among ( "uad", -1, 18, "", methodObject ),
                    new Among ( "vad", -1, 19, "", methodObject ),
                    new Among ( "cid", -1, 20, "", methodObject ),
                    new Among ( "lid", -1, 21, "", methodObject ),
                    new Among ( "erid", -1, 22, "", methodObject ),
                    new Among ( "pand", -1, 23, "", methodObject ),
                    new Among ( "end", -1, 24, "", methodObject ),
                    new Among ( "ond", -1, 25, "", methodObject ),
                    new Among ( "lud", -1, 26, "", methodObject ),
                    new Among ( "rud", -1, 27, "", methodObject ),
                    new Among ( "ul", -1, 9, "", methodObject ),
                    new Among ( "her", -1, 28, "", methodObject ),
                    new Among ( "metr", -1, 7, "", methodObject ),
                    new Among ( "istr", -1, 6, "", methodObject ),
                    new Among ( "urs", -1, 5, "", methodObject ),
                    new Among ( "uct", -1, 2, "", methodObject ),
                    new Among ( "et", -1, 32, "", methodObject ),
                    new Among ( "mit", -1, 29, "", methodObject ),
                    new Among ( "ent", -1, 30, "", methodObject ),
                    new Among ( "umpt", -1, 3, "", methodObject ),
                    new Among ( "rpt", -1, 4, "", methodObject ),
                    new Among ( "ert", -1, 31, "", methodObject ),
                    new Among ( "yt", -1, 33, "", methodObject ),
                    new Among ( "iev", -1, 1, "", methodObject ),
                    new Among ( "olv", -1, 8, "", methodObject ),
                    new Among ( "ax", -1, 14, "", methodObject ),
                    new Among ( "ex", -1, 15, "", methodObject ),
                    new Among ( "bex", 26, 10, "", methodObject ),
                    new Among ( "dex", 26, 11, "", methodObject ),
                    new Among ( "pex", 26, 12, "", methodObject ),
                    new Among ( "tex", 26, 13, "", methodObject ),
                    new Among ( "ix", -1, 16, "", methodObject ),
                    new Among ( "lux", -1, 17, "", methodObject ),
                    new Among ( "yz", -1, 34, "", methodObject )
                };


        private void copy_from(LovinsStemmer other)
        {
            base.CopyFrom(other);
        }

        private bool r_A()
        {
            // (, line 21
            // hop, line 21
            {
                int c = m_cursor - 2;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            return true;
        }

        private bool r_B()
        {
            // (, line 22
            // hop, line 22
            {
                int c = m_cursor - 3;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            return true;
        }

        private bool r_C()
        {
            // (, line 23
            // hop, line 23
            {
                int c = m_cursor - 4;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            return true;
        }

        private bool r_D()
        {
            // (, line 24
            // hop, line 24
            {
                int c = m_cursor - 5;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            return true;
        }

        private bool r_E()
        {
            int v_1;
            int v_2;
            // (, line 25
            // test, line 25
            v_1 = m_limit - m_cursor;
            // hop, line 25
            {
                int c = m_cursor - 2;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // not, line 25
            {
                v_2 = m_limit - m_cursor;
                do
                {
                    // literal, line 25
                    if (!(Eq_S_B(1, "e")))
                    {
                        goto lab0;
                    }
                    return false;
                } while (false);
                lab0:
                m_cursor = m_limit - v_2;
            }
            return true;
        }

        private bool r_F()
        {
            int v_1;
            int v_2;
            // (, line 26
            // test, line 26
            v_1 = m_limit - m_cursor;
            // hop, line 26
            {
                int c = m_cursor - 3;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // not, line 26
            {
                v_2 = m_limit - m_cursor;
                do
                {
                    // literal, line 26
                    if (!(Eq_S_B(1, "e")))
                    {
                        goto lab0;
                    }
                    return false;
                } while (false);
                lab0:
                m_cursor = m_limit - v_2;
            }
            return true;
        }

        private bool r_G()
        {
            int v_1;
            // (, line 27
            // test, line 27
            v_1 = m_limit - m_cursor;
            // hop, line 27
            {
                int c = m_cursor - 3;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // literal, line 27
            if (!(Eq_S_B(1, "f")))
            {
                return false;
            }
            return true;
        }

        private bool r_H()
        {
            int v_1;
            int v_2;
            // (, line 28
            // test, line 28
            v_1 = m_limit - m_cursor;
            // hop, line 28
            {
                int c = m_cursor - 2;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // or, line 28
            do
            {
                v_2 = m_limit - m_cursor;
                do
                {
                    // literal, line 28
                    if (!(Eq_S_B(1, "t")))
                    {
                        goto lab1;
                    }
                    goto lab0;
                } while (false);
                lab1:
                m_cursor = m_limit - v_2;
                // literal, line 28
                if (!(Eq_S_B(2, "ll")))
                {
                    return false;
                }
            } while (false);
            lab0:
            return true;
        }

        private bool r_I()
        {
            int v_1;
            int v_2;
            int v_3;
            // (, line 29
            // test, line 29
            v_1 = m_limit - m_cursor;
            // hop, line 29
            {
                int c = m_cursor - 2;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // not, line 29
            {
                v_2 = m_limit - m_cursor;
                do
                {
                    // literal, line 29
                    if (!(Eq_S_B(1, "o")))
                    {
                        goto lab0;
                    }
                    return false;
                } while (false);
                lab0:
                m_cursor = m_limit - v_2;
            }
            // not, line 29
            {
                v_3 = m_limit - m_cursor;
                do
                {
                    // literal, line 29
                    if (!(Eq_S_B(1, "e")))
                    {
                        goto lab1;
                    }
                    return false;
                } while (false);
                lab1:
                m_cursor = m_limit - v_3;
            }
            return true;
        }

        private bool r_J()
        {
            int v_1;
            int v_2;
            int v_3;
            // (, line 30
            // test, line 30
            v_1 = m_limit - m_cursor;
            // hop, line 30
            {
                int c = m_cursor - 2;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // not, line 30
            {
                v_2 = m_limit - m_cursor;
                do
                {
                    // literal, line 30
                    if (!(Eq_S_B(1, "a")))
                    {
                        goto lab0;
                    }
                    return false;
                } while (false);
                lab0:
                m_cursor = m_limit - v_2;
            }
            // not, line 30
            {
                v_3 = m_limit - m_cursor;
                do
                {
                    // literal, line 30
                    if (!(Eq_S_B(1, "e")))
                    {
                        goto lab1;
                    }
                    return false;
                } while (false);
                lab1:
                m_cursor = m_limit - v_3;
            }
            return true;
        }

        private bool r_K()
        {
            int v_1;
            int v_2;
            // (, line 31
            // test, line 31
            v_1 = m_limit - m_cursor;
            // hop, line 31
            {
                int c = m_cursor - 3;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // or, line 31
            do
            {
                v_2 = m_limit - m_cursor;
                do
                {
                    // literal, line 31
                    if (!(Eq_S_B(1, "l")))
                    {
                        goto lab1;
                    }
                    goto lab0;
                } while (false);
                lab1:
                m_cursor = m_limit - v_2;
                do
                {
                    // literal, line 31
                    if (!(Eq_S_B(1, "i")))
                    {
                        goto lab2;
                    }
                    goto lab0;
                } while (false);
                lab2:
                m_cursor = m_limit - v_2;
                // (, line 31
                // literal, line 31
                if (!(Eq_S_B(1, "e")))
                {
                    return false;
                }
                // next, line 31
                if (m_cursor <= m_limit_backward)
                {
                    return false;
                }
                m_cursor--;
                // literal, line 31
                if (!(Eq_S_B(1, "u")))
                {
                    return false;
                }
            } while (false);
            lab0:
            return true;
        }

        private bool r_L()
        {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            // (, line 32
            // test, line 32
            v_1 = m_limit - m_cursor;
            // hop, line 32
            {
                int c = m_cursor - 2;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // not, line 32
            {
                v_2 = m_limit - m_cursor;
                do
                {
                    // literal, line 32
                    if (!(Eq_S_B(1, "u")))
                    {
                        goto lab0;
                    }
                    return false;
                } while (false);
                lab0:
                m_cursor = m_limit - v_2;
            }
            // not, line 32
            {
                v_3 = m_limit - m_cursor;
                do
                {
                    // literal, line 32
                    if (!(Eq_S_B(1, "x")))
                    {
                        goto lab1;
                    }
                    return false;
                } while (false);
                lab1:
                m_cursor = m_limit - v_3;
            }
            // not, line 32
            {
                v_4 = m_limit - m_cursor;
                do
                {
                    // (, line 32
                    // literal, line 32
                    if (!(Eq_S_B(1, "s")))
                    {
                        goto lab2;
                    }
                    // not, line 32
                    {
                        v_5 = m_limit - m_cursor;
                        do
                        {
                            // literal, line 32
                            if (!(Eq_S_B(1, "o")))
                            {
                                goto lab3;
                            }
                            goto lab2;
                        } while (false);
                        lab3:
                        m_cursor = m_limit - v_5;
                    }
                    return false;
                } while (false);
                lab2:
                m_cursor = m_limit - v_4;
            }
            return true;
        }

        private bool r_M()
        {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            // (, line 33
            // test, line 33
            v_1 = m_limit - m_cursor;
            // hop, line 33
            {
                int c = m_cursor - 2;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // not, line 33
            {
                v_2 = m_limit - m_cursor;
                do
                {
                    // literal, line 33
                    if (!(Eq_S_B(1, "a")))
                    {
                        goto lab0;
                    }
                    return false;
                } while (false);
                lab0:
                m_cursor = m_limit - v_2;
            }
            // not, line 33
            {
                v_3 = m_limit - m_cursor;
                do
                {
                    // literal, line 33
                    if (!(Eq_S_B(1, "c")))
                    {
                        goto lab1;
                    }
                    return false;
                } while (false);
                lab1:
                m_cursor = m_limit - v_3;
            }
            // not, line 33
            {
                v_4 = m_limit - m_cursor;
                do
                {
                    // literal, line 33
                    if (!(Eq_S_B(1, "e")))
                    {
                        goto lab2;
                    }
                    return false;
                } while (false);
                lab2:
                m_cursor = m_limit - v_4;
            }
            // not, line 33
            {
                v_5 = m_limit - m_cursor;
                do
                {
                    // literal, line 33
                    if (!(Eq_S_B(1, "m")))
                    {
                        goto lab3;
                    }
                    return false;
                } while (false);
                lab3:
                m_cursor = m_limit - v_5;
            }
            return true;
        }

        private bool r_N()
        {
            int v_1;
            int v_2;
            int v_3;
            // (, line 34
            // test, line 34
            v_1 = m_limit - m_cursor;
            // hop, line 34
            {
                int c = m_cursor - 3;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // (, line 34
            // hop, line 34
            {
                int c = m_cursor - 2;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            // or, line 34
            do
            {
                v_2 = m_limit - m_cursor;
                do
                {
                    // not, line 34
                    {
                        v_3 = m_limit - m_cursor;
                        do
                        {
                            // literal, line 34
                            if (!(Eq_S_B(1, "s")))
                            {
                                goto lab2;
                            }
                            goto lab1;
                        } while (false);
                        lab2:
                        m_cursor = m_limit - v_3;
                    }
                    goto lab0;
                } while (false);
                lab1:
                m_cursor = m_limit - v_2;
                // hop, line 34
                {
                    int c = m_cursor - 2;
                    if (m_limit_backward > c || c > m_limit)
                    {
                        return false;
                    }
                    m_cursor = c;
                }
            } while (false);
            lab0:
            return true;
        }

        private bool r_O()
        {
            int v_1;
            int v_2;
            // (, line 35
            // test, line 35
            v_1 = m_limit - m_cursor;
            // hop, line 35
            {
                int c = m_cursor - 2;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // or, line 35
            do
            {
                v_2 = m_limit - m_cursor;
                do
                {
                    // literal, line 35
                    if (!(Eq_S_B(1, "l")))
                    {
                        goto lab1;
                    }
                    goto lab0;
                } while (false);
                lab1:
                m_cursor = m_limit - v_2;
                // literal, line 35
                if (!(Eq_S_B(1, "i")))
                {
                    return false;
                }
            } while (false);
            lab0:
            return true;
        }

        private bool r_P()
        {
            int v_1;
            int v_2;
            // (, line 36
            // test, line 36
            v_1 = m_limit - m_cursor;
            // hop, line 36
            {
                int c = m_cursor - 2;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // not, line 36
            {
                v_2 = m_limit - m_cursor;
                do
                {
                    // literal, line 36
                    if (!(Eq_S_B(1, "c")))
                    {
                        goto lab0;
                    }
                    return false;
                } while (false);
                lab0:
                m_cursor = m_limit - v_2;
            }
            return true;
        }

        private bool r_Q()
        {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            // (, line 37
            // test, line 37
            v_1 = m_limit - m_cursor;
            // hop, line 37
            {
                int c = m_cursor - 2;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // test, line 37
            v_2 = m_limit - m_cursor;
            // hop, line 37
            {
                int c = m_cursor - 3;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_2;
            // not, line 37
            {
                v_3 = m_limit - m_cursor;
                do
                {
                    // literal, line 37
                    if (!(Eq_S_B(1, "l")))
                    {
                        goto lab0;
                    }
                    return false;
                } while (false);
                lab0:
                m_cursor = m_limit - v_3;
            }
            // not, line 37
            {
                v_4 = m_limit - m_cursor;
                do
                {
                    // literal, line 37
                    if (!(Eq_S_B(1, "n")))
                    {
                        goto lab1;
                    }
                    return false;
                } while (false);
                lab1:
                m_cursor = m_limit - v_4;
            }
            return true;
        }

        private bool r_R()
        {
            int v_1;
            int v_2;
            // (, line 38
            // test, line 38
            v_1 = m_limit - m_cursor;
            // hop, line 38
            {
                int c = m_cursor - 2;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // or, line 38
            do
            {
                v_2 = m_limit - m_cursor;
                do
                {
                    // literal, line 38
                    if (!(Eq_S_B(1, "n")))
                    {
                        goto lab1;
                    }
                    goto lab0;
                } while (false);
                lab1:
                m_cursor = m_limit - v_2;
                // literal, line 38
                if (!(Eq_S_B(1, "r")))
                {
                    return false;
                }
            } while (false);
            lab0:
            return true;
        }

        private bool r_S()
        {
            int v_1;
            int v_2;
            int v_3;
            // (, line 39
            // test, line 39
            v_1 = m_limit - m_cursor;
            // hop, line 39
            {
                int c = m_cursor - 2;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // or, line 39
            do
            {
                v_2 = m_limit - m_cursor;
                do
                {
                    // literal, line 39
                    if (!(Eq_S_B(2, "dr")))
                    {
                        goto lab1;
                    }
                    goto lab0;
                } while (false);
                lab1:
                m_cursor = m_limit - v_2;
                // (, line 39
                // literal, line 39
                if (!(Eq_S_B(1, "t")))
                {
                    return false;
                }
                // not, line 39
                {
                    v_3 = m_limit - m_cursor;
                    do
                    {
                        // literal, line 39
                        if (!(Eq_S_B(1, "t")))
                        {
                            goto lab2;
                        }
                        return false;
                    } while (false);
                    lab2:
                    m_cursor = m_limit - v_3;
                }
            } while (false);
            lab0:
            return true;
        }

        private bool r_T()
        {
            int v_1;
            int v_2;
            int v_3;
            // (, line 40
            // test, line 40
            v_1 = m_limit - m_cursor;
            // hop, line 40
            {
                int c = m_cursor - 2;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // or, line 40
            do
            {
                v_2 = m_limit - m_cursor;
                do
                {
                    // literal, line 40
                    if (!(Eq_S_B(1, "s")))
                    {
                        goto lab1;
                    }
                    goto lab0;
                } while (false);
                lab1:
                m_cursor = m_limit - v_2;
                // (, line 40
                // literal, line 40
                if (!(Eq_S_B(1, "t")))
                {
                    return false;
                }
                // not, line 40
                {
                    v_3 = m_limit - m_cursor;
                    do
                    {
                        // literal, line 40
                        if (!(Eq_S_B(1, "o")))
                        {
                            goto lab2;
                        }
                        return false;
                    } while (false);
                    lab2:
                    m_cursor = m_limit - v_3;
                }
            } while (false);
            lab0:
            return true;
        }

        private bool r_U()
        {
            int v_1;
            int v_2;
            // (, line 41
            // test, line 41
            v_1 = m_limit - m_cursor;
            // hop, line 41
            {
                int c = m_cursor - 2;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // or, line 41
            do
            {
                v_2 = m_limit - m_cursor;
                do
                {
                    // literal, line 41
                    if (!(Eq_S_B(1, "l")))
                    {
                        goto lab1;
                    }
                    goto lab0;
                } while (false);
                lab1:
                m_cursor = m_limit - v_2;
                do
                {
                    // literal, line 41
                    if (!(Eq_S_B(1, "m")))
                    {
                        goto lab2;
                    }
                    goto lab0;
                } while (false);
                lab2:
                m_cursor = m_limit - v_2;
                do
                {
                    // literal, line 41
                    if (!(Eq_S_B(1, "n")))
                    {
                        goto lab3;
                    }
                    goto lab0;
                } while (false);
                lab3:
                m_cursor = m_limit - v_2;
                // literal, line 41
                if (!(Eq_S_B(1, "r")))
                {
                    return false;
                }
            } while (false);
            lab0:
            return true;
        }

        private bool r_V()
        {
            int v_1;
            // (, line 42
            // test, line 42
            v_1 = m_limit - m_cursor;
            // hop, line 42
            {
                int c = m_cursor - 2;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // literal, line 42
            if (!(Eq_S_B(1, "c")))
            {
                return false;
            }
            return true;
        }

        private bool r_W()
        {
            int v_1;
            int v_2;
            int v_3;
            // (, line 43
            // test, line 43
            v_1 = m_limit - m_cursor;
            // hop, line 43
            {
                int c = m_cursor - 2;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // not, line 43
            {
                v_2 = m_limit - m_cursor;
                do
                {
                    // literal, line 43
                    if (!(Eq_S_B(1, "s")))
                    {
                        goto lab0;
                    }
                    return false;
                } while (false);
                lab0:
                m_cursor = m_limit - v_2;
            }
            // not, line 43
            {
                v_3 = m_limit - m_cursor;
                do
                {
                    // literal, line 43
                    if (!(Eq_S_B(1, "u")))
                    {
                        goto lab1;
                    }
                    return false;
                } while (false);
                lab1:
                m_cursor = m_limit - v_3;
            }
            return true;
        }

        private bool r_X()
        {
            int v_1;
            int v_2;
            // (, line 44
            // test, line 44
            v_1 = m_limit - m_cursor;
            // hop, line 44
            {
                int c = m_cursor - 2;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // or, line 44
            do
            {
                v_2 = m_limit - m_cursor;
                do
                {
                    // literal, line 44
                    if (!(Eq_S_B(1, "l")))
                    {
                        goto lab1;
                    }
                    goto lab0;
                } while (false);
                lab1:
                m_cursor = m_limit - v_2;
                do
                {
                    // literal, line 44
                    if (!(Eq_S_B(1, "i")))
                    {
                        goto lab2;
                    }
                    goto lab0;
                } while (false);
                lab2:
                m_cursor = m_limit - v_2;
                // (, line 44
                // literal, line 44
                if (!(Eq_S_B(1, "e")))
                {
                    return false;
                }
                // next, line 44
                if (m_cursor <= m_limit_backward)
                {
                    return false;
                }
                m_cursor--;
                // literal, line 44
                if (!(Eq_S_B(1, "u")))
                {
                    return false;
                }
            } while (false);
            lab0:
            return true;
        }

        private bool r_Y()
        {
            int v_1;
            // (, line 45
            // test, line 45
            v_1 = m_limit - m_cursor;
            // hop, line 45
            {
                int c = m_cursor - 2;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // literal, line 45
            if (!(Eq_S_B(2, "in")))
            {
                return false;
            }
            return true;
        }

        private bool r_Z()
        {
            int v_1;
            int v_2;
            // (, line 46
            // test, line 46
            v_1 = m_limit - m_cursor;
            // hop, line 46
            {
                int c = m_cursor - 2;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // not, line 46
            {
                v_2 = m_limit - m_cursor;
                do
                {
                    // literal, line 46
                    if (!(Eq_S_B(1, "f")))
                    {
                        goto lab0;
                    }
                    return false;
                } while (false);
                lab0:
                m_cursor = m_limit - v_2;
            }
            return true;
        }

        private bool r_AA()
        {
            int v_1;
            // (, line 47
            // test, line 47
            v_1 = m_limit - m_cursor;
            // hop, line 47
            {
                int c = m_cursor - 2;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // among, line 47
            if (FindAmongB(a_0, 9) == 0)
            {
                return false;
            }
            return true;
        }

        private bool r_BB()
        {
            int v_1;
            int v_2;
            int v_3;
            // (, line 49
            // test, line 49
            v_1 = m_limit - m_cursor;
            // hop, line 49
            {
                int c = m_cursor - 3;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // not, line 49
            {
                v_2 = m_limit - m_cursor;
                do
                {
                    // literal, line 49
                    if (!(Eq_S_B(3, "met")))
                    {
                        goto lab0;
                    }
                    return false;
                } while (false);
                lab0:
                m_cursor = m_limit - v_2;
            }
            // not, line 49
            {
                v_3 = m_limit - m_cursor;
                do
                {
                    // literal, line 49
                    if (!(Eq_S_B(4, "ryst")))
                    {
                        goto lab1;
                    }
                    return false;
                } while (false);
                lab1:
                m_cursor = m_limit - v_3;
            }
            return true;
        }

        private bool r_CC()
        {
            int v_1;
            // (, line 50
            // test, line 50
            v_1 = m_limit - m_cursor;
            // hop, line 50
            {
                int c = m_cursor - 2;
                if (m_limit_backward > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = m_limit - v_1;
            // literal, line 50
            if (!(Eq_S_B(1, "l")))
            {
                return false;
            }
            return true;
        }

        private bool r_endings()
        {
            int among_var;
            // (, line 55
            // [, line 56
            m_ket = m_cursor;
            // substring, line 56
            among_var = FindAmongB(a_1, 294);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 56
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 145
                    // delete, line 145
                    SliceDel();
                    break;
            }
            return true;
        }

        private bool r_undouble()
        {
            int v_1;
            // (, line 151
            // test, line 152
            v_1 = m_limit - m_cursor;
            // substring, line 152
            if (FindAmongB(a_2, 10) == 0)
            {
                return false;
            }
            m_cursor = m_limit - v_1;
            // [, line 154
            m_ket = m_cursor;
            // next, line 154
            if (m_cursor <= m_limit_backward)
            {
                return false;
            }
            m_cursor--;
            // ], line 154
            m_bra = m_cursor;
            // delete, line 154
            SliceDel();
            return true;
        }

        private bool r_respell()
        {
            int among_var;
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            int v_6;
            int v_7;
            int v_8;
            // (, line 159
            // [, line 160
            m_ket = m_cursor;
            // substring, line 160
            among_var = FindAmongB(a_3, 34);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 160
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 161
                    // <-, line 161
                    SliceFrom("ief");
                    break;
                case 2:
                    // (, line 162
                    // <-, line 162
                    SliceFrom("uc");
                    break;
                case 3:
                    // (, line 163
                    // <-, line 163
                    SliceFrom("um");
                    break;
                case 4:
                    // (, line 164
                    // <-, line 164
                    SliceFrom("rb");
                    break;
                case 5:
                    // (, line 165
                    // <-, line 165
                    SliceFrom("ur");
                    break;
                case 6:
                    // (, line 166
                    // <-, line 166
                    SliceFrom("ister");
                    break;
                case 7:
                    // (, line 167
                    // <-, line 167
                    SliceFrom("meter");
                    break;
                case 8:
                    // (, line 168
                    // <-, line 168
                    SliceFrom("olut");
                    break;
                case 9:
                    // (, line 169
                    // not, line 169
                    {
                        v_1 = m_limit - m_cursor;
                        do
                        {
                            // literal, line 169
                            if (!(Eq_S_B(1, "a")))
                            {
                                goto lab0;
                            }
                            return false;
                        } while (false);
                        lab0:
                        m_cursor = m_limit - v_1;
                    }
                    // not, line 169
                    {
                        v_2 = m_limit - m_cursor;
                        do
                        {
                            // literal, line 169
                            if (!(Eq_S_B(1, "i")))
                            {
                                goto lab1;
                            }
                            return false;
                        } while (false);
                        lab1:
                        m_cursor = m_limit - v_2;
                    }
                    // not, line 169
                    {
                        v_3 = m_limit - m_cursor;
                        do
                        {
                            // literal, line 169
                            if (!(Eq_S_B(1, "o")))
                            {
                                goto lab2;
                            }
                            return false;
                        } while (false);
                        lab2:
                        m_cursor = m_limit - v_3;
                    }
                    // <-, line 169
                    SliceFrom("l");
                    break;
                case 10:
                    // (, line 170
                    // <-, line 170
                    SliceFrom("bic");
                    break;
                case 11:
                    // (, line 171
                    // <-, line 171
                    SliceFrom("dic");
                    break;
                case 12:
                    // (, line 172
                    // <-, line 172
                    SliceFrom("pic");
                    break;
                case 13:
                    // (, line 173
                    // <-, line 173
                    SliceFrom("tic");
                    break;
                case 14:
                    // (, line 174
                    // <-, line 174
                    SliceFrom("ac");
                    break;
                case 15:
                    // (, line 175
                    // <-, line 175
                    SliceFrom("ec");
                    break;
                case 16:
                    // (, line 176
                    // <-, line 176
                    SliceFrom("ic");
                    break;
                case 17:
                    // (, line 177
                    // <-, line 177
                    SliceFrom("luc");
                    break;
                case 18:
                    // (, line 178
                    // <-, line 178
                    SliceFrom("uas");
                    break;
                case 19:
                    // (, line 179
                    // <-, line 179
                    SliceFrom("vas");
                    break;
                case 20:
                    // (, line 180
                    // <-, line 180
                    SliceFrom("cis");
                    break;
                case 21:
                    // (, line 181
                    // <-, line 181
                    SliceFrom("lis");
                    break;
                case 22:
                    // (, line 182
                    // <-, line 182
                    SliceFrom("eris");
                    break;
                case 23:
                    // (, line 183
                    // <-, line 183
                    SliceFrom("pans");
                    break;
                case 24:
                    // (, line 184
                    // not, line 184
                    {
                        v_4 = m_limit - m_cursor;
                        do
                        {
                            // literal, line 184
                            if (!(Eq_S_B(1, "s")))
                            {
                                goto lab3;
                            }
                            return false;
                        } while (false);
                        lab3:
                        m_cursor = m_limit - v_4;
                    }
                    // <-, line 184
                    SliceFrom("ens");
                    break;
                case 25:
                    // (, line 185
                    // <-, line 185
                    SliceFrom("ons");
                    break;
                case 26:
                    // (, line 186
                    // <-, line 186
                    SliceFrom("lus");
                    break;
                case 27:
                    // (, line 187
                    // <-, line 187
                    SliceFrom("rus");
                    break;
                case 28:
                    // (, line 188
                    // not, line 188
                    {
                        v_5 = m_limit - m_cursor;
                        do
                        {
                            // literal, line 188
                            if (!(Eq_S_B(1, "p")))
                            {
                                goto lab4;
                            }
                            return false;
                        } while (false);
                        lab4:
                        m_cursor = m_limit - v_5;
                    }
                    // not, line 188
                    {
                        v_6 = m_limit - m_cursor;
                        do
                        {
                            // literal, line 188
                            if (!(Eq_S_B(1, "t")))
                            {
                                goto lab5;
                            }
                            return false;
                        } while (false);
                        lab5:
                        m_cursor = m_limit - v_6;
                    }
                    // <-, line 188
                    SliceFrom("hes");
                    break;
                case 29:
                    // (, line 189
                    // <-, line 189
                    SliceFrom("mis");
                    break;
                case 30:
                    // (, line 190
                    // not, line 190
                    {
                        v_7 = m_limit - m_cursor;
                        do
                        {
                            // literal, line 190
                            if (!(Eq_S_B(1, "m")))
                            {
                                goto lab6;
                            }
                            return false;
                        } while (false);
                        lab6:
                        m_cursor = m_limit - v_7;
                    }
                    // <-, line 190
                    SliceFrom("ens");
                    break;
                case 31:
                    // (, line 192
                    // <-, line 192
                    SliceFrom("ers");
                    break;
                case 32:
                    // (, line 193
                    // not, line 193
                    {
                        v_8 = m_limit - m_cursor;
                        do
                        {
                            // literal, line 193
                            if (!(Eq_S_B(1, "n")))
                            {
                                goto lab7;
                            }
                            return false;
                        } while (false);
                        lab7:
                        m_cursor = m_limit - v_8;
                    }
                    // <-, line 193
                    SliceFrom("es");
                    break;
                case 33:
                    // (, line 194
                    // <-, line 194
                    SliceFrom("ys");
                    break;
                case 34:
                    // (, line 195
                    // <-, line 195
                    SliceFrom("ys");
                    break;
            }
            return true;
        }


        public override bool Stem()
        {
            int v_1;
            int v_2;
            int v_3;
            // (, line 200
            // backwards, line 202
            m_limit_backward = m_cursor; m_cursor = m_limit;
            // (, line 202
            // do, line 203
            v_1 = m_limit - m_cursor;
            do
            {
                // call endings, line 203
                if (!r_endings())
                {
                    goto lab0;
                }
            } while (false);
            lab0:
            m_cursor = m_limit - v_1;
            // do, line 204
            v_2 = m_limit - m_cursor;
            do
            {
                // call undouble, line 204
                if (!r_undouble())
                {
                    goto lab1;
                }
            } while (false);
            lab1:
            m_cursor = m_limit - v_2;
            // do, line 205
            v_3 = m_limit - m_cursor;
            do
            {
                // call respell, line 205
                if (!r_respell())
                {
                    goto lab2;
                }
            } while (false);
            lab2:
            m_cursor = m_limit - v_3;
            m_cursor = m_limit_backward; return true;
        }


        public override bool Equals(object o)
        {
            return o is LovinsStemmer;
        }

        public override int GetHashCode()
        {
            return this.GetType().FullName.GetHashCode();
        }
    }
}
