/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.fuzzyml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.manifoldcf.core.fuzzyml.AttrNameValue;
import org.apache.manifoldcf.core.fuzzyml.SingleCharacterReceiver;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.system.Logging;

public class TagParseState
extends SingleCharacterReceiver {
    protected static final int TAGPARSESTATE_NORMAL = 0;
    protected static final int TAGPARSESTATE_SAWLEFTANGLE = 1;
    protected static final int TAGPARSESTATE_SAWEXCLAMATION = 2;
    protected static final int TAGPARSESTATE_SAWDASH = 3;
    protected static final int TAGPARSESTATE_IN_COMMENT = 4;
    protected static final int TAGPARSESTATE_SAWCOMMENTDASH = 5;
    protected static final int TAGPARSESTATE_SAWSECONDCOMMENTDASH = 6;
    protected static final int TAGPARSESTATE_IN_TAG_NAME = 7;
    protected static final int TAGPARSESTATE_IN_ATTR_NAME = 8;
    protected static final int TAGPARSESTATE_IN_ATTR_VALUE = 9;
    protected static final int TAGPARSESTATE_IN_TAG_SAW_SLASH = 10;
    protected static final int TAGPARSESTATE_IN_END_TAG_NAME = 11;
    protected static final int TAGPARSESTATE_IN_ATTR_LOOKING_FOR_VALUE = 12;
    protected static final int TAGPARSESTATE_IN_SINGLE_QUOTES_ATTR_VALUE = 13;
    protected static final int TAGPARSESTATE_IN_DOUBLE_QUOTES_ATTR_VALUE = 14;
    protected static final int TAGPARSESTATE_IN_UNQUOTED_ATTR_VALUE = 15;
    protected static final int TAGPARSESTATE_IN_QTAG_NAME = 16;
    protected static final int TAGPARSESTATE_IN_QTAG_ATTR_NAME = 17;
    protected static final int TAGPARSESTATE_IN_QTAG_SAW_QUESTION = 18;
    protected static final int TAGPARSESTATE_IN_QTAG_ATTR_VALUE = 19;
    protected static final int TAGPARSESTATE_IN_QTAG_ATTR_LOOKING_FOR_VALUE = 20;
    protected static final int TAGPARSESTATE_IN_QTAG_SINGLE_QUOTES_ATTR_VALUE = 21;
    protected static final int TAGPARSESTATE_IN_QTAG_DOUBLE_QUOTES_ATTR_VALUE = 22;
    protected static final int TAGPARSESTATE_IN_QTAG_UNQUOTED_ATTR_VALUE = 23;
    protected static final int TAGPARSESTATE_IN_BRACKET_TOKEN = 24;
    protected static final int TAGPARSESTATE_NEED_FINAL_BRACKET = 25;
    protected static final int TAGPARSESTATE_IN_BANG_TOKEN = 26;
    protected static final int TAGPARSESTATE_IN_CDATA_BODY = 27;
    protected static final int TAGPARSESTATE_SAWRIGHTBRACKET = 28;
    protected static final int TAGPARSESTATE_SAWSECONDRIGHTBRACKET = 29;
    protected int currentState = 0;
    protected int bTagDepth = 0;
    protected StringBuilder accumBuffer = new StringBuilder();
    protected StringBuilder currentTagNameBuffer = null;
    protected StringBuilder currentAttrNameBuffer = null;
    protected StringBuilder currentValueBuffer = null;
    protected String currentTagName = null;
    protected String currentAttrName = null;
    protected List<AttrNameValue> currentAttrList = null;
    protected boolean inAmpersand = false;
    protected StringBuilder ampBuffer = new StringBuilder();
    protected static final Map<String, String> mapLookup = new HashMap<String, String>();

    public TagParseState() {
        super(65536);
    }

    @Override
    public boolean dealWithCharacter(char thisChar) throws ManifoldCFException {
        switch (this.currentState) {
            case 0: {
                if (thisChar == '<') {
                    if (this.inAmpersand) {
                        this.outputAmpBuffer();
                        this.inAmpersand = false;
                    }
                    this.currentState = 1;
                    break;
                }
                if (this.bTagDepth > 0 && thisChar == '>') {
                    if (this.currentTagNameBuffer != null && this.currentTagNameBuffer.length() > 0) {
                        this.currentTagName = this.currentTagNameBuffer.toString();
                        if (this.noteBTagToken(this.currentTagName)) {
                            return true;
                        }
                        this.currentTagName = null;
                        this.currentTagNameBuffer = null;
                    }
                    if (this.noteEndBTag()) {
                        return true;
                    }
                    --this.bTagDepth;
                    break;
                }
                if (this.bTagDepth == 0) {
                    if (this.inAmpersand) {
                        if (thisChar == ';') {
                            this.ampBuffer.append(thisChar);
                            if (this.outputAmpBuffer()) {
                                return true;
                            }
                            this.inAmpersand = false;
                            break;
                        }
                        if (TagParseState.isWhitespace(thisChar)) {
                            if (this.outputAmpBuffer()) {
                                return true;
                            }
                            this.inAmpersand = false;
                            if (!this.noteNormalCharacter(thisChar)) break;
                            return true;
                        }
                        this.ampBuffer.append(thisChar);
                        break;
                    }
                    if (thisChar == '&') {
                        this.inAmpersand = true;
                        this.ampBuffer.setLength(0);
                        break;
                    }
                    if (!this.noteNormalCharacter(thisChar)) break;
                    return true;
                }
                if (TagParseState.isPunctuation(thisChar)) {
                    if (this.currentTagNameBuffer != null && this.currentTagNameBuffer.length() > 0) {
                        this.currentTagName = this.currentTagNameBuffer.toString();
                        if (this.noteBTagToken(this.currentTagName)) {
                            return true;
                        }
                        this.currentTagNameBuffer = null;
                        this.currentTagName = null;
                    }
                    if (!this.noteBTagToken("" + thisChar)) break;
                    return true;
                }
                if (TagParseState.isWhitespace(thisChar)) {
                    if (this.currentTagNameBuffer == null || this.currentTagNameBuffer.length() <= 0) break;
                    this.currentTagName = this.currentTagNameBuffer.toString();
                    if (this.noteBTagToken(this.currentTagName)) {
                        return true;
                    }
                    this.currentTagNameBuffer = null;
                    this.currentTagName = null;
                    break;
                }
                if (this.currentTagNameBuffer == null) {
                    this.currentTagNameBuffer = this.newBuffer();
                }
                this.currentTagNameBuffer.append(thisChar);
                break;
            }
            case 27: {
                if (thisChar == ']') {
                    this.currentState = 28;
                    break;
                }
                if (!this.noteEscapedCharacter(thisChar)) break;
                return true;
            }
            case 28: {
                if (thisChar == ']') {
                    this.currentState = 29;
                    break;
                }
                this.currentState = 27;
                if (this.noteEscapedCharacter(']')) {
                    return true;
                }
                if (!this.noteEscapedCharacter(thisChar)) break;
                return true;
            }
            case 29: {
                if (thisChar == '>') {
                    this.currentState = 0;
                    break;
                }
                if (thisChar == ']') {
                    if (!this.noteEscapedCharacter(']')) break;
                    return true;
                }
                this.currentState = 27;
                if (this.noteEscapedCharacter(']')) {
                    return true;
                }
                if (this.noteEscapedCharacter(']')) {
                    return true;
                }
                if (!this.noteEscapedCharacter(thisChar)) break;
                return true;
            }
            case 1: {
                if (thisChar == '!') {
                    this.currentState = 2;
                    break;
                }
                if (thisChar == '?') {
                    this.currentState = 16;
                    this.currentTagNameBuffer = this.newBuffer();
                    break;
                }
                if (this.bTagDepth == 0 && thisChar == '/') {
                    this.currentState = 11;
                    this.currentTagNameBuffer = this.newBuffer();
                    break;
                }
                if (this.bTagDepth == 0) {
                    if (TagParseState.isWhitespace(thisChar)) {
                        this.currentState = 0;
                        if (this.noteNormalCharacter('<')) {
                            return true;
                        }
                        if (!this.noteNormalCharacter(thisChar)) break;
                        return true;
                    }
                    this.currentState = 7;
                    this.currentTagNameBuffer = this.newBuffer();
                    this.currentTagNameBuffer.append(thisChar);
                    break;
                }
                if (this.noteBTagToken("<")) {
                    return true;
                }
                if (!TagParseState.isWhitespace(thisChar)) {
                    this.currentTagNameBuffer = this.newBuffer();
                    this.currentTagNameBuffer.append(thisChar);
                }
                this.currentState = 0;
                break;
            }
            case 2: {
                if (thisChar == '-') {
                    this.currentState = 3;
                    break;
                }
                if (thisChar == '[') {
                    this.currentState = 24;
                    this.currentTagNameBuffer = this.newBuffer();
                    break;
                }
                ++this.bTagDepth;
                this.currentState = 26;
                this.currentTagNameBuffer = this.newBuffer();
                if (TagParseState.isWhitespace(thisChar)) break;
                this.currentTagNameBuffer.append(thisChar);
                break;
            }
            case 3: {
                if (thisChar == '-') {
                    this.currentState = 4;
                    break;
                }
                this.currentState = 0;
                break;
            }
            case 4: {
                if (thisChar != '-') break;
                this.currentState = 5;
                break;
            }
            case 5: {
                if (thisChar == '-') {
                    this.currentState = 6;
                    break;
                }
                this.currentState = 4;
                break;
            }
            case 6: {
                if (thisChar == '>') {
                    this.currentState = 0;
                    break;
                }
                if (thisChar == '-') break;
                this.currentState = 4;
                break;
            }
            case 16: {
                if (TagParseState.isWhitespace(thisChar)) {
                    if (this.currentTagNameBuffer.length() <= 0) break;
                    this.currentTagName = this.currentTagNameBuffer.toString();
                    this.currentTagNameBuffer = null;
                    this.currentAttrList = new ArrayList<AttrNameValue>();
                    this.currentState = 17;
                    this.currentAttrNameBuffer = this.newBuffer();
                    break;
                }
                if (thisChar == '?') {
                    if (this.currentTagNameBuffer.length() > 0) {
                        this.currentTagName = this.currentTagNameBuffer.toString();
                        this.currentTagNameBuffer = null;
                        this.currentAttrList = new ArrayList<AttrNameValue>();
                        this.currentState = 18;
                        if (!this.noteQTag(this.currentTagName, this.currentAttrList)) break;
                        return true;
                    }
                    this.currentState = 0;
                    this.currentTagNameBuffer = null;
                    break;
                }
                if (thisChar == '>') {
                    if (this.currentTagNameBuffer.length() > 0) {
                        this.currentTagName = this.currentTagNameBuffer.toString();
                        this.currentTagNameBuffer = null;
                        this.currentAttrList = new ArrayList<AttrNameValue>();
                    }
                    if (this.currentTagName != null && this.noteQTag(this.currentTagName, this.currentAttrList)) {
                        return true;
                    }
                    this.currentState = 0;
                    this.currentTagName = null;
                    this.currentAttrList = null;
                    break;
                }
                this.currentTagNameBuffer.append(thisChar);
                break;
            }
            case 24: {
                if (TagParseState.isWhitespace(thisChar)) {
                    if (this.currentTagNameBuffer.length() <= 0) break;
                    this.currentTagName = this.currentTagNameBuffer.toString();
                    this.currentTagNameBuffer = null;
                    this.currentState = 25;
                    break;
                }
                if (thisChar == '[') {
                    this.currentTagName = this.currentTagNameBuffer.toString();
                    this.currentTagNameBuffer = null;
                    this.currentState = 27;
                    if (this.noteEscaped(this.currentTagName)) {
                        return true;
                    }
                    this.currentTagName = null;
                    break;
                }
                this.currentTagNameBuffer.append(thisChar);
                break;
            }
            case 25: {
                if (thisChar != '[') break;
                if (this.noteEscaped(this.currentTagName)) {
                    return true;
                }
                this.currentTagName = null;
                this.currentState = 27;
                break;
            }
            case 26: {
                if (TagParseState.isWhitespace(thisChar)) {
                    if (this.currentTagNameBuffer.length() <= 0) break;
                    this.currentTagName = this.currentTagNameBuffer.toString();
                    this.currentTagNameBuffer = null;
                    if (this.noteBTag(this.currentTagName)) {
                        return true;
                    }
                    this.currentTagName = null;
                    this.currentState = 0;
                    break;
                }
                if (thisChar == '>') {
                    this.currentTagName = this.currentTagNameBuffer.toString();
                    this.currentTagNameBuffer = null;
                    if (this.noteBTag(this.currentTagName)) {
                        return true;
                    }
                    this.currentTagName = null;
                    this.currentState = 0;
                    if (this.noteEndBTag()) {
                        return true;
                    }
                    --this.bTagDepth;
                    break;
                }
                this.currentTagNameBuffer.append(thisChar);
                break;
            }
            case 7: {
                if (TagParseState.isWhitespace(thisChar)) {
                    if (this.currentTagNameBuffer.length() <= 0) break;
                    this.currentTagName = this.currentTagNameBuffer.toString();
                    this.currentTagNameBuffer = null;
                    this.currentAttrList = new ArrayList<AttrNameValue>();
                    this.currentState = 8;
                    this.currentAttrNameBuffer = this.newBuffer();
                    break;
                }
                if (thisChar == '/') {
                    if (this.currentTagNameBuffer.length() > 0) {
                        this.currentTagName = this.currentTagNameBuffer.toString();
                        this.currentTagNameBuffer = null;
                        this.currentAttrList = new ArrayList<AttrNameValue>();
                        this.currentState = 10;
                        if (!this.noteTag(this.currentTagName, this.currentAttrList)) break;
                        return true;
                    }
                    this.currentState = 0;
                    this.currentTagNameBuffer = null;
                    break;
                }
                if (thisChar == '>') {
                    if (this.currentTagNameBuffer.length() > 0) {
                        this.currentTagName = this.currentTagNameBuffer.toString();
                        this.currentTagNameBuffer = null;
                        this.currentAttrList = new ArrayList<AttrNameValue>();
                    }
                    if (this.currentTagName != null && this.noteTag(this.currentTagName, this.currentAttrList)) {
                        return true;
                    }
                    this.currentState = 0;
                    this.currentTagName = null;
                    this.currentAttrList = null;
                    break;
                }
                this.currentTagNameBuffer.append(thisChar);
                break;
            }
            case 17: {
                if (TagParseState.isWhitespace(thisChar)) {
                    if (this.currentAttrNameBuffer.length() <= 0) break;
                    this.currentAttrName = this.currentAttrNameBuffer.toString();
                    this.currentAttrNameBuffer = null;
                    this.currentState = 20;
                    break;
                }
                if (thisChar == '=') {
                    if (this.currentAttrNameBuffer.length() <= 0) break;
                    this.currentAttrName = this.currentAttrNameBuffer.toString();
                    this.currentAttrNameBuffer = null;
                    this.currentState = 19;
                    this.currentValueBuffer = this.newBuffer();
                    break;
                }
                if (thisChar == '?') {
                    if (this.currentAttrNameBuffer.length() > 0) {
                        this.currentAttrName = this.currentAttrNameBuffer.toString();
                        this.currentAttrNameBuffer = null;
                    }
                    if (this.currentAttrName != null) {
                        this.currentAttrList.add(new AttrNameValue(this.currentAttrName, ""));
                        this.currentAttrName = null;
                    }
                    if (this.noteQTag(this.currentTagName, this.currentAttrList)) {
                        return true;
                    }
                    this.currentState = 18;
                    break;
                }
                if (thisChar == '>') {
                    if (this.currentAttrNameBuffer.length() > 0) {
                        this.currentAttrName = this.currentAttrNameBuffer.toString();
                        this.currentAttrNameBuffer = null;
                    }
                    if (this.currentAttrName != null) {
                        this.currentAttrList.add(new AttrNameValue(this.currentAttrName, ""));
                        this.currentAttrName = null;
                    }
                    this.currentState = 0;
                    if (this.noteQTag(this.currentTagName, this.currentAttrList)) {
                        return true;
                    }
                    this.currentTagName = null;
                    this.currentAttrList = null;
                    break;
                }
                this.currentAttrNameBuffer.append(thisChar);
                break;
            }
            case 8: {
                if (TagParseState.isWhitespace(thisChar)) {
                    if (this.currentAttrNameBuffer.length() <= 0) break;
                    this.currentAttrName = this.currentAttrNameBuffer.toString();
                    this.currentAttrNameBuffer = null;
                    this.currentState = 12;
                    break;
                }
                if (thisChar == '=') {
                    if (this.currentAttrNameBuffer.length() <= 0) break;
                    this.currentAttrName = this.currentAttrNameBuffer.toString();
                    this.currentAttrNameBuffer = null;
                    this.currentState = 9;
                    this.currentValueBuffer = this.newBuffer();
                    break;
                }
                if (thisChar == '/') {
                    if (this.currentAttrNameBuffer.length() > 0) {
                        this.currentAttrName = this.currentAttrNameBuffer.toString();
                        this.currentAttrNameBuffer = null;
                    }
                    if (this.currentAttrName != null) {
                        this.currentAttrList.add(new AttrNameValue(this.currentAttrName, ""));
                        this.currentAttrName = null;
                    }
                    if (this.noteTag(this.currentTagName, this.currentAttrList)) {
                        return true;
                    }
                    this.currentState = 10;
                    break;
                }
                if (thisChar == '>') {
                    if (this.currentAttrNameBuffer.length() > 0) {
                        this.currentAttrName = this.currentAttrNameBuffer.toString();
                        this.currentAttrNameBuffer = null;
                    }
                    if (this.currentAttrName != null) {
                        this.currentAttrList.add(new AttrNameValue(this.currentAttrName, ""));
                        this.currentAttrName = null;
                    }
                    this.currentState = 0;
                    if (this.noteTag(this.currentTagName, this.currentAttrList)) {
                        return true;
                    }
                    this.currentTagName = null;
                    this.currentAttrList = null;
                    break;
                }
                this.currentAttrNameBuffer.append(thisChar);
                break;
            }
            case 20: {
                if (thisChar == '=') {
                    this.currentState = 19;
                    this.currentValueBuffer = this.newBuffer();
                    break;
                }
                if (thisChar == '>') {
                    this.currentState = 0;
                    if (this.noteQTag(this.currentTagName, this.currentAttrList)) {
                        return true;
                    }
                    this.currentTagName = null;
                    this.currentAttrList = null;
                    break;
                }
                if (thisChar == '?') {
                    this.currentState = 18;
                    this.currentAttrList.add(new AttrNameValue(this.currentAttrName, ""));
                    this.currentAttrName = null;
                    if (!this.noteQTag(this.currentTagName, this.currentAttrList)) break;
                    return true;
                }
                if (TagParseState.isWhitespace(thisChar)) break;
                this.currentAttrList.add(new AttrNameValue(this.currentAttrName, ""));
                this.currentState = 17;
                this.currentAttrNameBuffer = this.newBuffer();
                this.currentAttrNameBuffer.append(thisChar);
                this.currentAttrName = null;
                break;
            }
            case 12: {
                if (thisChar == '=') {
                    this.currentState = 9;
                    this.currentValueBuffer = this.newBuffer();
                    break;
                }
                if (thisChar == '>') {
                    this.currentState = 0;
                    if (this.noteTag(this.currentTagName, this.currentAttrList)) {
                        return true;
                    }
                    this.currentTagName = null;
                    this.currentAttrList = null;
                    break;
                }
                if (thisChar == '/') {
                    this.currentState = 10;
                    this.currentAttrList.add(new AttrNameValue(this.currentAttrName, ""));
                    this.currentAttrName = null;
                    if (!this.noteTag(this.currentTagName, this.currentAttrList)) break;
                    return true;
                }
                if (TagParseState.isWhitespace(thisChar)) break;
                this.currentAttrList.add(new AttrNameValue(this.currentAttrName, ""));
                this.currentState = 8;
                this.currentAttrNameBuffer = this.newBuffer();
                this.currentAttrNameBuffer.append(thisChar);
                this.currentAttrName = null;
                break;
            }
            case 19: {
                if (thisChar == '\'') {
                    this.currentState = 21;
                    break;
                }
                if (thisChar == '\"') {
                    this.currentState = 22;
                    break;
                }
                if (TagParseState.isWhitespace(thisChar)) break;
                this.currentState = 23;
                this.currentValueBuffer.append(thisChar);
                break;
            }
            case 9: {
                if (thisChar == '\'') {
                    this.currentState = 13;
                    break;
                }
                if (thisChar == '\"') {
                    this.currentState = 14;
                    break;
                }
                if (TagParseState.isWhitespace(thisChar)) break;
                this.currentState = 15;
                this.currentValueBuffer.append(thisChar);
                break;
            }
            case 18: {
                if (thisChar != '>') break;
                this.currentState = 0;
                this.currentTagName = null;
                this.currentAttrList = null;
                break;
            }
            case 10: {
                if (thisChar != '>') break;
                if (this.noteEndTag(this.currentTagName)) {
                    return true;
                }
                this.currentState = 0;
                this.currentTagName = null;
                this.currentAttrList = null;
                break;
            }
            case 11: {
                if (TagParseState.isWhitespace(thisChar)) {
                    if (this.currentTagNameBuffer == null || this.currentTagNameBuffer.length() <= 0) break;
                    this.currentTagName = this.currentTagNameBuffer.toString();
                    this.currentTagNameBuffer = null;
                    break;
                }
                if (thisChar == '>') {
                    if (this.currentTagNameBuffer != null && this.currentTagNameBuffer.length() > 0) {
                        this.currentTagName = this.currentTagNameBuffer.toString();
                        this.currentTagNameBuffer = null;
                    }
                    if (this.currentTagName != null && this.noteEndTag(this.currentTagName)) {
                        return true;
                    }
                    this.currentTagName = null;
                    this.currentState = 0;
                    break;
                }
                if (this.currentTagNameBuffer == null) break;
                this.currentTagNameBuffer.append(thisChar);
                break;
            }
            case 21: {
                if (thisChar == '\'' || thisChar == '\n' || thisChar == '\r') {
                    this.currentAttrList.add(new AttrNameValue(this.currentAttrName, TagParseState.attributeDecode(this.currentValueBuffer.toString())));
                    this.currentAttrName = null;
                    this.currentValueBuffer = null;
                    this.currentState = 17;
                    this.currentAttrNameBuffer = this.newBuffer();
                    break;
                }
                this.currentValueBuffer.append(thisChar);
                break;
            }
            case 13: {
                if (thisChar == '\'' || thisChar == '\n' || thisChar == '\r') {
                    this.currentAttrList.add(new AttrNameValue(this.currentAttrName, TagParseState.attributeDecode(this.currentValueBuffer.toString())));
                    this.currentAttrName = null;
                    this.currentValueBuffer = null;
                    this.currentState = 8;
                    this.currentAttrNameBuffer = this.newBuffer();
                    break;
                }
                this.currentValueBuffer.append(thisChar);
                break;
            }
            case 22: {
                if (thisChar == '\"' || thisChar == '\n' || thisChar == '\r') {
                    this.currentAttrList.add(new AttrNameValue(this.currentAttrName, TagParseState.attributeDecode(this.currentValueBuffer.toString())));
                    this.currentAttrName = null;
                    this.currentValueBuffer = null;
                    this.currentState = 17;
                    this.currentAttrNameBuffer = this.newBuffer();
                    break;
                }
                this.currentValueBuffer.append(thisChar);
                break;
            }
            case 14: {
                if (thisChar == '\"' || thisChar == '\n' || thisChar == '\r') {
                    this.currentAttrList.add(new AttrNameValue(this.currentAttrName, TagParseState.attributeDecode(this.currentValueBuffer.toString())));
                    this.currentAttrName = null;
                    this.currentValueBuffer = null;
                    this.currentState = 8;
                    this.currentAttrNameBuffer = this.newBuffer();
                    break;
                }
                this.currentValueBuffer.append(thisChar);
                break;
            }
            case 23: {
                if (TagParseState.isWhitespace(thisChar)) {
                    this.currentAttrList.add(new AttrNameValue(this.currentAttrName, TagParseState.attributeDecode(this.currentValueBuffer.toString())));
                    this.currentAttrName = null;
                    this.currentValueBuffer = null;
                    this.currentState = 17;
                    this.currentAttrNameBuffer = this.newBuffer();
                    break;
                }
                if (thisChar == '?') {
                    this.currentAttrList.add(new AttrNameValue(this.currentAttrName, TagParseState.attributeDecode(this.currentValueBuffer.toString())));
                    if (this.noteTag(this.currentTagName, this.currentAttrList)) {
                        return true;
                    }
                    this.currentState = 18;
                    break;
                }
                if (thisChar == '>') {
                    this.currentAttrList.add(new AttrNameValue(this.currentAttrName, TagParseState.attributeDecode(this.currentValueBuffer.toString())));
                    this.currentAttrName = null;
                    this.currentValueBuffer = null;
                    this.currentState = 0;
                    if (this.noteTag(this.currentTagName, this.currentAttrList)) {
                        return true;
                    }
                    this.currentTagName = null;
                    this.currentAttrList = null;
                    break;
                }
                this.currentValueBuffer.append(thisChar);
                break;
            }
            case 15: {
                if (TagParseState.isWhitespace(thisChar)) {
                    this.currentAttrList.add(new AttrNameValue(this.currentAttrName, TagParseState.attributeDecode(this.currentValueBuffer.toString())));
                    this.currentAttrName = null;
                    this.currentValueBuffer = null;
                    this.currentState = 8;
                    this.currentAttrNameBuffer = this.newBuffer();
                    break;
                }
                if (thisChar == '/') {
                    this.currentAttrList.add(new AttrNameValue(this.currentAttrName, TagParseState.attributeDecode(this.currentValueBuffer.toString())));
                    if (this.noteTag(this.currentTagName, this.currentAttrList)) {
                        return true;
                    }
                    this.currentState = 10;
                    break;
                }
                if (thisChar == '>') {
                    this.currentAttrList.add(new AttrNameValue(this.currentAttrName, TagParseState.attributeDecode(this.currentValueBuffer.toString())));
                    this.currentAttrName = null;
                    this.currentValueBuffer = null;
                    this.currentState = 0;
                    if (this.noteTag(this.currentTagName, this.currentAttrList)) {
                        return true;
                    }
                    this.currentTagName = null;
                    this.currentAttrList = null;
                    break;
                }
                this.currentValueBuffer.append(thisChar);
                break;
            }
            default: {
                throw new ManifoldCFException("Invalid state: " + Integer.toString(this.currentState));
            }
        }
        return false;
    }

    protected StringBuilder newBuffer() {
        this.accumBuffer.setLength(0);
        return this.accumBuffer;
    }

    protected boolean outputAmpBuffer() throws ManifoldCFException {
        String replacement;
        if (this.ampBuffer.length() == 0 || this.ampBuffer.length() == 1 && this.ampBuffer.charAt(0) == ';') {
            if (this.noteNormalCharacter('&')) {
                return true;
            }
            return this.dumpValues(this.ampBuffer.toString());
        }
        String entity = this.ampBuffer.toString();
        if (entity.endsWith(";")) {
            entity = entity.substring(0, entity.length() - 1);
        }
        return (replacement = TagParseState.mapChunk(entity)) != null && this.dumpValues(replacement);
    }

    protected boolean dumpValues(String value) throws ManifoldCFException {
        for (int i = 0; i < value.length(); ++i) {
            if (!this.noteNormalCharacter(value.charAt(i))) continue;
            return true;
        }
        return false;
    }

    protected boolean noteTag(String tagName, List<AttrNameValue> attributes) throws ManifoldCFException {
        if (Logging.misc.isDebugEnabled()) {
            Logging.misc.debug((Object)(" Saw tag '" + tagName + "'"));
        }
        return false;
    }

    protected boolean noteEndTag(String tagName) throws ManifoldCFException {
        if (Logging.misc.isDebugEnabled()) {
            Logging.misc.debug((Object)(" Saw end tag '" + tagName + "'"));
        }
        return false;
    }

    protected boolean noteQTag(String tagName, List<AttrNameValue> attributes) throws ManifoldCFException {
        if (Logging.misc.isDebugEnabled()) {
            Logging.misc.debug((Object)(" Saw QTag '" + tagName + "'"));
        }
        return false;
    }

    protected boolean noteBTag(String tagName) throws ManifoldCFException {
        if (Logging.misc.isDebugEnabled()) {
            Logging.misc.debug((Object)(" Saw BTag '" + tagName + "'"));
        }
        return false;
    }

    protected boolean noteEndBTag() throws ManifoldCFException {
        Logging.misc.debug((Object)" Saw end BTag");
        return false;
    }

    protected boolean noteEscaped(String token) throws ManifoldCFException {
        if (Logging.misc.isDebugEnabled()) {
            Logging.misc.debug((Object)(" Saw escaped block '" + token + "'"));
        }
        return false;
    }

    protected boolean noteEndEscaped() throws ManifoldCFException {
        Logging.misc.debug((Object)" Saw end of escaped block");
        return false;
    }

    protected boolean noteBTagToken(String token) throws ManifoldCFException {
        return false;
    }

    protected boolean noteNormalCharacter(char thisChar) throws ManifoldCFException {
        return false;
    }

    protected boolean noteEscapedCharacter(char thisChar) throws ManifoldCFException {
        return false;
    }

    protected static String attributeDecode(String input) {
        StringBuilder output = new StringBuilder();
        int i = 0;
        while (i < input.length()) {
            String chunk;
            String replacement;
            int index;
            char x;
            if ((x = input.charAt(i++)) == '&' && (index = input.indexOf(";", i)) != -1 && (replacement = TagParseState.mapChunk(chunk = input.substring(i, index))) != null) {
                output.append(replacement);
                i = index + 1;
                continue;
            }
            output.append(x);
        }
        return output.toString();
    }

    protected static String mapChunk(String input) {
        if (input.startsWith("#")) {
            try {
                input = input.substring(1);
                int value = input.startsWith("x") ? Integer.decode("0" + input) : Integer.parseInt(input);
                StringBuilder sb = new StringBuilder();
                sb.append((char)value);
                return sb.toString();
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return mapLookup.get(input);
    }

    protected static boolean isWhitespace(char x) {
        return x <= ' ';
    }

    protected static boolean isPunctuation(char x) {
        return x == '%' || x == '|' || x == '&' || x == '!' || x == '^' || x == ',' || x == ';' || x == '[' || x == ']' || x == '(' || x == ')' || x == ':' || x == '/' || x == '\\' || x == '+' || x == '=';
    }

    static {
        mapLookup.put("amp", "&");
        mapLookup.put("lt", "<");
        mapLookup.put("gt", ">");
        mapLookup.put("quot", "\"");
        mapLookup.put("apos", "'");
    }
}

