/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.i18n;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.manifoldcf.core.i18n.MCFVelocityResourceLoader;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.system.Logging;
import org.apache.velocity.app.VelocityEngine;

public class Messages {
    protected static Set<BundleKey> bundleSet = new HashSet<BundleKey>();
    protected static Set<MessageKey> messageSet = new HashSet<MessageKey>();
    protected static Set<ResourceKey> resourceSet = new HashSet<ResourceKey>();

    protected Messages() {
    }

    public static VelocityEngine createVelocityEngine(Class classInstance) throws ManifoldCFException {
        VelocityEngine engine = new VelocityEngine();
        ExtendedProperties configuration = new ExtendedProperties();
        configuration.setProperty("resource.loader", (Object)"mcf");
        configuration.setProperty("mcf.resource.loader.instance", (Object)new MCFVelocityResourceLoader(classInstance));
        engine.setExtendedProperties(configuration);
        engine.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.Log4JLogChute");
        engine.setProperty("runtime.log.logsystem.log4j.logger", (Object)"velocity");
        return engine;
    }

    public static InputStream getResourceAsStream(Class classInstance, String pathName, Locale originalLocale, String resourceKey) throws ManifoldCFException {
        Locale locale = originalLocale;
        InputStream is = classInstance.getResourceAsStream(Messages.localizeResourceName(pathName, resourceKey, locale));
        if (is == null) {
            Messages.complainMissingResource("No resource in path '" + pathName + "' named '" + resourceKey + "' found for locale '" + locale.toString() + "'", new Exception("Resource not found"), pathName, locale, resourceKey);
            locale = new Locale(locale.getLanguage());
            is = classInstance.getResourceAsStream(Messages.localizeResourceName(pathName, resourceKey, locale));
            if (is == null) {
                Messages.complainMissingResource("No resource in path '" + pathName + "' named '" + resourceKey + "' found for locale '" + locale.toString() + "'", new Exception("Resource not found"), pathName, locale, resourceKey);
                locale = Locale.US;
                is = classInstance.getResourceAsStream(Messages.localizeResourceName(pathName, resourceKey, locale));
                if (is == null) {
                    Messages.complainMissingResource("No resource in path '" + pathName + "' named '" + resourceKey + "' found for locale '" + locale.toString() + "'", new Exception("Resource not found"), pathName, locale, resourceKey);
                    locale = new Locale(locale.getLanguage());
                    is = classInstance.getResourceAsStream(Messages.localizeResourceName(pathName, resourceKey, locale));
                    if (is == null) {
                        Messages.complainMissingResource("No resource in path '" + pathName + "' named '" + resourceKey + "' found for locale '" + locale.toString() + "'", new Exception("Resource not found"), pathName, locale, resourceKey);
                        is = classInstance.getResourceAsStream(Messages.localizeResourceName(pathName, resourceKey, null));
                        if (is == null) {
                            throw new ManifoldCFException("No matching language resource in path '" + pathName + "' named '" + resourceKey + "' found for locale '" + originalLocale.toString() + "'");
                        }
                    }
                }
            }
        }
        return is;
    }

    private static String localizeResourceName(String pathName, String resourceName, Locale locale) {
        if (locale == null) {
            return resourceName;
        }
        int dotIndex = resourceName.lastIndexOf(".");
        if (dotIndex == -1) {
            return resourceName + "_" + locale.toString();
        }
        return resourceName.substring(0, dotIndex) + "_" + locale.toString() + resourceName.substring(dotIndex);
    }

    public static ResourceBundle getResourceBundle(Class clazz, String bundleName, Locale locale) {
        ResourceBundle resources;
        ClassLoader classLoader = clazz.getClassLoader();
        try {
            resources = ResourceBundle.getBundle(bundleName, locale, classLoader);
        }
        catch (MissingResourceException e) {
            Messages.complainMissingBundle("Missing resource bundle '" + bundleName + "' for locale '" + locale.toString() + "': " + e.getMessage() + "; trying " + locale.getLanguage(), e, bundleName, locale);
            locale = new Locale(locale.getLanguage());
            try {
                resources = ResourceBundle.getBundle(bundleName, locale, classLoader);
            }
            catch (MissingResourceException e2) {
                Messages.complainMissingBundle("Missing resource bundle '" + bundleName + "' for locale '" + locale.toString() + "': " + e2.getMessage() + "; trying en_US", e2, bundleName, locale);
                locale = Locale.US;
                try {
                    resources = ResourceBundle.getBundle(bundleName, locale, classLoader);
                }
                catch (MissingResourceException e3) {
                    Messages.complainMissingBundle("No backup en_US bundle found! " + e3.getMessage(), e3, bundleName, locale);
                    locale = new Locale(locale.getLanguage());
                    try {
                        resources = ResourceBundle.getBundle(bundleName, locale, classLoader);
                    }
                    catch (MissingResourceException e4) {
                        Messages.complainMissingBundle("No backup en bundle found! " + e4.getMessage(), e4, bundleName, locale);
                        return null;
                    }
                }
            }
        }
        return resources;
    }

    public static String getMessage(Class clazz, String bundleName, Locale locale, String messageKey) {
        ResourceBundle resources = Messages.getResourceBundle(clazz, bundleName, locale);
        if (resources == null) {
            return null;
        }
        return Messages.getMessage(resources, bundleName, locale, messageKey);
    }

    public static String getMessage(ResourceBundle resources, String bundleName, Locale locale, String messageKey) {
        try {
            return resources.getString(messageKey);
        }
        catch (MissingResourceException e) {
            Messages.complainMissingMessage("Missing resource '" + messageKey + "' in bundle '" + bundleName + "' for locale '" + locale.toString() + "'", e, bundleName, locale, messageKey);
            return null;
        }
    }

    public static String getString(ResourceBundle resourceBundle, String bundleName, Locale locale, String messageKey) {
        return Messages.getString(resourceBundle, bundleName, locale, messageKey, null);
    }

    public static String getString(Class clazz, String bundleName, Locale locale, String messageKey, Object[] args) {
        String formatMessage;
        String message = Messages.getMessage(clazz, bundleName, locale, messageKey);
        if (message == null) {
            return messageKey;
        }
        if (args != null) {
            MessageFormat fm = new MessageFormat(message);
            fm.setLocale(locale);
            formatMessage = fm.format(args);
        } else {
            formatMessage = message;
        }
        return formatMessage;
    }

    public static String getString(ResourceBundle resourceBundle, String bundleName, Locale locale, String messageKey, Object[] args) {
        String formatMessage;
        String message = Messages.getMessage(resourceBundle, bundleName, locale, messageKey);
        if (message == null) {
            return messageKey;
        }
        if (args != null) {
            MessageFormat fm = new MessageFormat(message);
            fm.setLocale(locale);
            formatMessage = fm.format(args);
        } else {
            formatMessage = message;
        }
        return formatMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void complainMissingBundle(String errorMessage, Throwable exception, String bundleName, Locale locale) {
        String localeName = locale.toString();
        BundleKey bk = new BundleKey(bundleName, localeName);
        Set<BundleKey> set = bundleSet;
        synchronized (set) {
            if (bundleSet.contains(bk)) {
                return;
            }
            bundleSet.add(bk);
        }
        Messages.logError(errorMessage, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void complainMissingMessage(String errorMessage, Throwable exception, String bundleName, Locale locale, String messageKey) {
        String localeName = locale.toString();
        MessageKey bk = new MessageKey(bundleName, localeName, messageKey);
        Set<MessageKey> set = messageSet;
        synchronized (set) {
            if (messageSet.contains(bk)) {
                return;
            }
            messageSet.add(bk);
        }
        Messages.logError(errorMessage, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void complainMissingResource(String errorMessage, Throwable exception, String pathName, Locale locale, String resourceKey) {
        String localeName = locale.toString();
        ResourceKey bk = new ResourceKey(pathName, localeName, resourceKey);
        Set<ResourceKey> set = resourceSet;
        synchronized (set) {
            if (resourceSet.contains(bk)) {
                return;
            }
            resourceSet.add(bk);
        }
        Messages.logError(errorMessage, exception);
    }

    protected static void logError(String errorMessage, Throwable exception) {
        if (Logging.misc == null) {
            System.err.println(errorMessage);
            exception.printStackTrace(System.err);
        } else {
            Logging.misc.error((Object)errorMessage, exception);
        }
    }

    protected static class ResourceKey {
        protected String pathName;
        protected String localeName;
        protected String resourceKey;

        public ResourceKey(String pathName, String localeName, String resourceKey) {
            this.pathName = pathName;
            this.localeName = localeName;
            this.resourceKey = resourceKey;
        }

        public int hashCode() {
            return this.pathName.hashCode() + this.localeName.hashCode() + this.resourceKey.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof ResourceKey)) {
                return false;
            }
            ResourceKey b = (ResourceKey)o;
            return b.pathName.equals(this.pathName) && b.localeName.equals(this.localeName) && b.resourceKey.equals(this.resourceKey);
        }
    }

    protected static class MessageKey {
        protected String bundleName;
        protected String localeName;
        protected String messageKey;

        public MessageKey(String bundleName, String localeName, String messageKey) {
            this.bundleName = bundleName;
            this.localeName = localeName;
            this.messageKey = messageKey;
        }

        public int hashCode() {
            return this.bundleName.hashCode() + this.localeName.hashCode() + this.messageKey.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof MessageKey)) {
                return false;
            }
            MessageKey b = (MessageKey)o;
            return b.bundleName.equals(this.bundleName) && b.localeName.equals(this.localeName) && b.messageKey.equals(this.messageKey);
        }
    }

    protected static class BundleKey {
        protected String bundleName;
        protected String localeName;

        public BundleKey(String bundleName, String localeName) {
            this.bundleName = bundleName;
            this.localeName = localeName;
        }

        public int hashCode() {
            return this.bundleName.hashCode() + this.localeName.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof BundleKey)) {
                return false;
            }
            BundleKey b = (BundleKey)o;
            return b.bundleName.equals(this.bundleName) && b.localeName.equals(this.localeName);
        }
    }
}

